{**************************************************************************}
{*  BitSoft Development, L.L.C.                                           *}
{*  Copyright (C) 1995, 1996 BitSoft Development, L.L.C.                  *}
{*  All rights reserved.                                                  *}
{*  Containers Library demo                                               *}
{**************************************************************************}

program Collect5;

{$X+}

{ Sample program for using a huge EMS collection. }

uses Objects, Containr, ctCollec,
     {$ifdef Windows}
     WinCtr;
     {$else}
     Crt;
     {$endif}

type
  PContact = ^TContact;
  TContact = object (TObject)
      FirstName,
      LastName,
      Phone,
      Company : PString;
    constructor Init(ALastName, AFirstName, APhone, ACompany : string);
    destructor Done; virtual;
  end; { TContact }

constructor TContact.Init(ALastName, AFirstName, APhone, ACompany : string);
begin
  FirstName := NewStr(AFirstName);
  LastName := NewStr(ALastName);
  Phone := NewStr(APhone);
  Company := NewStr(ACompany);
end;

destructor TContact.Done;
begin
  DisposeStr(FirstName);
  DisposeStr(LastName);
  DisposeStr(Phone);
  DisposeStr(Company);
end;

procedure DisplayContacts(ContactList : PSequence);

  procedure PrintInfo (Item : Pointer); far;
  begin
    with PContact(Item)^ do
      writeln(LastName^, '':15 - Length(LastName^),
        FirstName^, '':15 - Length(FirstName^),
        Phone^, '':20 - Length(Phone^),
        Company^, '':20 - Length(Company^));
  end;

begin
  ContactList^.ForEach(@PrintInfo);
end;

procedure DisplayFirst(ContactList : PSequence);
var
  Item : Pointer;
  Index : LongInt;
begin
  Item := ContactList^.First(Index);
  Writeln('First item:');
  with PContact(Item)^ do
    writeln(LastName^, '':15 - Length(LastName^),
      FirstName^, '':15 - Length(FirstName^),
      Phone^, '':20 - Length(Phone^),
      Company^, '':20 - Length(Company^));
  ContactList^.DoneItem(Item); { not required }
end;

procedure DisplayLast(ContactList : PSequence);
var
  Item : Pointer;
  Index : LongInt;
begin
  Item := ContactList^.Last(Index);
  Writeln('Last item:');
  with PContact(Item)^ do
    writeln(LastName^, '':15 - Length(LastName^),
      FirstName^, '':15 - Length(FirstName^),
      Phone^, '':20 - Length(Phone^),
      Company^, '':20 - Length(Company^));
  ContactList^.DoneItem(Item); { not required }
end;

procedure FindLastName(ContactList : PSequence; LastName : string);
var
  Item : Pointer;
  Index : LongInt;

  function MatchLastName (Item : Pointer): boolean; far;
  begin
    MatchLastName := (LastName = PContact(Item)^.LastName^);
  end;

begin
  Item := ContactList^.FirstThat(@MatchLastName, Index);
  Writeln('Item found with last name ''', LastName, ''':');
  with PContact(Item)^ do
    writeln(LastName^, '':15 - Length(LastName^),
      FirstName^, '':15 - Length(FirstName^),
      Phone^, '':20 - Length(Phone^),
      Company^, '':20 - Length(Company^));
  ContactList^.DoneItem(Item); { not required }
end;

var
  ContactInfo : PEmsCollection;

begin
  ClrScr;

  { Create the collection }
  ContactInfo := New(PEmsCollection, Init(50, 10));
  if ContactInfo = nil
    then begin
           Writeln('No EMS memory available.');
           Halt(1);
         end; { if }

  { Insert items into the collection }
  with ContactInfo^ do
  begin
    Insert(New(PContact, Init('Lewis', 'Carl', '(506) 83-780',
      'Running, Corp.')));
    Insert(New(PContact, Init('Benton', 'Michael', '(403) 33-973',
      'ER, Inc.')));
    Insert(New(PContact, Init('Wagner', 'Robert', '(906) 11-230',
      'Symphony, Ltd.')));
    Insert(New(PContact, Init('Smith', 'John', '(656) 75-843',
      'InterComm, Corp.')));
  end; { with }

  DisplayContacts(ContactInfo);
  Writeln;
  DisplayFirst(ContactInfo);
  Writeln;
  DisplayLast(ContactInfo);
  Writeln;
  FindLastName(ContactInfo, 'Wagner');

  { Dispose of the collection and all the objects in it }
  Dispose(ContactInfo, Done);
end.