{**************************************************************************}
{*  BitSoft Development, L.L.C.                                           *}
{*  Copyright (C) 1995, 1996 BitSoft Development, L.L.C.                  *}
{*  All rights reserved.                                                  *}
{*  Containers Library demo                                               *}
{**************************************************************************}

program Collect7;

{$X+}

{ Sample program for using a huge EMS sorted string collection. }

uses Objects, Containr, ctCollec,
     {$ifdef Windows}
     WinCtr;
     {$else}
     Crt;
     {$endif}

procedure DisplayStrings(StringList : PSequence);

  procedure PrintString(Str : PString); far;
  begin
    Writeln(Str^);
  end;

begin
  StringList^.ForEach(@PrintString);
end;

procedure DisplayFirst(StringList : PSequence);
var
  Item : Pointer;
  Index : LongInt;
begin
  Item := StringList^.First(Index);
  Writeln('First item:');
  writeln(PString(Item)^);
  StringList^.DoneItem(Item); { not required }
end;

procedure DisplayLast(StringList : PSequence);
var
  Item : Pointer;
  Index : LongInt;
begin
  Item := StringList^.Last(Index);
  Writeln('Last item:');
  writeln(PString(Item)^);
  StringList^.DoneItem(Item); { not required }
end;

procedure FindString(StringList : PSequence;  SearchStr : string);
var
  Index : LongInt;
begin
  if StringList^.Search(@SearchStr, Index)
    then begin
           Writeln('String found:');
           Writeln(PString(StringList^.At(Index))^)
         end { if }
    else Writeln('String not found.');
end;

var
  StringList : PEmsStringCollection;

begin
  ClrScr;

  { Create the collection }
  StringList := New(PEmsStringCollection, Init(50, 10));
  if StringList = nil
    then begin
           Writeln('No EMS memory available.');
           Halt(1);
         end; { if }

  { Insert items into the collection }
  with StringList^ do
  begin
    Insert(NewStr('Sky'));
    Insert(NewStr('Absolute'));
    Insert(NewStr('Temporary'));
    Insert(NewStr('Field'));
  end; { with }

  DisplayStrings(StringList);
  Writeln;
  DisplayFirst(StringList);
  Writeln;
  DisplayLast(StringList);
  Writeln;
  FindString(StringList, 'Field');

  { Dispose of the collection and all the objects in it }
  Dispose(StringList, Done);
end.