{**************************************************************************}
{*  BitSoft Development, L.L.C.                                           *}
{*  Copyright (C) 1995, 1996 BitSoft Development, L.L.C.                  *}
{*  All rights reserved.                                                  *}
{*  Containers Library demo                                               *}
{**************************************************************************}

program Collect8;

{$X+}

{ Sample program for using a huge EMS unsorted string collection. }

uses Objects, Containr, ctCollec,
     {$ifdef Windows}
     WinCtr;
     {$else}
     Crt;
     {$endif}

procedure DisplayStrings(StringList : PSequence);

  procedure PrintString(Str : PString); far;
  begin
    Writeln(Str^);
  end;

begin
  StringList^.ForEach(@PrintString);
end;

procedure DisplayFirst(StringList : PSequence);
var
  Item : Pointer;
  Index : LongInt;
begin
  Item := StringList^.First(Index);
  Writeln('First item:');
  writeln(PString(Item)^);
  StringList^.DoneItem(Item); { not required }
end;

procedure DisplayLast(StringList : PSequence);
var
  Item : Pointer;
  Index : LongInt;
begin
  Item := StringList^.Last(Index);
  Writeln('Last item:');
  writeln(PString(Item)^);
  StringList^.DoneItem(Item); { not required }
end;

procedure FindString(StringList : PSequence;  SearchStr : string);
var
  Item : Pointer;
  Index : LongInt;

  function MatchString (Str : PString): boolean; far;
  begin
    MatchString := (SearchStr = Str^);
  end;

begin
  Item := StringList^.FirstThat(@MatchString, Index);
  if Item <> nil
    then begin
           Writeln('String found:');
           Writeln(PString(Item)^);
         end
    else Writeln('String not found.');
  StringList^.DoneItem(Item); { not required }
end;

var
  StringList : PEmsUnSortedStrCollection;

begin
  ClrScr;

  { Create the collection }
  StringList := New(PEmsUnSortedStrCollection, Init(50, 10));
  if StringList = nil
    then begin
           Writeln('No EMS memory available.');
           Halt(1);
         end; { if }

  { Insert items into the collection }
  with StringList^ do
  begin
    Insert(NewStr('Sky'));
    Insert(NewStr('Absolute'));
    Insert(NewStr('Temporary'));
    Insert(NewStr('Field'));
  end; { with }

  DisplayStrings(StringList);
  Writeln;
  DisplayFirst(StringList);
  Writeln;
  DisplayLast(StringList);
  Writeln;
  FindString(StringList, 'Field');

  { Dispose of the collection and all the objects in it }
  Dispose(StringList, Done);
end.