{**************************************************************************}
{*  BitSoft Development, L.L.C.                                           *}
{*  Copyright (C) 1995, 1996 BitSoft Development, L.L.C.                  *}
{*  All rights reserved.                                                  *}
{**************************************************************************}

unit ListBox;

{$X+}

interface

uses Dialogs,
     Containr, ctCollec, ctListBx;

type
  ListBoxTypes = (lbSequenceListBox, lbSortedSequenceListBox);
  { Variables of ListBoxTypes are used with the test procedures in this
    unit. }

type
  PTestListBoxDlg = ^TTestListBoxDlg;
  TTestListBoxDlg = object(TDialog)
      ListBox : PSequenceListBox;
    constructor Init (ListBoxType : ListBoxTypes);
  end;  { TTestListBoxDlg }

procedure TestSequenceListBox (ListBoxType : ListBoxTypes);

implementation

uses App, Objects, Drivers, Views,
     BsdProcs,
     Types;

{****************************************************************************}
{ TTestListBoxDlg object                                                     }
{****************************************************************************}
{****************************************************************************}
{ TTestListBoxDlg.Init                                                       }
{****************************************************************************}
constructor TTestListBoxDlg.Init (ListBoxType : ListBoxTypes);
var
  R : TRect;
  ATitle : TTitleStr;
  HScrollBar, VScrollBar : PImsScrollbar;
  Control : PView;
begin
  R.Assign(20, 3, 60, 20);
  case ListBoxType of
    lbSequenceListBox : ATitle := 'TSequenceListBox';
    lbSortedSequenceListBox : ATitle := 'TSortedSequenceListBox';
  end; { case }
  if not TDialog.Init(R, ATitle) then
     Fail;
  R.Assign(37, 2, 38, 12);
  VScrollBar := New(PImsScrollbar, Init(R));
  Insert(VScrollbar);
  R.Assign(2, 2, 37, 12);
  case ListBoxType of
    lbSequenceListBox :
      ListBox := New(PSequenceListBox, Init(R, 2, VScrollbar));
    lbSortedSequenceListBox :
      ListBox := New(PSortedSequenceListBox, Init(R, 2, VScrollbar));
  end; { case }
  if ListBox = nil
    then begin
           TDialog.Done;
           Fail;
         end; { if }
  Insert(ListBox);
  R.Assign(1, 1, 8, 2);
  Control := New(PLabel, Init(R, '~I~items', ListBox));
  Insert(Control);
  R.Assign(2, 12, 37, 13);
  HScrollBar := New(PImsScrollbar, Init(R));
  Insert(HScrollbar);
  ListBox^.NewHScrollBar(HScrollBar);
  R.Assign(2, 14, 12, 16);
  Control := New(PButton, Init(R, 'O~k~', cmOk, bfDefault));
  Insert(Control);
  R.Assign(25, 14, 35, 16);
  Control := New(PButton, Init(R, 'Cancel', cmCancel, bfNormal));
  Insert(Control);
  SelectNext(False);
end;

{****************************************************************************}
{ NewSequence                                                                }
{****************************************************************************}
function NewSequence (MaxItems : LongInt; SortedSequence : Boolean) :
  PSequence;
var
  Str : String;
  S : PSequence;
  i : LongInt;
begin
  if SortedSequence
    then S := New(PStreamStringCollection, Init(MaxItems, 1))
    else S := New(PStreamUnSortedStrCollection, Init(MaxItems, 1));
  if S <> nil then
    for i := 1 to MaxItems do
    begin
      FormatStr(Str,'Item %d',i);
      S^.Insert(NewStr(Str));
    end; { for }
  NewSequence := S;
end;

{****************************************************************************}
{ TestSequenceListBox                                                        }
{****************************************************************************}
procedure TestSequenceListBox (ListBoxType : ListBoxTypes);
var
  Rec : TSequenceListBoxRec;
  Dialog : PDialog;
begin
  case ListBoxType of
    lbSequenceListBox :
      Rec.List := NewSequence(TotalDisplayItems, False);
    lbSortedSequenceListBox :
      Rec.List := NewSequence(TotalDisplayItems, True);
  end; { case }
  Rec.Selection := 0;
  Dialog := New(PTestListBoxDlg, Init(ListBoxType));
  if Application^.ValidView(Dialog) <> nil
    then begin
           Dialog^.SetData(Rec);
           Desktop^.ExecView(Dialog);
           Dispose(Dialog, Done);
         end; { if }
  DisposeObject(Rec.List);
end;

end.