{**************************************************************************}
{*  BitSoft Development, L.L.C.                                           *}
{*  Copyright (C) 1995, 1996 BitSoft Development, L.L.C.                  *}
{*  All rights reserved.                                                  *}
{**************************************************************************}

unit Main;

{$X+}

interface

uses Drivers, Menus, Views, Objects, App, MsgBox, Gadgets, Types, Display;

type
  PContainersDemo = ^TContainersDemo;
  TContainersDemo = object(TApplication)
      Clock      : PClockView;
      HeapViewer : PHeapView;
    constructor Init;
    procedure AddClock; virtual;
    procedure AddHeapViewer; virtual;
    procedure HandleEvent(var Event : TEvent); virtual;
    procedure Idle; virtual;
    procedure InitMenuBar; virtual;
    procedure SetNumberOfDuplicates;
    procedure SetNumberOfItems;
    procedure ShowAboutDialog;
  end; { TContainersDemo }

implementation

uses Dialogs,
     ctFields,
     ListBox, Data, Utils, ObjTests;

{****************************************************************************}
{ TContainersDemo object                                                     }
{****************************************************************************}
{****************************************************************************}
{ TContainersDemo.Init                                                       }
{****************************************************************************}
constructor TContainersDemo.Init;
begin
  TApplication.Init;
  AddClock;
  AddHeapViewer;
  DisableCommands([cmEmsStdArray, cmEmsStdObjectArray,
    cmEmsObjectArray, cmEmsCollection, cmEmsSortedCollection,
    cmEmsStringCollection, cmEmsUnSortedStrCollection, cmEmsStack]);
  {$ifndef Windows}
  {$ifndef DPMI}
  EnableCommands([cmEmsStdArray, cmEmsStdObjectArray, cmEmsObjectArray,
    cmEmsCollection, cmEmsSortedCollection, cmEmsStringCollection,
    cmEmsUnSortedStrCollection, cmEmsStack]);
  {$endif DPMI}
  {$endif Windows}
  RegisterType(RTestObject);
  RegisterFields;
  RegisterType(RTestStaticObject);
end;

{****************************************************************************}
{ TContainersDemo.AddClock                                                   }
{****************************************************************************}
procedure TContainersDemo.AddClock;
var
  R : TRect;
begin
  GetExtent(R);
  R.B.Y := R.A.Y + 1;
  R.A.X := R.B.X - 9;
  Clock := New(PClockView, Init(R));
  Insert(Clock);
end;

{****************************************************************************}
{ TContainersDemo.AddHeapViewer                                              }
{****************************************************************************}
procedure TContainersDemo.AddHeapViewer;
var
  R : TRect;
begin
  GetExtent(R);
  R.A.Y := R.B.Y - 1;
  R.A.X := R.B.X - 9;
  HeapViewer := New(PHeapView, Init(R));
  Insert(HeapViewer);
end;

{****************************************************************************}
{ TContainersDemo.HandleEvent                                                }
{****************************************************************************}
procedure TContainersDemo.HandleEvent(var Event : TEvent);

{$ifdef ver60}
    procedure DosShell;
    begin
      DoneSysError;
      DoneEvents;
      DoneVideo;
      DoneMemory;
      SetMemTop(HeapPtr);
      PrintStr(DemoStrings^.Get(sShellMsg));
      SwapVectors;
      Exec(GetEnv('COMSPEC'), '');
      SwapVectors;
      SetMemTop(HeapEnd);
      InitMemory;
      InitVideo;
      InitEvents;
      InitSysError;
      Redraw;
    end; { GoToDos }

    procedure Tile;
    var
      R: TRect;
    begin
      Desktop^.GetExtent(R);
      Desktop^.Tile(R);
    end; { Tile }

    procedure Cascade;
    var
      R: TRect;
    begin
      Desktop^.GetExtent(R);
      Desktop^.Cascade(R);
    end; { Cascade }
{$endif}

    procedure CloseAll;
    begin
       Dispose(Desktop, Done);
       InitDesktop;
       Insert(Desktop);
    end; { CloseAll }

    procedure ChangeVideo;
    var
      NewMode : Word;
    begin
      Dispose(HeapViewer, Done);
      NewMode := ScreenMode xor smFont8x8;
      if NewMode and smFont8x8 <> 0 then
        ShadowSize.X := 1
      else
        ShadowSize.X := 2;
      SetScreenMode(NewMode);
      AddHeapViewer;
    end; { ChangeVideo }

begin
  TApplication.HandleEvent(Event);
  if Event.What = evCommand then
       begin
         case Event.Command of
           { Application events }

           {$ifdef ver60}
           cmDosShell        : DosShell;
           cmTile            : Tile;
           cmCascade         : Cascade;
           {$endif}

           cmCloseAll        : CloseAll;
           cmRefresh         : Application^.Redraw;
           cmVideoMode       : ChangeVideo;
           cmTotalItems      : SetNumberOfItems;
           cmTotalDuplicates : SetNumberOfDuplicates;
           cmAbout           : ShowAboutDialog;

           { Arrays }
           cmStdArray : if CanStartNewTest
                          then TestTStdArray;
           cmResizableStdArray : if CanStartNewTest
                                   then TestTResizableStdArray;
           cmSortedStdArray : if CanStartNewTest
                                then TestTSortedStdArray;
           cmStdObjectArray : if CanStartNewTest
                                then TestTStdObjectArray;
           cmResizableStdObjectArray : if CanStartNewTest
                                         then TestTResizableStdObjectArray;
           cmSortedStdObjectArray : if CanStartNewTest
                                      then TestTSortedStdObjectArray;
           cmHugeArray : if CanStartNewTest
                           then TestTHugeArray;
           cmResizableHugeArray : if CanStartNewTest
                                    then TestTResizableHugeArray;
           cmSortedHugeArray : if CanStartNewTest
                           then TestTSortedHugeArray;
           cmHugeObjectArray : if CanStartNewTest
                                 then TestTHugeObjectArray;
           cmResizableHugeObjectArray : if CanStartNewTest
                                          then TestTResizableHugeObjectArray;
           cmSortedHugeObjectArray : if CanStartNewTest
                                       then TestTSortedHugeObjectArray;
           cmStreamStdArray : if CanStartNewTest
                                then TestTStreamStdArray;
           cmEmsStdArray : if CanStartNewTest
                             then TestTEmsStdArray;
           cmStreamStdObjectArray : if CanStartNewTest
                                      then TestTStreamStdObjectArray;
           cmEmsStdObjectArray : if CanStartNewTest
                                   then TestTEmsStdObjectArray;
           cmStreamObjectArray : if CanStartNewTest
                                   then TestTStreamObjectArray;
           cmEmsObjectArray : if CanStartNewTest
                                      then TestTEmsObjectArray;

           { Collections }
           cmHugeCollection : if CanStartNewTest
                                then TestTHugeCollection;
           cmHugeSortedCollection : if CanStartNewTest
                                        then TestTHugeSortedCollection;
           cmHugeStringCollection : if CanStartNewTest
                                        then TestTHugeStringCollection;
           cmHugeUnSortedStrCollection : if CanStartNewTest
                                             then TestTHugeUnSortedStrCollection;
           cmStreamCollection : if CanStartNewTest
                                  then TestTStreamCollection;
           cmEmsCollection : if CanStartNewTest
                               then TestTEmsCollection;
           cmStreamSortedCollection : if CanStartNewTest
                                        then TestTStreamSortedCollection;
           cmEmsSortedCollection : if CanStartNewTest
                                     then TestTEmsSortedCollection;
           cmStreamStringCollection : if CanStartNewTest
                                        then TestTStreamStringCollection;
           cmEmsStringCollection : if CanStartNewTest
                                     then TestTEmsStringCollection;
           cmStreamUnSortedStrCollection : if CanStartNewTest
                                             then TestTStreamUnSortedStrCollection;
           cmEmsUnSortedStrCollection : if CanStartNewTest
                                          then TestTEmsUnSortedStrCollection;

           { Linked lists }
           cmListSingle : if CanStartNewTest
                            then TestTListSingle;
           cmListDouble : if CanStartNewTest
                            then TestTListDouble;
           cmSortedListSingle : if CanStartNewTest
                                  then TestTSortedListSingle;
           cmSortedListDouble : if CanStartNewTest
                                  then TestTSortedListDouble;

           { Tables }
           cmTable : if CanStartNewTest
                       then TestTTable;
           cmObjectTable : if CanStartNewTest
                             then TestTObjectTable;

           { Queues }
           cmQueue : if CanStartNewTest
                       then TestTQueue;
           cmDoubleEndedQueue : if CanStartNewTest
                                  then TestTDoubleEndedQueue;

           { Stacks }
           cmHugeCollectionStack : if CanStartNewTest
                                     then TestTHugeCollectionStack;
           cmArrayStack: if CanStartNewTest
                           then TestTArrayStack;
           cmHugeArrayStack: if CanStartNewTest
                               then TestTHugeArrayStack;
           cmLinkedStack: if CanStartNewTest
                            then TestTLinkedStack;
           cmStreamStack: if CanStartNewTest
                            then TestTStreamStack;
           cmEmsStack: if CanStartNewTest
                         then TestTEmsStack;

           { Binary trees }
           cmBinaryTree : if CanStartNewTest
                            then TestTBinaryTree;
           cmAVLTree : if CanStartNewTest
                         then TestTAVLTree;

           { B trees }
           cmBTree : if CanStartNewTest
                       then TestTBTree;
           cmObjectBTree : if CanStartNewTest
                             then TestTObjectBTree;
           cmBPlusTree : if CanStartNewTest
                           then TestTBPlusTree;
           cmObjectBPlusTree : if CanStartNewTest
                                 then TestTObjectBPlusTree;

           { List boxes }
           cmSequenceListBox : TestSequenceListBox(lbSequenceListBox);
           cmSortedListBox   : TestSequenceListBox(lbSortedSequenceListBox);
         else
           Exit;
         end; { case }
         ClearEvent(Event);
       end; { if }
end;

{****************************************************************************}
{ TContainersDemo.Idle                                                       }
{****************************************************************************}
procedure TContainersDemo.Idle;

    function IsTileable(P: PView): Boolean; far;
    begin
      IsTileable := P^.Options and ofTileable <> 0;
    end; {...IsTileable }

begin
  TApplication.Idle;
  if Clock <> nil then
     Clock^.Update;
  if HeapViewer <> nil then
     HeapViewer^.Update;
  If Desktop^.FirstThat(@IsTileable) <> nil then
    EnableCommands([cmTile, cmCascade])
  else
    DisableCommands([cmTile, cmCascade]);
end;

{****************************************************************************}
{ TContainersDemo.InitMenuBar                                                }
{****************************************************************************}
procedure TContainersDemo.InitMenuBar;
var
  R: TRect;
begin
  R.Assign(0,0,80,1);
  MenuBar := New(PMenuBar, Init(R, NewMenu(
    NewSubMenu('~F~ile', hcFileMenu, NewMenu(
      NewItem('~D~os Shell...', '', kbNoKey, cmDosShell, hcDosShell,
      NewItem('E~x~it', 'Alt-X', kbAltX, cmQuit, hcQuit,
      nil))),
    NewSubMenu('~S~equences', hcSequencesMenu, NewMenu(
      NewSubMenu('~A~rrays', hcArraysMenu, NewMenu(
        NewSubMenu('~S~tandard arrays', hcStdArraysMenu, NewMenu(
          NewItem('~T~StdArray', '', kbNoKey, cmStdArray, hcStdArray,
          NewItem('T~R~esizableStdArray', '', kbNoKey, cmResizableStdArray,
            hcResizableStdArray,
          NewItem('T~S~ortedStdArray', '', kbNoKey, cmSortedStdArray,
            hcSortedStdArray,
          NewLine(
          NewItem('TSt~d~ObjectArray', '', kbNoKey, cmStdObjectArray,
            hcStdObjectArray,
          NewItem('TRes~i~zableStdObjectArray', '', kbNoKey,
            cmResizableStdObjectArray, hcResizableStdObjectArray,
          NewItem('TS~o~rtedStdObjectArray', '', kbNoKey, cmSortedStdObjectArray,
            hcSortedStdObjectArray,
          nil)))))))),
        NewSubMenu('~H~uge arrays', hcHugeArraysMenu, NewMenu(
          NewItem('~T~HugeArray', '', kbNoKey, cmHugeArray, hcHugeArray,
          NewItem('T~R~esizableHugeArray', '', kbNoKey, cmResizableHugeArray,
            hcResizableHugeArray,
          NewItem('T~S~ortedHugeArray', '', kbNoKey, cmSortedHugeArray,
            hcSortedHugeArray,
          NewLine(
          NewItem('T~H~ugeObjectArray', '', kbNoKey, cmHugeObjectArray,
            hcHugeObjectArray,
          NewItem('TR~e~sizableHugeObjectArray', '', kbNoKey, cmResizableHugeObjectArray,
            hcResizableHugeObjectArray,
          NewItem('TS~o~rtedHugeObjectArray', '', kbNoKey, cmSortedHugeObjectArray,
            hcSortedHugeObjectArray,
          nil)))))))),
        NewSubMenu('~S~tream arrays', hcStreamArraysMenu, NewMenu(
          NewItem('~T~StreamStdArray', '', kbNoKey, cmStreamStdArray,
            hcStreamStdArray,
          NewItem('T~S~treamStdObjectArray', '', kbNoKey,
            cmStreamStdObjectArray, hcStreamStdObjectArray,
          NewItem('TSt~r~eamObjectArray', '', kbNoKey, cmStreamObjectArray,
            hcStreamObjectArray,
          NewLine(
          NewItem('T~E~msStdArray', '', kbNoKey, cmEmsStdArray, hcEmsStdArray,
          NewItem('TE~m~sStdObjectArray', '', kbNoKey, cmEmsStdObjectArray,
            hcEmsStdObjectArray,
          NewItem('TEms~O~bjectArray', '', kbNoKey,
            cmEmsObjectArray, hcEmsObjectArray,
          nil)))))))),
        nil)))),
      NewSubMenu('~C~ollections', hcCollectionsMenu, NewMenu(
        NewItem('T~H~ugeCollection', '', kbNoKey, cmHugeCollection,
          hcHugeCollection,
        NewItem('THugeS~o~rtedCollection', '', kbNoKey, cmHugeSortedCollection,
          hcHugeSortedCollection,
        NewItem('THugeS~t~ringCollection', '', kbNoKey, cmHugeStringCollection,
          hcHugeStringCollection,
        NewItem('THuge~U~nSortedStrCollection', '', kbNoKey,
          cmHugeUnSortedStrCollection, hcHugeUnSortedStrCollection,
        NewLine(
        NewItem('T~S~treamCollection', '', kbNoKey, cmStreamCollection,
          hcStreamCollection,
        NewItem('TSt~r~eamSortedCollection', '', kbNoKey, cmStreamSortedCollection,
          hcStreamSortedCollection,
        NewItem('TStreamStr~i~ngCollection', '', kbNoKey, cmStreamStringCollection,
          hcStreamStringCollection,
        NewItem('TStreamU~n~SortedStrCollection', '', kbNoKey,
          cmStreamUnSortedStrCollection, hcStreamUnSortedStrCollection,
        NewLine(
        NewItem('T~E~msCollection', '', kbNoKey, cmEmsCollection,
          hcEmsCollection,
        NewItem('TE~m~sSortedCollection', '', kbNoKey, cmEmsSortedCollection,
          hcEmsSortedCollection,
        NewItem('TEmsStrin~g~Collection', '', kbNoKey, cmEmsStringCollection,
          hcEmsStringCollection,
        NewItem('TEmsUnSorte~d~Collection', '', kbNoKey,
          cmEmsUnSortedStrCollection, hcEmsUnSortedStrCollection,
        nil))))))))))))))),
      NewSubMenu('~L~inked lists', hcListsMenu, NewMenu(
        NewItem('T~L~ist', '', kbNoKey, cmListSingle, hcListSingle,
        NewItem('T~D~oubleList', '', kbNoKey, cmListDouble, hcListDouble,
        NewItem('T~S~ortedList', '', kbNoKey, cmSortedListSingle,
          hcSortedListSingle,
        NewItem('TS~o~rtedDoubleList', '', kbNoKey, cmSortedListDouble,
          hcSortedListDouble,
        nil))))),
      NewSubMenu('~Q~ueues', hcQueuesMenu, NewMenu(
        NewItem('T~Q~ueue', '', kbNoKey, cmQueue, hcQueue,
        NewItem('T~D~oubleEndedQueue', '', kbNoKey, cmDoubleEndedQueue, hcDoubleEndedQueue,
        nil))),
      NewSubMenu('~S~tacks', hcStacksMenu, NewMenu(
        NewItem('T~H~ugeCollectionStack', '', kbNoKey, cmHugeCollectionStack,
          hcHugeCollectionStack,
        NewItem('T~A~rrayStack', '', kbNoKey, cmArrayStack, hcArrayStack,
        NewItem('TH~u~geArrayStack', '', kbNoKey, cmHugeArrayStack,
          hcHugeArrayStack,
        NewItem('T~L~inkedStack', '', kbNoKey, cmLinkedStack, hcLinkedStack,
        NewItem('TS~t~reamStack', '', kbNoKey, cmStreamStack, hcStreamStack,
        NewLine(
        NewItem('T~E~msStack', '', kbNoKey, cmEmsStack, hcEmsStack,
        nil)))))))),
      NewSubMenu('~T~ables', hcTablesMenu, NewMenu(
        NewItem('T~T~able', '', kbNoKey, cmTable, hcTable,
        NewItem('T~O~bjectTable', '', kbNoKey, cmObjectTable, hcObjectTable,
        nil))),
      nil))))))),
    NewSubMenu('~G~raphs', hcGraphsMenu, NewMenu(
      NewItem('T~B~inaryTree', '', kbNoKey, cmBinaryTree, hcBinaryTree,
      NewItem('T~A~VLTree', '', kbNoKey, cmAvlTree, hcAvlTree,
      NewLine(
      NewItem('TB~T~ree', '', kbNoKey, cmBTree, hcBTree,
      NewItem('T~O~bjectBTree', '', kbNoKey, cmObjectBTree, hcObjectBTree,
      NewLine(
      NewItem('TB~P~lusTree', '', kbNoKey, cmBPlusTree, hcBPlusTree,
      NewItem('TOb~j~ectBPlusTree', '', kbNoKey, cmObjectBPlusTree,
        hcObjectBPlusTree,
      nil))))))))),
    NewSubMenu('~L~ist Boxes', hcListBoxesMenu, NewMenu(
      NewItem('T~S~equenceListBox','',kbNoKey, cmSequenceListBox,
        hcNoContext,
      NewItem('TS~o~rtedSequenceListBox','',kbNoKey, cmSortedListBox,
        hcNoContext,
      nil))),
    NewSubMenu('~O~ptions', hcOptionsMenu, NewMenu(
      NewItem('~N~umber of items', '', kbNoKey, cmTotalItems, hcTotalItems,
      NewItem('Number of ~d~uplicates', '', kbNoKey, cmTotalDuplicates,
        hcTotalDuplicates,
      nil))),
    NewSubMenu('~W~indow', hcWindowMenu, NewMenu(
      NewItem('~T~ile', '', kbNoKey, cmTile, hcTile,
      NewItem('C~a~scade', '', kbNoKey, cmCascade, hcCascade,
      NewItem('~C~lose', 'Alt-F3', kbAltF3, cmClose, hcClose,
      NewItem('Cl~o~se all', '', kbNoKey, cmCloseAll, hcCloseAll,
      NewItem('~R~efresh display', '', kbNoKey, cmRefresh, hcRefresh,
      NewLine(
      NewItem('~S~ize/Move', 'Ctrl-F5', kbCtrlF5, cmResize, hcResize,
      NewItem('~Z~oom', 'F5', kbF5, cmZoom, hcZoom,
      NewItem('~N~ext', 'F6', kbF6, cmNext, hcNext,
      NewItem('~P~revious', 'Shift-F6', kbShiftF6, cmPrev, hcPrev,
      NewLine(
      NewItem('~V~ideo Mode', '', kbNoKey, cmVideoMode, hcVideoMode,
      nil))))))))))))),
    NewSubMenu('~H~elp', hcSequencesMenu, NewMenu(
      NewItem('~A~bout...', '', kbNoKey, cmAbout, hcAbout,
      nil)),
    nil))))))))));
end;

{****************************************************************************}
{ TContainersDemo.SetNumberOfDuplicates                                      }
{****************************************************************************}
procedure TContainersDemo.SetNumberOfDuplicates;
var
  S : string;
  N : LongInt;
  Code : Integer;
begin
  Str(TotalDuplicates, S);
  if InputBox('Number of duplicates...', 'Number of duplicates to insert in '+
       'tests:', S, 5) <> cmCancel
    then begin
           Val(S, N, Code);
           if Code <> 0
             then MessageBox('Not a valid number.', nil, mfError + mfOkButton)
             else if (N < 1) or (N > 100)
                    then MessageBox('Number must be between 1 and 100.',
                           nil, mfError + mfOkButton)
                    else TotalDuplicates := N;
         end; { if }
end;

{****************************************************************************}
{ TContainersDemo.SetNumberOfItems                                           }
{****************************************************************************}
procedure TContainersDemo.SetNumberOfItems;
var
  S : string;
  N : LongInt;
  Code : Integer;
begin
  Str(TotalItems, S);
  if InputBox('Number of items...', 'Number of items to use in tests:',
       S, 5) <> cmCancel
    then begin
           Val(S, N, Code);
           if Code <> 0
             then MessageBox('Not a valid number.', nil, mfError + mfOkButton)
             else if (N < 10) or (N > 10000)
                    then MessageBox('Number must be between 10 and 10000.',
                           nil, mfError + mfOkButton)
                    else TotalItems := N;
         end; { if }
end;

{****************************************************************************}
{ TContainersDemo.ShowAboutDialog                                            }
{****************************************************************************}
procedure TContainersDemo.ShowAboutDialog;
var
  Dlg : PDialog;
  R : TRect;
  Control, HScroll : PView;
Begin
  R.Assign(20,4,59,19);
  New(Dlg, Init(R, 'About...'));
  Dlg^.Options := $0343;

  R.Assign(2,2,37,12);
  Control := New(PStaticText, Init(R, ^C'"Tests Demo Program"'^M+
     ^M+
     ^C'Containers Library (TM) v1.0'^M+
     ^C''^M+
     ^C'Copyright (C) 1995, 1996'^M+
     ^C'by BitSoft Development, L.L.C.'^M+
     ^C''^M+
     ^C' All rights reserved.'^M+
     ^C''));
  Dlg^.Insert(Control);

  R.Assign(14,12,26,14);
  Control := New(PButton, Init(R, 'O~k~', cmOk, bfNormal));
  Dlg^.Insert(Control);

  Dlg^.SelectNext(False);

  if Application^.ValidView(Dlg) <> NIL then
    Desktop^.ExecView(Dlg);
  if Dlg <> nil then
    Dispose(Dlg, Done);
end;

end.