{**************************************************************************}
{*  BitSoft Development, L.L.C.                                           *}
{*  Copyright (C) 1995, 1996 BitSoft Development, L.L.C.                  *}
{*  All rights reserved.                                                  *}
{*  Containers Library demo                                               *}
{**************************************************************************}

program Queues1;

{$X+}

{ Sample program for using a queue }

uses Objects, Containr, ctLists, ctQueues,
     {$ifdef Windows}
     WinCtr;
     {$else}
     Crt;
     {$endif}

type
  PRequest = ^TRequest;
  TRequest = object (TListNode)
      ID : Integer;
      Instruction : Integer;
    constructor Init(AId, AInstruction : Integer);
  end; { TRequest }

constructor TRequest.Init(AId, AInstruction : Integer);
begin
  TListNode.Init;
  ID := AId;
  Instruction := AInstruction;
end;

var
  InstructionQueue : PQueue;
  Item : Pointer;

begin
  ClrScr;

  { Create the queue }
  InstructionQueue := New(PQueue, Init);

  { Insert items into the queue }
  with InstructionQueue^ do
  begin
    Writeln('Enqueueing:  ID = 0, Instruction = 234');
    Enqueue(New(PRequest, Init(0, 234)));
    Writeln('Enqueueing:  ID = 1, Instruction = 735');
    Enqueue(New(PRequest, Init(1, 735)));
    Writeln('Enqueueing:  ID = 2, Instruction = 956');
    Enqueue(New(PRequest, Init(2, 956)));
    Writeln('Enqueueing:  ID = 3, Instruction = 164');
    Enqueue(New(PRequest, Init(3, 164)));
    Writeln('Enqueueing:  ID = 4, Instruction = 691');
    Enqueue(New(PRequest, Init(4, 691)));
  end; { with }
  Writeln;

  { Extract items from the queue }
  with InstructionQueue^ do
  begin
    repeat
      Item := Remove;
      with PRequest(Item)^ do
        Writeln('Extracting:  ID = ', ID, ', Instruction number = ', Instruction:4);
      FreeItem(Item);
    until Count = 0;
  end; { with }

  { Dispose of the queue }
  Dispose(InstructionQueue, Done);
end.