{
 The  Telephony  API  is jointly copyrighted by Intel and Microsoft.  You are
 granted  a royalty free worldwide, unlimited license to make copies, and use
 the   API/SPI  for  making  applications/drivers  that  interface  with  the
 specification provided that this paragraph and the Intel/Microsoft copyright
 statement is maintained as is in the text and source code files.

 Copyright 1995 Microsoft, all rights reserved.
 Portions copyright 1992, 1993 Intel/Microsoft, all rights reserved.
}

{ Converted to Delphi by Davide Moretti <dmoretti@iper.net> }

unit Tapi;

interface

{$IFDEF WIN32}
  uses Windows, Messages;
{$ELSE}
  uses WinTypes, Messages;
{$ENDIF}

{ Type definitions of the data types used in tapi }

type
  LPHCall = ^THCall;
  THCall = Longint;
  LPHLine = ^THLine;
  THLine = Longint;
  LPHPhone = ^THPhone;
  THPhone = Longint;
  LPHLineApp = ^THLineApp;
  THLineApp = Longint;
	LPHPhoneApp = ^THPhoneApp;
  THPhoneApp = Longint;

  LPHIcon = ^HIcon;


{
// typedef of the LINE callback procedure
typedef void (CALLBACK * LINECALLBACK)  (DWORD hDevice,
                          DWORD dwMessage,
                          DWORD dwInstance,
													DWORD dwParam1,
                          DWORD dwParam2,
                          DWORD dwParam3);

// typedef of the PHONE callback procedure
typedef void (CALLBACK * PHONECALLBACK)  (DWORD hDevice,
                           DWORD dwMessage,
                           DWORD dwInstance,
                           DWORD dwParam1,
                           DWORD dwParam2,
                           DWORD dwParam3);
}

{ Messages for Phones and Lines }

const
  LINE_ADDRESSSTATE       = 0;
  LINE_CALLINFO           = 1;
  LINE_CALLSTATE          = 2;
  LINE_CLOSE              = 3;
  LINE_DEVSPECIFIC        = 4;
  LINE_DEVSPECIFICFEATURE = 5;
  LINE_GATHERDIGITS       = 6;
  LINE_GENERATE           = 7;
  LINE_LINEDEVSTATE       = 8;
  LINE_MONITORDIGITS      = 9;
  LINE_MONITORMEDIA       = 10;
  LINE_MONITORTONE        = 11;
  LINE_REPLY              = 12;
  LINE_REQUEST            = 13;
  PHONE_BUTTON            = 14;
  PHONE_CLOSE             = 15;
  PHONE_DEVSPECIFIC       = 16;
  PHONE_REPLY             = 17;
  PHONE_STATE             = 18;
  LINE_CREATE             = 19;
  PHONE_CREATE            = 20;

{ Define Simple Telephony Constants. }

  TAPI_REPLY                  = Wm_User + 99;

  TAPIERR_CONNECTED           = 0;
  TAPIERR_DROPPED             = -1;
  TAPIERR_NOREQUESTRECIPIENT  = -2;
  TAPIERR_REQUESTQUEUEFULL    = -3;
  TAPIERR_INVALDESTADDRESS    = -4;
  TAPIERR_INVALWINDOWHANDLE   = -5;
  TAPIERR_INVALDEVICECLASS    = -6;
  TAPIERR_INVALDEVICEID       = -7;
  TAPIERR_DEVICECLASSUNAVAIL  = -8;
  TAPIERR_DEVICEIDUNAVAIL     = -9;
  TAPIERR_DEVICEINUSE         = -10;
  TAPIERR_DESTBUSY            = -11;
  TAPIERR_DESTNOANSWER        = -12;
  TAPIERR_DESTUNAVAIL         = -13;
  TAPIERR_UNKNOWNWINHANDLE    = -14;
  TAPIERR_UNKNOWNREQUESTID    = -15;
  TAPIERR_REQUESTFAILED       = -16;
  TAPIERR_REQUESTCANCELLED    = -17;
  TAPIERR_INVALPOINTER        = -18;


  TAPIMAXDESTADDRESSSIZE  = 80;
  TAPIMAXAPPNAMESIZE      = 40;
  TAPIMAXCALLEDPARTYSIZE  = 40;
  TAPIMAXCOMMENTSIZE      = 80;
  TAPIMAXDEVICECLASSSIZE  = 40;
  TAPIMAXDEVICEIDSIZE     = 40;


{ Data types and values for Phones }


  PHONEBUTTONFUNCTION_UNKNOWN       = $00000000;
  PHONEBUTTONFUNCTION_CONFERENCE    = $00000001;
  PHONEBUTTONFUNCTION_TRANSFER      = $00000002;
  PHONEBUTTONFUNCTION_DROP          = $00000003;
  PHONEBUTTONFUNCTION_HOLD          = $00000004;
  PHONEBUTTONFUNCTION_RECALL        = $00000005;
  PHONEBUTTONFUNCTION_DISCONNECT    = $00000006;
  PHONEBUTTONFUNCTION_CONNECT       = $00000007;
  PHONEBUTTONFUNCTION_MSGWAITON     = $00000008;
  PHONEBUTTONFUNCTION_MSGWAITOFF    = $00000009;
  PHONEBUTTONFUNCTION_SELECTRING    = $0000000A;
  PHONEBUTTONFUNCTION_ABBREVDIAL    = $0000000B;
  PHONEBUTTONFUNCTION_FORWARD       = $0000000C;
  PHONEBUTTONFUNCTION_PICKUP        = $0000000D;
  PHONEBUTTONFUNCTION_RINGAGAIN     = $0000000E;
  PHONEBUTTONFUNCTION_PARK          = $0000000F;
  PHONEBUTTONFUNCTION_REJECT        = $00000010;
  PHONEBUTTONFUNCTION_REDIRECT      = $00000011;
  PHONEBUTTONFUNCTION_MUTE          = $00000012;
  PHONEBUTTONFUNCTION_VOLUMEUP      = $00000013;
  PHONEBUTTONFUNCTION_VOLUMEDOWN    = $00000014;
  PHONEBUTTONFUNCTION_SPEAKERON     = $00000015;
  PHONEBUTTONFUNCTION_SPEAKEROFF    = $00000016;
  PHONEBUTTONFUNCTION_FLASH         = $00000017;
  PHONEBUTTONFUNCTION_DATAON        = $00000018;
  PHONEBUTTONFUNCTION_DATAOFF       = $00000019;
  PHONEBUTTONFUNCTION_DONOTDISTURB  = $0000001A;
  PHONEBUTTONFUNCTION_INTERCOM      = $0000001B;
  PHONEBUTTONFUNCTION_BRIDGEDAPP    = $0000001C;
  PHONEBUTTONFUNCTION_BUSY          = $0000001D;
  PHONEBUTTONFUNCTION_CALLAPP       = $0000001E;
  PHONEBUTTONFUNCTION_DATETIME      = $0000001F;
  PHONEBUTTONFUNCTION_DIRECTORY     = $00000020;
  PHONEBUTTONFUNCTION_COVER         = $00000021;
  PHONEBUTTONFUNCTION_CALLID        = $00000022;
  PHONEBUTTONFUNCTION_LASTNUM       = $00000023;
  PHONEBUTTONFUNCTION_NIGHTSRV      = $00000024;
  PHONEBUTTONFUNCTION_SENDCALLS     = $00000025;
  PHONEBUTTONFUNCTION_MSGINDICATOR  = $00000026;
  PHONEBUTTONFUNCTION_REPDIAL       = $00000027;
  PHONEBUTTONFUNCTION_SETREPDIAL    = $00000028;
  PHONEBUTTONFUNCTION_SYSTEMSPEED   = $00000029;
  PHONEBUTTONFUNCTION_STATIONSPEED  = $0000002A;
  PHONEBUTTONFUNCTION_CAMPON        = $0000002B;
  PHONEBUTTONFUNCTION_SAVEREPEAT    = $0000002C;
  PHONEBUTTONFUNCTION_QUEUECALL     = $0000002D;
  PHONEBUTTONFUNCTION_NONE          = $0000002E;

type
  LPPhoneButtonInfo = ^TPhoneButtonInfo;
  TPhoneButtonInfo = record
    dwTotalSize,
    dwNeededSize,
    dwUsedSize,

    dwButtonMode,
    dwButtonFunction,

    dwButtonTextSize,
    dwButtonTextOffset,

    dwDevSpecificSize,
    dwDevSpecificOffset,

    dwButtonState: Longint;
    end;

const
  PHONEBUTTONMODE_DUMMY   = $00000001;
  PHONEBUTTONMODE_CALL    = $00000002;
  PHONEBUTTONMODE_FEATURE = $00000004;
  PHONEBUTTONMODE_KEYPAD  = $00000008;
  PHONEBUTTONMODE_LOCAL   = $00000010;
  PHONEBUTTONMODE_DISPLAY = $00000020;

  PHONEBUTTONSTATE_UP      = $00000001;
  PHONEBUTTONSTATE_DOWN    = $00000002;
  PHONEBUTTONSTATE_UNKNOWN = $00000004;
  PHONEBUTTONSTATE_UNAVAIL = $00000008;

type
  LPPhoneExtensionID = ^TPhoneExtensionID;
  TPhoneExtensionID = record
    dwExtensionID0,
    dwExtensionID1,
    dwExtensionID2,
    dwExtensionID3: Longint;
    end;

  LPPhoneCaps = ^TPhoneCaps;
  TPhoneCaps = record
    dwTotalSize,
    dwNeededSize,
    dwUsedSize,

    dwProviderInfoSize,
    dwProviderInfoOffset,

    dwPhoneInfoSize,
    dwPhoneInfoOffset,

    dwPermanentPhoneID,
    dwPhoneNameSize,
    dwPhoneNameOffset,
    dwStringFormat,

    dwPhoneStates,
    dwHookSwitchDevs,
    dwHandsetHookSwitchModes,
    dwSpeakerHookSwitchModes,
    dwHeadsetHookSwitchModes,

    dwVolumeFlags,
    dwGainFlags,
    dwDisplayNumRows,
    dwDisplayNumColumns,
    dwNumRingModes,
    dwNumButtonLamps,

    dwButtonModesSize,
    dwButtonModesOffset,

    dwButtonFunctionsSize,
    dwButtonFunctionsOffset,

    dwLampModesSize,
    dwLampModesOffset,

    dwNumSetData,
    dwSetDataSize,
    dwSetDataOffset,

    dwNumGetData,
    dwGetDataSize,
    dwGetDataOffset,

    dwDevSpecificSize,
    dwDevSpecificOffset: Longint;
    end;

const
  PHONEERR_ALLOCATED              = $90000001;
  PHONEERR_BADDEVICEID            = $90000002;
  PHONEERR_INCOMPATIBLEAPIVERSION = $90000003;
  PHONEERR_INCOMPATIBLEEXTVERSION = $90000004;
  PHONEERR_INIFILECORRUPT         = $90000005;
  PHONEERR_INUSE                  = $90000006;
  PHONEERR_INVALAPPHANDLE         = $90000007;
  PHONEERR_INVALAPPNAME           = $90000008;
  PHONEERR_INVALBUTTONLAMPID      = $90000009;
  PHONEERR_INVALBUTTONMODE        = $9000000A;
  PHONEERR_INVALBUTTONSTATE       = $9000000B;
  PHONEERR_INVALDATAID            = $9000000C;
  PHONEERR_INVALDEVICECLASS       = $9000000D;
  PHONEERR_INVALEXTVERSION        = $9000000E;
  PHONEERR_INVALHOOKSWITCHDEV     = $9000000F;
  PHONEERR_INVALHOOKSWITCHMODE    = $90000010;
  PHONEERR_INVALLAMPMODE          = $90000011;
  PHONEERR_INVALPARAM             = $90000012;
  PHONEERR_INVALPHONEHANDLE       = $90000013;
  PHONEERR_INVALPHONESTATE        = $90000014;
  PHONEERR_INVALPOINTER           = $90000015;
  PHONEERR_INVALPRIVILEGE         = $90000016;
  PHONEERR_INVALRINGMODE          = $90000017;
  PHONEERR_NODEVICE               = $90000018;
  PHONEERR_NODRIVER               = $90000019;
  PHONEERR_NOMEM                  = $9000001A;
  PHONEERR_NOTOWNER               = $9000001B;
  PHONEERR_OPERATIONFAILED        = $9000001C;
  PHONEERR_OPERATIONUNAVAIL       = $9000001D;
  PHONEERR_RESOURCEUNAVAIL        = $9000001F;
  PHONEERR_REQUESTOVERRUN         = $90000020;
  PHONEERR_STRUCTURETOOSMALL      = $90000021;
  PHONEERR_UNINITIALIZED          = $90000022;
  PHONEERR_REINIT                 = $90000023;

  PHONEHOOKSWITCHDEV_HANDSET  = $00000001;
  PHONEHOOKSWITCHDEV_SPEAKER  = $00000002;
  PHONEHOOKSWITCHDEV_HEADSET  = $00000004;

  PHONEHOOKSWITCHMODE_ONHOOK      = $00000001;
  PHONEHOOKSWITCHMODE_MIC         = $00000002;
  PHONEHOOKSWITCHMODE_SPEAKER     = $00000004;
  PHONEHOOKSWITCHMODE_MICSPEAKER  = $00000008;
  PHONEHOOKSWITCHMODE_UNKNOWN     = $00000010;

  PHONELAMPMODE_DUMMY         = $00000001;
  PHONELAMPMODE_OFF           = $00000002;
  PHONELAMPMODE_STEADY        = $00000004;
  PHONELAMPMODE_WINK          = $00000008;
  PHONELAMPMODE_FLASH         = $00000010;
  PHONELAMPMODE_FLUTTER       = $00000020;
  PHONELAMPMODE_BROKENFLUTTER = $00000040;
  PHONELAMPMODE_UNKNOWN       = $00000080;


  PHONEPRIVILEGE_MONITOR  = $00000001;
  PHONEPRIVILEGE_OWNER    = $00000002;

  PHONESTATE_OTHER              = $00000001;
  PHONESTATE_CONNECTED          = $00000002;
  PHONESTATE_DISCONNECTED       = $00000004;
  PHONESTATE_OWNER              = $00000008;
  PHONESTATE_MONITORS           = $00000010;
  PHONESTATE_DISPLAY            = $00000020;
  PHONESTATE_LAMP               = $00000040;
  PHONESTATE_RINGMODE           = $00000080;
  PHONESTATE_RINGVOLUME         = $00000100;
  PHONESTATE_HANDSETHOOKSWITCH  = $00000200;
  PHONESTATE_HANDSETVOLUME      = $00000400;
  PHONESTATE_HANDSETGAIN        = $00000800;
  PHONESTATE_SPEAKERHOOKSWITCH  = $00001000;
  PHONESTATE_SPEAKERVOLUME      = $00002000;
  PHONESTATE_SPEAKERGAIN        = $00004000;
  PHONESTATE_HEADSETHOOKSWITCH  = $00008000;
  PHONESTATE_HEADSETVOLUME      = $00010000;
  PHONESTATE_HEADSETGAIN        = $00020000;
  PHONESTATE_SUSPEND            = $00040000;
  PHONESTATE_RESUME             = $00080000;
  PHONESTATE_DEVSPECIFIC        = $00100000;
  PHONESTATE_REINIT             = $00200000;
  PHONESTATE_CAPSCHANGE         = $00400000;
  PHONESTATE_REMOVED            = $00800000;

type
  LPPhoneStatus = ^TPhoneStatus;
  TPhoneStatus = record
    dwTotalSize,
    dwNeededSize,
    dwUsedSize,

    dwStatusFlags,
    dwNumOwners,
    dwNumMonitors,
    dwRingMode,
    dwRingVolume,

    dwHandsetHookSwitchMode,
    dwHandsetVolume,
    dwHandsetGain,

    dwSpeakerHookSwitchMode,
    dwSpeakerVolume,
    dwSpeakerGain,

    dwHeadsetHookSwitchMode,
    dwHeadsetVolume,
    dwHeadsetGain,

    dwDisplaySize,
    dwDisplayOffset,

    dwLampModesSize,
    dwLampModesOffset,

    dwOwnerNameSize,
    dwOwnerNameOffset,

    dwDevSpecificSize,
    dwDevSpecificOffset: Longint;
    end;

const
  PHONESTATUSFLAGS_CONNECTED  = $00000001;
  PHONESTATUSFLAGS_SUSPENDED  = $00000002;

  STRINGFORMAT_ASCII   = $00000001;
  STRINGFORMAT_DBCS    = $00000002;
  STRINGFORMAT_UNICODE = $00000003;
  STRINGFORMAT_BINARY  = $00000004;

type
  LPVarString = ^TVarString;
  TVarString = record
    dwTotalSize,
    dwNeededSize,
    dwUsedSize,

    dwStringFormat,
    dwStringSize,
    dwStringOffset: Longint;
    end;


{ Data types and values for Lines }

const
  LINEADDRCAPFLAGS_FWDNUMRINGS      = $00000001;
  LINEADDRCAPFLAGS_PICKUPGROUPID    = $00000002;
  LINEADDRCAPFLAGS_SECURE           = $00000004;
  LINEADDRCAPFLAGS_BLOCKIDDEFAULT   = $00000008;
  LINEADDRCAPFLAGS_BLOCKIDOVERRIDE  = $00000010;
  LINEADDRCAPFLAGS_DIALED           = $00000020;
  LINEADDRCAPFLAGS_ORIGOFFHOOK      = $00000040;
  LINEADDRCAPFLAGS_DESTOFFHOOK      = $00000080;
  LINEADDRCAPFLAGS_FWDCONSULT       = $00000100;
  LINEADDRCAPFLAGS_SETUPCONFNULL    = $00000200;
  LINEADDRCAPFLAGS_AUTORECONNECT    = $00000400;
  LINEADDRCAPFLAGS_COMPLETIONID     = $00000800;
  LINEADDRCAPFLAGS_TRANSFERHELD     = $00001000;
  LINEADDRCAPFLAGS_TRANSFERMAKE     = $00002000;
  LINEADDRCAPFLAGS_CONFERENCEHELD   = $00004000;
  LINEADDRCAPFLAGS_CONFERENCEMAKE   = $00008000;
  LINEADDRCAPFLAGS_PARTIALDIAL      = $00010000;
  LINEADDRCAPFLAGS_FWDSTATUSVALID   = $00020000;
  LINEADDRCAPFLAGS_FWDINTEXTADDR    = $00040000;
  LINEADDRCAPFLAGS_FWDBUSYNAADDR    = $00080000;
  LINEADDRCAPFLAGS_ACCEPTTOALERT    = $00100000;
  LINEADDRCAPFLAGS_CONFDROP         = $00200000;
  LINEADDRCAPFLAGS_PICKUPCALLWAIT   = $00400000;

type
  LPLineAddressCaps = ^TLineAddressCaps;
  TLineAddressCaps = record
    dwTotalSize,
    dwNeededSize,
    dwUsedSize,

    dwLineDeviceID,

    dwAddressSize,
    dwAddressOffset,

    dwDevSpecificSize,
    dwDevSpecificOffset,

    dwAddressSharing,
    dwAddressStates,
    dwCallInfoStates,
    dwCallerIDFlags,
    dwCalledIDFlags,
    dwConnectedIDFlags,
    dwRedirectionIDFlags,
    dwRedirectingIDFlags,
    dwCallStates,
    dwDialToneModes,
    dwBusyModes,
    dwSpecialInfo,
    dwDisconnectModes,

    dwMaxNumActiveCalls,
    dwMaxNumOnHoldCalls,
    dwMaxNumOnHoldPendingCalls,
    dwMaxNumConference,
    dwMaxNumTransConf,

    dwAddrCapFlags,
    dwCallFeatures,
    dwRemoveFromConfCaps,
    dwRemoveFromConfState,
    dwTransferModes,
    dwParkModes,

    dwForwardModes,
    dwMaxForwardEntries,
    dwMaxSpecificEntries,
    dwMinFwdNumRings,
    dwMaxFwdNumRings,

    dwMaxCallCompletions,
    dwCallCompletionConds,
    dwCallCompletionModes,
    dwNumCompletionMessages,
    dwCompletionMsgTextEntrySize,
    dwCompletionMsgTextSize,
    dwCompletionMsgTextOffset,
    dwAddressFeatures: Longint;
    end;

const
  LINEADDRESSMODE_ADDRESSID     = $00000001;
  LINEADDRESSMODE_DIALABLEADDR  = $00000002;


  LINEADDRESSSHARING_PRIVATE        = $00000001;
  LINEADDRESSSHARING_BRIDGEDEXCL    = $00000002;
  LINEADDRESSSHARING_BRIDGEDNEW     = $00000004;
  LINEADDRESSSHARING_BRIDGEDSHARED  = $00000008;
  LINEADDRESSSHARING_MONITORED      = $00000010;

  LINEADDRESSSTATE_OTHER        = $00000001;
  LINEADDRESSSTATE_DEVSPECIFIC  = $00000002;
  LINEADDRESSSTATE_INUSEZERO    = $00000004;
  LINEADDRESSSTATE_INUSEONE     = $00000008;
  LINEADDRESSSTATE_INUSEMANY    = $00000010;
  LINEADDRESSSTATE_NUMCALLS     = $00000020;
  LINEADDRESSSTATE_FORWARD      = $00000040;
  LINEADDRESSSTATE_TERMINALS    = $00000080;
  LINEADDRESSSTATE_CAPSCHANGE   = $00000100;

type
  LPLineAddressStatus = ^TLineAddressStatus;
  TLineAddressStatus = record
    dwTotalSize,
    dwNeededSize,
    dwUsedSize,

    dwNumInUse,
    dwNumActiveCalls,
    dwNumOnHoldCalls,
    dwNumOnHoldPendCalls,
    dwAddressFeatures,

    dwNumRingsNoAnswer,
    dwForwardNumEntries,
    dwForwardSize,
    dwForwardOffset,

    dwTerminalModesSize,
    dwTerminalModesOffset,

    dwDevSpecificSize,
    dwDevSpecificOffset: Longint;
    end;

const
  LINEADDRFEATURE_FORWARD         = $00000001;
  LINEADDRFEATURE_MAKECALL        = $00000002;
  LINEADDRFEATURE_PICKUP          = $00000004;
  LINEADDRFEATURE_SETMEDIACONTROL = $00000008;
  LINEADDRFEATURE_SETTERMINAL     = $00000010;
  LINEADDRFEATURE_SETUPCONF       = $00000020;
  LINEADDRFEATURE_UNCOMPLETECALL  = $00000040;
  LINEADDRFEATURE_UNPARK          = $00000080;


  LINEANSWERMODE_NONE = $00000001;
  LINEANSWERMODE_DROP = $00000002;
  LINEANSWERMODE_HOLD = $00000004;

  LINEBEARERMODE_VOICE            = $00000001;
  LINEBEARERMODE_SPEECH           = $00000002;
  LINEBEARERMODE_MULTIUSE         = $00000004;
  LINEBEARERMODE_DATA             = $00000008;
  LINEBEARERMODE_ALTSPEECHDATA    = $00000010;
  LINEBEARERMODE_NONCALLSIGNALING = $00000020;
  LINEBEARERMODE_PASSTHROUGH      = $00000040;

  LINEBUSYMODE_STATION  = $00000001;
  LINEBUSYMODE_TRUNK    = $00000002;
  LINEBUSYMODE_UNKNOWN  = $00000004;
  LINEBUSYMODE_UNAVAIL  = $00000008;

  LINECALLCOMPLCOND_BUSY      = $00000001;
  LINECALLCOMPLCOND_NOANSWER  = $00000002;

  LINECALLCOMPLMODE_CAMPON    = $00000001;
  LINECALLCOMPLMODE_CALLBACK  = $00000002;
  LINECALLCOMPLMODE_INTRUDE   = $00000004;
  LINECALLCOMPLMODE_MESSAGE   = $00000008;

  LINECALLFEATURE_ACCEPT              = $00000001;
  LINECALLFEATURE_ADDTOCONF           = $00000002;
  LINECALLFEATURE_ANSWER              = $00000004;
  LINECALLFEATURE_BLINDTRANSFER       = $00000008;
  LINECALLFEATURE_COMPLETECALL        = $00000010;
  LINECALLFEATURE_COMPLETETRANSF      = $00000020;
  LINECALLFEATURE_DIAL                = $00000040;
  LINECALLFEATURE_DROP                = $00000080;
  LINECALLFEATURE_GATHERDIGITS        = $00000100;
  LINECALLFEATURE_GENERATEDIGITS      = $00000200;
  LINECALLFEATURE_GENERATETONE        = $00000400;
  LINECALLFEATURE_HOLD                = $00000800;
  LINECALLFEATURE_MONITORDIGITS       = $00001000;
  LINECALLFEATURE_MONITORMEDIA        = $00002000;
  LINECALLFEATURE_MONITORTONES        = $00004000;
  LINECALLFEATURE_PARK                = $00008000;
  LINECALLFEATURE_PREPAREADDCONF      = $00010000;
  LINECALLFEATURE_REDIRECT            = $00020000;
  LINECALLFEATURE_REMOVEFROMCONF      = $00040000;
  LINECALLFEATURE_SECURECALL          = $00080000;
  LINECALLFEATURE_SENDUSERUSER        = $00100000;
  LINECALLFEATURE_SETCALLPARAMS       = $00200000;
  LINECALLFEATURE_SETMEDIACONTROL     = $00400000;
  LINECALLFEATURE_SETTERMINAL         = $00800000;
  LINECALLFEATURE_SETUPCONF           = $01000000;
  LINECALLFEATURE_SETUPTRANSFER       = $02000000;
  LINECALLFEATURE_SWAPHOLD            = $04000000;
  LINECALLFEATURE_UNHOLD              = $08000000;
  LINECALLFEATURE_RELEASEUSERUSERINFO = $10000000;

type
  LPLineDialParams = ^TLineDialParams;
  TLineDialParams = record
    dwDialPause,
    dwDialSpeed,
    dwDigitDuration,
    dwWaitForDialtone: Longint;
    end;

  LPLineCallInfo = ^TLineCallInfo;
  TLineCallInfo = record
    dwTotalSize,
    dwNeededSize,
    dwUsedSize: Longint;

    hLine: THLine;
    dwLineDeviceID,
    dwAddressID,

    dwBearerMode,
    dwRate,
    dwMediaMode,

    dwAppSpecific,
    dwCallID,
    dwRelatedCallID,
    dwCallParamFlags,
    dwCallStates,

    dwMonitorDigitModes,
    dwMonitorMediaModes: Longint;
    DialParams: TLineDialParams;

    dwOrigin,
    dwReason,
    dwCompletionID,
    dwNumOwners,
    dwNumMonitors,

    dwCountryCode,
    dwTrunk,

    dwCallerIDFlags,
    dwCallerIDSize,
    dwCallerIDOffset,
    dwCallerIDNameSize,
    dwCallerIDNameOffset,

    dwCalledIDFlags,
    dwCalledIDSize,
    dwCalledIDOffset,
    dwCalledIDNameSize,
    dwCalledIDNameOffset,

    dwConnectedIDFlags,
    dwConnectedIDSize,
    dwConnectedIDOffset,
    dwConnectedIDNameSize,
    dwConnectedIDNameOffset,

    dwRedirectionIDFlags,
    dwRedirectionIDSize,
    dwRedirectionIDOffset,
    dwRedirectionIDNameSize,
    dwRedirectionIDNameOffset,

    dwRedirectingIDFlags,
    dwRedirectingIDSize,
    dwRedirectingIDOffset,
    dwRedirectingIDNameSize,
    dwRedirectingIDNameOffset,

    dwAppNameSize,
    dwAppNameOffset,

    dwDisplayableAddressSize,
    dwDisplayableAddressOffset,

    dwCalledPartySize,
    dwCalledPartyOffset,

    dwCommentSize,
    dwCommentOffset,

    dwDisplaySize,
    dwDisplayOffset,

    dwUserUserInfoSize,
    dwUserUserInfoOffset,

    dwHighLevelCompSize,
    dwHighLevelCompOffset,

    dwLowLevelCompSize,
    dwLowLevelCompOffset,

    dwChargingInfoSize,
    dwChargingInfoOffset,

    dwTerminalModesSize,
    dwTerminalModesOffset,

    dwDevSpecificSize,
    dwDevSpecificOffset: Longint;
    end;

const
  LINECALLINFOSTATE_OTHER         = $00000001;
  LINECALLINFOSTATE_DEVSPECIFIC   = $00000002;
  LINECALLINFOSTATE_BEARERMODE    = $00000004;
  LINECALLINFOSTATE_RATE          = $00000008;
  LINECALLINFOSTATE_MEDIAMODE     = $00000010;
  LINECALLINFOSTATE_APPSPECIFIC   = $00000020;
  LINECALLINFOSTATE_CALLID        = $00000040;
  LINECALLINFOSTATE_RELATEDCALLID = $00000080;
  LINECALLINFOSTATE_ORIGIN        = $00000100;
  LINECALLINFOSTATE_REASON        = $00000200;
  LINECALLINFOSTATE_COMPLETIONID  = $00000400;
  LINECALLINFOSTATE_NUMOWNERINCR  = $00000800;
  LINECALLINFOSTATE_NUMOWNERDECR  = $00001000;
  LINECALLINFOSTATE_NUMMONITORS   = $00002000;
  LINECALLINFOSTATE_TRUNK         = $00004000;
  LINECALLINFOSTATE_CALLERID      = $00008000;
  LINECALLINFOSTATE_CALLEDID      = $00010000;
  LINECALLINFOSTATE_CONNECTEDID   = $00020000;
  LINECALLINFOSTATE_REDIRECTIONID = $00040000;
  LINECALLINFOSTATE_REDIRECTINGID = $00080000;
  LINECALLINFOSTATE_DISPLAY       = $00100000;
  LINECALLINFOSTATE_USERUSERINFO  = $00200000;
  LINECALLINFOSTATE_HIGHLEVELCOMP = $00400000;
  LINECALLINFOSTATE_LOWLEVELCOMP  = $00800000;
  LINECALLINFOSTATE_CHARGINGINFO  = $01000000;
  LINECALLINFOSTATE_TERMINAL      = $02000000;
  LINECALLINFOSTATE_DIALPARAMS    = $04000000;
  LINECALLINFOSTATE_MONITORMODES  = $08000000;

type
  LPLineCallList = ^TLineCallList;
  TLineCallList = record
    dwTotalSize,
    dwNeededSize,
    dwUsedSize,

    dwCallsNumEntries,
    dwCallsSize,
    dwCallsOffset: Longint;
    end;

const
  LINECALLORIGIN_OUTBOUND   = $00000001;
  LINECALLORIGIN_INTERNAL   = $00000002;
  LINECALLORIGIN_EXTERNAL   = $00000004;
  LINECALLORIGIN_UNKNOWN    = $00000010;
  LINECALLORIGIN_UNAVAIL    = $00000020;
  LINECALLORIGIN_CONFERENCE = $00000040;
  LINECALLORIGIN_INBOUND    = $00000080;

  LINECALLPARAMFLAGS_SECURE       = $00000001;
  LINECALLPARAMFLAGS_IDLE         = $00000002;
  LINECALLPARAMFLAGS_BLOCKID      = $00000004;
  LINECALLPARAMFLAGS_ORIGOFFHOOK  = $00000008;
  LINECALLPARAMFLAGS_DESTOFFHOOK  = $00000010;

type
  LPLineCallParams = ^TLineCallParams;
  TLineCallParams = record              { Defaults: }
    dwTotalSize,                        { --------- }

    dwBearerMode,                       { voice }
    dwMinRate,                          { (3.1kHz) }
    dwMaxRate,                          { (3.1kHz) }
    dwMediaMode,                        { interactiveVoice }

    dwCallParamFlags,                   { 0 }
    dwAddressMode,                      { addressID }
    dwAddressID: Longint;               { (any available) }

    DialParams: TLineDialParams;        { (0, 0, 0, 0) }

    dwOrigAddressSize,                  { 0 }
    dwOrigAddressOffset,
    dwDisplayableAddressSize,
    dwDisplayableAddressOffset,

    dwCalledPartySize,                  { 0 }
    dwCalledPartyOffset,

    dwCommentSize,                      { 0 }
    dwCommentOffset,

    dwUserUserInfoSize,                 { 0 }
    dwUserUserInfoOffset,

    dwHighLevelCompSize,                { 0 }
    dwHighLevelCompOffset,

    dwLowLevelCompSize,                 { 0 }
    dwLowLevelCompOffset,

    dwDevSpecificSize,                  { 0 }
    dwDevSpecificOffset: Longint;
    end;

const
  LINECALLPARTYID_BLOCKED       = $00000001;
  LINECALLPARTYID_OUTOFAREA     = $00000002;
  LINECALLPARTYID_NAME          = $00000004;
  LINECALLPARTYID_ADDRESS       = $00000008;
  LINECALLPARTYID_PARTIAL       = $00000010;
  LINECALLPARTYID_UNKNOWN       = $00000020;
  LINECALLPARTYID_UNAVAIL       = $00000040;

  LINECALLPRIVILEGE_NONE        = $00000001;
  LINECALLPRIVILEGE_MONITOR     = $00000002;
  LINECALLPRIVILEGE_OWNER       = $00000004;

  LINECALLREASON_DIRECT         = $00000001;
  LINECALLREASON_FWDBUSY        = $00000002;
  LINECALLREASON_FWDNOANSWER    = $00000004;
  LINECALLREASON_FWDUNCOND      = $00000008;
  LINECALLREASON_PICKUP         = $00000010;
  LINECALLREASON_UNPARK         = $00000020;
  LINECALLREASON_REDIRECT       = $00000040;
  LINECALLREASON_CALLCOMPLETION = $00000080;
  LINECALLREASON_TRANSFER       = $00000100;
  LINECALLREASON_REMINDER       = $00000200;
  LINECALLREASON_UNKNOWN        = $00000400;
  LINECALLREASON_UNAVAIL        = $00000800;
  LINECALLREASON_INTRUDE        = $00001000;
  LINECALLREASON_PARKED         = $00002000;

  LINECALLSELECT_LINE     = $00000001;
  LINECALLSELECT_ADDRESS  = $00000002;
  LINECALLSELECT_CALL     = $00000004;

  LINECALLSTATE_IDLE                = $00000001;
  LINECALLSTATE_OFFERING            = $00000002;
  LINECALLSTATE_ACCEPTED            = $00000004;
  LINECALLSTATE_DIALTONE            = $00000008;
  LINECALLSTATE_DIALING             = $00000010;
  LINECALLSTATE_RINGBACK            = $00000020;
  LINECALLSTATE_BUSY                = $00000040;
  LINECALLSTATE_SPECIALINFO         = $00000080;
  LINECALLSTATE_CONNECTED           = $00000100;
  LINECALLSTATE_PROCEEDING          = $00000200;
  LINECALLSTATE_ONHOLD              = $00000400;
  LINECALLSTATE_CONFERENCED         = $00000800;
  LINECALLSTATE_ONHOLDPENDCONF      = $00001000;
  LINECALLSTATE_ONHOLDPENDTRANSFER  = $00002000;
  LINECALLSTATE_DISCONNECTED        = $00004000;
  LINECALLSTATE_UNKNOWN             = $00008000;


  LINECONNECTEDMODE_ACTIVE    = $00000001;
  LINECONNECTEDMODE_INACTIVE  = $00000002;

  LINEOFFERINGMODE_ACTIVE   = $00000001;
  LINEOFFERINGMODE_INACTIVE = $00000002;


type
  LPLineCallStatus = ^TLineCallStatus;
  TLineCallStatus = record
    dwTotalSize,
    dwNeededSize,
    dwUsedSize,

    dwCallState,
    dwCallStateMode,
    dwCallPrivilege,
    dwCallFeatures,

    dwDevSpecificSize,
    dwDevSpecificOffset: Longint;
    end;

const
  LINEDEVCAPFLAGS_CROSSADDRCONF = $00000001;
  LINEDEVCAPFLAGS_HIGHLEVCOMP   = $00000002;
  LINEDEVCAPFLAGS_LOWLEVCOMP    = $00000004;
  LINEDEVCAPFLAGS_MEDIACONTROL  = $00000008;
  LINEDEVCAPFLAGS_MULTIPLEADDR  = $00000010;
  LINEDEVCAPFLAGS_CLOSEDROP     = $00000020;
  LINEDEVCAPFLAGS_DIALBILLING   = $00000040;
  LINEDEVCAPFLAGS_DIALQUIET     = $00000080;
  LINEDEVCAPFLAGS_DIALDIALTONE  = $00000100;

type
  LPLineExtensionID = ^TLineExtensionID;
  TLineExtensionID = record
    dwExtensionID0,
    dwExtensionID1,
    dwExtensionID2,
    dwExtensionID3: Longint;
    end;

  LPLineDevCaps = ^TLineDevCaps;
  TLineDevCaps = record
    dwTotalSize,
    dwNeededSize,
    dwUsedSize,

    dwProviderInfoSize,
    dwProviderInfoOffset,

    dwSwitchInfoSize,
    dwSwitchInfoOffset,

    dwPermanentLineID,
    dwLineNameSize,
    dwLineNameOffset,
    dwStringFormat,

    dwAddressModes,
    dwNumAddresses,
    dwBearerModes,
    dwMaxRate,
    dwMediaModes,

    dwGenerateToneModes,
    dwGenerateToneMaxNumFreq,
    dwGenerateDigitModes,
    dwMonitorToneMaxNumFreq,
    dwMonitorToneMaxNumEntries,
    dwMonitorDigitModes,
    dwGatherDigitsMinTimeout,
    dwGatherDigitsMaxTimeout,

    dwMedCtlDigitMaxListSize,
    dwMedCtlMediaMaxListSize,
    dwMedCtlToneMaxListSize,
    dwMedCtlCallStateMaxListSize,

    dwDevCapFlags,
    dwMaxNumActiveCalls,
    dwAnswerMode,
    dwRingModes,
    dwLineStates,

    dwUUIAcceptSize,
    dwUUIAnswerSize,
    dwUUIMakeCallSize,
    dwUUIDropSize,
    dwUUISendUserUserInfoSize,
    dwUUICallInfoSize: Longint;

    MinDialParams,
    MaxDialParams,
    DefaultDialParams: TLineDialParams;

    dwNumTerminals,
    dwTerminalCapsSize,
    dwTerminalCapsOffset,
    dwTerminalTextEntrySize,
    dwTerminalTextSize,
    dwTerminalTextOffset,

    dwDevSpecificSize,
    dwDevSpecificOffset,
    dwLineFeatures: Longint;
    end;

const
  LINEDEVSTATE_OTHER            = $00000001;
  LINEDEVSTATE_RINGING          = $00000002;
  LINEDEVSTATE_CONNECTED        = $00000004;
  LINEDEVSTATE_DISCONNECTED     = $00000008;
  LINEDEVSTATE_MSGWAITON        = $00000010;
  LINEDEVSTATE_MSGWAITOFF       = $00000020;
  LINEDEVSTATE_INSERVICE        = $00000040;
  LINEDEVSTATE_OUTOFSERVICE     = $00000080;
  LINEDEVSTATE_MAINTENANCE      = $00000100;
  LINEDEVSTATE_OPEN             = $00000200;
  LINEDEVSTATE_CLOSE            = $00000400;
  LINEDEVSTATE_NUMCALLS         = $00000800;
  LINEDEVSTATE_NUMCOMPLETIONS   = $00001000;
  LINEDEVSTATE_TERMINALS        = $00002000;
  LINEDEVSTATE_ROAMMODE         = $00004000;
  LINEDEVSTATE_BATTERY          = $00008000;
  LINEDEVSTATE_SIGNAL           = $00010000;
  LINEDEVSTATE_DEVSPECIFIC      = $00020000;
  LINEDEVSTATE_REINIT           = $00040000;
  LINEDEVSTATE_LOCK             = $00080000;
  LINEDEVSTATE_CAPSCHANGE       = $00100000;
  LINEDEVSTATE_CONFIGCHANGE     = $00200000;
  LINEDEVSTATE_TRANSLATECHANGE  = $00400000;
  LINEDEVSTATE_COMPLCANCEL      = $00800000;
  LINEDEVSTATE_REMOVED          = $01000000;

type
  LPLineDevStatus = ^TLineDevStatus;
  TLineDevStatus = record
    dwTotalSize,
    dwNeededSize,
    dwUsedSize,

    dwNumOpens,
    dwOpenMediaModes,
    dwNumActiveCalls,
    dwNumOnHoldCalls,
    dwNumOnHoldPendCalls,
    dwLineFeatures,
    dwNumCallCompletions,
    dwRingMode,
    dwSignalLevel,
    dwBatteryLevel,
    dwRoamMode,

    dwDevStatusFlags,

    dwTerminalModesSize,
    dwTerminalModesOffset,

    dwDevSpecificSize,
    dwDevSpecificOffset: Longint;
    end;

const
  LINEDEVSTATUSFLAGS_CONNECTED  = $00000001;
  LINEDEVSTATUSFLAGS_MSGWAIT    = $00000002;
  LINEDEVSTATUSFLAGS_INSERVICE  = $00000004;
  LINEDEVSTATUSFLAGS_LOCKED     = $00000008;


  LINEDIALTONEMODE_NORMAL   = $00000001;
  LINEDIALTONEMODE_SPECIAL  = $00000002;
  LINEDIALTONEMODE_INTERNAL = $00000004;
  LINEDIALTONEMODE_EXTERNAL = $00000008;
  LINEDIALTONEMODE_UNKNOWN  = $00000010;
  LINEDIALTONEMODE_UNAVAIL  = $00000020;

  LINEDIGITMODE_PULSE   = $00000001;
  LINEDIGITMODE_DTMF    = $00000002;
  LINEDIGITMODE_DTMFEND = $00000004;

  LINEDISCONNECTMODE_NORMAL       = $00000001;
  LINEDISCONNECTMODE_UNKNOWN      = $00000002;
  LINEDISCONNECTMODE_REJECT       = $00000004;
  LINEDISCONNECTMODE_PICKUP       = $00000008;
  LINEDISCONNECTMODE_FORWARDED    = $00000010;
  LINEDISCONNECTMODE_BUSY         = $00000020;
  LINEDISCONNECTMODE_NOANSWER     = $00000040;
  LINEDISCONNECTMODE_BADADDRESS   = $00000080;
  LINEDISCONNECTMODE_UNREACHABLE  = $00000100;
  LINEDISCONNECTMODE_CONGESTION   = $00000200;
  LINEDISCONNECTMODE_INCOMPATIBLE = $00000400;
  LINEDISCONNECTMODE_UNAVAIL      = $00000800;
  LINEDISCONNECTMODE_NODIALTONE   = $00001000;

  LINEERR_ALLOCATED               = $80000001;
  LINEERR_BADDEVICEID             = $80000002;
  LINEERR_BEARERMODEUNAVAIL       = $80000003;
  LINEERR_CALLUNAVAIL             = $80000005;
  LINEERR_COMPLETIONOVERRUN       = $80000006;
  LINEERR_CONFERENCEFULL          = $80000007;
  LINEERR_DIALBILLING             = $80000008;
  LINEERR_DIALDIALTONE            = $80000009;
  LINEERR_DIALPROMPT              = $8000000A;
  LINEERR_DIALQUIET               = $8000000B;
  LINEERR_INCOMPATIBLEAPIVERSION  = $8000000C;
  LINEERR_INCOMPATIBLEEXTVERSION  = $8000000D;
  LINEERR_INIFILECORRUPT          = $8000000E;
  LINEERR_INUSE                   = $8000000F;
  LINEERR_INVALADDRESS            = $80000010;
  LINEERR_INVALADDRESSID          = $80000011;
  LINEERR_INVALADDRESSMODE        = $80000012;
  LINEERR_INVALADDRESSSTATE       = $80000013;
  LINEERR_INVALAPPHANDLE          = $80000014;
  LINEERR_INVALAPPNAME            = $80000015;
  LINEERR_INVALBEARERMODE         = 80000016;
  LINEERR_INVALCALLCOMPLMODE      = $80000017;
  LINEERR_INVALCALLHANDLE         = $80000018;
  LINEERR_INVALCALLPARAMS         = $80000019;
  LINEERR_INVALCALLPRIVILEGE      = $8000001A;
  LINEERR_INVALCALLSELECT         = $8000001B;
  LINEERR_INVALCALLSTATE          = $8000001C;
  LINEERR_INVALCALLSTATELIST      = $8000001D;
  LINEERR_INVALCARD               = $8000001E;
  LINEERR_INVALCOMPLETIONID       = $8000001F;
  LINEERR_INVALCONFCALLHANDLE     = $80000020;
  LINEERR_INVALCONSULTCALLHANDLE  = $80000021;
  LINEERR_INVALCOUNTRYCODE        = $80000022;
  LINEERR_INVALDEVICECLASS        = $80000023;
  LINEERR_INVALDEVICEHANDLE       = $80000024;
  LINEERR_INVALDIALPARAMS         = $80000025;
  LINEERR_INVALDIGITLIST          = $80000026;
  LINEERR_INVALDIGITMODE          = $80000027;
  LINEERR_INVALDIGITS             = $80000028;
  LINEERR_INVALEXTVERSION         = $80000029;
  LINEERR_INVALGROUPID            = $8000002A;
  LINEERR_INVALLINEHANDLE         = $8000002B;
  LINEERR_INVALLINESTATE          = $8000002C;
  LINEERR_INVALLOCATION           = $8000002D;
  LINEERR_INVALMEDIALIST          = $8000002E;
  LINEERR_INVALMEDIAMODE          = $8000002F;
  LINEERR_INVALMESSAGEID          = $80000030;
  LINEERR_INVALPARAM              = $80000032;
  LINEERR_INVALPARKID             = $80000033;
  LINEERR_INVALPARKMODE           = $80000034;
  LINEERR_INVALPOINTER            = $80000035;
  LINEERR_INVALPRIVSELECT         = $80000036;
  LINEERR_INVALRATE               = $80000037;
  LINEERR_INVALREQUESTMODE        = $80000038;
  LINEERR_INVALTERMINALID         = $80000039;
  LINEERR_INVALTERMINALMODE       = $8000003A;
  LINEERR_INVALTIMEOUT            = $8000003B;
  LINEERR_INVALTONE               = $8000003C;
  LINEERR_INVALTONELIST           = $8000003D;
  LINEERR_INVALTONEMODE           = $8000003E;
  LINEERR_INVALTRANSFERMODE       = $8000003F;
  LINEERR_LINEMAPPERFAILED        = $80000040;
  LINEERR_NOCONFERENCE            = $80000041;
  LINEERR_NODEVICE                = $80000042;
  LINEERR_NODRIVER                = $80000043;
  LINEERR_NOMEM                   = $80000044;
  LINEERR_NOREQUEST               = $80000045;
  LINEERR_NOTOWNER                = $80000046;
  LINEERR_NOTREGISTERED           = $80000047;
  LINEERR_OPERATIONFAILED         = $80000048;
  LINEERR_OPERATIONUNAVAIL        = $80000049;
  LINEERR_RATEUNAVAIL             = $8000004A;
  LINEERR_RESOURCEUNAVAIL         = $8000004B;
  LINEERR_REQUESTOVERRUN          = $8000004C;
  LINEERR_STRUCTURETOOSMALL       = $8000004D;
  LINEERR_TARGETNOTFOUND          = $8000004E;
  LINEERR_TARGETSELF              = $8000004F;
  LINEERR_UNINITIALIZED           = $80000050;
  LINEERR_USERUSERINFOTOOBIG      = $80000051;
  LINEERR_REINIT                  = $80000052;
  LINEERR_ADDRESSBLOCKED          = $80000053;
  LINEERR_BILLINGREJECTED         = $80000054;
  LINEERR_INVALFEATURE            = $80000055;
  LINEERR_NOMULTIPLEINSTANCE      = $80000056;

  LINEFEATURE_DEVSPECIFIC     = $00000001;
  LINEFEATURE_DEVSPECIFICFEAT = $00000002;
  LINEFEATURE_FORWARD         = $00000004;
  LINEFEATURE_MAKECALL        = $00000008;
  LINEFEATURE_SETMEDIACONTROL = $00000010;
  LINEFEATURE_SETTERMINAL     = $00000020;

type
  LPLineForward = ^TLineForward;
  TLineForward = record
    dwForwardMode,

    dwCallerAddressSize,
    dwCallerAddressOffset,

    dwDestCountryCode,
    dwDestAddressSize,
    dwDestAddressOffset: Longint;
    end;


  LPLineForwardList = ^TLineForwardList;
  TLineForwardList = record
    dwTotalSize: Longint;

    dwNumEntries: Longint;
    ForwardList: array[0..0] of TLineForward;
    end;

const
  LINEFORWARDMODE_UNCOND          = $00000001;
  LINEFORWARDMODE_UNCONDINTERNAL  = $00000002;
  LINEFORWARDMODE_UNCONDEXTERNAL  = $00000004;
  LINEFORWARDMODE_UNCONDSPECIFIC  = $00000008;
  LINEFORWARDMODE_BUSY            = $00000010;
  LINEFORWARDMODE_BUSYINTERNAL    = $00000020;
  LINEFORWARDMODE_BUSYEXTERNAL    = $00000040;
  LINEFORWARDMODE_BUSYSPECIFIC    = $00000080;
  LINEFORWARDMODE_NOANSW          = $00000100;
  LINEFORWARDMODE_NOANSWINTERNAL  = $00000200;
  LINEFORWARDMODE_NOANSWEXTERNAL  = $00000400;
  LINEFORWARDMODE_NOANSWSPECIFIC  = $00000800;
  LINEFORWARDMODE_BUSYNA          = $00001000;
  LINEFORWARDMODE_BUSYNAINTERNAL  = $00002000;
  LINEFORWARDMODE_BUSYNAEXTERNAL  = $00004000;
  LINEFORWARDMODE_BUSYNASPECIFIC  = $00008000;
  LINEFORWARDMODE_UNKNOWN         = $00010000;
  LINEFORWARDMODE_UNAVAIL         = $00020000;

  LINEGATHERTERM_BUFFERFULL   = $00000001;
  LINEGATHERTERM_TERMDIGIT    = $00000002;
  LINEGATHERTERM_FIRSTTIMEOUT = $00000004;
  LINEGATHERTERM_INTERTIMEOUT = $00000008;
  LINEGATHERTERM_CANCEL       = $00000010;

  LINEGENERATETERM_DONE   = $00000001;
  LINEGENERATETERM_CANCEL = $00000002;

type
  LPLineGenerateTone = ^TLineGenerateTone;
  TLineGenerateTone = record
    dwFrequency,
    dwCadenceOn,
    dwCadenceOff,
    dwVolume: Longint;
    end;

const
  LINEMAPPER = $FFFFFFFF;

type
  LPLineMediaControlCallState = ^TLineMediaControlCallState;
  TLineMediaControlCallState = record
    dwCallStates,
    dwMediaControl: Longint;
    end;

  LPLineMediaControlDigit = ^TLineMediaControlDigit;
  TLineMediaControlDigit = record
    dwDigit,
    dwDigitModes,
    dwMediaControl: Longint;
    end;

  LPLineMediaControlMedia = ^TLineMediaControlMedia;
  TLineMediaControlMedia = record
    dwMediaModes,
    dwDuration,
    dwMediaControl: Longint;
    end;

  LPLineMediaControlTone = ^TLineMediaControlTone;
  TLineMediaControlTone = record
    dwAppSpecific,
    dwDuration,
    dwFrequency1,
    dwFrequency2,
    dwFrequency3,
    dwMediaControl: Longint;
    end;

const
  LINEMEDIACONTROL_NONE         = $00000001;
  LINEMEDIACONTROL_START        = $00000002;
  LINEMEDIACONTROL_RESET        = $00000004;
  LINEMEDIACONTROL_PAUSE        = $00000008;
  LINEMEDIACONTROL_RESUME       = $00000010;
  LINEMEDIACONTROL_RATEUP       = $00000020;
  LINEMEDIACONTROL_RATEDOWN     = $00000040;
  LINEMEDIACONTROL_RATENORMAL   = $00000080;
  LINEMEDIACONTROL_VOLUMEUP     = $00000100;
  LINEMEDIACONTROL_VOLUMEDOWN   = $00000200;
  LINEMEDIACONTROL_VOLUMENORMAL = $00000400;

  LINEMEDIAMODE_UNKNOWN           = $00000002;
  LINEMEDIAMODE_INTERACTIVEVOICE  = $00000004;
  LINEMEDIAMODE_AUTOMATEDVOICE    = $00000008;
  LINEMEDIAMODE_DATAMODEM         = $00000010;
  LINEMEDIAMODE_G3FAX             = $00000020;
  LINEMEDIAMODE_TDD               = $00000040;
  LINEMEDIAMODE_G4FAX             = $00000080;
  LINEMEDIAMODE_DIGITALDATA       = $00000100;
  LINEMEDIAMODE_TELETEX           = $00000200;
  LINEMEDIAMODE_VIDEOTEX          = $00000400;
  LINEMEDIAMODE_TELEX             = $00000800;
  LINEMEDIAMODE_MIXED             = $00001000;
  LINEMEDIAMODE_ADSI              = $00002000;
  LINEMEDIAMODE_VOICEVIEW         = $00004000;

  LAST_LINEMEDIAMODE  = $00004000;

type
  LPLineMonitorTone = ^TLineMonitorTone;
  TLineMonitorTone = record
    dwAppSpecific,
    dwDuration,
    dwFrequency1,
    dwFrequency2,
    dwFrequency3: Longint;
    end;

const
  LINEPARKMODE_DIRECTED     = $00000001;
  LINEPARKMODE_NONDIRECTED  = $00000002;

  LINEREMOVEFROMCONF_NONE = $00000001;
  LINEREMOVEFROMCONF_LAST = $00000002;
  LINEREMOVEFROMCONF_ANY  = $00000003;

type
  LPLineReqMakeCall = ^TLineReqMakeCall;
  TLineReqMakeCall = record
    szDestAddress: array[0.. TAPIMAXDESTADDRESSSIZE - 1] of char;
    szAppName: array[0..TAPIMAXAPPNAMESIZE - 1] of char;
    szCalledParty: array[0..TAPIMAXCALLEDPARTYSIZE - 1] of char;
    szComment: array[0..TAPIMAXCOMMENTSIZE] of char;
    end;

  LPLineReqMediaCall = ^TLineReqMediaCall;
  TLineReqMediaCall = record
    hWnd: HWnd;
    wRequestID: Word;
    szDeviceClass: array[0..TAPIMAXDEVICECLASSSIZE - 1] of char;
    ucDeviceID: array[0..TAPIMAXDEVICEIDSIZE] of Byte;
    dwSize,
    dwSecure: Longint;
    szDestAddress: array[0..TAPIMAXDESTADDRESSSIZE - 1] of char;
    szAppName: array[0..TAPIMAXAPPNAMESIZE - 1] of char;
    szCalledParty: array[0..TAPIMAXCALLEDPARTYSIZE - 1] of char;
    szComment: array[0..TAPIMAXCOMMENTSIZE - 1] of char;
    end;

const
  LINEREQUESTMODE_MAKECALL  = $00000001;
  LINEREQUESTMODE_MEDIACALL = $00000002;
  LINEREQUESTMODE_DROP      = $00000004;

  LAST_LINEREQUESTMODE  = LINEREQUESTMODE_MEDIACALL;


  LINEROAMMODE_UNKNOWN  = $00000001;
  LINEROAMMODE_UNAVAIL  = $00000002;
  LINEROAMMODE_HOME     = $00000004;
  LINEROAMMODE_ROAMA    = $00000008;
  LINEROAMMODE_ROAMB    = $00000010;

  LINESPECIALINFO_NOCIRCUIT = $00000001;
  LINESPECIALINFO_CUSTIRREG = $00000002;
  LINESPECIALINFO_REORDER   = $00000004;
  LINESPECIALINFO_UNKNOWN   = $00000008;
  LINESPECIALINFO_UNAVAIL   = $00000010;

type
  LPLineTermCaps = ^TLineTermCaps;
  TLineTermCaps = record
    dwTermDev,
    dwTermModes,
    dwTermSharing: Longint;
    end;

const
  LINETERMDEV_PHONE   = $00000001;
  LINETERMDEV_HEADSET = $00000002;
  LINETERMDEV_SPEAKER = $00000004;

  LINETERMMODE_BUTTONS       = $00000001;
  LINETERMMODE_LAMPS         = $00000002;
  LINETERMMODE_DISPLAY       = $00000004;
  LINETERMMODE_RINGER        = $00000008;
  LINETERMMODE_HOOKSWITCH    = $00000010;
  LINETERMMODE_MEDIATOLINE   = $00000020;
  LINETERMMODE_MEDIAFROMLINE = $00000040;
  LINETERMMODE_MEDIABIDIRECT = $00000080;

  LINETERMSHARING_PRIVATE     = $00000001;
  LINETERMSHARING_SHAREDEXCL  = $00000002;
  LINETERMSHARING_SHAREDCONF  = $00000004;

  LINETONEMODE_CUSTOM   = $00000001;
  LINETONEMODE_RINGBACK = $00000002;
  LINETONEMODE_BUSY     = $00000004;
  LINETONEMODE_BEEP     = $00000008;
  LINETONEMODE_BILLING  = $00000010;

  LINETRANSFERMODE_TRANSFER   = $00000001;
  LINETRANSFERMODE_CONFERENCE = $00000002;

type
  LPLineTranslateOutput = ^TLineTranslateOutput;
  TLineTranslateOutput = record
    dwTotalSize,
    dwNeededSize,
    dwUsedSize,

    dwDialableStringSize,
    dwDialableStringOffset,
    dwDisplayableStringSize,
    dwDisplayableStringOffset,

    dwCurrentCountry,
    dwDestCountry,
    dwTranslateResults: Longint;
    end;

  LPLineTranslateCaps = ^TLineTranslateCaps;
  TLineTranslateCaps = record
    dwTotalSize,
    dwNeededSize,
    dwUsedSize,

    dwNumLocations,
    dwLocationListSize,
    dwLocationListOffset,

    dwCurrentLocationID,

    dwNumCards,
    dwCardListSize,
    dwCardListOffset,

    dwCurrentPreferredCardID: Longint;
    end;

  LPLineLocationEntry = ^TLineLocationEntry;
  TLineLocationEntry = record
    dwPermanentLocationID,
    dwLocationNameSize,
    dwLocationNameOffset,
    dwCountryCode,
    dwCityCodeSize,
    dwCityCodeOffset,
    dwPreferredCardID,
    dwLocalAccessCodeSize,
    dwLocalAccessCodeOffset,
    dwLongDistanceAccessCodeSize,
    dwLongDistanceAccessCodeOffset,
    dwTollPrefixListSize,
    dwTollPrefixListOffset,
    dwCountryID,
    dwOptions,
    dwCancelCallWaitingSize,
    dwCancelCallWaitingOffset: Longint;
    end;

  LPLineCardEntry = ^TLineCardEntry;
  TLineCardEntry = record
    dwPermanentCardID,
    dwCardNameSize,
    dwCardNameOffset,
    dwCardNumberDigits,
    dwSameAreaRuleSize,
    dwSameAreaRuleOffset,
    dwLongDistanceRuleSize,
    dwLongDistanceRuleOffset,
    dwInternationalRuleSize,
    dwInternationalRuleOffset,
    dwOptions: Longint;
    end;

  LPLineCountryList = ^TLineCountryList;
  TLineCountryList = record
    dwTotalSize,
    dwNeededSize,
    dwUsedSize,

    dwNumCountries,
    dwCountryListSize,
    dwCountryListOffset: Longint;
    end;

  LPLineCountryEntry = ^TLineCountryEntry;
  TLineCountryEntry = record
    dwCountryID,
    dwCountryCode,
    dwNextCountryID,
    dwCountryNameSize,
    dwCountryNameOffset,
    dwSameAreaRuleSize,
    dwSameAreaRuleOffset,
    dwLongDistanceRuleSize,
    dwLongDistanceRuleOffset,
    dwInternationalRuleSize,
    dwInternationalRuleOffset: Longint;
    end;

  LPLineProviderList = ^TLineProviderList;
  TLineProviderList = record
    dwTotalSize,
    dwNeededSize,
    dwUsedSize,
    dwNumProviders,
    dwProviderListSize,
    dwProviderListOffset: Longint;
    end;

  LPLineProviderEntry = ^TLineProviderEntry;
  TLineProviderEntry = record
    dwPermanentProviderID,
    dwProviderFilenameSize,
    dwProviderFilenameOffset: Longint;
    end;

const
  LINETOLLLISTOPTION_ADD    = $00000001;
  LINETOLLLISTOPTION_REMOVE = $00000002;

  LINETRANSLATEOPTION_CARDOVERRIDE      = $00000001;
  LINETRANSLATEOPTION_CANCELCALLWAITING = $00000002;
  LINETRANSLATEOPTION_FORCELOCAL        = $00000004;
  LINETRANSLATEOPTION_FORCELD           = $00000008;

  LINETRANSLATERESULT_CANONICAL     = $00000001;
  LINETRANSLATERESULT_INTERNATIONAL = $00000002;
  LINETRANSLATERESULT_LONGDISTANCE  = $00000004;
  LINETRANSLATERESULT_LOCAL         = $00000008;
  LINETRANSLATERESULT_INTOLLLIST    = $00000010;
  LINETRANSLATERESULT_NOTINTOLLLIST = $00000020;
  LINETRANSLATERESULT_DIALBILLING   = $00000040;
  LINETRANSLATERESULT_DIALQUIET     = $00000080;
  LINETRANSLATERESULT_DIALDIALTONE  = $00000100;
  LINETRANSLATERESULT_DIALPROMPT    = $00000200;


  LINELOCATIONOPTION_PULSEDIAL  = $00000001;

  LINECARDOPTION_PREDEFINED = $00000001;
  LINECARDOPTION_HIDDEN     = $00000002;


{ Simple Telephony prototypes }

{$IFDEF WIN32}

function tapiRequestMakeCall(
    lpszDestAddress, lpszAppName,
    lpszCalledParty, lpszComment: PChar): Longint; stdcall;

function tapiRequestMediaCall(
    Wnd: HWnd;
    wRequestID: Word;
    lpszDeviceClass, lpDeviceID: PChar;
    dwSize, dwSecure: Longint;
    lpszDestAddress, lpszAppName, lpszCalledParty, lpszComment: PChar): Longint; stdcall;

function tapiRequestDrop(
    Wnd: HWnd;
    wRequestID: Word): Longint; stdcall;

function lineRegisterRequestRecipient(
    hLineApp: THLineApp;
    dwRegistrationInstance, dwRequestMode, bEnable: Longint): Longint; stdcall;

function tapiGetLocationInfo(
    lpszCountryCode, lpszCityCode: PChar): Longint; stdcall;

{ Tapi Address Translation procedures }
function lineSetCurrentLocation(
    hLineApp: THLineApp;
    dwLocation: Longint): Longint; stdcall;

function lineSetTollList(
    hLineApp: THLineApp;
    dwDeviceID: Longint;
    lpszAddressIn: PChar;
    dwTollListOption: Longint): Longint; stdcall;

function lineTranslateAddress(
    hLineApp: THLineApp;
    dwDeviceID, dwAPIVersion: Longint;
    lpszAddressIn: PChar;
    dwCard, dwTranslateOptions: Longint;
    var lpTranslateOutput: TLineTranslateOutput): Longint; stdcall;

function lineGetTranslateCaps(
    hLineApp: THLineApp;
    dwAPIVersion: Longint;
    var lpTranslateCaps: TLineTranslateCaps): Longint; stdcall;


{ Tapi function prototypes }

function lineAccept(
    hCall: THCall;
    lpsUserUserInfo: PChar;
    dwSize: Longint): Longint; stdcall;

function lineAddToConference(
    hConfCall, hConsultCall: THCall): Longint; stdcall;

function lineAnswer(
    hCall: THCall;
    lpsUserUserInfo: PChar;
    dwSize: Longint): Longint; stdcall;

function lineBlindTransfer(
    hCall: THCall;
    lpszDestAddress: PChar;
    dwCountryCode: Longint): Longint; stdcall;

function lineClose(
    hLine: THLine): Longint; stdcall;

function  lineCompleteCall(
    hCall: THCall;
    var lpdwCompletionID: Longint;
    dwCompletionMode, dwMessageID: Longint): Longint; stdcall;

function lineCompleteTransfer(
    hCall, hConsultCall: THCall;
    var lphConfCall: THCall;
    dwTransferMode: Longint): Longint; stdcall;

function lineConfigDialog(
    dwDeviceID: Longint;
    hwndOwner: HWnd;
    lpszDeviceClass: PChar): Longint; stdcall;

function lineConfigDialogEdit(
    dwDeviceID: Longint;
    hwndOwner: HWnd;
    lpszDeviceClass: PChar;
    lpDeviceConfigIn: Pointer;
    dwSize: Longint;
    var lpDeviceConfigOut: TVarString): Longint; stdcall;

function lineDeallocateCall(
    hCall: THCall): Longint; stdcall;

function lineDevSpecific(
    hLine: THLine;
    dwAddressID: Longint;
    hCall: THCall;
    lpParams: Pointer;
    dwSize: Longint): Longint; stdcall;

function lineDevSpecificFeature(
    hLine: THLine;
    dwFeature: Longint;
    lpParams: Pointer;
    dwSize: Longint): Longint; stdcall;

function lineDial(
    hCall: THCall;
    lpszDestAddress: PChar;
    dwCountryCode: Longint): Longint; stdcall;

function lineDrop(
    hCall: THCall;
    lpsUserUserInfo: PChar;
    dwSize: Longint): Longint; stdcall;

function lineForward(
    hLine: THLine;
    bAllAddresses, dwAddressID: Longint;
    var lpForwardList: TLineForwardList;
    dwNumRingsNoAnswer: Longint;
    var lphConsultCall: THCall;
    var lpCallParams: TLineCallParams): Longint; stdcall;

function lineGatherDigits(
    hCall: THCall;
    dwDigitModes: Longint;
    lpsDigits: PChar;
    dwNumDigits: Longint;
    lpszTerminationDigits: PChar;
    dwFirstDigitTimeout, dwInterDigitTimeout: Longint): Longint; stdcall;

function lineGenerateDigits(
    hCall: THCall;
    dwDigitMode: Longint;
    lpszDigits: PChar;
    dwDuration: Longint): Longint; stdcall;

function lineGenerateTone(
    hCall: THCall;
    dwToneMode, dwDuration, dwNumTones: Longint;
    var lpTones: TLineGenerateTone): Longint; stdcall;

function lineGetAddressCaps(
    hLineApp: THLineApp;
    dwDeviceID, dwAddressID, dwAPIVersion, dwExtVersion: Longint;
    var lpAddressCaps: TLineAddressCaps): Longint; stdcall;

function lineGetAddressID(
    hLine: THLine;
    var lpdwAddressID: Longint;
    dwAddressMode: Longint;
    lpsAddress: Pchar;
    dwSize: Longint): Longint; stdcall;

function lineGetAddressStatus(
    hLine: THLine;
    dwAddressID: Longint;
    var lpAddressStatus: TLineAddressStatus): Longint; stdcall;

function lineGetCallInfo(
    hCall: THCall;
    var lpCallInfo: TLineCallInfo): Longint; stdcall;

function lineGetCallStatus(
    hCall: THCall;
    var lpCallStatus: TLineCallStatus): Longint; stdcall;

function lineGetConfRelatedCalls(
    hCall: THCall;
    var lpCallList: TLineCallList): Longint; stdcall;

function lineGetDevCaps(
    hLineApp: THLineApp;
    dwDeviceID, dwAPIVersion, dwExtVersion: Longint;
    var lpLineDevCaps: TLineDevCaps): Longint; stdcall;

function lineGetDevConfig(
    dwDeviceID: Longint;
    var lpDeviceConfig: TVarString;
    lpszDeviceClass: PChar): Longint; stdcall;

function lineGetNewCalls(
    hLine: THLine;
    dwAddressID, dwSelect: Longint;
    var lpCallList: TLineCallList): Longint; stdcall;

function lineGetIcon(
    dwDeviceID: Longint;
    lpszDeviceClass: PChar;
    var lphIcon: HIcon): Longint; stdcall;

function lineGetID(
    hLine: THLine;
    dwAddressID: Longint;
    hCall: THCall;
    dwSelect: Longint;
    var lpDeviceID: TVarString;
    lpszDeviceClass: PChar): Longint; stdcall;

function lineGetLineDevStatus(
    hLine: THLine;
    var lpLineDevStatus: TLineDevStatus): Longint; stdcall;

function lineGetNumRings(
    hLine: THLine;
    dwAddressID: Longint;
    var lpdwNumRings: Longint): Longint; stdcall;

function lineGetRequest(
    hLineApp: THLineApp;
    dwRequestMode: Longint;
    lpRequestBuffer: Pointer): Longint; stdcall;

function lineGetStatusMessages(
    hLine: THLine;
    var lpdwLineStates, lpdwAddressStates: Longint): Longint; stdcall;

function lineHandoff(
    hCall: THCall;
    lpszFileName: PChar;
    dwMediaMode: Longint): Longint; stdcall;

function lineHold(
    hCall: THCall): Longint; stdcall;

function lineInitialize(
    var lphLineApp: THLineApp;
    hInstance: THandle;
    lpfnCallback: Pointer;
    lpszAppName: PChar;
    var lpdwNumDevs: Longint): Longint; stdcall;

function lineMakeCall(
    hLine: THLine;
    var lphCall: THCall;
    lpszDestAddress: Pchar;
    dwCountryCode: Longint;
    var lpCallParams: TLineCallparams): Longint; stdcall;

function lineMonitorDigits(
    hCall: THCall;
    dwDigitModes: Longint): Longint; stdcall;

function lineMonitorMedia(
    hCall: THCall;
    dwMediaModes: Longint): Longint; stdcall;

function lineMonitorTones(
    hCall: THCall;
    var lpToneList: TLineMonitorTone;
    dwNumEntries: Longint): Longint; stdcall;

function lineNegotiateAPIVersion(
    hLineApp: THLineApp;
    dwDeviceID, dwAPILowVersion, dwAPIHighVersion: Longint;
    var lpdwAPIVersion: Longint;
    var lpExtensionID: TLineExtensionID): Longint; stdcall;

function lineNegotiateExtVersion(
    hLineApp: THLineApp;
    dwDeviceID, dwAPIVersion, dwExtLowVersion, dwExtHighVersion: Longint;
    var lpdwExtVersion: Longint): Longint; stdcall;

function lineOpen(
    hLineApp: THLineApp;
    dwDeviceID: Longint;
    var lphLine: THLine;
    dwAPIVersion, dwExtVersion, dwCallbackInstance,
    dwPrivileges, dwMediaModes: Longint;
    var lpCallParams: TLineCallParams): Longint; stdcall;

function linePark(
    hCall: THCall;
    dwParkMode: Longint;
    lpszDirAddress: PChar;
    var lpNonDirAddress: TVarString): Longint; stdcall;

function linePickup(
    hLine: THLine;
    dwAddressID: Longint;
    var lphCall: THCall;
    lpszDestAddress, lpszGroupID: PChar): Longint; stdcall;

function linePrepareAddToConference(
    hConfCall: THCall;
    var lphConsultCall: THCall;
    var lpCallParams: TLineCallParams): Longint; stdcall;

function lineRedirect(
    hCall: THCall;
    lpszDestAddress: PChar;
    dwCountryCode: Longint): Longint; stdcall;

function lineRemoveFromConference(
    hCall: THCall): Longint; stdcall;

function lineSecureCall(
    hCall: THCall): Longint; stdcall;

function lineSendUserUserInfo(
    hCall: THCall;
    lpsUserUserInfo: PChar;
    dwSize: Longint): Longint; stdcall;

function lineSetAppSpecific(
    hCall: THCall;
    dwAppSpecific: Longint): Longint; stdcall;

function lineSetCallParams(
    hCall: THCall;
    dwBearerMode, dwMinRate, dwMaxRate: Longint;
    var lpDialParams: TLineDialParams): Longint; stdcall;

function lineSetCallPrivilege(
    hCall: THCall;
    dwCallPrivilege: Longint): Longint; stdcall;

function lineSetDevConfig(
    dwDeviceID: Longint;
    lpDeviceConfig: Pointer;
    dwSize: Longint;
    lpszDeviceClass: PChar): Longint; stdcall;

function lineSetMediaControl(
    hLine: THLine;
    dwAddressID: Longint;
    hCall: THCall;
    dwSelect: Longint;
    var lpDigitList: TLineMediaControlDigit;
    dwDigitNumEntries: Longint;
    var lpMediaList: TLineMediaControlMedia;
    dwMediaNumEntries: Longint;
    var lpToneList: TLineMediaControlTone;
    dwToneNumEntries: Longint;
    var lpCallStateList: TLineMediaControlCallState;
    dwCallStateNumEntries: Longint): Longint; stdcall;

function lineSetMediaMode(
    hCall: THCall;
    dwMediaModes: Longint): Longint; stdcall;

function lineSetNumRings(
    hLine: THLine;
    dwAddressID, dwNumRings: Longint): Longint; stdcall;

function lineSetStatusMessages(
    hLine: THLine;
    dwLineStates, dwAddressStates: Longint): Longint; stdcall;

function lineSetTerminal(
    hLine: THLine;
    dwAddressID: Longint;
    hCall: THCall;
    dwSelect, dwTerminalModes, dwTerminalID, bEnable: Longint): Longint; stdcall;

function lineSetupConference(
    hCall: THCall;
    hLine: THLine;
    varlphConfCall, lphConsultCall: THCall;
    dwNumParties: Longint;
    var lpCallParams: TLineCallParams): Longint; stdcall;

function lineSetupTransfer(
    hCall: THCall;
    var lphConsultCall: THCall;
    var lpCallParams: TLineCallParams): Longint; stdcall;

function lineShutdown(
    hLineApp: THLineApp): Longint; stdcall;

function lineSwapHold(
    hActiveCall, hHeldCall: THCall): Longint; stdcall;

function lineUncompleteCall(
    hLine: THLine;
    dwCompletionID: Longint): Longint; stdcall;

function lineUnhold(
    hCall: THCall): Longint; stdcall;

function lineUnpark(
    hLine: THLine;
    dwAddressID: Longint;
    var lphCall: THCall;
    lpszDestAddress: PChar): Longint; stdcall;

function lineReleaseUserUserInfo(
    hCall: THCall): Longint; stdcall;


function phoneClose(
    hPhone: THPhone): Longint; stdcall;

function phoneConfigDialog(
    dwDeviceID: Longint;
    hwndOwner: HWnd;
    lpszDeviceClass: PChar): Longint; stdcall;

function phoneDevSpecific(
    hPhone: THPhone;
    lpParams: Pointer;
    dwSize: Longint): Longint; stdcall;

function phoneGetButtonInfo(
    hPhone: THPhone;
    dwButtonLampID: Longint;
    var lpButtonInfo: TPhoneButtonInfo): Longint; stdcall;

function phoneGetData(
    hPhone: THPhone;
    dwDataID: Longint;
    lpData: Pointer;
    dwSize: Longint): Longint; stdcall;

function phoneGetDevCaps(
    hPhoneApp: THPhoneApp;
    dwDeviceID, dwAPIVersion, dwExtVersion: Longint;
    var lpPhoneCaps: TPhoneCaps): Longint; stdcall;

function phoneGetDisplay(
    hPhone: THPhone;
    var lpDisplay: TVarString): Longint; stdcall;

function phoneGetGain(
    hPhone: THPhone;
    dwHookSwitchDev: Longint;
    var lpdwGain: Longint): Longint; stdcall;

function phoneGetHookSwitch(
    hPhone: THPhone;
    var lpdwHookSwitchDevs: Longint): Longint; stdcall;

function phoneGetIcon(
    dwDeviceID: Longint;
    lpszDeviceClass: PChar;
    var lphIcon: HIcon): Longint; stdcall;

function phoneGetID(
    hPhone: THPhone;
    var lpDeviceID: TVarString;
    lpszDeviceClass: PChar): Longint; stdcall;

function phoneGetLamp(
    hPhone: THPhone;
    dwButtonLampID: Longint;
    var lpdwLampMode: Longint): Longint; stdcall;

function phoneGetRing(
    hPhone: THPhone;
    var lpdwRingMode, lpdwVolume: Longint): Longint; stdcall;

function phoneGetStatus(
    hPhone: THPhone;
    var lpPhoneStatus: TPhoneStatus): Longint; stdcall;

function phoneGetStatusMessages(
    hPhone: THPhone;
    var lpdwPhoneStates, lpdwButtonModes, lpdwButtonStates: Longint): Longint; stdcall;

function phoneGetVolume(
    hPhone: THPhone;
    dwHookSwitchDev: Longint;
    var lpdwVolume: Longint): Longint; stdcall;

function phoneInitialize(
    var lphPhoneApp: THPhoneApp;
    hInstance: THandle;
    lpfnCallback: Pointer;
    lpszAppName: PChar;
    var lpdwNumDevs: Longint): Longint; stdcall;

function phoneNegotiateAPIVersion(
    hPhoneApp: THPhoneApp;
    dwDeviceID, dwAPILowVersion, dwAPIHighVersion: Longint;
    var lpdwAPIVersion: Longint;
    var lpExtensionID: TPHoneExtensionID): Longint; stdcall;

function phoneNegotiateExtVersion(
    hPhoneApp: THPhoneApp;
    dwDeviceID, dwAPIVersion, dwExtLowVersion, dwExtHighVersion: Longint;
    var lpdwExtVersion: Longint): Longint; stdcall;

function phoneOpen(
    hPhoneApp: THPhoneApp;
    dwDeviceID: Longint;
    var lphPhone: THPhone;
    dwAPIVersion, dwExtVersion, dwCallbackInstance, dwPrivilege: Longint): Longint; stdcall;

function phoneSetButtonInfo(
    hPhone: THPhone;
    dwButtonLampID: Longint;
    var lpButtonInfo: TPhoneButtonInfo): Longint; stdcall;

function phoneSetData(
    hPhone: THPhone;
    dwDataID: Longint;
    lpData: Pointer;
    dwSize: Longint): Longint; stdcall;

function phoneSetDisplay(
    hPhone: THPhone;
    dwRow, dwColumn: Longint;
    lpsDisplay: PChar;
    dwSize: Longint): Longint; stdcall;

function phoneSetGain(
    hPhone: THPhone;
    dwHookSwitchDev, dwGain: Longint): Longint; stdcall;

function phoneSetHookSwitch(
    hPhone: THPhone;
    dwHookSwitchDevs, dwHookSwitchMode: Longint): Longint; stdcall;

function phoneSetLamp(
    hPhone: THPhone;
    dwButtonLampID, dwLampMode: Longint): Longint; stdcall;

function phoneSetRing(
    hPhone: THPhone;
    dwRingMode, dwVolume: Longint): Longint; stdcall;

function phoneSetStatusMessages(
    hPhone: THPhone;
    dwPhoneStates, dwButtonModes, dwButtonStates: Longint): Longint; stdcall;

function phoneSetVolume(
    hPhone: THPhone;
    dwHookSwitchDev, dwVolume: Longint): Longint; stdcall;

function phoneShutdown(hPhoneApp: THPhoneApp): Longint; stdcall;


function lineTranslateDialog(
    hLineApp: THLineApp;
    dwDeviceID, dwAPIVersion: Longint;
    hwndOwner: HWnd;
    lpszAddressIn: PChar): Longint; stdcall;

function lineGetCountry(
    dwCountryID, dwAPIVersion: Longint;
    var lpLineCountryList: TLineCountryList): Longint; stdcall;

function lineGetAppPriority(
    lpszAppFilename: PChar;
    dwMediaMode: Longint;
    var lpExtensionID: TLineExtensionID;
    dwRequestMode: Longint;
    var lpExtensionName: TVarString;
    var lpdwPriority: Longint): Longint; stdcall;

function lineSetAppPriority(
    lpszAppFilename: PChar;
    dwMediaMode: Longint;
    var lpExtensionID: TLineExtensionID;
    dwRequestMode: Longint;
    lpszExtensionName: PChar;
    dwPriority: Longint): Longint; stdcall;

function lineAddProvider(
    lpszProviderFilename: PChar;
    hwndOwner: THandle;
    var lpdwPermanentProviderID: Longint): Longint; stdcall;

function lineConfigProvider(
    hwndOwner: THandle;
    dwPermanentProviderID: Longint): Longint; stdcall;

function lineRemoveProvider(
    dwPermanentProviderID: Longint;
    hwndOwner: THandle): Longint; stdcall;

function lineGetProviderList(
    dwAPIVersion: Longint;
    var lpProviderList: TLineProviderList): Longint; stdcall;

{$ELSE}

function tapiRequestMakeCall(
    lpszDestAddress, lpszAppName,
    lpszCalledParty, lpszComment: PChar): Longint;

function tapiRequestMediaCall(
    Wnd: HWnd;
    wRequestID: Word;
    lpszDeviceClass, lpDeviceID: PChar;
    dwSize, dwSecure: Longint;
    lpszDestAddress, lpszAppName, lpszCalledParty, lpszComment: PChar): Longint;

function tapiRequestDrop(
    Wnd: HWnd;
    wRequestID: Word): Longint;

function lineRegisterRequestRecipient(
    hLineApp: THLineApp;
    dwRegistrationInstance, dwRequestMode, bEnable: Longint): Longint;

function tapiGetLocationInfo(
    lpszCountryCode, lpszCityCode: PChar): Longint;

{ Tapi Address Translation procedures }
function lineSetCurrentLocation(
    hLineApp: THLineApp;
    dwLocation: Longint): Longint;

function lineSetTollList(
    hLineApp: THLineApp;
    dwDeviceID: Longint;
    lpszAddressIn: PChar;
    dwTollListOption: Longint): Longint;

function lineTranslateAddress(
    hLineApp: THLineApp;
    dwDeviceID, dwAPIVersion: Longint;
    lpszAddressIn: PChar;
    dwCard, dwTranslateOptions: Longint;
    var lpTranslateOutput: TLineTranslateOutput): Longint;

function lineGetTranslateCaps(
    hLineApp: THLineApp;
    dwAPIVersion: Longint;
    var lpTranslateCaps: TLineTranslateCaps): Longint;


{ Tapi function prototypes }

function lineAccept(
    hCall: THCall;
    lpsUserUserInfo: PChar;
    dwSize: Longint): Longint;

function lineAddToConference(
    hConfCall, hConsultCall: THCall): Longint;

function lineAnswer(
    hCall: THCall;
    lpsUserUserInfo: PChar;
    dwSize: Longint): Longint;

function lineBlindTransfer(
    hCall: THCall;
    lpszDestAddress: PChar;
    dwCountryCode: Longint): Longint;

function lineClose(
    hLine: THLine): Longint;

function  lineCompleteCall(
    hCall: THCall;
    var lpdwCompletionID: Longint;
    dwCompletionMode, dwMessageID: Longint): Longint;

function lineCompleteTransfer(
    hCall, hConsultCall: THCall;
    var lphConfCall: THCall;
    dwTransferMode: Longint): Longint;

function lineConfigDialog(
    dwDeviceID: Longint;
    hwndOwner: HWnd;
    lpszDeviceClass: PChar): Longint;

function lineConfigDialogEdit(
    dwDeviceID: Longint;
    hwndOwner: HWnd;
    lpszDeviceClass: PChar;
    lpDeviceConfigIn: Pointer;
    dwSize: Longint;
    var lpDeviceConfigOut: TVarString): Longint;

function lineDeallocateCall(
    hCall: THCall): Longint;

function lineDevSpecific(
    hLine: THLine;
    dwAddressID: Longint;
    hCall: THCall;
    lpParams: Pointer;
    dwSize: Longint): Longint;

function lineDevSpecificFeature(
    hLine: THLine;
    dwFeature: Longint;
    lpParams: Pointer;
    dwSize: Longint): Longint;

function lineDial(
    hCall: THCall;
    lpszDestAddress: PChar;
    dwCountryCode: Longint): Longint;

function lineDrop(
    hCall: THCall;
    lpsUserUserInfo: PChar;
    dwSize: Longint): Longint;

function lineForward(
    hLine: THLine;
    bAllAddresses, dwAddressID: Longint;
    var lpForwardList: TLineForwardList;
    dwNumRingsNoAnswer: Longint;
    var lphConsultCall: THCall;
    var lpCallParams: TLineCallParams): Longint;

function lineGatherDigits(
    hCall: THCall;
    dwDigitModes: Longint;
    lpsDigits: PChar;
    dwNumDigits: Longint;
    lpszTerminationDigits: PChar;
    dwFirstDigitTimeout, dwInterDigitTimeout: Longint): Longint;

function lineGenerateDigits(
    hCall: THCall;
    dwDigitMode: Longint;
    lpszDigits: PChar;
    dwDuration: Longint): Longint;

function lineGenerateTone(
    hCall: THCall;
    dwToneMode, dwDuration, dwNumTones: Longint;
    var lpTones: TLineGenerateTone): Longint;

function lineGetAddressCaps(
    hLineApp: THLineApp;
    dwDeviceID, dwAddressID, dwAPIVersion, dwExtVersion: Longint;
    var lpAddressCaps: TLineAddressCaps): Longint;

function lineGetAddressID(
    hLine: THLine;
    var lpdwAddressID: Longint;
    dwAddressMode: Longint;
    lpsAddress: Pchar;
    dwSize: Longint): Longint;

function lineGetAddressStatus(
    hLine: THLine;
    dwAddressID: Longint;
    var lpAddressStatus: TLineAddressStatus): Longint;

function lineGetCallInfo(
    hCall: THCall;
    var lpCallInfo: TLineCallInfo): Longint;

function lineGetCallStatus(
    hCall: THCall;
    var lpCallStatus: TLineCallStatus): Longint;

function lineGetConfRelatedCalls(
    hCall: THCall;
    var lpCallList: TLineCallList): Longint;

function lineGetDevCaps(
    hLineApp: THLineApp;
    dwDeviceID, dwAPIVersion, dwExtVersion: Longint;
    var lpLineDevCaps: TLineDevCaps): Longint;

function lineGetDevConfig(
    dwDeviceID: Longint;
    var lpDeviceConfig: TVarString;
    lpszDeviceClass: PChar): Longint;

function lineGetNewCalls(
    hLine: THLine;
    dwAddressID, dwSelect: Longint;
    var lpCallList: TLineCallList): Longint;

function lineGetIcon(
    dwDeviceID: Longint;
    lpszDeviceClass: PChar;
    var lphIcon: HIcon): Longint;

function lineGetID(
    hLine: THLine;
    dwAddressID: Longint;
    hCall: THCall;
    dwSelect: Longint;
    var lpDeviceID: TVarString;
    lpszDeviceClass: PChar): Longint; 

function lineGetLineDevStatus(
    hLine: THLine;
    var lpLineDevStatus: TLineDevStatus): Longint;

function lineGetNumRings(
    hLine: THLine;
    dwAddressID: Longint;
    var lpdwNumRings: Longint): Longint;

function lineGetRequest(
    hLineApp: THLineApp;
    dwRequestMode: Longint;
    lpRequestBuffer: Pointer): Longint;

function lineGetStatusMessages(
    hLine: THLine;
    var lpdwLineStates, lpdwAddressStates: Longint): Longint;

function lineHandoff(
    hCall: THCall;
    lpszFileName: PChar;
    dwMediaMode: Longint): Longint; 

function lineHold(
    hCall: THCall): Longint; 

function lineInitialize(
    var lphLineApp: THLineApp;
    hInstance: THandle;
    lpfnCallback: Pointer;
    lpszAppName: PChar;
    var lpdwNumDevs: Longint): Longint;

function lineMakeCall(
    hLine: THLine;
    var lphCall: THCall;
    lpszDestAddress: Pchar;
    dwCountryCode: Longint;
    var lpCallParams: TLineCallparams): Longint; 

function lineMonitorDigits(
    hCall: THCall;
    dwDigitModes: Longint): Longint; 

function lineMonitorMedia(
    hCall: THCall;
    dwMediaModes: Longint): Longint;

function lineMonitorTones(
    hCall: THCall;
    var lpToneList: TLineMonitorTone;
    dwNumEntries: Longint): Longint; 

function lineNegotiateAPIVersion(
    hLineApp: THLineApp;
    dwDeviceID, dwAPILowVersion, dwAPIHighVersion: Longint;
    var lpdwAPIVersion: Longint;
    var lpExtensionID: TLineExtensionID): Longint; 

function lineNegotiateExtVersion(
    hLineApp: THLineApp;
    dwDeviceID, dwAPIVersion, dwExtLowVersion, dwExtHighVersion: Longint;
    var lpdwExtVersion: Longint): Longint; 

function lineOpen(
    hLineApp: THLineApp;
    dwDeviceID: Longint;
    var lphLine: THLine;
    dwAPIVersion, dwExtVersion, dwCallbackInstance,
    dwPrivileges, dwMediaModes: Longint;
    var lpCallParams: TLineCallParams): Longint; 

function linePark(
    hCall: THCall;
    dwParkMode: Longint;
    lpszDirAddress: PChar;
    var lpNonDirAddress: TVarString): Longint; 

function linePickup(
    hLine: THLine;
    dwAddressID: Longint;
    var lphCall: THCall;
    lpszDestAddress, lpszGroupID: PChar): Longint; 

function linePrepareAddToConference(
    hConfCall: THCall;
    var lphConsultCall: THCall;
    var lpCallParams: TLineCallParams): Longint; 

function lineRedirect(
    hCall: THCall;
    lpszDestAddress: PChar;
    dwCountryCode: Longint): Longint;

function lineRemoveFromConference(
    hCall: THCall): Longint;

function lineSecureCall(
    hCall: THCall): Longint;

function lineSendUserUserInfo(
    hCall: THCall;
    lpsUserUserInfo: PChar;
    dwSize: Longint): Longint;

function lineSetAppSpecific(
    hCall: THCall;
    dwAppSpecific: Longint): Longint;

function lineSetCallParams(
    hCall: THCall;
    dwBearerMode, dwMinRate, dwMaxRate: Longint;
    var lpDialParams: TLineDialParams): Longint;

function lineSetCallPrivilege(
    hCall: THCall;
    dwCallPrivilege: Longint): Longint;

function lineSetDevConfig(
    dwDeviceID: Longint;
    lpDeviceConfig: Pointer;
    dwSize: Longint;
    lpszDeviceClass: PChar): Longint;

function lineSetMediaControl(
    hLine: THLine;
    dwAddressID: Longint;
    hCall: THCall;
    dwSelect: Longint;
    var lpDigitList: TLineMediaControlDigit;
    dwDigitNumEntries: Longint;
    var lpMediaList: TLineMediaControlMedia;
    dwMediaNumEntries: Longint;
    var lpToneList: TLineMediaControlTone;
    dwToneNumEntries: Longint;
    var lpCallStateList: TLineMediaControlCallState;
    dwCallStateNumEntries: Longint): Longint;

function lineSetMediaMode(
    hCall: THCall;
    dwMediaModes: Longint): Longint;

function lineSetNumRings(
    hLine: THLine;
    dwAddressID, dwNumRings: Longint): Longint;

function lineSetStatusMessages(
    hLine: THLine;
    dwLineStates, dwAddressStates: Longint): Longint;

function lineSetTerminal(
    hLine: THLine;
    dwAddressID: Longint;
    hCall: THCall;
    dwSelect, dwTerminalModes, dwTerminalID, bEnable: Longint): Longint;

function lineSetupConference(
    hCall: THCall;
    hLine: THLine;
    varlphConfCall, lphConsultCall: THCall;
    dwNumParties: Longint;
    var lpCallParams: TLineCallParams): Longint;

function lineSetupTransfer(
    hCall: THCall;
    var lphConsultCall: THCall;
    var lpCallParams: TLineCallParams): Longint;

function lineShutdown(
    hLineApp: THLineApp): Longint;

function lineSwapHold(
    hActiveCall, hHeldCall: THCall): Longint;

function lineUncompleteCall(
    hLine: THLine;
    dwCompletionID: Longint): Longint;

function lineUnhold(
    hCall: THCall): Longint;

function lineUnpark(
    hLine: THLine;
    dwAddressID: Longint;
    var lphCall: THCall;
    lpszDestAddress: PChar): Longint;

function lineReleaseUserUserInfo(
    hCall: THCall): Longint;


function phoneClose(
    hPhone: THPhone): Longint;

function phoneConfigDialog(
    dwDeviceID: Longint;
    hwndOwner: HWnd;
    lpszDeviceClass: PChar): Longint;

function phoneDevSpecific(
    hPhone: THPhone;
    lpParams: Pointer;
    dwSize: Longint): Longint;

function phoneGetButtonInfo(
    hPhone: THPhone;
    dwButtonLampID: Longint;
    var lpButtonInfo: TPhoneButtonInfo): Longint;

function phoneGetData(
    hPhone: THPhone;
    dwDataID: Longint;
    lpData: Pointer;
    dwSize: Longint): Longint;

function phoneGetDevCaps(
    hPhoneApp: THPhoneApp;
    dwDeviceID, dwAPIVersion, dwExtVersion: Longint;
    var lpPhoneCaps: TPhoneCaps): Longint;

function phoneGetDisplay(
    hPhone: THPhone;
    var lpDisplay: TVarString): Longint;

function phoneGetGain(
    hPhone: THPhone;
    dwHookSwitchDev: Longint;
    var lpdwGain: Longint): Longint;

function phoneGetHookSwitch(
    hPhone: THPhone;
    var lpdwHookSwitchDevs: Longint): Longint;

function phoneGetIcon(
    dwDeviceID: Longint;
    lpszDeviceClass: PChar;
    var lphIcon: HIcon): Longint;

function phoneGetID(
    hPhone: THPhone;
    var lpDeviceID: TVarString;
    lpszDeviceClass: PChar): Longint;

function phoneGetLamp(
    hPhone: THPhone;
    dwButtonLampID: Longint;
    var lpdwLampMode: Longint): Longint;

function phoneGetRing(
    hPhone: THPhone;
    var lpdwRingMode, lpdwVolume: Longint): Longint;

function phoneGetStatus(
    hPhone: THPhone;
    var lpPhoneStatus: TPhoneStatus): Longint;

function phoneGetStatusMessages(
    hPhone: THPhone;
    var lpdwPhoneStates, lpdwButtonModes, lpdwButtonStates: Longint): Longint;

function phoneGetVolume(
    hPhone: THPhone;
    dwHookSwitchDev: Longint;
    var lpdwVolume: Longint): Longint;

function phoneInitialize(
    var lphPhoneApp: THPhoneApp;
    hInstance: THandle;
    lpfnCallback: Pointer;
    lpszAppName: PChar;
    var lpdwNumDevs: Longint): Longint;

function phoneNegotiateAPIVersion(
    hPhoneApp: THPhoneApp;
    dwDeviceID, dwAPILowVersion, dwAPIHighVersion: Longint;
    var lpdwAPIVersion: Longint;
    var lpExtensionID: TPHoneExtensionID): Longint;

function phoneNegotiateExtVersion(
    hPhoneApp: THPhoneApp;
    dwDeviceID, dwAPIVersion, dwExtLowVersion, dwExtHighVersion: Longint;
    var lpdwExtVersion: Longint): Longint;

function phoneOpen(
    hPhoneApp: THPhoneApp;
    dwDeviceID: Longint;
    var lphPhone: THPhone;
    dwAPIVersion, dwExtVersion, dwCallbackInstance, dwPrivilege: Longint): Longint;

function phoneSetButtonInfo(
    hPhone: THPhone;
    dwButtonLampID: Longint;
    var lpButtonInfo: TPhoneButtonInfo): Longint;

function phoneSetData(
    hPhone: THPhone;
    dwDataID: Longint;
    lpData: Pointer;
    dwSize: Longint): Longint;

function phoneSetDisplay(
    hPhone: THPhone;
    dwRow, dwColumn: Longint;
    lpsDisplay: PChar;
    dwSize: Longint): Longint;

function phoneSetGain(
    hPhone: THPhone;
    dwHookSwitchDev, dwGain: Longint): Longint;

function phoneSetHookSwitch(
    hPhone: THPhone;
    dwHookSwitchDevs, dwHookSwitchMode: Longint): Longint;

function phoneSetLamp(
    hPhone: THPhone;
    dwButtonLampID, dwLampMode: Longint): Longint;

function phoneSetRing(
    hPhone: THPhone;
    dwRingMode, dwVolume: Longint): Longint;

function phoneSetStatusMessages(
    hPhone: THPhone;
    dwPhoneStates, dwButtonModes, dwButtonStates: Longint): Longint;

function phoneSetVolume(
    hPhone: THPhone;
    dwHookSwitchDev, dwVolume: Longint): Longint;

function phoneShutdown(hPhoneApp: THPhoneApp): Longint;


function lineTranslateDialog(
    hLineApp: THLineApp;
    dwDeviceID, dwAPIVersion: Longint;
    hwndOwner: HWnd;
    lpszAddressIn: PChar): Longint;

function lineGetCountry(
    dwCountryID, dwAPIVersion: Longint;
    var lpLineCountryList: TLineCountryList): Longint;

function lineGetAppPriority(
    lpszAppFilename: PChar;
    dwMediaMode: Longint;
    var lpExtensionID: TLineExtensionID;
    dwRequestMode: Longint;
    var lpExtensionName: TVarString;
    var lpdwPriority: Longint): Longint;

function lineSetAppPriority(
    lpszAppFilename: PChar;
    dwMediaMode: Longint;
    var lpExtensionID: TLineExtensionID;
    dwRequestMode: Longint;
    lpszExtensionName: PChar;
    dwPriority: Longint): Longint;

function lineAddProvider(
    lpszProviderFilename: PChar;
    hwndOwner: THandle;
    var lpdwPermanentProviderID: Longint): Longint;

function lineConfigProvider(
    hwndOwner: THandle;
    dwPermanentProviderID: Longint): Longint;

function lineRemoveProvider(
    dwPermanentProviderID: Longint;
    hwndOwner: THandle): Longint;

function lineGetProviderList(
    dwAPIVersion: Longint;
    var lpProviderList: TLineProviderList): Longint;

{$ENDIF}

implementation

{$IFDEF WIN32}

function lineAccept                   ; external 'Tapi32.dll' index 1;
function lineAddProvider              ; external 'Tapi32.dll' index 2;
function lineAddToConference          ; external 'Tapi32.dll' index 3;
function lineAnswer                   ; external 'Tapi32.dll' index 4;
function lineBlindTransfer            ; external 'Tapi32.dll' index 5;
function lineClose                    ; external 'Tapi32.dll' index 6;
function lineCompleteCall             ; external 'Tapi32.dll' index 7;
function lineCompleteTransfer         ; external 'Tapi32.dll' index 8;
function lineConfigDialog             ; external 'Tapi32.dll' index 9;
function lineConfigDialogEdit         ; external 'Tapi32.dll' index 10;
function lineConfigProvider           ; external 'Tapi32.dll' index 11;
function lineDeallocateCall           ; external 'Tapi32.dll' index 12;
function lineDevSpecific              ; external 'Tapi32.dll' index 13;
function lineDevSpecificFeature       ; external 'Tapi32.dll' index 14;
function lineDial                     ; external 'Tapi32.dll' index 15;
function lineDrop                     ; external 'Tapi32.dll' index 16;
function lineForward                  ; external 'Tapi32.dll' index 17;
function lineGatherDigits             ; external 'Tapi32.dll' index 18;
function lineGenerateDigits           ; external 'Tapi32.dll' index 19;
function lineGenerateTone             ; external 'Tapi32.dll' index 20;
function lineGetAddressCaps           ; external 'Tapi32.dll' index 21;
function lineGetAddressID             ; external 'Tapi32.dll' index 22;
function lineGetAddressStatus         ; external 'Tapi32.dll' index 23;
function lineGetAppPriority           ; external 'Tapi32.dll' index 24;
function lineGetCallInfo              ; external 'Tapi32.dll' index 25;
function lineGetCallStatus            ; external 'Tapi32.dll' index 26;
function lineGetConfRelatedCalls      ; external 'Tapi32.dll' index 27;
function lineGetCountry               ; external 'Tapi32.dll' index 28;
function lineGetDevCaps               ; external 'Tapi32.dll' index 29;
function lineGetDevConfig             ; external 'Tapi32.dll' index 30;
function lineGetID                    ; external 'Tapi32.dll' index 31;
function lineGetIcon                  ; external 'Tapi32.dll' index 32;
function lineGetLineDevStatus         ; external 'Tapi32.dll' index 33;
function lineGetNewCalls              ; external 'Tapi32.dll' index 34;
function lineGetNumRings              ; external 'Tapi32.dll' index 35;
function lineGetProviderList          ; external 'Tapi32.dll' index 36;
function lineGetRequest               ; external 'Tapi32.dll' index 37;
function lineGetStatusMessages        ; external 'Tapi32.dll' index 38;
function lineGetTranslateCaps         ; external 'Tapi32.dll' index 39;
function lineHandoff                  ; external 'Tapi32.dll' index 40;
function lineHold                     ; external 'Tapi32.dll' index 41;
function lineInitialize               ; external 'Tapi32.dll' index 42;
function lineMakeCall                 ; external 'Tapi32.dll' index 43;
function lineMonitorDigits            ; external 'Tapi32.dll' index 44;
function lineMonitorMedia             ; external 'Tapi32.dll' index 45;
function lineMonitorTones             ; external 'Tapi32.dll' index 46;
function lineNegotiateAPIVersion      ; external 'Tapi32.dll' index 47;
function lineNegotiateExtVersion      ; external 'Tapi32.dll' index 48;
function lineOpen                     ; external 'Tapi32.dll' index 49;
function linePark                     ; external 'Tapi32.dll' index 50;
function linePickup                   ; external 'Tapi32.dll' index 51;
function linePrepareAddToConference   ; external 'Tapi32.dll' index 52;
function lineRedirect                 ; external 'Tapi32.dll' index 53;
function lineRegisterRequestRecipient ; external 'Tapi32.dll' index 54;
function lineReleaseUserUserInfo      ; external 'Tapi32.dll' index 55;
function lineRemoveFromConference     ; external 'Tapi32.dll' index 56;
function lineRemoveProvider           ; external 'Tapi32.dll' index 57;
function lineSecureCall               ; external 'Tapi32.dll' index 58;
function lineSendUserUserInfo         ; external 'Tapi32.dll' index 59;
function lineSetAppPriority           ; external 'Tapi32.dll' index 60;
function lineSetAppSpecific           ; external 'Tapi32.dll' index 61;
function lineSetCallParams            ; external 'Tapi32.dll' index 62;
function lineSetCallPrivilege         ; external 'Tapi32.dll' index 63;
function lineSetCurrentLocation       ; external 'Tapi32.dll' index 64;
function lineSetDevConfig             ; external 'Tapi32.dll' index 65;
function lineSetMediaControl          ; external 'Tapi32.dll' index 66;
function lineSetMediaMode             ; external 'Tapi32.dll' index 67;
function lineSetNumRings              ; external 'Tapi32.dll' index 68;
function lineSetStatusMessages        ; external 'Tapi32.dll' index 69;
function lineSetTerminal              ; external 'Tapi32.dll' index 70;
function lineSetTollList              ; external 'Tapi32.dll' index 71;
function lineSetupConference          ; external 'Tapi32.dll' index 72;
function lineSetupTransfer            ; external 'Tapi32.dll' index 73;
function lineShutdown                 ; external 'Tapi32.dll' index 74;
function lineSwapHold                 ; external 'Tapi32.dll' index 75;
function lineTranslateAddress         ; external 'Tapi32.dll' index 76;
function lineTranslateDialog          ; external 'Tapi32.dll' index 77;
function lineUncompleteCall           ; external 'Tapi32.dll' index 78;
function lineUnhold                   ; external 'Tapi32.dll' index 79;
function lineUnpark                   ; external 'Tapi32.dll' index 80;
function phoneClose                   ; external 'Tapi32.dll' index 81;
function phoneConfigDialog            ; external 'Tapi32.dll' index 82;
function phoneDevSpecific             ; external 'Tapi32.dll' index 83;
function phoneGetButtonInfo           ; external 'Tapi32.dll' index 84;
function phoneGetData                 ; external 'Tapi32.dll' index 85;
function phoneGetDevCaps              ; external 'Tapi32.dll' index 86;
function phoneGetDisplay              ; external 'Tapi32.dll' index 87;
function phoneGetGain                 ; external 'Tapi32.dll' index 88;
function phoneGetHookSwitch           ; external 'Tapi32.dll' index 89;
function phoneGetID                   ; external 'Tapi32.dll' index 90;
function phoneGetIcon                 ; external 'Tapi32.dll' index 91;
function phoneGetLamp                 ; external 'Tapi32.dll' index 92;
function phoneGetRing                 ; external 'Tapi32.dll' index 93;
function phoneGetStatus               ; external 'Tapi32.dll' index 94;
function phoneGetStatusMessages       ; external 'Tapi32.dll' index 95;
function phoneGetVolume               ; external 'Tapi32.dll' index 96;
function phoneInitialize              ; external 'Tapi32.dll' index 97;
function phoneNegotiateAPIVersion     ; external 'Tapi32.dll' index 98;
function phoneNegotiateExtVersion     ; external 'Tapi32.dll' index 99;
function phoneOpen                    ; external 'Tapi32.dll' index 100;
function phoneSetButtonInfo           ; external 'Tapi32.dll' index 101;
function phoneSetData                 ; external 'Tapi32.dll' index 102;
function phoneSetDisplay              ; external 'Tapi32.dll' index 103;
function phoneSetGain                 ; external 'Tapi32.dll' index 104;
function phoneSetHookSwitch           ; external 'Tapi32.dll' index 105;
function phoneSetLamp                 ; external 'Tapi32.dll' index 106;
function phoneSetRing                 ; external 'Tapi32.dll' index 107;
function phoneSetStatusMessages       ; external 'Tapi32.dll' index 108;
function phoneSetVolume               ; external 'Tapi32.dll' index 109;
function phoneShutdown                ; external 'Tapi32.dll' index 110;
function tapiGetLocationInfo          ; external 'Tapi32.dll' index 111;
function tapiRequestDrop              ; external 'Tapi32.dll' index 112;
function tapiRequestMakeCall          ; external 'Tapi32.dll' index 113;
function tapiRequestMediaCall         ; external 'Tapi32.dll' index 114;

{$ELSE}

function tapiRequestMakeCall; external 'TAPI' index 28;
function tapiRequestMediaCall; external 'TAPI' index 101;
function tapiRequestDrop; external 'TAPI' index 112;
function lineRegisterRequestRecipient; external 'TAPI' index 10;
function tapiGetLocationInfo; external 'TAPI' index 85;
function lineSetCurrentLocation; external 'TAPI' index 81;
function lineSetTollList; external 'TAPI' index 3;
function lineTranslateAddress; external 'TAPI' index 19;
function lineGetTranslateCaps; external 'TAPI' index 100;
function lineAccept; external 'TAPI' index 82;
function lineAddToConference; external 'TAPI' index 47;
function lineAnswer; external 'TAPI' index 103;
function lineBlindTransfer; external 'TAPI' index 25;
function lineClose; external 'TAPI' index 78;
function lineCompleteCall; external 'TAPI' index 76;
function lineCompleteTransfer; external 'TAPI' index 73;
function lineConfigDialog; external 'TAPI' index 12;
function lineConfigDialogEdit; external 'TAPI' index 135;
function lineDeallocateCall; external 'TAPI' index 111;
function lineDevSpecific; external 'TAPI' index 21;
function lineDevSpecificFeature; external 'TAPI' index 22;
function lineDial; external 'TAPI' index 29;
function lineDrop; external 'TAPI' index 23;
function lineForward; external 'TAPI' index 87;
function lineGatherDigits; external 'TAPI' index 52;
function lineGenerateDigits; external 'TAPI' index 105;
function lineGenerateTone; external 'TAPI' index 80;
function lineGetAddressCaps; external 'TAPI' index 71;
function lineGetAddressID; external 'TAPI' index 104;
function lineGetAddressStatus; external 'TAPI' index 60;
function lineGetCallInfo; external 'TAPI' index 97;
function lineGetCallStatus; external 'TAPI' index 94;
function lineGetConfRelatedCalls; external 'TAPI' index 72;
function lineGetDevCaps; external 'TAPI' index 116;
function lineGetDevConfig; external 'TAPI' index 79;
function lineGetNewCalls; external 'TAPI' index 34;
function lineGetIcon; external 'TAPI' index 53;
function lineGetID; external 'TAPI' index 40;
function lineGetLineDevStatus; external 'TAPI' index 49;
function lineGetNumRings; external 'TAPI' index 62;
function lineGetRequest; external 'TAPI' index 86;
function lineGetStatusMessages; external 'TAPI' index 45;
function lineHandoff; external 'TAPI' index 11;
function lineHold; external 'TAPI' index 6;
function lineInitialize; external 'TAPI' index 33;
function lineMakeCall; external 'TAPI' index 32;
function lineMonitorDigits; external 'TAPI' index 24;
function lineMonitorMedia; external 'TAPI' index 15;
function lineMonitorTones; external 'TAPI' index 31;
function lineNegotiateAPIVersion; external 'TAPI' index 64;
function lineNegotiateExtVersion; external 'TAPI' index 17;
function lineOpen; external 'TAPI' index 46;
function linePark; external 'TAPI' index 5;
function linePickup; external 'TAPI' index 102;
function linePrepareAddToConference; external 'TAPI' index 50;
function lineRedirect; external 'TAPI' index 38;
function lineRemoveFromConference; external 'TAPI' index 43;
function lineSecureCall; external 'TAPI' index 57;
function lineSendUserUserInfo; external 'TAPI' index 63;
function lineSetAppSpecific; external 'TAPI' index 88;
function lineSetCallParams; external 'TAPI' index 2;
function lineSetCallPrivilege; external 'TAPI' index 95;
function lineSetDevConfig; external 'TAPI' index 107;
function lineSetMediaControl; external 'TAPI' index 37;
function lineSetMediaMode; external 'TAPI' index 115;
function lineSetNumRings; external 'TAPI' index 61;
function lineSetStatusMessages; external 'TAPI' index 44;
function lineSetTerminal; external 'TAPI' index 108;
function lineSetupConference; external 'TAPI' index 48;
function lineSetupTransfer; external 'TAPI' index 65;
function lineShutdown; external 'TAPI' index 8;
function lineSwapHold; external 'TAPI' index 109;
function lineUncompleteCall; external 'TAPI' index 41;
function lineUnhold; external 'TAPI' index 113;
function lineUnpark; external 'TAPI' index 77;
function lineReleaseUserUserInfo; external 'TAPI' index 139;
function phoneClose; external 'TAPI' index 119;
function phoneConfigDialog; external 'TAPI' index 16;
function phoneDevSpecific; external 'TAPI' index 9;
function phoneGetButtonInfo; external 'TAPI' index 4;
function phoneGetData; external 'TAPI' index 93;
function phoneGetDevCaps; external 'TAPI' index 114;
function phoneGetDisplay; external 'TAPI' index 83;
function phoneGetGain; external 'TAPI' index 68;
function phoneGetHookSwitch; external 'TAPI' index 27;
function phoneGetIcon; external 'TAPI' index 74;
function phoneGetID; external 'TAPI' index 106;
function phoneGetLamp; external 'TAPI' index 117;
function phoneGetRing; external 'TAPI' index 70;
function phoneGetStatus; external 'TAPI' index 39;
function phoneGetStatusMessages; external 'TAPI' index 55;
function phoneGetVolume; external 'TAPI' index 59;
function phoneInitialize; external 'TAPI' index 35;
function phoneNegotiateAPIVersion; external 'TAPI' index 7;
function phoneNegotiateExtVersion; external 'TAPI' index 14;
function phoneOpen; external 'TAPI' index 89;
function phoneSetButtonInfo; external 'TAPI' index 42;
function phoneSetData; external 'TAPI' index 92;
function phoneSetDisplay; external 'TAPI' index 98;
function phoneSetGain; external 'TAPI' index 67;
function phoneSetHookSwitch; external 'TAPI' index 51;
function phoneSetLamp; external 'TAPI' index 118;
function phoneSetRing; external 'TAPI' index 69;
function phoneSetStatusMessages; external 'TAPI' index 56;
function phoneSetVolume; external 'TAPI' index 54;
function phoneShutdown; external 'TAPI' index 26;
function lineTranslateDialog; external 'TAPI' index 13;
function lineGetCountry; external 'TAPI' index 143;
function lineGetAppPriority; external 'TAPI' index 58;
function lineSetAppPriority; external 'TAPI' index 66;
function lineAddProvider; external 'TAPI' index 141;
function lineConfigProvider; external 'TAPI' index 75;
function lineRemoveProvider; external 'TAPI' index 142;
function lineGetProviderList; external 'TAPI' index 129;

{$ENDIF}

end.

