unit DatReg;
{******************************************************************************}
{                                                                              }
{                           IMPORTANT NOTICE                                   }
{                                                                              }
{          (c) Copyright 1996 by Softouch Development Incorporated             }
{                                                                              }
{                         ALL RIGHTS RESERVED                                  }
{                                                                              }
{       Software and documentation are the confidential property and           }
{       contain trade secrets of Softouch Development Incorporated.            }
{       Any copying, use, disclosure, modification, or transfer by rental,     }
{       sale, or otherwise without the written consent of Softouch             }
{       Development Incorporated is strictly prohibited.                       }
{                                                                              }
{       Portions may be Copyright (c) 1995 Borland International.              }
{       All restriction apply.                                                 }
{******************************************************************************}
interface

uses
	{$IFDEF Win32}
	Windows, Forms,
	{$ELSE}
	Forms,
	{$ENDIF}
	Classes, DsgnIntf, Dialogs, Controls, DB, DBTables, Typinfo;

type
	TDateEditAboutBoxEditor = class(TComponentEditor)
		procedure ExecuteVerb(Index: Integer); override;
		function GetVerb(Index: Integer): string; override;
		function GetVerbCount: Integer; override;
	end;

	TDBStringProperty = class(TStringProperty)
	public
		function GetAttributes: TPropertyAttributes; override;
		procedure GetValueList(List: TStrings); virtual; abstract;
		procedure GetValues(Proc: TGetStrProc); override;
	end;

	TCustomFormatProperty = class(TDBStringProperty)
	public
		procedure GetValueList(List: TStrings); override;
	end;

procedure Register;

implementation

uses DatAbout, DatEdit, DatDBEdt, GridSrc;

procedure TDateEditAboutBoxEditor.ExecuteVerb(Index: Integer);
var DateEditAboutBox: TDateEditAboutBox;
begin
	DateEditAboutBox := TDateEditAboutBox.Create(Application);
	DateEditAboutBox.ShowModal;
	DateEditAboutBox.Destroy;
end;

function TDateEditAboutBoxEditor.GetVerb(Index: Integer): string;
begin
  Result := 'About...';
end;

function TDateEditAboutBoxEditor.GetVerbCount: Integer;
begin
  Result := 1;
end;

function TDBStringProperty.GetAttributes: TPropertyAttributes;
begin
	Result := [paValueList, paSortList, paMultiSelect];
end;

procedure TDBStringProperty.GetValues(Proc: TGetStrProc);
var
I: Integer;
Values: TStringList;
begin
	Values := TStringList.Create;
	try
		GetValueList(Values);
		for I := 0 to Values.Count - 1 do Proc(Values[I]);
	finally
		Values.Free;
	end;
end;

procedure TCustomFormatProperty.GetValueList(List: TStrings);
begin
	List.Add('MM/DD/YY');
	List.Add('MM/DD/YYYY');
	List.Add('MMMM DD, YYYY');
	List.Add('MM/YY');
	List.Add('MMM-YYYY');
	List.Add('DD-MMM-YY');
	List.Add('DD-MMM-YYYY');
	List.Add('DD/MM/YY');
	List.Add('YY/MM/DD');
end;

procedure Register;
begin
	RegisterComponents('Softouch', [TDateEditPlus]);
	RegisterComponents('Softouch', [TDBDateEditPlus]);
	RegisterComponentEditor(TDateEditPlus  ,TDateEditAboutBoxEditor);
	RegisterComponentEditor(TDBDateEditPlus,TDateEditAboutBoxEditor);
	RegisterPropertyEditor(TypeInfo(string),TCustomDateEditPlus,'CustomEditFormat'   ,TCustomFormatProperty);
	RegisterPropertyEditor(TypeInfo(string),TCustomDateEditPlus,'CustomDisplayFormat',TCustomFormatProperty);
	RegisterGridParentEditors;
end;

end.
