unit DBChkReg;
{******************************************************************************}
{                                                                              }
{                           IMPORTANT NOTICE                                   }
{                                                                              }
{          (c) Copyright 1996 by Softouch Development Incorporated             }
{                                                                              }
{                         ALL RIGHTS RESERVED                                  }
{                                                                              }
{       Software and documentation are the confidential property and           }
{       contain trade secrets of Softouch Development Incorporated.            }
{       Any copying, use, disclosure, modification, or transfer by rental,     }
{       sale, or otherwise without the written consent of Softouch             }
{       Development Incorporated is strictly prohibited.                       }
{                                                                              }
{       Portions may be Copyright (c) 1995 Borland International.              }
{       All restriction apply.                                                 }
{******************************************************************************}
interface

uses
	{$IFDEF Win32}
	Windows, Forms,
	{$ELSE}
	Forms,
	{$ENDIF}
	Classes, DsgnIntf, GridSrc, DBChkPlu, DBChkAbt;

type
	TDBCheckBoxPlusAboutBoxEditor = class(TComponentEditor)
		procedure ExecuteVerb(Index: Integer); override;
		function GetVerb(Index: Integer): string; override;
		function GetVerbCount: Integer; override;
	end;


procedure Register;

implementation
{$IFDEF WIN32}
{$R DBChkP32.res}
{$ELSE}
{$R DBChkP16.res}
{$ENDIF}

procedure TDBCheckBoxPlusAboutBoxEditor.ExecuteVerb(Index: Integer);
var DBCheckBoxPlusAboutBox: TDBCheckBoxPlusAboutBox;
begin
	DBCheckBoxPlusAboutBox := TDBCheckBoxPlusAboutBox.Create(Application);
	DBCheckBoxPlusAboutBox.ShowModal;
	DBCheckBoxPlusAboutBox.Destroy;
end;

function TDBCheckBoxPlusAboutBoxEditor.GetVerb(Index: Integer): string;
begin
  Result := 'About...';
end;

function TDBCheckBoxPlusAboutBoxEditor.GetVerbCount: Integer;
begin
  Result := 1;
end;

{******************************************************************************}
{ Start of register stuff                                                      }
{******************************************************************************}
procedure Register;
begin
	RegisterComponents('Softouch', [TDBCheckBoxPlus]);
	RegisterComponentEditor(TDBCheckBoxPlus, TDBCheckBoxPlusAboutBoxEditor);
	RegisterGridParentEditors;
end;
{******************************************************************************}
{ End of register stuff                                                        }
{******************************************************************************}


end.
