unit DBImgReg;
{******************************************************************************}
{                                                                              }
{                           IMPORTANT NOTICE                                   }
{                                                                              }
{          (c) Copyright 1996 by Softouch Development Incorporated             }
{                                                                              }
{                         ALL RIGHTS RESERVED                                  }
{                                                                              }
{       Software and documentation are the confidential property and           }
{       contain trade secrets of Softouch Development Incorporated.            }
{       Any copying, use, disclosure, modification, or transfer by rental,     }
{       sale, or otherwise without the written consent of Softouch             }
{       Development Incorporated is strictly prohibited.                       }
{                                                                              }
{       Portions may be Copyright (c) 1995 Borland International.              }
{       All restriction apply.                                                 }
{******************************************************************************}
{                                                                              }
{  Problem Log                                                                 }
{  04/25/97  Started problem log                                               }
{******************************************************************************}
interface

uses
	{$IFDEF Win32}
	Windows, Forms,
	{$ELSE}
	Forms,
	{$ENDIF}
	Classes, DsgnIntf, Dialogs, Controls, DB, DBTables, Typinfo, GridSrc;

type
	TDBImagePlusAboutBox = class(TComponentEditor)
		procedure ExecuteVerb(Index: Integer); override;
		function GetVerb(Index: Integer): string; override;
		function GetVerbCount: Integer; override;
	end;

procedure Register;

implementation
{$IFDEF WIN32}
{$R DBImg32.res}
{$ELSE}
{$R DBImg16.res}
{$ENDIF}

uses DBImgAbt, DBImgPlu;

procedure TDBImagePlusAboutBox.ExecuteVerb(Index: Integer);
var DBImagePlusAbout: TDBImagePlusAbout;
begin
	DBImagePlusAbout := TDBImagePlusAbout.Create(Application);
	DBImagePlusAbout.ShowModal;
	DBImagePlusAbout.Destroy;
end;

function TDBImagePlusAboutBox.GetVerb(Index: Integer): string;
begin
  Result := 'About...';
end;

function TDBImagePlusAboutBox.GetVerbCount: Integer;
begin
  Result := 1;
end;

procedure Register;
begin
	RegisterComponentEditor(TDBImagePlus,TDBImagePlusAboutBox);
	RegisterComponents('Softouch',[TDBImagePlus]);
	RegisterGridParentEditors;
end;

end.
