{

   TDBLookupCombo Plus Component Registration Module
   DB Aware Components for Delphi

   Copyright (c) 1995 Out & About Production, All Rights Reserved

   Version 4.1 (3/96)
}

unit Dblupl32;

interface

uses Classes, DsgnIntf, DBLup2, Dialogs;

procedure Register;

implementation

uses DBTables;

{ TDBStringProperty }

type
  TDBStringProperty = class(TStringProperty)
  public
    function GetAttributes: TPropertyAttributes; override;
    procedure GetValueList(List: TStrings); virtual; abstract;
    procedure GetValues(Proc: TGetStrProc); override;
  end;

  TDBLookupComponentEditor = class(TDefaultEditor)
  public
    procedure ExecuteVerb(Index: Integer); override;
    function GetVerb(Index: Integer): string; override;
    function GetVerbCount: Integer; override;
  end;

function TDBStringProperty.GetAttributes: TPropertyAttributes;
begin
  Result := [paValueList, paSortList, paMultiSelect];
end;

procedure TDBStringProperty.GetValues(Proc: TGetStrProc);
var
  I: Integer;
  Values: TStringList;
begin
  Values := TStringList.Create;
  try
    GetValueList(Values);
    for I := 0 to Values.Count - 1 do Proc(Values[I]);
  finally
    Values.Free;
  end;
end;

{ TIndexNameProperty }

type
  TIndexNameProperty = class(TDBStringProperty)
  public
    procedure GetValueList(List: TStrings); override;
  end;

procedure TIndexNameProperty.GetValueList(List: TStrings);
begin
  if (GetComponent(0) as TDBLookupComboPlus).LookUpSource <> nil then
  ((GetComponent(0) as TDBLookupComboPlus).LookUpSource.DataSet as TTable).GetIndexNames(List);
end;

{TDBLookupComponentEditor}
procedure TDBLookupComponentEditor.ExecuteVerb(Index: Integer);
begin
  MessageDlg('TDBLookupComboPlus'
             +#10#13+ '(c) 1995, 1996, Out && About Productions'
             +#10#13+ '75664.1224@compuserve.com'
             +#10#13+ 'Fax 619.566.0210' ,mtInformation,[mbOK],0);
end;

function TDBLookupComponentEditor.GetVerb(Index: Integer): string;
begin
  result := 'Component Info';
end;

function TDBLookupComponentEditor.GetVerbCount: Integer;
begin
  result := 1;
end;

procedure Register;
begin
  RegisterComponents('Data Controls', [TDBLookupComboPlus]);
  RegisterPropertyEditor(TypeInfo(string), TDBLookupComboPlus, 'LookupIndex', TIndexNameProperty);
  RegisterComponentEditor(TDBLookupComboPlus,TDBLookupComponentEditor);
end;

end.
