unit u_main2;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  u_about2, u_rbuild, StdCtrls, DB, DBTables, ComCtrls, DBTree, ExtCtrls,
  Mask, DBCtrls, Menus, Buttons;

type
  Tmain = class(TForm)
    GroupBox1: TGroupBox;
    bQuit: TButton;
    bAbout: TButton;
    Table1: TTable;
    Table2: TTable;
    DataSource1: TDataSource;
    DataSource2: TDataSource;
    DataSource3: TDataSource;
    ImageList1: TImageList;
    Panel1: TPanel;
    Timer1: TTimer;
    MemAlloc: TLabel;
    MemFree: TLabel;
    Query1: TQuery;
    ImageList2: TImageList;
    Table1L1_Desc: TStringField;
    Table2L1_REF: TIntegerField;
    Table2L2_ID: TIntegerField;
    Table2L2_Desc: TStringField;
    DBTreeView1: TDBTreeView;
    Table1L1_ID: TIntegerField;
    Query1L1_REF: TIntegerField;
    Query1L2_REF: TIntegerField;
    Query1L3_ID: TIntegerField;
    Query1L3_Desc: TStringField;
    PopupMenu1: TPopupMenu;
    mExpand1: TMenuItem;
    mDelete1: TMenuItem;
    mCopy1: TMenuItem;
    mCut1: TMenuItem;
    bRebuild: TButton;
    bRefresh: TButton;
    bTrash: TBitBtn;
    bExpand: TButton;
    mCollapse1: TMenuItem;
    bCollapse: TButton;
    mChangeSelect1: TMenuItem;
    mClearSelect1: TMenuItem;
    mPaste1: TMenuItem;
    N1: TMenuItem;
    N2: TMenuItem;
    Label1: TLabel;
    Label2: TLabel;
    Table3: TTable;
    Table3L1_REF: TIntegerField;
    Table3L2_REF: TIntegerField;
    Table3L3_ID: TIntegerField;
    Table3L3_Desc: TStringField;
    bLastOp: TButton;
    mRefreshSelect1: TMenuItem;
    procedure bQuitClick(Sender: TObject);
    procedure bAboutClick(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure bRebuildClick(Sender: TObject);
    procedure bRefreshClick(Sender: TObject);
    procedure bTrashDragOver(Sender, Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
    procedure bTrashDragDrop(Sender, Source: TObject; X, Y: Integer);
    procedure bExpandClick(Sender: TObject);
    procedure DBTreeView1TreeNodeAction(Sender: TObject;
      const NodeFrom : TDBTreeNode; const NodeAt : TDBTreeNode;
      const TableFrom : TDataSet; const TableAt : TDataSet;
      const Action: TDBTreeViewAction; var Continue: Boolean);
    procedure DBTreeView1FireAction(Sender: TObject;
      const Action: TDBTreeViewAction; const BeginPhase: Boolean);
    procedure PopupMenu1Popup(Sender: TObject);
    procedure bCollapseClick(Sender: TObject);
    procedure mExpand1Click(Sender: TObject);
    procedure mCollapse1Click(Sender: TObject);
    procedure mClearSelect1Click(Sender: TObject);
    procedure mChangeSelect1Click(Sender: TObject);
    procedure mDelete1Click(Sender: TObject);
    procedure mCut1Click(Sender: TObject);
    procedure mCopy1Click(Sender: TObject);
    procedure mPaste1Click(Sender: TObject);
    procedure DBTreeView1TreeDBError(Sender: TObject;
      const E: EDatabaseError; const NodeAt: TDBTreeNode;
      const Table: TDataSet; const Action: TDBTreeViewAction;
      var ErrAction: TDataAction);
    procedure bLastOpClick(Sender: TObject);
    procedure DBTreeView1AskQuery(Sender: TObject; const Level: Integer;
      var DatabaseName, TableName, MasterFields: string);
    procedure mRefreshSelect1Click(Sender: TObject);
  private
    { Dclarations prives }
  public
    { Dclarations publiques }
  end;

var
  main: Tmain;

implementation

{$R *.DFM}

procedure Tmain.bQuitClick(Sender: TObject);
begin
     Close;
end;

procedure Tmain.bAboutClick(Sender: TObject);
begin
     AboutBox.ShowModal;
end;

procedure Tmain.Timer1Timer(Sender: TObject);
begin
     MemAlloc.Caption := 'Memory allocated : ' + IntToStr( GetHeapStatus.TotalAllocated );
     MemFree.Caption  := 'Memory free : ' + IntToStr( GetHeapStatus.TotalFree      );
end;

procedure Tmain.bRebuildClick(Sender: TObject);
begin
     Table1.Close;
     Table2.Close;
     Table3.Close;
     Rebuild.ShowModal;
     ( DBTreeView1.Items[ 0 ] as TDBTreeNode ).Refresh;
end;


procedure Tmain.bRefreshClick(Sender: TObject);
begin
     ( DBTreeView1.Selected as TDBTreeNode ).Refresh;
end;

procedure Tmain.bTrashDragOver(Sender, Source: TObject; X, Y: Integer;
  State: TDragState; var Accept: Boolean);
begin
     Accept := ( Source is TDBTreeView );
end;

procedure Tmain.bTrashDragDrop(Sender, Source: TObject; X, Y: Integer);
begin
     If Source is TDBTreeView Then Begin
        With TDBTreeView( Source ) Do Begin
             If Selected is TDBTreeNode Then Begin
                Delete;
                End;
             End;
        End;
end;

procedure Tmain.bExpandClick(Sender: TObject);
begin
     DBTreeView1.FullExpandv2( DBTreeView1.Selected );
end;

procedure Tmain.DBTreeView1TreeNodeAction(Sender: TObject;
  const NodeFrom : TDBTreeNode; const NodeAt : TDBTreeNode;
  const TableFrom : TDataSet; const TableAt : TDataSet;
  const Action: TDBTreeViewAction; var Continue: Boolean);
Var
   Query : TQuery;
   S     : String;
begin
     If ( NodeFrom.Text  = 'Wheels'        ) And
        ( Action         = tvpDeleteSelect ) Then Begin
        ShowMessage( 'Sorry. I don''t want to delete the Wheels.' );
        Continue := False;
        End;

     If ( NodeFrom.Text  = 'Wheels'     ) And
        ( Action         = tvpCutSelect ) Then Begin
        ShowMessage( 'Sorry. I don''t want to move the Wheels, even under the ' +
                     NodeAt.Text );
        Continue := False;
        End;

     If ( NodeFrom.Level = 3 ) Then Begin
        With NodeFrom.DataSource.DataSet, Sender as TDBTreeView Do Begin
             Query := TQuery.Create( Sender as TComponent );

             If Action = tvpCopySelect Then
                S := FieldByName( 'L3_ID'   ).AsString + ', "Copy of ' +
                     FieldByName( 'L3_DESC' ).AsString
             Else
                S := 'L1_REF=' + FieldByName( 'L1_REF' ).AsString + ' and ' +
                     'L2_REF=' + FieldByName( 'L2_REF' ).AsString + ' and ' +
                     'L3_ID='  + FieldByName( 'L3_ID'  ).AsString;

             Case Action Of
                  tvpDeleteSelect : Begin
                                    Query.SQL.Add( 'delete from "LEVEL3.DB" where ' + S );
                                    End;
                  tvpCutSelect    : Begin
                                    Synchronize_On( NodeAt );
                                    Query.SQL.Add( 'update "LEVEL3.DB" set ' +
                                              'L1_REF=' + NodeAt.DataSource.DataSet.FieldByName( 'L1_REF' ).AsString + ', ' +
                                              'L2_REF=' + NodeAt.DataSource.DataSet.FieldByName( 'L2_ID'  ).AsString + ' where ' + S );
                                    End;
                  tvpCopySelect   : Begin
                                    Synchronize_On( NodeAt );
                                    Query.SQL.Add( 'insert into "LEVEL3.DB" ( L1_REF, L2_REF, L3_ID, L3_DESC ) ' +
                                              ' values( ' +
                                              NodeAt.DataSource.DataSet.FieldByName( 'L1_REF' ).AsString + ', ' +
                                              NodeAt.DataSource.DataSet.FieldByName( 'L2_ID'  ).AsString + ', ' +
                                              S + '")' );
                                    End;
                  End;
             End;
        ShowMessage( 'The following SQL instruction will now be executed :' +
                     #13#10#10 +
                     Query.SQL[ 0 ] );

        Query.ExecSQL;

        Continue := False;
        End;
end;

procedure Tmain.DBTreeView1FireAction(Sender: TObject;
  const Action: TDBTreeViewAction; const BeginPhase: Boolean);
begin
     If BeginPhase Then
        Screen.Cursor := crHourGlass
     Else
        Screen.Cursor := crDefault;
end;

procedure Tmain.PopupMenu1Popup(Sender: TObject);
Var
   Actions : TDBTreeViewActions;
begin
     With DBTreeView1 Do Begin
          Actions := AllowedActions;
          mExpand1.Enabled       := tvpExpandNode   in Actions;
          mCollapse1.Enabled     := tvpCollapseNode in Actions;
          mCut1.Enabled          := tvpCutSelect    in Actions;
          mCopy1.Enabled         := tvpCopySelect   in Actions;
          mPaste1.Enabled        := tvpPasteSelect  in Actions;
          mDelete1.Enabled       := tvpDeleteSelect in Actions;
          mChangeSelect1.Enabled := tvpChangeSelect in Actions;
          mClearSelect1.Enabled  := tvpClearSelect  in Actions;
          End;
end;

procedure Tmain.bCollapseClick(Sender: TObject);
begin
     DBTreeView1.FullCollapsev2( DBTreeView1.Selected );
end;

procedure Tmain.mExpand1Click(Sender: TObject);
begin
     DBTreeView1.Execute_PopupMenu( tvpExpandNode );
end;

procedure Tmain.mCollapse1Click(Sender: TObject);
begin
     DBTreeView1.Execute_PopupMenu( tvpCollapseNode );
end;

procedure Tmain.mClearSelect1Click(Sender: TObject);
begin
     DBTreeView1.Execute_PopupMenu( tvpClearSelect );
end;

procedure Tmain.mChangeSelect1Click(Sender: TObject);
begin
     DBTreeView1.Execute_PopupMenu( tvpChangeSelect );
end;

procedure Tmain.mDelete1Click(Sender: TObject);
begin
     DBTreeView1.Execute_PopupMenu( tvpDeleteSelect );
end;

procedure Tmain.mCut1Click(Sender: TObject);
begin
     DBTreeView1.Execute_PopupMenu( tvpCutSelect );
end;

procedure Tmain.mCopy1Click(Sender: TObject);
begin
     DBTreeView1.Execute_PopupMenu( tvpCopySelect );
end;

procedure Tmain.mPaste1Click(Sender: TObject);
begin
     DBTreeView1.Execute_PopupMenu( tvpPasteSelect );
end;

procedure Tmain.DBTreeView1TreeDBError(Sender: TObject;
  const E: EDatabaseError; const NodeAt: TDBTreeNode;
  const Table: TDataSet; const Action: TDBTreeViewAction;
  var ErrAction: TDataAction);
Var
   SpecialInfos : String;
begin
     With ( Sender as TDBTreeView ) Do Begin
          SpecialInfos := 'Key(s) infos : "';
          Case NodeAt.Level Of
               1, 2 : SpecialInfos := SpecialInfos + Get_IndexFieldNames( NodeAt.DataSource.DataSet );
               3    : SpecialInfos := SpecialInfos + 'L1_REF;L2_REF';
               End;

          Case MessageDlg( 'DBT2SAMP reports a database error with the following message :' +
                           #13#10#10 + '"' +
                           E.Message +
                           '"' + #13#10#10 +
                           'Error Class : "' + E.ClassName + '"' + #13#10 +
                           'Node implied : "' + NodeAt.Text + '"' + #13#10 +
                           'DataSet implied : "' + Table.Name + '"' + #13#10 +
                           SpecialInfos + '"' + #13#10#10 +
                           'You may [Abort] the program, or [Ignore] to continue.',
                           mtError, [ mbAbort, mbIgnore ], 0 ) of
               mrAbort   : ErrAction := daFail;
               mrIgnore  : ErrAction := daAbort;
               End;

          End;
end;

procedure Tmain.bLastOpClick(Sender: TObject);
begin
     With DBTreeView1 Do Begin
          ShowMessage( 'Last operation has implied :' + #13#10#10 +
                       IntToStr( NbCopied  ) + ' node(s) copied,' + #13#10 +
                       IntToStr( NbMoved   ) + ' node(s) moved,' + #13#10 +
                       IntToStr( NbDeleted ) + ' node(s) deleted,' + #13#10 +
                       IntToStr( NbInError ) + ' error(s).' );
          End;
end;

procedure Tmain.DBTreeView1AskQuery(Sender: TObject; const Level: Integer;
  var DatabaseName, TableName, MasterFields: string);
begin
     If Sender is TDBTreeView Then Begin
        If Level = 3 Then Begin
           DataBaseName := '';
           TableName    := '';
           MasterFields := 'L1_REF;L2_REF';
           End;
        End;
end;

procedure Tmain.mRefreshSelect1Click(Sender: TObject);
begin
     DBTreeView1.Execute_PopupMenu( tvpRefreshSelect );
end;

end.
