unit u_main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  u_about, u_verify, StdCtrls, DB, DBTables, ComCtrls, DBTree, ExtCtrls,
  Mask, DBCtrls;

type
  Tmain = class(TForm)
    Database1: TDatabase;
    GroupBox1: TGroupBox;
    bQuit: TButton;
    bVerify: TButton;
    bAbout: TButton;
    Table1: TTable;
    Table2: TTable;
    Table4: TTable;
    DataSource1: TDataSource;
    DataSource2: TDataSource;
    DataSource3: TDataSource;
    DataSource4: TDataSource;
    ImageList1: TImageList;
    Label1: TLabel;
    Panel1: TPanel;
    GroupBox2: TGroupBox;
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    TabSheet3: TTabSheet;
    TabSheet4: TTabSheet;
    Table1CustNo: TFloatField;
    Table1Company: TStringField;
    Table1City: TStringField;
    Table1State: TStringField;
    Table1Country: TStringField;
    Table1Phone: TStringField;
    Label2: TLabel;
    DBEdit1: TDBEdit;
    Label3: TLabel;
    DBEdit2: TDBEdit;
    Label4: TLabel;
    DBEdit3: TDBEdit;
    Label5: TLabel;
    DBEdit4: TDBEdit;
    Label6: TLabel;
    DBEdit5: TDBEdit;
    Label7: TLabel;
    DBEdit6: TDBEdit;
    Table2OrderNo: TFloatField;
    Table2CustNo: TFloatField;
    Table2SaleDate: TDateTimeField;
    Table2ShipDate: TDateTimeField;
    Table2EmpNo: TIntegerField;
    Table2Terms: TStringField;
    Table2PaymentMethod: TStringField;
    Label8: TLabel;
    DBEdit7: TDBEdit;
    Label9: TLabel;
    DBEdit8: TDBEdit;
    Label10: TLabel;
    DBEdit9: TDBEdit;
    Label11: TLabel;
    DBEdit10: TDBEdit;
    Label12: TLabel;
    DBEdit11: TDBEdit;
    Label13: TLabel;
    DBEdit12: TDBEdit;
    Label14: TLabel;
    DBEdit13: TDBEdit;
    Label15: TLabel;
    DBEdit14: TDBEdit;
    Label16: TLabel;
    DBEdit15: TDBEdit;
    Label17: TLabel;
    DBEdit16: TDBEdit;
    Label18: TLabel;
    DBEdit17: TDBEdit;
    Label19: TLabel;
    DBEdit18: TDBEdit;
    Table4PartNo: TFloatField;
    Table4VendorNo: TFloatField;
    Table4Description: TStringField;
    Table4OnHand: TFloatField;
    Table4OnOrder: TFloatField;
    Table4Cost: TCurrencyField;
    Table4ListPrice: TCurrencyField;
    Label20: TLabel;
    DBEdit19: TDBEdit;
    Label21: TLabel;
    DBEdit20: TDBEdit;
    Label22: TLabel;
    DBEdit21: TDBEdit;
    Label23: TLabel;
    DBEdit22: TDBEdit;
    Label24: TLabel;
    DBEdit23: TDBEdit;
    Label25: TLabel;
    DBEdit24: TDBEdit;
    Label26: TLabel;
    DBEdit25: TDBEdit;
    TabSheet5: TTabSheet;
    Memo1: TMemo;
    Timer1: TTimer;
    MemAlloc: TLabel;
    MemFree: TLabel;
    Query1: TQuery;
    Query1OrderNo: TFloatField;
    Query1ItemNo: TFloatField;
    Query1PartNo: TFloatField;
    Query1Qty: TIntegerField;
    Query1Discount: TFloatField;
    bDrop: TButton;
    DBTreeView1: TDBTreeView;
    ImageList2: TImageList;
    Label27: TLabel;
    procedure bQuitClick(Sender: TObject);
    procedure bVerifyClick(Sender: TObject);
    procedure bAboutClick(Sender: TObject);
    procedure DBTreeView1Change(Sender: TObject; Node: TTreeNode);
    procedure Timer1Timer(Sender: TObject);
    procedure bDropDragOver(Sender, Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
    procedure bDropDragDrop(Sender, Source: TObject; X, Y: Integer);
  private
    { Dclarations prives }
  public
    { Dclarations publiques }
  end;

var
  main: Tmain;

implementation

{$R *.DFM}

procedure Tmain.bQuitClick(Sender: TObject);
begin
     Close;
end;

procedure Tmain.bVerifyClick(Sender: TObject);
begin
     Verify.Show;
end;

procedure Tmain.bAboutClick(Sender: TObject);
begin
     AboutBox.ShowModal;
end;

procedure Tmain.DBTreeView1Change(Sender: TObject; Node: TTreeNode);
begin
     With PageControl1 Do Begin
          ActivePage := Pages[ DBTreeView1.Selected.Level ];
          End;
end;

procedure Tmain.Timer1Timer(Sender: TObject);
begin
     MemAlloc.Caption := 'Memory allocated : ' + IntToStr( GetHeapStatus.TotalAllocated );
     MemFree.Caption  := 'Memory free : ' + IntToStr( GetHeapStatus.TotalFree      );
end;

procedure Tmain.bDropDragOver(Sender, Source: TObject; X, Y: Integer;
  State: TDragState; var Accept: Boolean);
begin
     Accept := ( Source is TDBCommonTreeView );
end;

procedure Tmain.bDropDragDrop(Sender, Source: TObject; X, Y: Integer);
Var
   S : String;
   i : Integer;
begin
     If ( Source is TDBCommonTreeView ) Then Begin
        With TDBCommonTreeView( Source ),
             TDBTreeNode( TTreeView( Source ).Selected ) Do Begin
             If SelectStrategy = tssOneSelect Then Begin
                If Level = 0 Then
                   ShowMessage( 'You have dropped the ROOT node. This is OK, ' +
                                'but has no interest...' )
                Else
                   ShowMessage( 'You have dropped a node from the ' +
                                DataSource.DataSet.Name +
                                ' dataset. Its text is <' + Text + '>' );
                End
             Else Begin
                S := '';
                For i := 0 To SelectedNodes.Count - 1 Do
                    S := S + '[' + TTreeNode( SelectedNodes.Items[ i ] ).Text + '] ';
                ShowMessage( 'You have selected all the following nodes :' + #13#10 + S );
                End;
             End;
        End;
end;


end.
