//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop

#include "u_main.h"
#include "u_about.h"
#include "u_verify.h"
//---------------------------------------------------------------------------
#pragma link "DBTree"
#pragma resource "*.dfm"
TMain *Main;
//---------------------------------------------------------------------------
__fastcall TMain::TMain(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TMain::DBTreeView1Change(TObject *Sender, TTreeNode *Node)
{
PageControl1->ActivePage = PageControl1->Pages[ DBTreeView1->Selected->Level ];
}
//---------------------------------------------------------------------------
void __fastcall TMain::bQuitClick(TObject *Sender)
{
Close();
}
//---------------------------------------------------------------------------
void __fastcall TMain::bVerifyClick(TObject *Sender)
{
Verify->Show();
}
//---------------------------------------------------------------------------
void __fastcall TMain::bAboutClick(TObject *Sender)
{
AboutBox->ShowModal();
}
//---------------------------------------------------------------------------
void __fastcall TMain::bDropDragDrop(TObject *Sender, TObject *Source, int X,
	int Y)
{
if ( dynamic_cast<TDBTreeView*>(Source) != 0 )
   {
   TDBTreeView *src(dynamic_cast<TDBTreeView*>(Source));
   TDBTreeNode *nod(dynamic_cast<TDBTreeNode*>(src->Selected));
   AnsiString  S;
   int         i;
   if ( src->SelectStrategy == tssOneSelect )
      {
      if ( nod->Level == 0 )
         {
         MessageBox( NULL,
                     "You have dropped the ROOT node. This is OK, but has no interest...",
                     "Information", MB_OK );
         }
      else
         {
         S = "You have dropped a node from the " +
             nod->DataSource->DataSet->Name      +
             " dataset. Its text is <"           +
             nod->Text + ">";

         MessageDlg( S, mtInformation, TMsgDlgButtons() << mbOK, 0 );
         }
      }
   else
      {
      S = "You have selected all the following nodes : ";
      for ( i = 0; i <= src->SelectedNodes->Count - 1; i++ )
          {
          nod = static_cast<TDBTreeNode*>(src->SelectedNodes->Items[ i ]);
          S = S + "[" + nod->Text + "]";
          }
      MessageDlg( S, mtInformation, TMsgDlgButtons() << mbOK, 0 );
      }
   }
}
//---------------------------------------------------------------------------
void __fastcall TMain::bDropDragOver(TObject *Sender, TObject *Source, int X,
	int Y, TDragState State, bool &Accept)
{
Accept = ( dynamic_cast<TDBTreeView*>(Source) != 0 ) ? true : false;
}
//---------------------------------------------------------------------------
