//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop

#include "u_main2.h"
#include "u_about2.h"
#include "u_rbuild.h"
//---------------------------------------------------------------------------
#pragma link "DBTree"
#pragma resource "*.dfm"
TMain *Main;
//---------------------------------------------------------------------------
__fastcall TMain::TMain(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TMain::bQuitClick(TObject *Sender)
{
Close();
}
//---------------------------------------------------------------------------
void __fastcall TMain::bAboutClick(TObject *Sender)
{
AboutBox->ShowModal();
}
//---------------------------------------------------------------------------

void __fastcall TMain::bRebuildClick(TObject *Sender)
{
Table1->Close();
Table2->Close();
Table3->Close();
Rebuild->ShowModal();
//static_cast<TDBTreeNode*>(DBTreeView1->Items[0])->Refresh();
}
//---------------------------------------------------------------------------
void __fastcall TMain::bRefreshClick(TObject *Sender)
{
static_cast<TDBTreeNode*>(DBTreeView1->Selected)->Refresh();
}
//---------------------------------------------------------------------------
void __fastcall TMain::bExpandClick(TObject *Sender)
{
DBTreeView1->FullExpandv2( DBTreeView1->Selected );
}
//---------------------------------------------------------------------------
void __fastcall TMain::bCollapseClick(TObject *Sender)
{
DBTreeView1->FullCollapsev2( DBTreeView1->Selected );
}
//---------------------------------------------------------------------------
void __fastcall TMain::DBTreeView1FireAction(TObject *Sender,
	const TDBTreeViewAction Action, const bool BeginPhase)
{
Screen->Cursor = ( BeginPhase ) ? crHourGlass : crDefault;
}
//---------------------------------------------------------------------------
void __fastcall TMain::mExpand1Click(TObject *Sender)
{
DBTreeView1->Execute_PopupMenu( tvpExpandNode );
}
//---------------------------------------------------------------------------
void __fastcall TMain::mCollapse1Click(TObject *Sender)
{
DBTreeView1->Execute_PopupMenu( tvpCollapseNode );
}
//---------------------------------------------------------------------------
void __fastcall TMain::mClearSelect1Click(TObject *Sender)
{
DBTreeView1->Execute_PopupMenu( tvpClearSelect );
}
//---------------------------------------------------------------------------
void __fastcall TMain::mChangeSelect1Click(TObject *Sender)
{
DBTreeView1->Execute_PopupMenu( tvpChangeSelect );
}
//---------------------------------------------------------------------------
void __fastcall TMain::mCopy1Click(TObject *Sender)
{
DBTreeView1->Execute_PopupMenu( tvpCopySelect );
}
//---------------------------------------------------------------------------
void __fastcall TMain::mCut1Click(TObject *Sender)
{
DBTreeView1->Execute_PopupMenu( tvpCutSelect );
}
//---------------------------------------------------------------------------
void __fastcall TMain::mDelete1Click(TObject *Sender)
{
DBTreeView1->Execute_PopupMenu( tvpDeleteSelect );
}
//---------------------------------------------------------------------------
void __fastcall TMain::mPaste1Click(TObject *Sender)
{
DBTreeView1->Execute_PopupMenu( tvpPasteSelect );
}
//---------------------------------------------------------------------------
void __fastcall TMain::mRefreshSelect1Click(TObject *Sender)
{
DBTreeView1->Execute_PopupMenu( tvpRefreshSelect );
}
//---------------------------------------------------------------------------
void __fastcall TMain::bLastOpClick(TObject *Sender)
{
ShowMessage( "Last operation has implied : \r\n\n" +
             IntToStr( DBTreeView1->NbCopied  ) + " node(s) copied,\r\n" +
             IntToStr( DBTreeView1->NbMoved   ) + " node(s) moved,\r\n" +
             IntToStr( DBTreeView1->NbDeleted ) + " node(s) deleted,\r\n" +
             IntToStr( DBTreeView1->NbInError ) + " error(s)." );
}
//---------------------------------------------------------------------------

void __fastcall TMain::PopupMenu1Popup(TObject *Sender)
{
TDBTreeViewActions Actions;
Actions = DBTreeView1->AllowedActions;
mExpand1->Enabled       = ( Actions.Contains( tvpExpandNode   ) ) ? true : false;
mCollapse1->Enabled     = ( Actions.Contains( tvpCollapseNode ) ) ? true : false;
mCut1->Enabled          = ( Actions.Contains( tvpCutSelect    ) ) ? true : false;
mCopy1->Enabled         = ( Actions.Contains( tvpCopySelect   ) ) ? true : false;
mPaste1->Enabled        = ( Actions.Contains( tvpPasteSelect  ) ) ? true : false;
mDelete1->Enabled       = ( Actions.Contains( tvpDeleteSelect ) ) ? true : false;
mChangeSelect1->Enabled = ( Actions.Contains( tvpChangeSelect ) ) ? true : false;
mClearSelect1->Enabled  = ( Actions.Contains( tvpClearSelect  ) ) ? true : false;
}
//---------------------------------------------------------------------------

void __fastcall TMain::bTrashDragDrop(TObject *Sender, TObject *Source, int X,
	int Y)
{
TDBTreeView *dbt;

if ( dynamic_cast<TDBTreeView*>(Source) != 0 )
   {
   dbt = dynamic_cast<TDBTreeView*>(Source);
   if ( dynamic_cast<TDBTreeNode*>(dbt->Selected) != 0 )
      {
      dbt->Delete();
      }
   }
}
//---------------------------------------------------------------------------
void __fastcall TMain::bTrashDragOver(TObject *Sender, TObject *Source, int X,
	int Y, TDragState State, bool &Accept)
{
Accept = ( dynamic_cast<TDBTreeView*>(Source) != 0 ) ? true : false;
}
//---------------------------------------------------------------------------
void __fastcall TMain::DBTreeView1AskQuery(TObject *Sender, const int Level,
	AnsiString &DatabaseName, AnsiString &TableName, AnsiString &MasterFields)
{
if ( dynamic_cast<TDBTreeView*>(Sender) != 0 )
   {
   if ( Level == 3 )
      {
      DatabaseName = "";
      TableName    = "";
      MasterFields = "L1_REF;L2_REF";
      }
   }
}
//---------------------------------------------------------------------------
void __fastcall TMain::DBTreeView1TreeNodeAction(TObject *Sender,
	TDBTreeNode *NodeFrom, TDBTreeNode *NodeAt,
	TDataSet *TableFrom, TDataSet *TableAt,
	const TDBTreeViewAction Action, bool &Continue)
{
TDBTreeView *dbt;
TDataSet    *dst;
TQuery      *Query;
AnsiString  S;

if ( NodeFrom->Text == "Wheels" &&
     Action         == tvpDeleteSelect )
   {
   ShowMessage( "Sorry. I don't want to delete the Wheels." );
   Continue = false;
   }

if ( NodeFrom->Text == "Wheels" &&
     Action         == tvpCutSelect )
   {
   ShowMessage( "Sorry. I don't want to move the Wheels, even under the " +
                NodeAt->Text );
   Continue = false;
   }

if ( NodeFrom->Level == 3 )
   {
   dbt = dynamic_cast<TDBTreeView*>(Sender);
   dst = NodeFrom->DataSource->DataSet;

   if ( Action == tvpCopySelect )
      {
      S = dst->FieldByName( "L3_ID"   )->AsString + ", \"Copy of " +
          dst->FieldByName( "L3_DESC" )->AsString;
      }
   else
      {
      S = "L1_REF=" + dst->FieldByName( "L1_REF" )->AsString + " and " +
          "L2_REF=" + dst->FieldByName( "L2_REF" )->AsString + " and " +
          "L3_ID="  + dst->FieldByName( "L3_ID"  )->AsString;
      }

   Query = new TQuery( dbt );

   switch ( Action )
          {
          case tvpDeleteSelect :
               Query->SQL->Add( "delete from \"LEVEL3.DB\" where " + S );
               break;
          case tvpCutSelect    :
               dbt->Synchronize_On( NodeAt );
               Query->SQL->Add( "update \"LEVEL3.DB\" set " \
                                "L1_REF=" +
                                NodeAt->DataSource->DataSet->FieldByName( "L1_REF" )->AsString +
                                ", "      \
                                "L2_REF=" +
                                NodeAt->DataSource->DataSet->FieldByName( "L2_ID"  )->AsString +
                                " where " + S );
               break;
          case tvpCopySelect   :
               dbt->Synchronize_On( NodeAt );
               Query->SQL->Add( "insert into \"LEVEL3.DB\" ( L1_REF, L2_REF, L3_ID, L3_DESC ) " \
                                " values( " +
                                NodeAt->DataSource->DataSet->FieldByName( "L1_REF" )->AsString + ", " +
                                NodeAt->DataSource->DataSet->FieldByName( "L2_ID"  )->AsString + ", " +
                                S + "\")" );
          }

   S = Query->SQL->Strings[ 0 ];
   ShowMessage( "The following SQL instruction will now be executed : " + S );

   Query->ExecSQL();

   Continue = false;
   }
/*
     If ( NodeFrom.Level = 3 ) Then Begin
        With NodeFrom.DataSource.DataSet, Sender as TDBTreeView Do Begin
             Query := TQuery.Create( Sender as TComponent );

             Case Action Of
                  tvpDeleteSelect : Begin
                                    Query.SQL.Add( 'delete from "LEVEL3.DB" where ' + S );
                                    End;
                  tvpCutSelect    : Begin
                                    Synchronize_On( NodeAt );
                                    Query.SQL.Add( 'update "LEVEL3.DB" set ' +
                                              'L1_REF=' + NodeAt.DataSource.DataSet.FieldByName( 'L1_REF' ).AsString + ', ' +
                                              'L2_REF=' + NodeAt.DataSource.DataSet.FieldByName( 'L2_ID'  ).AsString + ' where ' + S );
                                    End;
                  tvpCopySelect   : Begin
                                    Synchronize_On( NodeAt );
                                    Query.SQL.Add( 'insert into "LEVEL3.DB" ( L1_REF, L2_REF, L3_ID, L3_DESC ) ' +
                                              ' values( ' +
                                              NodeAt.DataSource.DataSet.FieldByName( 'L1_REF' ).AsString + ', ' +
                                              NodeAt.DataSource.DataSet.FieldByName( 'L2_ID'  ).AsString + ', ' +
                                              S + '")' );
                                    End;
                  End;
             End;
        ShowMessage( 'The following SQL instruction will now be executed :' +
                     #13#10#10 +
                     Query.SQL[ 0 ] );

        Query.ExecSQL;

        Continue := False;
        End;
*/
}
//---------------------------------------------------------------------------
void __fastcall TMain::DBTreeView1TreeDBError(TObject *Sender,
	EDatabaseError *E, TDBTreeNode *NodeAt, TDataSet *Table,
	const TDBTreeViewAction Action, TDataAction &ErrAction)
{
AnsiString SpecialInfos;

TDBTreeView *dbt;

if ( dynamic_cast<TDBTreeView*>(Sender) != 0 )
   {
   dbt = dynamic_cast<TDBTreeView*>(Sender);
   SpecialInfos = "Key(s) infos : '";
   switch ( NodeAt->Level )
          {
          case 1 :
          case 2 : SpecialInfos = SpecialInfos + dbt->Get_IndexFieldNames( NodeAt->DataSource->DataSet );
                   break;
          case 3 : SpecialInfos = SpecialInfos + "L1_REF;L2_REF";
                   break;
          }
   }

switch ( MessageDlg( "DBT2SAMP reports a database error with the following message :" \
                     "\r\n\n '" +
                     E->Message +
                     "'\r\n\n"  +
                     "Error Class : '"  + E->ClassName() + "'\r\n" +
                     "Node implied : '" + NodeAt->Text   + "'\r\n" +
                     "DataSet implied : '" + Table->Name + "'\r\n" +
                     SpecialInfos + "'\r\n\n" +
                     "You may [Abort] the program, or [Ignore] to continue.",
                     mtError, TMsgDlgButtons() << mbAbort << mbIgnore, 0 ) )
       {
       case mbAbort  : ErrAction = daFail; break;
       case mbIgnore : ErrAction = daAbort; break;
       }
}
//---------------------------------------------------------------------------
