unit uMain;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  DC4D, ExtCtrls, Buttons, Menus;

type
  TForm1 = class(TForm)
    Panel1: TPanel;
    ScrollBox: TScrollBox;
    DiagramBox: TDCDiagramBox;
    SpeedButton1: TSpeedButton;
    SpeedButton2: TSpeedButton;
    SpeedButton3: TSpeedButton;
    SpeedButton4: TSpeedButton;
    StyleLibrary: TDCStyleLibrary;
    AddVertexActor: TDCAddVertexActor;
    AddEdgeActor: TDCAddEdgeActor;
    EditActor: TDCEditActor;
    SpeedButton5: TSpeedButton;
    SpeedButton6: TSpeedButton;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Load1: TMenuItem;
    Save1: TMenuItem;
    N1: TMenuItem;
    Print1: TMenuItem;
    N2: TMenuItem;
    Import1: TMenuItem;
    Export1: TMenuItem;
    N3: TMenuItem;
    SaveBitmap1: TMenuItem;
    N4: TMenuItem;
    Quit1: TMenuItem;
    OD: TOpenDialog;
    SD: TSaveDialog;
    SDT: TSaveDialog;
    ODT: TOpenDialog;
    SDB: TSaveDialog;
    function AddVertexActorCreateVertex(Sender: TObject;
      P: TDCPoint): TDCCustomVertex;
    function AddEdgeActorCreateEdge(Sender: TObject; Source,
      Target: TDCObject; StartP, EndP: TDCPoint): TDCCustomEdge;
    procedure SpeedButton1Click(Sender: TObject);
    procedure SpeedButton2Click(Sender: TObject);
    procedure SpeedButton6Click(Sender: TObject);
    procedure SpeedButton5Click(Sender: TObject);
    procedure SpeedButton3Click(Sender: TObject);
    procedure SpeedButton4Click(Sender: TObject);
    function StyleLibraryGetData(Id: Integer; Fieldname: string;
      theObject: TObject): string;
    procedure EditActorRightClick(DiagramObject: TDCObject; P: TPoint;
      var SelMode: TDCSelMode; var DoDefaults: Boolean);
    procedure Load1Click(Sender: TObject);
    procedure Save1Click(Sender: TObject);
    procedure Import1Click(Sender: TObject);
    procedure Export1Click(Sender: TObject);
    procedure SaveBitmap1Click(Sender: TObject);
    procedure Quit1Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;

  VertexStyle : string;
  EdgeStyle : string;

implementation

{$R *.DFM}

function TForm1.AddVertexActorCreateVertex(Sender: TObject;
  P: TDCPoint): TDCCustomVertex;
var
   DI : TDCDataItem;
   NewText : string;
begin
   Result := TDCVertex.Create(P, VertexStyle, StyleLibrary);

   if InputQuery(VertexStyle + ' Text', 'Enter text', NewText) then begin
      DI := TDCVertex(Result).Style.GetDataItem('Text');
      DI.Data := NewText;
   end;
end;

function TForm1.AddEdgeActorCreateEdge(Sender: TObject; Source,
  Target: TDCObject; StartP, EndP: TDCPoint): TDCCustomEdge;
var
   NewText : string;
begin
   Result := TDCEdge.Create(Source, Target, StartP, EndP, EdgeStyle, StyleLibrary);

   if EdgeStyle <> 'Remark' then begin
      if InputQuery(VertexStyle + ' Text', 'Enter text', NewText) then begin
         TDCEdge(Result).TextBox.Text := NewText;
      end;
   end;
end;

procedure TForm1.SpeedButton1Click(Sender: TObject);
begin
   DiagramBox.Actor := AddVertexActor;
   VertexStyle := 'Operation';
end;

procedure TForm1.SpeedButton2Click(Sender: TObject);
begin
   DiagramBox.Actor := AddVertexActor;
   VertexStyle := 'Decision';
end;

procedure TForm1.SpeedButton6Click(Sender: TObject);
begin
   DiagramBox.Actor := AddVertexActor;
   VertexStyle := 'Note';
end;

procedure TForm1.SpeedButton5Click(Sender: TObject);
begin
   DiagramBox.Actor := AddEdgeActor;
   EdgeStyle := 'Flow';
end;

procedure TForm1.SpeedButton3Click(Sender: TObject);
begin
   DiagramBox.Actor := AddEdgeActor;
   EdgeStyle := 'Remark';
end;

procedure TForm1.SpeedButton4Click(Sender: TObject);
begin
   DiagramBox.Actor := EditActor;
end;

function TForm1.StyleLibraryGetData(Id: Integer; Fieldname: string;
  theObject: TObject): string;
begin
  Result := TDCVertex(DiagramBox.FindObjectById(Id)).Style.GetDataItem('Text').Data;
end;

procedure TForm1.EditActorRightClick(DiagramObject: TDCObject; P: TPoint;
  var SelMode: TDCSelMode; var DoDefaults: Boolean);
begin
   if MessageDlg('Really delete objects', mtConfirmation, [mbYes,mbNo], 0) = ID_YES then begin
      DiagramBox.DeleteSelectedObjects(dcInteractive);
   end;
end;

procedure TForm1.Load1Click(Sender: TObject);
begin
   if OD.Execute then begin
      DiagramBox.Load(OD.Filename, StyleLibrary);
   end;
end;

procedure TForm1.Save1Click(Sender: TObject);
begin
   if SD.Execute then begin
      DiagramBox.Save(SD.Filename, StyleLibrary);
   end;
end;

procedure TForm1.Import1Click(Sender: TObject);
begin
   if ODT.Execute then begin
      DiagramBox.Import(ODT.Filename, StyleLibrary);
   end;
end;

procedure TForm1.Export1Click(Sender: TObject);
begin
   if SDT.Execute then begin
      DiagramBox.Export(SDT.Filename, StyleLibrary);
   end;
end;

procedure TForm1.SaveBitmap1Click(Sender: TObject);
begin
   if SDB.Execute then begin
      DiagramBox.SaveBitmap(SDB.Filename);
   end;
end;

procedure TForm1.Quit1Click(Sender: TObject);
begin
   if ((DiagramBox.Changed = True) and (MessageDlg('Diagram changed. Really quit?', mtConfirmation, [mbYes, mbNo], 0) = ID_YES)) or (DiagramBox.Changed = False) then begin
      Close;
   end;
end;

procedure TForm1.FormShow(Sender: TObject);
begin
   RegisterDCClass(TDCVertex);
   RegisterDCClass(TDCEdge);
end;

end.
