unit CGIProcs;

interface

uses
	CGI,
	SysUtils;

procedure SendOrderForm;
procedure ProcessOrder;
procedure RejectOrder(const Reason: String);
procedure SendHeader(const Title: String);
procedure SendFooter;

var
	CGI1: TCGI;

implementation

procedure SendOrderForm;
begin
	with CGI1 do begin
		SendHeader('Pizza Order Form');
		Send('<FORM METHOD="POST" ACTION="/cgi-win/noform.exe">');
		Send('<B>Godzilla''s Pizza -- Internet Delivery Service</B><P>');
		Send('At present, we accept internet orders only for medium (13") size pizzas.');
		Send('It is now ' + FormatDateTime('h:mm AM/PM', Now) +'. ');
		Send('You will have your pizza by ' + FormatDateTime('h:mm AM/PM', Now + EncodeTime(0,45,0,0)) + '.');
		Send('<PRE>');
		Send('          Name: <INPUT SIZE=30 NAME="name">');
		Send('Street address: <INPUT SIZE=30 NAME="address">');
		Send('  Phone number: <INPUT SIZE=15 NAME="phone">');
		Send('          City: <SELECT NAME="city">');
		Send('                <OPTION SELECTED>Pasadena (free)');
		Send('                <OPTION>Altadena (free)');
		Send('                <OPTION>So. Pasadena ($1.00)');
		Send('                <OPTION>Arcadia ($1.00)');
		Send('                <OPTION>Monrovia ($2.50)');
		Send('                </SELECT>');
		Send('</PRE>');
		Send('Which toppings would you like? <BR>');
		Send('<OL>');
		Send('<LI> <INPUT TYPE="checkbox" NAME="topping" VALUE="pepperoni"> Pepperoni.');
		Send('<LI> <INPUT TYPE="checkbox" NAME="topping" VALUE="sausage"> Sausage.');
		Send('<LI> <INPUT TYPE="checkbox" NAME="topping" VALUE="anchovies"> Anchovies.');
		Send('</OL>');
		Send('To order your pizza, press this button: <INPUT TYPE="submit" VALUE="Order Pizza">.');
		Send('</FORM>');
	end;
	SendFooter;
end;

procedure ProcessOrder;
var
	Name,
   Address,
	City,
	Phone,
	Toppings: String;
	i: Char;
begin
	with CGI1.FormFields do begin
		Name := Values['name'];
		Address := Values['address'];
		Phone := Values['phone'];
		City := Values['city'];
		Toppings := Values['topping'];

		i := '1';
		while IndexOfKey('topping_'+i) > -1 do begin
			Toppings := Toppings + ', ' + Values['topping_'+i];
			Inc(i);
		end;
	end;

	if (Name = '') or (Address = '') or (Phone = '') or (City = '') then
		RejectOrder('you didn''t fill in all of the fields')
	else begin
		SendHeader('Order Confirmation');
		with CGI1 do begin
			Send('<H1>Order Confirmation</H1>');
			Send('Your order has been received, and appears valid. Here it is:');
			Send('<PRE>');
			Send('          Name: ' + Name);
			Send('Street address: ' + Address);
			Send('  Phone number: ' + Phone);
			Send('          City: ' + City);
			Send('      Toppings: ' + Toppings);
			Send('</PRE>');
			Send('If you have any corrections, please call 555-555-5555 immediately!');
		end;
		SendFooter;
	end;
end;

procedure SendHeader(const Title: String);
begin
	with CGI1 do begin
		Send('<HTML><HEAD><TITLE>' + Title + '</TITLE></HEAD>');
		Send('<BODY>');
	end;
end;

procedure SendFooter;
begin
	with CGI1 do begin
		Send('<HR>');
		Send('Click below to send mail to our order desk:<BR>');
		Send('<A HREF="mailto:Orders@Godzilla.com">');
		Send('<ADDRESS>&lt;Orders@Godzilla.com&gt;</ADDRESS></A>');
		Send('</BODY></HTML>');
	end;
end;

procedure RejectOrder(const Reason: String);
begin
	SendHeader('Order Rejected');
	with CGI1 do begin
		Send('<H1>Can''t process your order</H1>');
		Send('We can''t process your order because ' + Reason + '. ');
		Send('Please correct your order and re-send it.');
	end;
	SendFooter;
end;

end.
 