unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Raycast, StdCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    Timer: TTimer;
    procedure FormResize(Sender: TObject);
    procedure TimerTimer(Sender: TObject);
  private
    { Private declarations }
  protected
    function PixelLoc(X,Y: Integer): pChar;
    procedure WMEraseBkgnd(var Msg: TWMEraseBkgnd); message WM_ERASEBKGND;
    procedure CreateParams(var Params: TCreateParams); override;
    function GetPalette: HPALETTE; override;
    procedure Paint; override;
  public
    { Public declarations }
    Film: TFilm;
    constructor Create(AOwner: TComponent); override;
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

constructor TForm1.Create(AOwner: TComponent);
var
  Bmp: TBitmap;
begin
  inherited Create(AOwner);
  Film := TFilm.Create(Self);
  Bmp := TBitmap.Create;
  try
    Bmp.LoadFromFile(ExtractFilePath(Application.ExeName)+'bkgd.bmp');
    Film.SetBounds(Bmp.Width, Bmp.Height);
    Film.Canvas.Draw(0, 0, Bmp);
  finally
    Bmp.Free;
  end;
  ClientWidth := Film.Width;
  ClientHeight := Film.Height;
  Randomize;
end;

procedure TForm1.CreateParams(var Params: TCreateParams);
begin
  inherited CreateParams(Params);
  with Params.WindowClass do
    Style := Style or CS_HREDRAW or CS_VREDRAW;
end;

function TForm1.GetPalette: HPALETTE;
begin
  if (Film <> nil) and (Film.Palette <> 0) then
    Result := Film.Palette
  else
    Result := inherited GetPalette;
end;

procedure TForm1.Paint;
var
  R: TRect;
begin
  if (Film <> nil) and (Film.Canvas <> nil) then begin
    R := GetClientRect;
    SetStretchBltMode(Canvas.Handle, ColorOnColor);
    StretchBlt(Canvas.Handle, R.Left, R.Top, R.Right-R.Left, R.Bottom-R.Top,
        Film.Canvas.Handle, 0, 0, Film.Width, Film.Height, SRCCOPY);
  end
  else inherited Paint;
end;

function TForm1.PixelLoc(X,Y: Integer): pChar;
begin
  Result := pChar(Film.Pixels) + Y*Film.ScanWidth + ((X*Film.ColorDepth) div 8);
end;

procedure TForm1.WMEraseBkgnd(var Msg: TWMEraseBkgnd);
begin
  Msg.Result := 1;
end;

var
  DoingResize: Boolean;

procedure TForm1.FormResize(Sender: TObject);
begin
  if Film = nil then Exit;
  if not DoingResize then begin
    DoingResize := True;
    try
      ClientWidth := ClientHeight*Film.Width div Film.Height;
    finally
      DoingResize := False;
    end;
  end;
end;

procedure TForm1.TimerTimer(Sender: TObject);
var
  P: pChar;
  X,Y: Integer;
begin
  X := Random(Film.Width);
  Y := Random(Film.Height);
  P := PixelLoc(X, Y);
  case Film.ColorDepth of
    8:
      begin
        P^ := #0;
      end;
    16:
      begin
        pWord(P)^ := 0;
      end;
    24:
      begin
        FillChar(P^, 3, 0);
      end;
    32:
      begin
        pLongInt(P)^ := 0;
      end;
  end;
  Invalidate;
end;

end.
