unit Tblinfo;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, DB, DBTables, BDEProcs, DBITypes,
  IniFiles;

type
  TfrmTableInfo = class(TForm)
    Memo: TMemo;
    GrpBox: TGroupBox;
    rbtnAliasNames: TRadioButton;
    rbtnDictionary: TRadioButton;
    lstAlias: TComboBox;
    btnSelect: TButton;
    Database: TDatabase;
    btnOpenDatabase: TButton;
    OpenDialog: TOpenDialog;
    Table: TTable;
    Label1: TLabel;
    lstTables: TComboBox;
    lblphysFileName: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    btnStatus: TButton;
    btnTblProperties: TButton;
    btnData: TButton;
    Memo1: TMemo;
    btnAddToIni: TButton;
    procedure btnSelectClick(Sender: TObject);
    procedure lstAliasChange(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure btnOpenDatabaseClick(Sender: TObject);
    procedure lstTablesChange(Sender: TObject);
    procedure btnDataClick(Sender: TObject);
    procedure btnStatusClick(Sender: TObject);
    procedure btnTblPropertiesClick(Sender: TObject);
    procedure btnAddToIniClick(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
    procedure GetBtrieveAliasNames;
    function GetTablePhysFileName ( sTable : string) :string;
    procedure GetIndexes;
  end;

var
  frmTableInfo: TfrmTableInfo;

implementation

uses TblData, TblStat, TblProps, TblDBNam;

{$R *.DFM}

procedure TfrmTableInfo.GetBtrieveAliasNames;
var ls,lsP : TStringlist;
    i : integer;
begin
  ls := TStringList.Create; lsP := TStringList.Create;
  Session.GetAliasNames (ls);
  i := 0;
  while i <= ls.Count-1 do begin
    Session.GetAliasParams (ls.strings[i],lsp);
    if pos ('DDL',lsp.strings [0])=0 then ls.Delete (i)
      else inc (i);
  end;
  lstAlias.Items := ls;
  ls.free; lsP.Free;
end;

procedure TfrmTableInfo.GetIndexes;
var ls : TStringList;
    i  : integer;
begin
  ls := TStringList.Create;
  Table.IndexDefs.Update;
  with Table.IndexDefs do begin
    for i := 0 to Count-1 do begin
      ls.Add (Items [i].Name + ' ' + Items [i].Fields);
    end;
  end;
  Memo1.Lines := ls;
  ls.free;
end;

function TfrmTableInfo.GetTablePhysFileName ( sTable : string) :string;
var szTableName : array [0..21] of char;
    szName : array [0..80] of char;
begin
  DBIFormFullName (Database.Handle,
                   StrPCopy(@szTableName,sTable) ,
                   'BTRIEVE',@szName);
  Result := strPas (@szName);
end;

procedure TfrmTableInfo.btnSelectClick(Sender: TObject);
var i : byte;
begin
  if rBtnAliasNames.Checked then
    GetBtrieveAliasNames;
  if rBtnDictionary.Checked then begin
    if OpenDialog.Execute then begin
      i := pos('\FILE.DDF',OpenDialog.FileName);
      lstAlias.Text := copy (OpenDialog.FileName,1,i-1);
    end;
  end;
end;

procedure TfrmTableInfo.lstAliasChange(Sender: TObject);
begin
  with lstAlias do
    Text := Items.Strings[ItemIndex];
end;

procedure TfrmTableInfo.FormCreate(Sender: TObject);
begin
  lstTables.Text := '';
  lstAlias.Text := '';
  if rBtnAliasNames.Checked then begin
    GetBtrieveAliasNames;
    with lstAlias do
      Text := Items.Strings[0];
  end;
end;

procedure TfrmTableInfo.btnOpenDatabaseClick(Sender: TObject);
var ls : TStringList;
begin
  ls := TStringList.Create;
  if Database.connected then with Database do begin
    connected := false;
    DriverName:= '';
    Aliasname := '';
    Params.Clear;
  end;
  btnAddToIni.Visible := false;

  if rBtnAliasNames.Checked then begin
    try
      with Database do begin
        AliasName  := lstAlias.Text;
        Connected := true;
        screen.Cursor := crHourGlass;
      end;
    except
      screen.Cursor := crDefault;
      ShowMessage ('Database not opened'#13);
    end;
  end;
  if rBtnDictionary.Checked then begin
    try
      ls := TStringList.Create;
      ls.Add ('DDL='+lstAlias.Text);
      ls.Add ('USER NAME= MASTER');
      with Database do begin
        DriverName := 'BTRIEVE';
        Params := ls;
        Connected := true;
        screen.Cursor := crHourGlass;
      end;
      btnAddToIni.Visible := true;
    except
      screen.Cursor := crDefault;
      ShowMessage ('Database not opened'#13);
    end;
  end;

  {- Read Dictionary files}
  try
    ls.Clear;
    Session.GetTableNames (Database.DataBaseName,
                           '*', False, False, ls);
    with lstTables do begin
      Items := ls;
      Text := Items.Strings[0];
      lblphysFileName.Caption := GetTablePhysFileName (Text);
      Table.TableName := text;
      ls.Clear;
      Table.GetFieldNames (ls);
      Memo.Lines := ls;
      GetIndexes;
    end;

  except
    screen.Cursor := crDefault;
    ShowMessage ('Dictionary not open'#13);
  end;
  screen.Cursor := crDefault;
  ls.Free;
end;

procedure TfrmTableInfo.lstTablesChange(Sender: TObject);
var ls : TStringList;
begin
  with lstTables do begin
    Text := Items.Strings[ItemIndex];
    lblphysFileName.Caption := GetTablePhysFileName (Text);
    Table.TableName := text;
    ls := TStringList.Create;
    Table.GetFieldNames (ls);
    Memo.Lines := ls;
    GetIndexes;
    ls.free;
  end;
end;

procedure TfrmTableInfo.btnDataClick(Sender: TObject);
begin
  frmData.ShowModal;
end;

procedure TfrmTableInfo.btnStatusClick(Sender: TObject);
Var DBIResult : word;
    iLen : word;
begin
  try
    Table.Active := true;

    DBIResult := dbiGetProp (hDBIObj(Table.Handle),
                    curNativeHndl,@BTRHandle,
                    sizeOf (BTRHandle),
                    iLen);
    TableStatus.sTableName := Table.TableName;
    TableStatus.ShowModal;
    Table.Active := false;
  except
    ShowMessage ('Table not found.'#13);
  end;
end;

procedure TfrmTableInfo.btnTblPropertiesClick(Sender: TObject);
begin
  try
    Table.Active := true;
    frmProperty.bCurProperties := true;
    frmProperty.ShowModal;
    Table.Active := false;
  except
    ShowMessage ('Table not found.'#13);
  end;
end;

procedure TfrmTableInfo.btnAddToIniClick(Sender: TObject);
var oIni : TIniFile;
    sDBName: string;
begin

  if frmDBName.ShowModal=mrOK then begin
    sDBName := frmDBName.Edit.text;
    oIni := TiniFile.Create('C:\WINDOWS\BTRDDL.INI');
    if not FileExists ('C:\WINDOWS\BTRDDL.INI') then
      oIni.WriteString ('DENG','LANG','intl');
    oIni.WriteString (sDBName,'DDL',lstAlias.Text);
    oIni.WriteString (sDBName,'USER NAME','MASTER');
    oIni.Free;
  end;
end;

end.
