unit TblProps;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Grids, StdCtrls;

type
  TfrmProperty = class(TForm)
    gridProperties: TStringGrid;
    Button1: TButton;
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
    bCurProperties : boolean;
  end;

var
  frmProperty: TfrmProperty;

implementation


uses TblInfo, DbiTypes, BDEProcs, BOFile;
type
  setcurProperties = ( prpMaxprops,
                       prpTableName,
                       prpTableType,
                       prpTableLevel,
                       prpFileName,
                       prpXltMode,
                       prpSeqReadOn,
                       prpOnePassOn,
                       prpUpdateTS,
                       prpSoftDeleteOn,
                       prpLangDrvName,
                       prpCursorName );
const
  caXLTMode :array [0..2] of string[10] = (                        { Field translate mode }
    ('xltNONE'),                         { No translation  (Physical Types) }
    ('xltRECORD'),                       { Record level translation (not supported) }
    ('xltFIELD')                         { Field level translation (Logical types) }
  );

{$R *.DFM}

function hexW ( l : longint ) : string;
begin
  FmtStr (Result,'%4x',[l]);
end;

function GetCurProperties ( setProperty : setCurProperties;
                            var sPropVal  : string  ) : boolean;
var DBIResult : word;
    iLen      : word;
    iMaxProps,
    iTableLevel : word;
    bSeqReadOn,
    bOnePassOn,
    bSoftDeleteOn : bool;
    propResult : array [0..255] of char;
    UpdateTS : TimeStamp;
    eXLTMode : XLTMode;
begin
  Result := false;
  DBIResult := 0;
  case setProperty of
    prpMaxProps : begin
      DBIResult := dbiGetProp (hDBIObj(frmTableInfo.Table.Handle),
                         curMaxProps,@iMaxProps,
                         sizeOf (iMaxProps),
                         iLen);
      if DBIResult=0 then begin
        sPropVal := IntToStr(iMaxProps);
      end else
        sPropVal := 'DBI-Error $'+hexw(DBIResult);
    end;
    prpTableName : begin
      DBIResult := dbiGetProp (hDBIObj(frmTableInfo.Table.Handle),
                         curTableName,@propResult,
                         sizeOf (propResult),
                         iLen);
      if DBIResult=0 then begin
        sPropVal := StrPas (propResult);
      end else
        sPropVal := 'DBI Error $'+hexw(DBIResult);
    end;
    prpTableType : begin
      DBIResult := dbiGetProp (hDBIObj(frmTableInfo.Table.Handle),
                         curTableType,@propResult,
                         sizeOf (propResult),
                         iLen);
      if DBIResult=0 then begin
        sPropVal := StrPas (propResult);
      end else
        sPropVal := 'DBI Error $'+hexw(DBIResult);
    end;
    prpTableLevel: begin
      DBIResult := dbiGetProp (hDBIObj(frmTableInfo.Table.Handle),
                         curTableLevel,@iTableLevel,
                         sizeOf (iTableLevel),
                         iLen);
      if DBIResult=0 then begin
        sPropVal := IntToStr (iTableLevel);
      end else
        sPropVal := 'DBI Error $'+hexw(DBIResult);
    end;
    prpFileName  : begin
      DBIResult := dbiGetProp (hDBIObj(frmTableInfo.Table.Handle),
                         curFileName,@propResult,
                         sizeOf (propResult),
                         iLen);
      if DBIResult=0 then begin
        sPropVal := StrPas (propResult);
      end else
        sPropVal := 'DBI Error $'+hexw(DBIResult);
    end;
    prpXLTMode   : begin
      DBIResult := dbiGetProp (hDBIObj(frmTableInfo.Table.Handle),
                         curXLTMode,@eXLTMode,
                         sizeOf (eXLTMode),
                         iLen);
      if DBIResult=0 then begin
        sPropVal := caXLTMode [ord(eXLTMode)];
      end else
        sPropVal := 'DBI Error $'+hexw(DBIResult);
    end;
    prpSeqReadOn : begin
      DBIResult := dbiGetProp (hDBIObj(frmTableInfo.Table.Handle),
                         curSeqReadOn,@bSeqReadOn,
                         sizeOf (bSeqReadOn),
                         iLen);
      if DBIResult=0 then begin
        if bSeqReadOn then sPropVal := 'True'
          else sPropVal := 'False';
      end else
        sPropVal := 'DBI Error $'+hexw(DBIResult);
    end;
    prpOnePassOn : begin
      DBIResult := dbiGetProp (hDBIObj(frmTableInfo.Table.Handle),
                         curOnePassOn,@bOnePassOn,
                         sizeOf (bOnePassOn),
                         iLen);
      if DBIResult=0 then begin
        if bOnePassOn then sPropVal := 'True'
          else sPropVal := 'False';
      end else
        sPropVal := 'DBI Error $'+hexw(DBIResult);
    end;
    prpUpdateTS  : begin
      DBIResult := dbiGetProp (hDBIObj(frmTableInfo.Table.Handle),
                         curUpdateTS,@UpdateTS,
                         sizeOf (UpdateTS),
                         iLen);
      if DBIResult=0 then begin
        sPropVal := DateTimeToStr (UpdateTS);
      end else
        sPropVal := 'DBI Error $'+hexw(DBIResult);
    end;
    prpSoftDeleteOn: begin
      DBIResult := dbiGetProp (hDBIObj(frmTableInfo.Table.Handle),
                         curSoftDeleteOn,@bSoftDeleteOn,
                         sizeOf (bSoftDeleteOn),
                         iLen);
      if DBIResult=0 then begin
        if bSoftDeleteOn then sPropVal := 'True'
          else sPropVal := 'False';
      end else
        sPropVal := 'DBI Error $'+hexw(DBIResult);
    end;
    prpLangDrvName: begin
      DBIResult := dbiGetProp (hDBIObj(frmTableInfo.Table.Handle),
                         curLangDrvName,@propResult,
                         sizeOf (propResult),
                         iLen);
      if DBIResult=0 then begin
        sPropVal := StrPas (propResult);
      end else
        sPropVal := 'DBI Error $'+hexw(DBIResult);
    end;
    prpCursorName: begin
      DBIResult := dbiGetProp (hDBIObj(frmTableInfo.Table.Handle),
                         curCursorName,@propResult,
                         sizeOf (propResult),
                         iLen);
      if DBIResult=0 then begin
        sPropVal := StrPas (propResult);
      end else
        sPropVal := 'DBI Error $'+hexw(DBIResult);
    end;
  end;{case}
  if DBIResult = $3001 then
    sPropVal := 'Not Supported';
  Result := ( DBIResult = 0);
end;

procedure TfrmProperty.FormCreate(Sender: TObject);
begin
  with gridProperties do begin
    Font.Name := 'Arial';
    Font.Size := 8;
    RowCount := 13;
    cells [0,0] := 'Property';
    cells [1,0] := 'Result';
    cells [2,0] := 'Value';
    cells [0,1] := 'curMaxProps';
    cells [0,2] := 'curTableName';
    cells [0,3] := 'curTableType';
    cells [0,4] := 'curTableLevel';
    cells [0,5] := 'curFileName';
    cells [0,6] := 'curXLTMode';
    cells [0,7] := 'curSEQReadOn';
    cells [0,8] := 'curOnePassOn';
    cells [0,9] := 'curUpdateTS';
    cells [0,10] := 'curSoftDeleteOn';
    cells [0,11] := 'curLangDrvName';
    cells [0,12] := 'curCursorName';
    colwidths[0]:= 120;
    colwidths[1]:= 0;
    colwidths[2]:= 320;
  end;
  bCurProperties := false;
end;

procedure TfrmProperty.FormShow(Sender: TObject);
var i : setCurProperties;
    j : word;
    s : string;
    iLen,
    DBIResult : word;
    pBTR : PBtrieve5File;
    iProp,
    lRecs : Longint;
begin
  if bCurProperties then begin
    for i :=  prpMaxProps to prpCursorName do begin
      gridProperties.cells [1,ord(i)+1] := 'Error';
      if GetCurProperties ( i, s ) then begin
        gridProperties.cells [2,ord(i)+1] := s;
        gridProperties.cells [1,ord(i)+1] := 'OK';
      end else
        gridProperties.cells [2,ord(i)+1] := s;
    end;
  end;
end;


procedure TfrmProperty.Button1Click(Sender: TObject);
begin
  close;
end;

end.
