{ TDialer component for Borland DELPHI, Version 2.00.
     Freeware.
 (C) Artchil Gogava, ArGo Software Design, Toronto, Canada. October 1995.
     Internet: 75231.330@compuserve.com
     www     : http://www.icacomp.com/customers/agogava

 To install this component in you VCL place the files
 DIALER.PAS, DIALDLG.PAS and DIALDLG.DFM it in your
 C:\DELPHI\LIB directory and from IDE Options Menu select
 Install Components. In the Install Components dialog
 box click Add Button, then in Add Module box type
 C:\DELPHI\LIB\DIALER.PAS, click OK, then in the Install
 Components Dialog box click OK again and wait a while.
 Dialer icon will appear in the System section of
 your Components Palette.

 New version detects dialtone and busy signal and includes
 one more property - Modem initialization string}

unit Dialer;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, DialDlg;

type

  TComPort = (dpCOM1,dpCOM2,dpCOM3,dpCOM4);
  TMethod  = (dmTone,dmPulse);

  TDialer = class(TComponent)
  private
    { Private declarations }
    FComPort : TComPort;
    FNumberToDial : string;
    FConfirm : boolean;
    FMethod : TMethod;
    FInitStr : string;
    Buf : array[1..32] of Char;
  protected
    { Protected declarations }
    CId : Integer;
    Stat : TComStat;
    HInv : HWnd;
    DialerDlg : TDialerDlg;
    procedure WndProc(var Msg : TMessage);
  public
    { Public declarations }
    constructor Create(AOwner : TComponent); override;
    destructor Destroy; override;
    procedure Execute;
  published
    { Published declarations }
    property ComPort : TComPort read FComPort
                 write FComPort;
    property Confirm : boolean read FConfirm
                 write FConfirm;
    property InitStr : string read FInitStr
                 write FInitStr;
    property Method  : TMethod read FMethod
                 write FMethod;
    property NumberToDial : string read FNumberToDial
                 write FNumberToDial;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('System', [TDialer]);
end;

constructor TDialer.Create(AOwner : TComponent);
begin
  inherited Create(AOwner);
  HInv:=AllocateHWnd(WndProc);
end;

destructor TDialer.Destroy;
begin
  DeallocateHWnd(HInv);
  inherited Destroy;
end;

procedure TDialer.WndProc(var Msg : TMessage);
var
  Status : Integer;
  s : string;
begin
  with Msg do
  if (Msg=WM_COMMNOTIFY) and (lParamLo=CN_RECEIVE) then
  begin
    Status:=ReadComm(CId,@Buf,128);
    GetCommError(CId,Stat);
    s:=UpperCase(StrPas(@Buf));
    if Pos('DIALTONE',s)<>0 then
      DialerDlg.Label1.Caption:='No Dialtone'
    else
    if Pos('BUSY',s)<>0 then
      DialerDlg.Label1.Caption:='Line is busy';
    Result:=0;
  end
  else
    Result:=DefWindowProc(HInv, Msg, wParam, lParam);
end;

procedure TDialer.Execute;
var
  s : string;
  Status : Integer;
begin
  {Open Com Port}
  StrPCopy(@Buf,'COM ');
  Buf[4]:=Chr(49+Ord(FComPort));
  CId:=OpenComm(@Buf,512,512);
  if CId<0 then
  begin
    MessageDlg('Unable to open '+StrPas(@Buf),mtError,
                [mbOk], 0);
    Exit;
  end;
  {Send modem initialization string, if any}
  if FInitStr<>'' then
  begin
    s:=FInitStr+^M^J;
    StrPCopy(@Buf,s);
    Status:=WriteComm(CId,@Buf,StrLen(@Buf));
    if Status<0 then
    begin
      MessageDlg('Error initializing a modem',mtError,
                 [mbOk],0);
      CloseComm(CId);
      Exit;
    end;
  end;
  if FConfirm then
  begin
   if MessageDlg('About to dial the number '+FNumberToDial+'. Are you sure?',
      mtConfirmation, [mbYes,mbNo], 0)<>mrYes then
   begin
     CloseComm(CId);
     Exit;
   end;
  end;
  {Create a string to send to modem}
  s:=Concat('ATDT',FNumberToDial,^M^J);
  if FMethod=dmPulse then s[4]:='P';
  {Send phone number to modem}
  StrPCopy(@Buf,s);
  Status:=WriteComm(CId,@Buf,StrLen(@Buf));
{Enable WM_COMMNOTIFY message}
  EnableCommNotification(CId,HInv,128,128);
  if Status>=0 then
  begin
    DialerDlg:=TDialerDlg.Create(Application);
    DialerDlg.Caption:=Concat('Dialing ',FNumberToDial);
    DialerDlg.ShowModal;
    DialerDlg.Free;
    WriteComm(CId,'ATH'^M^J,5);
  end
  else
    MessageDlg('Unable to dial number',mtError,
                [mbOk], 0);
  {Close communication port}
  if CId>0 then
    CloseComm(CId);
end;

end.
