{ TDialer component for Borland DELPHI, Version 1.00.
     Freeware.
  Original code by Artchil Gogava, ArGo Software Design, Toronto, Canada.
October 1995.
     Internet: 75231.330@compuserve.com
     www     : http://www.icacomp.com/customers/agogava
  Changes for Borland DELPHI 2.0 made by:
     Ruud Overdijk, Kwarts produkties, Hilversum, The Netherlands, April 1996.
     Internet : roverdyk@worldaccess.nl
     Compuserve :  71613,1733

  Changes for bi-language support (both english and dutch)
     Ruud Bijvank, Visual Solutions, Dordrecht, The Netherlands, June 1996.
     Compuserve : 100425,3165}

unit dialerPlus;

interface

uses
  Windows, SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics,
  Controls, Forms, Dialogs;
type
  TMode =(mDirect,mTapi);
  TComPort = (dpCOM1,dpCOM2,dpCOM3,dpCOM4);
  TLanguage = (dlEnglish, dlDutch, dlGerman);
  TDialer = class(TComponent)
  private
    { Private declarations }
    FComPort : TComPort;
    FNumberToDial : string;
    FConfirm : boolean;
    FMethod : String;
    FLanguage : TLanguage;
    FMode : TMode;

  protected
    { Protected declarations }
  public
    { Public declarations }

    Function Execute :String;
  published
    property ComPort : TComPort read FComPort
                 write FComPort;
    property Confirm : boolean read FConfirm
                 write FConfirm;
    property NumberToDial : string read FNumberToDial
                 write FNumberToDial;
    property Language : TLanguage Read FLanguage
                 write FLanguage;
    property DialCommand : string read FMethod
                 write FMethod;
    property Mode : Tmode read FMode
                 write FMode;

    { Published declarations }
  end;

procedure Register;
function tapiRequestMakeCall(pDestAddress,pAppName,pCalledParty,pComment: PChar): LongInt; stdcall;

implementation
function tapiRequestMakeCall(pDestAddress,pAppName,pCalledParty,pComment: PChar): LongInt; stdcall; external 'TAPI32.DLL';
const
TAPIERR_CONNECTED=0;
TAPIERR_NOREQUESTRECIPIENT=-2;
TAPIERR_REQUESTQUEUEFULL=-3;
TAPIERR_INVALDESTADDRESS=-4;
TAPIMAXDESTADDRESSSIZE=80;



procedure Register;
begin
  RegisterComponents('Samples', [TDialer]);
end;

function TDialer.Execute :String;
var
  ErrorCode:LongInt;
  szNR          : Array[0..TAPIMAXDESTADDRESSSIZE] of Char;
  sText         : String;
  s		: string;
  hCommFile 	: THandle;
  Status 	: LongBool;
  NumberWritten	: DWORD;
  SMessage      : string;
  DialCommand :PChar;
  HangUpCommand: PChar;

  begin
if Fmode=mDirect then begin
  if FConfirm then
  begin
  Case FLanguage of
  dlEnglish:     SMessage := 'About to dial the number '+FNumberToDial+'. Are you sure?';
  dlDutch:       SMessage := 'Weet u zeker dat u nummer '+FNumberToDial+' wilt kiezen ?';
  dlGerman:      SMessage := 'Wollen Sie die Nummer '+FNumberToDial+' whlen ?';

  end;
  if MessageDlg(SMessage,
      mtConfirmation, [mbYes,mbNo], 0)=mrNo then Exit;
  end;
  {Open Com Port}
  s:='COM'+Chr(49+Ord(FComPort));
  hCommFile:= CreateFile( PChar(s), GENERIC_WRITE,
                                0, {not shared}
                                nil, {no security ??}
                                OPEN_EXISTING,
                                FILE_ATTRIBUTE_NORMAL,
                                0 {template} );
  if hCommFile=INVALID_HANDLE_VALUE then
  begin
    Case FLanguage of
    dlEnglish:     SMessage := 'Unable to open '+s;
    dlDutch:       SMessage := 'Kan '+s+ ' niet openen';
    dlGerman:      SMessage := 'Fehler beim Ansprechen des COM '+s+' Ports. Bitte berprfen Sie, ob das Modem richtig angeschlossen ist und ob keine weitere Kommunikationssoftware aktiv ist.';
    end;
    Result:='COMOPENERROR';
    MessageDlg(SMessage,mtError,[mbOk], 0);
    Exit;
  end;
  {Create a string to send to modem}
  s:=FMethod+FNumberToDial+#13+#10;
  //if FMethod=dmPulse then s[4]:='P';
  {Send phone number to modem}
  NumberWritten:=0;
  Status:=WriteFile( hCommFile,PChar(s)[0],
                     Length(s),
                     NumberWritten,
                     nil);
  if Status then
  begin
    Case FLanguage of
    dlEnglish:     SMessage := 'Pick up phone';
    dlDutch:       SMessage := 'Pak de telefoon op';
    dlGerman:      SMessage := 'Nummer gewhlt - Bitte nehmen Sie den Hrer ab und klicken dann auf OK';
    end;
    MessageDlg(SMessage,mtInformation,[mbOk], 0);
    Result:='OK';
    WriteFile(hCommFile,'ATH'^M^J,5,NumberWritten,nil);
  end
  else
  Begin
    Case FLanguage of
    dlEnglish:     SMessage := 'Unable to dial number';
    dlDutch:       SMessage := 'Kan dit nummer niet kiezen';
    dlGerman:       SMessage := 'Kann die angegebene Nummer nicht erreichen !';
    end;
    MessageDlg(SMessage,mtError,[mbOk], 0);
    Result:='DIALERROR';

  end;
  {Close communication port}
  CloseHandle(hCommFile);
end
else
begin
 FillChar(szNR,SizeOf(szNR),#0);
 StrPCopy(szNR,FNumberToDial);
 ErrorCode:=TAPIRequestMakeCall(szNr,'TDialer','','');
 Case ErrorCode of
   TAPIERR_CONNECTED:Result:='TapiConnected';
   TAPIERR_NOREQUESTRECIPIENT:Result:='TapiNotAvailable';
   TAPIERR_REQUESTQUEUEFULL:Result:='TapiFull';
   TAPIERR_INVALDESTADDRESS:Result:='TapiInvalidAddress';
 End;
end;

end;



end.
