unit Mainfrm;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Buttons, ExtCtrls, Dockbar, StdCtrls, Spin;

type
  TForm1 = class(TForm)
    DocPanel1: TDocPanel;
    MainMenu: TDocPanel;
    SpeedButton1: TSpeedButton;
    SpeedButton2: TSpeedButton;
    SpeedButton3: TSpeedButton;
    SpeedButton4: TSpeedButton;
    SpeedButton5: TSpeedButton;
    SpeedButton6: TSpeedButton;
    SpeedButton7: TSpeedButton;
    SpeedButton8: TSpeedButton;
    Docked: TCheckBox;
    Button1: TButton;
    Label1: TLabel;
    ComboBox1: TComboBox;
    Label2: TLabel;
    ComboBox2: TComboBox;
    Label3: TLabel;
    ComboBox3: TComboBox;
    CheckBox1: TCheckBox;
    ComboBox4: TComboBox;
    Label4: TLabel;
    Label5: TLabel;
    left: TCheckBox;
    top: TCheckBox;
    bottom: TCheckBox;
    right: TCheckBox;
    SpinEdit1: TSpinEdit;
    Label6: TLabel;
    CheckBox2: TCheckBox;
    Panel1: TPanel;
    Memo1: TMemo;
    BitBtn1: TBitBtn;
    FontDialog1: TFontDialog;
    DockFrame: TLabel;
    ComboBox5: TComboBox;
    procedure FormCreate(Sender: TObject);
    procedure DockedClick(Sender: TObject);
    procedure DocPanel1DockChanged(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
    procedure ComboBox2Change(Sender: TObject);
    procedure ComboBox3Change(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure ComboBox4Change(Sender: TObject);
    procedure leftClick(Sender: TObject);
    procedure CheckBox2Click(Sender: TObject);
    procedure SpinEdit1Change(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure ComboBox5Change(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
begin
{$IFDEF Win32}
  combobox3.items.add('ctSmall');
{$ENDIF}
  panel1.align:=alclient;
  combobox1.itemindex:=0;
  combobox2.itemindex:=1;
  combobox3.itemindex:=1;
  combobox4.itemindex:=0;
  combobox5.itemindex:=0;
end;

procedure TForm1.DockedClick(Sender: TObject);
begin
  DocPanel1.docked:=docked.checked;
end;

procedure TForm1.DocPanel1DockChanged(Sender: TObject);
begin
  docked.checked:=DocPanel1.docked;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  Docpanel1.visible:=not Docpanel1.visible;

end;

procedure TForm1.ComboBox1Change(Sender: TObject);
begin
  case combobox1.itemindex of
    0 : Docpanel1.Floatborder:=fbsingle;
    1 : Docpanel1.FloatBorder:=fbsizeable;
  end;
end;

procedure TForm1.ComboBox2Change(Sender: TObject);
begin
  case combobox2.itemindex of
    0 : Docpanel1.DockingMethod:=dmboth;
    1 : Docpanel1.DockingMethod:=dmdblclick;
    2 : Docpanel1.DockingMethod:=dmdrag;
    3 : Docpanel1.DockingMethod:=dmnone;
  end;
end;

procedure TForm1.ComboBox3Change(Sender: TObject);
begin
  case combobox3.itemindex of
    0 : Docpanel1.captionType:=ctcustom;
    1 : Docpanel1.captiontype:=ctnot3x;
    2 : Docpanel1.captiontype:=ctwindows;
{$IFDEF Win32}
    3 : Docpanel1.captiontype:=ctsmall;
{$ENDIF}
  end;

end;

procedure TForm1.CheckBox1Click(Sender: TObject);
begin
  Docpanel1.autohide:=checkbox1.checked;
end;

procedure TForm1.ComboBox4Change(Sender: TObject);
begin
  case combobox4.itemindex of
    0 : Docpanel1.Arrangement:=amAuto;
    1 : Docpanel1.Arrangement:=AmNone;
    2 : Docpanel1.Arrangement:=amwidth;
  end;

end;

procedure TForm1.leftClick(Sender: TObject);
var tmp : Tdocksides;
begin
  case docpanel1.align of
    alleft : left.checked:=true;
    alright : right.checked:=true;
    altop : top.checked:=true;
    albottom : bottom.checked:=true;
  end;
  tmp:=[];
  if left.checked then
    tmp:=tmp+[dsleft];
  if right.checked then
    tmp:=tmp+[dsright];
  if top.checked then
    tmp:=tmp+[dstop];
  if bottom.checked then
    tmp:=tmp+[dsleft];
  docpanel1.dockingsides:=tmp;
end;

procedure TForm1.CheckBox2Click(Sender: TObject);
begin
  docpanel1.maxwidthrestore:=checkbox2.checked;
end;

procedure TForm1.SpinEdit1Change(Sender: TObject);
begin
  docpanel1.maxwidth:=spinedit1.value;
end;

procedure TForm1.BitBtn1Click(Sender: TObject);
begin
  fontdialog1.font:=docpanel1.titlefont;
  if fontdialog1.execute then
    docpanel1.titlefont:=fontdialog1.font;
end;

procedure TForm1.ComboBox5Change(Sender: TObject);
begin
  case combobox5.itemindex of
    0 : Docpanel1.dockframe:=dfInner;
    1 : Docpanel1.dockframe:=dfOuter;
  end;

end;

procedure TForm1.SpeedButton1Click(Sender: TObject);
var i : integer;
begin
  docpanel1.prepareforchange;
  try
  for i:=0 to docpanel1.controlcount do
    if odd(i) then
      docpanel1.controls[i].visible:=not docpanel1.controls[i].visible;
 finally
   docpanel1.donechange;
  end;
end;

end.
