{
>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
 DEMO of TDBGridDeLuxe and TGLnB
  (C)1996,1997 by Data Projects GmbH
 All rights reserved.
 Version 1.0
>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
}

unit demo;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, StdCtrls, Tabs,
  Buttons, ExtCtrls, Dialogs, SysUtils, Grids, DBGrids, DBCtrls, DB, DBTables,
  DPGLnB, DPDBGrid, DPTabset;

type
  TMultPageDlg = class(TForm)
    ButtonPanel: TPanel;
    Notebook: TNotebook;
    BitBtn1: TBitBtn;
    Label1: TLabel;
    GLnB5: TGLnB;
    Edit1: TEdit;
    GLnB6: TGLnB;
    ComboBox1: TComboBox;
    GLnB7: TGLnB;
    Edit2: TEdit;
    Button1: TButton;
    GLnB1: TGLnB;
    GLnB4: TGLnB;
    GLnB3: TGLnB;
    Image1: TImage;
    GLnB8: TGLnB;
    GLnB9: TGLnB;
    GroupBox1: TGroupBox;
    GLnB11: TGLnB;
    StringGrid1: TStringGrid;
    ListBox1: TListBox;
    GLnB12: TGLnB;
    GLnB13: TGLnB;
    GLnB14: TGLnB;
    GLnB2: TGLnB;
    ComboBox2: TComboBox;
    GLnB15: TGLnB;
    GLnB16: TGLnB;
    ListBox2: TListBox;
    StringGrid2: TStringGrid;
    GLnB17: TGLnB;
    Shadow: TGLnB;
    GLnB19: TGLnB;
    GLnB20: TGLnB;
    GLnB21: TGLnB;
    GLnB22: TGLnB;
    GLnB23: TGLnB;
    GLnB24: TGLnB;
    Grid: TGLnB;
    ButtonLabel: TGLnB;
    Criss: TGLnB;
    Cross: TGLnB;
    Image2: TImage;
    GLnB25: TGLnB;
    GroupLnB: TGLnB;
    TabSet: TTabSetDP;
    GLnB26: TGLnB;
    GLnB18: TGLnB;
    DBGridDeLuxe1: TDBGridDeLuxe;
    DBNavigator1: TDBNavigator;
    DataSource1: TDataSource;
    Table1: TTable;
    DBGridDeLuxe2: TDBGridDeLuxe;
    SpeedButton1: TSpeedButton;
    GLnB27: TGLnB;
    GLnB28: TGLnB;
    GLnB29: TGLnB;
    Image3: TImage;
    GLnB10: TGLnB;
    GLnB30: TGLnB;
    GLnB31: TGLnB;
    GLnB32: TGLnB;
    GLnB33: TGLnB;
    Timer1: TTimer;
    GLnB34: TGLnB;
    GLnB35: TGLnB;
    GLnB36: TGLnB;
    GLnB37: TGLnB;
    Table1Model: TStringField;
    Table1PartNo: TStringField;
    Table1Description: TStringField;
    Table1CatalogDescription: TMemoField;
    Table1ListPrice: TCurrencyField;
    Table1Delivery: TBooleanField;
    procedure FormCreate(Sender: TObject);
    procedure TabSetClick(Sender: TObject);
    procedure ButtonLabelClick(Sender: TObject);
    procedure CrossClick(Sender: TObject);
    procedure CrissClick(Sender: TObject);
    procedure GLnB25MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure GLnB10MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure GLnB9MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure GroupBox1Click(Sender: TObject);
    procedure GroupLnBClick(Sender: TObject);
    procedure GLnB33BeforePaint(Sender: TObject);
    procedure GLnB33AfterPaint(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure GLnB33MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure GLnB34MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure GLnB34MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure GLnB34MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  MultPageDlg: TMultPageDlg;

implementation

{$R *.DFM}

procedure TMultPageDlg.FormCreate(Sender: TObject);
begin
  Application.ShowHint:=True;
  Application.HintColor:=clLime;
  Application.HintPause:=200;
  {$IFDEF WIN32}
  Application.HintHidePause:=30000;
  {$ENDIF}
  TabSet.Tabs := Notebook.Pages;
end;

procedure TMultPageDlg.TabSetClick(Sender: TObject);
begin
  Notebook.PageIndex := TabSet.TabIndex;
  Notebook.ShowHint:=Notebook.PageIndex=0;
end;

procedure TMultPageDlg.ButtonLabelClick(Sender: TObject);
begin
{show sizing tool...}
if (bsDown in ButtonLabel.FrameTop.ButtonState) then
 begin
 Cross.Visible:=not(Cross.Visible);
 Criss.Visible:=not(Criss.Visible);
 end
end;

procedure TMultPageDlg.CrossClick(Sender: TObject);
begin
with ButtonLabel do
begin
if (bsDown in Cross.FrameBack.ButtonState) then
 {change one dimension}
 Width:=Width+4;
if (bsDown in Cross.FrameTop.ButtonState) then
 begin
 {change two dimensions}
 Left:=Left-4;
 Width:=Width+4;
 end;
if (bsDown in Cross.FrameText.ButtonState) then
 {change all dimensions}
 {here: reset to old size}
 SetBounds(291,207,102,43);
end;
end;

procedure TMultPageDlg.CrissClick(Sender: TObject);
begin
with ButtonLabel do
begin
if (bsDown in Criss.FrameBack.ButtonState) then
 begin
 Top:=Top-4;
 Height:=Height+4;
 end;
if (bsDown in Criss.FrameTop.ButtonState) then
 Height:=Height+4;
end;
end;

procedure TMultPageDlg.GLnB25MouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
{control shadow switch}
with GLnB25 do
begin
if PtInRect(FrameShapeRect(FrameTop),Point(x,y)) then
 begin
 if bsDown in FrameTop.ButtonState then
  begin
  FrameBack.ButtonState:=FrameBack.ButtonState-[bsDown];
  FrameText.Surface.Style:=ssTransparent;
  Shadow.FrameBack.Surface.Style:=ssTransparent;
  Shadow.Left:=Shadow.Left+20;
  end
 else
  begin
  FrameBack.ButtonState:=FrameBack.ButtonState+[bsDown];
  FrameText.Surface.Style:=ssShadow;
  Shadow.FrameBack.Surface.Style:=ssShadow;
  Shadow.Left:=Shadow.Left-20;
  end;
 end;
if PtInRect(FrameShapeRect(FrameBack),Point(x,y)) then
 begin
 if bsDown in FrameBack.ButtonState then
  begin
  FrameTop.ButtonState:=FrameTop.ButtonState-[bsDown];
  FrameText.Surface.Style:=ssShadow;
  Shadow.FrameBack.Surface.Style:=ssShadow;
  Shadow.Left:=Shadow.Left-20;
  end
 else
  begin
  FrameTop.ButtonState:=FrameTop.ButtonState+[bsDown];
  FrameText.Surface.Style:=ssTransparent;
  Shadow.FrameBack.Surface.Style:=ssTransparent;
  Shadow.Left:=Shadow.Left+20;
  end
 end;
end;
end;

procedure TMultPageDlg.GLnB10MouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
{control TTabset button and text}
if not(bsDown in GLnB10.FrameText.ButtonState)
 then
  begin
  TabSet.Align:=alBottom;
  TabSet.BackgroundColor:=clWindow;
  GLnB10.Caption:=' 1997 by Data Projects';
  GLnB12.Visible:=True;
  GLnB10.FrameText.Surface.Color:=clBlue;
  GLnB10.Font.Color:=clAqua;
  end
 else
  begin
  TabSet.Align:=alTop;
  TabSet.BackgroundColor:=clBtnFace;
  GLnB10.Caption:='Data Projects'' GLnB';
  GLnB12.Visible:=False;
  GLnB10.FrameText.Surface.Color:=clMaroon;
  GLnB10.Font.Color:=clRed;
  end;
end;

procedure TMultPageDlg.GLnB9MouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
{control pyramid style button}
with GLnB17.FrameText do
begin
if not(bsDown in GLnB9.FrameText.ButtonState)
 then
  begin
  GLnB9.Caption:='?';
  ButtonState:=ButtonState-[bsDown];
  end
 else
  begin
  GLnB9.Caption:=#191;
  ButtonState:=ButtonState+[bsDown];
  end;
end;
end;

procedure TMultPageDlg.GroupBox1Click(Sender: TObject);
begin
{color GroupBox...}
with GroupBox1 do
 if (Color=clTeal) then Color:=clBtnFace
 else Color:=clTeal;
end;

procedure TMultPageDlg.GroupLnBClick(Sender: TObject);
begin
{color 'Group'LnB...}
with GroupLnB.FrameBack.Surface do
 {here: by switching ...Style to solid (=use ...Color)}
 if (Style=ssTransparent) then Style:=ssSolidorPattern
 else Style:=ssTransparent;
end;

procedure TMultPageDlg.GLnB33BeforePaint(Sender: TObject);
begin
GLnB33.Caption:=TimeToStr(Time);
{set caption and let GLnB paint it...}
end;

procedure TMultPageDlg.GLnB33AfterPaint(Sender: TObject);
Var dRect: TRect;
dCenter: TPoint;
Year, Month, Day, Hour, Min, Sec, MSec: Word;
s: Integer;
  StartA, EndA: Integer;
  midX, midY, stX, stY, endX, endY: Integer;
  sX, sY, eX, eY: Real;
begin
{create additional output each time the regular painting is done...}
with GLnB33,GLnB33.Canvas do
 begin
 {here: draw a pie showing seconds}
 dRect:=FrameShapeRect(FrameTop);
 inflaterect(dRect,-(FrameTop.Width+1),-(FrameTop.Width+1));
 Pen.Color:=clRed;
 Brush.Color:=clRed;
 DecodeTime(Now, Hour, Min, Sec, MSec);
 s:=Sec;
 StartA := 90;
 EndA := 90-(s*6);
 midX := (dRect.Right+dRect.Left)div 2;
 midY := (dRect.Top+dRect.Bottom)div 2;
 sX := Cos((StartA / 180.0) * pi);
 sY := Sin((StartA / 180.0) * pi);
 eX := Cos((EndA / 180.0) * pi);
 eY := Sin((EndA / 180.0) * pi);
 stX := Round(sX * 100);
 stY := Round(sY * 100);
 endX := Round(eX * 100);
 endY := Round(eY * 100);
 Pie(dRect.Left,dRect.Top,dRect.Right,dRect.Bottom,
  midX + stX, midY - stY, midX + endX, midY - endY);
 end;
end;


procedure TMultPageDlg.Timer1Timer(Sender: TObject);
begin
{timer only has to force a repaint...}
GLnB33.RePaint;
end;

procedure TMultPageDlg.GLnB33MouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
{switch timer}
if PtInRect(GLnB33.FrameShapeRect(GLnB33.FrameTop),Point(x,y)) then
 Timer1.Enabled:=(bsDown) in GLnB33.FrameTop.ButtonState;
end;

procedure TMultPageDlg.GLnB34MouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
Var I:Integer;
R:TRect;
begin
with GLnB34 do
begin
{effects for the upper corner buttons...}
R:=FrameShapeRect(FrameTop);
if PtInRect(FrameShapeRect(FrameTop),Point(x,y)) then
 for i:=15 to 35 do
  begin
  offsetrect(r,-i,i);
  DrawFrame(r,FrameTop.Color2D,FrameTop.Color3D,4,FrameTop.Style,False,False,False);
  DrawSurface(FrameTop,r);
  end;
R:=FrameShapeRect(FrameBack);
if PtInRect(FrameShapeRect(FrameBack),Point(x,y)) then
 for i:=8 to 30 do
  begin
  offsetrect(r,i,i);
  DrawFrame(r,FrameBack.Color2D,FrameBack.Color3D,4,FrameBack.Style,False,False,False);
  DrawSurface(FrameBack,r);
  end;
end;
end;

procedure TMultPageDlg.GLnB34MouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
with GLnB34 do
begin
if PtInRect(FrameShapeRect(FrameBack),Point(x,y)) or
 PtInRect(FrameShapeRect(FrameTop),Point(x,y))
 {...one of the upper corner buttons}
 then Repaint;
end;
end;

procedure TMultPageDlg.GLnB34MouseMove(Sender: TObject; Shift: TShiftState;
  X, Y: Integer);
begin
{animate Info page...}
if (GLnB37.Caption='<   ?   >') then GLnB37.Caption:='< '+#191+' >' else GLnB37.Caption:='<   ?   >';
end;

end.
