unit DPTabSet;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Tabs;

type
  TTabSetDP = class(TTabSet)
  protected
    procedure GetChildren(Proc: TGetChildProc); override;
  end;

procedure Register;

implementation

procedure TTabSetDP.GetChildren(Proc: TGetChildProc);
{
The original TTabSet in Delphi32 doesn't report its children to a caller.
Therefore, an integrated component (like a GLnB using the ParentControl 
property) will not be saved to the form's data.
To change this behavior, we added the code from TWinControl...
}
var
  I: Integer;
  Control: TControl;
  Form: TForm;
begin
  Form:=GetParentForm(Self);
  for I:=0 to ControlCount-1 do
  begin
    Control:=Controls[I];
    if Control.Owner=Form then Proc(Control);
  end;
end;

procedure Register;
begin
  RegisterComponents('DP', [TTabSetDP]);
end;

end.
