{$H+}
unit FTPMain;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  FTP, StdCtrls, ExtCtrls, FileCtrl, Buttons, GetStrng, Options, Viewer,
  WinSock, SockHelp, Lines;


// Feel free to do with this as you wish.  It's yours!
// I would appreciate any suggestions or comments you might have.
// rmstrong@scis.acast.nova.edu

type
  TfrmMain = class(TForm)
    Panel2: TPanel;
    Panel1: TPanel;
    FTPFileListBox: TListBox;
    btnOpen: TButton;
    btnClose: TButton;
    FTPDirListBox: TListBox;
    FTPDirLabel: TLabel;
    Label2: TLabel;
    Panel3: TPanel;
    Panel4: TPanel;
    DirectoryListBox1: TDirectoryListBox;
    DriveComboBox1: TDriveComboBox;
    FileListBox1: TFileListBox;
    sbtnToFTP: TSpeedButton;
    sbtnToLocal: TSpeedButton;
    Label3: TLabel;
    StatusLine: TLabel;
    btnFTPDelete: TBitBtn;
    btnFTPRename: TBitBtn;
    btnFTPRefresh: TBitBtn;
    btnFTPChDir: TBitBtn;
    btnFTPMkDir: TBitBtn;
    btnFTPRmDir: TBitBtn;
    LocalDirLabel: TLabel;
    btnExit: TButton;
    rgTransfer: TRadioGroup;
    btnConnections: TButton;
    Label1: TLabel;
    lRemoteHost: TLabel;
    bbtnFTPView: TBitBtn;
    btnCommand: TButton;
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure btnOpenClick(Sender: TObject);
    procedure btnCloseClick(Sender: TObject);
    procedure OpenConnection;
    procedure CloseConnection;
    procedure sbtnToFTPClick(Sender: TObject);
    procedure sbtnToLocalClick(Sender: TObject);
    procedure FileListBox1MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure btnFTPDeleteClick(Sender: TObject);
    procedure btnFTPRenameClick(Sender: TObject);
    procedure btnFTPRefreshClick(Sender: TObject);
    procedure btnFTPChDirClick(Sender: TObject);
    procedure btnFTPMkDirClick(Sender: TObject);
    procedure btnFTPRmDirClick(Sender: TObject);
    procedure btnExitClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure btnConnectionsClick(Sender: TObject);
    procedure rgTransferClick(Sender: TObject);
    procedure bbtnFTPViewClick(Sender: TObject);
    procedure btnCommandClick(Sender: TObject);
    procedure StatusLineDblClick(Sender: TObject);
    procedure FTPDirListBoxDblClick(Sender: TObject);
  private
    { Private declarations }
    InSession: Boolean;
    FTP: TFTP;
    LastCommand,
    LocalDir,
    FTPCurDir: String;
    procedure GetDirList;
    procedure LookupHost;
    function GetNewFileName(FN: String): String;
    procedure SetStatus(strStatus: String);
    procedure SetButtons;
    procedure DeleteFTPFile;
    procedure RenameFTPFile;
    function GetString(strPrompt, strCaption, strDefault: String): String;
    function SetConnection: Boolean;
    procedure ViewFTPFile;
    procedure ChangeDirectory;
  public
    { Public declarations }
    procedure WMResults(var Msg: TMessage); message wm_Results;
  end;

var
  frmMain: TfrmMain;
  ProgramPath,
  ProgramName: String;

implementation

{$R *.DFM}

procedure TfrmMain.FormCreate(Sender: TObject);
begin
  FTP := TFTP.Create(Self);
  With FTP Do
  Begin
    HostName := '';
    UserName := '';
    Password := '';
    Transfer := ftpBinary;
    Caller := Handle;
  End;
  InSession := False;
  FTPCurDir := '';
  SetButtons;
  ProgramPath := ExtractFilePath(ParamStr(0));
  If ProgramPath[Length(ProgramPath)] <> '\' THEN
     ProgramPath := ProgramPath + '\';
  ProgramName := ExtractFileName(ParamStr(0));
end;

procedure TfrmMain.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  FTP.Free;
  FTPCurDir := '';
  FTPDirLabel.Caption := FTPCurDir;
  FTPDirListBox.Clear;
  FTPFileListBox.Clear;
end;

procedure TfrmMain.btnOpenClick(Sender: TObject);
var
  bResult: Boolean;
begin
  bResult := (FTP.HostName = '') OR
             (FTP.UserName = '');
  If bResult THEN
     bResult := SetConnection;
  If bResult THEN
     OpenConnection;
end;

procedure TfrmMain.OpenConnection;
begin
  Screen.Cursor := crHourglass;
  InSession := FTP.Connect;

  If InSession THEN
  Begin
    GetDirList;
    SetButtons;
  End
  ELSE
    SetStatus('Error:  ' + IntToStr(FTP.LastError));
  Screen.Cursor := crDefault;
end;

// DNS Lookup
procedure TfrmMain.LookupHost;
var
  dwRoundTrip: LongInt;
  pHostEntry: pHostEnt;
  InAddr: LongInt;
  pFinger: PChar;
begin
  Screen.Cursor := crHourglass;
  dwRoundTrip := 0;

  pHostEntry := LookupHostBlocking(FTP.HostName);
  If pHostEntry <> Nil THEN
  Begin
    If IsDottedDecimal(FTP.HostName) THEN
       lremoteHost.Caption := StrPas(pHostEntry^.h_name)
    ELSE
    Begin
      InAddr := PLongInt(pHostEntry^.h_addr_list^)^;
      lremoteHost.Caption := StrPas(inet_ntoa(TInAddr(InAddr)));
    End;
  End;
  Screen.Cursor := crDefault;
end;

procedure TfrmMain.btnCloseClick(Sender: TObject);
begin
  CloseConnection;
end;

procedure TfrmMain.CloseConnection;
begin
  Screen.Cursor := crHourglass;
  InSession := Not FTP.Disconnect;
  If InSession THEN
     InSession := Not FTP.Disconnect;
  SetButtons;
  FTPCurDir := '';
  FTPDirListBox.Clear;
  FTPFileListBox.Clear;
  Screen.Cursor := crDefault;
end;

procedure TfrmMain.sbtnToFTPClick(Sender: TObject);
var
  LocalFile,
  NewRemoteFile: String;
  I: Integer;
  B: Boolean;
begin
  { transfer to FTP }
  If FileListBox1.FileName = '' THEN
  Begin
    SetStatus('No file selected for transfer');
    Exit;
  End;

  Screen.Cursor := crHourglass;
  SetStatus('Transferring file');
  B := True;
  I := 0;
  While (I < FileListBox1.Items.Count - 1) AND B DO
  Begin
    If FileListBox1.Selected[I] THEN
    Begin
      NewRemoteFile := FileListBox1.Items[I];
      LocalFile := DirectoryListBox1.Directory + '\' +
                   NewRemoteFile;
      B := FTP.Put(NewRemoteFile, LocalFile);
      If B THEN
         SetStatus(Localfile + ' transferred')
      ELSE
         SetStatus(Localfile + ':  transfer failed');
    End;
    Inc(I);
    Application.ProcessMessages;
  End;
  GetDirList;
  Screen.Cursor := crDefault;
end;

procedure TfrmMain.sbtnToLocalClick(Sender: TObject);
var
  LocalFile,
  RemoteFile: String;
begin
  { Transfer to Local }
  If FTPFileListBox.ItemIndex < 0 THEN
  Begin
    SetStatus('No file selected for transfer');
    Exit;
  End;

  RemoteFile := FTPFileListBox.Items[FTPFileListBox.ItemIndex];
  LocalFile := DirectoryListBox1.Directory;

  SetStatus('Transferring ' + RemoteFile);
  Screen.Cursor := crHourglass;
  If LocalFile[Length(LocalFile)] <> '\' THEN
     LocalFile := LocalFile + '\' + RemoteFile
  ELSE
     LocalFile := LocalFile + RemoteFile;
  If FileExists(LocalFile) THEN
     LocalFile := GetNewFileName(LocalFile);
  If LocalFile <> '' THEN
  Begin
    SetStatus('Transferring ' + RemoteFile + ' to ' + LocalFile);
    Screen.Cursor := crHourglass;
     If FTP.Get(RemoteFile, LocalFile) THEN
     Begin
       SetStatus(RemoteFile + ' transferred');
       FileListBox1.Refresh;
     End
     ELSE
       SetStatus(RemoteFile + ':  transfer failed')
  End;
  Screen.Cursor := crDefault;
end;

function TfrmMain.GetNewFileName(FN: String): String;
begin
  Result := GetString('Enter the new file name', 'File Name', FN);
end;

procedure TfrmMain.SetStatus(strStatus: String);
begin
  StatusLine.Caption := strStatus;
  Application.ProcessMessages;
end;

procedure TfrmMain.FileListBox1MouseUp(Sender: TObject; Button: TMouseButton;
                                     Shift: TShiftState; X, Y: Integer);
var
  NewMask: String;
begin
  If Button = mbRight THEN
  Begin
    NewMask := GetString('Enter the file mask', 'File Mask', FileListBox1.Mask);
    If NewMask <> '' THEN
    Begin
      FileListBox1.Mask := NewMask;
      FileListBox1.Refresh;
    End;
  End;
end;

procedure TfrmMain.SetButtons;
begin
  btnOpen.Enabled := Not InSession;
  btnClose.Enabled := InSession;
  sbtnToFTP.Enabled := InSession;
  sbtnToLocal.Enabled := InSession;
  btnFTPDelete.Enabled := InSession;
  btnFTPRename.Enabled := InSession;
  btnFTPRefresh.Enabled := InSession;
  btnFTPChDir.Enabled := InSession;
  btnFTPMkDir.Enabled := InSession;
  btnFTPRmDir.Enabled := InSession;
  bbtnFTPView.Enabled := InSession;
end;

procedure TfrmMain.btnFTPDeleteClick(Sender: TObject);
begin
  Screen.Cursor := crHourglass;
  DeleteFTPFile;
  Screen.Cursor := crDefault;
end;

procedure TfrmMain.DeleteFTPFile;
var
  RemoteFile: String;
begin
  { Transfer to Local }
  If FTPFileListBox.ItemIndex < 0 THEN
  Begin
    SetStatus('No file selected for deletion');
    Exit;
  End;
  RemoteFile := FTPFileListBox.Items[FTPFileListBox.ItemIndex];
  If MessageDlg('Are you sure you want to delete ' + RemoteFile + '?',
                mtWarning, [mbYes, mbNo], 0) = mrNo THEN
     Exit;

  SetStatus('Deleting ' + RemoteFile);
  Screen.Cursor := crHourglass;
  If FTP.DeleteFile(RemoteFile) THEN
  Begin
    GetDirList;
    SetStatus(RemoteFile + ' deleted');
  End
  ELSE
     SetStatus(RemoteFile + ':  delete failed');
  Screen.Cursor := crDefault;
end;


procedure TfrmMain.btnFTPRenameClick(Sender: TObject);
begin
  Screen.Cursor := crHourglass;
  RenameFTPFile;
  Screen.Cursor := crDefault;
end;

procedure TfrmMain.RenameFTPFile;
var
  RemoteFile,
  NewName: String;
begin
  { Transfer to Local }
  If FTPFileListBox.ItemIndex < 0 THEN
  Begin
    SetStatus('No file selected for renaming');
    Exit;
  End;
  RemoteFile := FTPFileListBox.Items[FTPFileListBox.ItemIndex];
  NewName := RemoteFile;
  { Get New Name }
  NewName := GetString('Enter new file name', 'File Name', RemoteFile);
  If (NewName = '') OR (NewName = RemoteFile) THEN
     Exit; 

  SetStatus('Renaming ' + RemoteFile);
  Screen.Cursor := crHourglass;
  If FTP.RenameFile(RemoteFile, NewName) THEN
  Begin
    GetDirList;
    SetStatus(RemoteFile + ' renamed to ' + NewName);
  End
  ELSE
     SetStatus(RemoteFile + ':  rename failed');
  Screen.Cursor := crDefault;
end;

procedure TfrmMain.btnFTPRefreshClick(Sender: TObject);
begin
  Screen.Cursor := crHourglass;
  GetDirList;
  Screen.Cursor := crDefault;
end;

procedure TfrmMain.btnFTPChDirClick(Sender: TObject);
begin
  ChangeDirectory;
end;

procedure TfrmMain.ChangeDirectory;
var
  RemoteDir: String;
  RD: Array[0..256] Of Char;
  P: Integer;
begin
  If FTPDirListBox.ItemIndex < 0 THEN
     RemoteDir := GetString('Enter the directory name', 'Change Directory', '')
  ELSE
  Begin
    Screen.Cursor := crHourglass;
    RemoteDir :=  FTPDirListBox.Items[FTPDirListBox.ItemIndex];
    If RemoteDir = '/' THEN
       RemoteDir := '';
    If RemoteDir <> '..' THEN
    Begin
      StrPCopy(RD, PChar(FTPCurDir));
      StrCat(RD, '/');
      StrCat(RD, PChar(RemoteDir));
      RemoteDir := StrPas(RD);
      // Check for '//'
      P := Pos('//', RemoteDir);
      While P > 0 DO
      Begin
        Delete(RemoteDir, P, 1);
        P := Pos('//', RemoteDir);
      End;
      RemoteDir := GetString('Enter the directory name', 'Directory', RemoteDir);
    End
    ELSE
    Begin
      RemoteDir := FTPCurDir;
      P := Length(FTPCurDir);
      // Back up to the slash - 1
      While (P >= 0) AND (FTPCurDir[P] <> '/') DO
        Dec(P);
      If P > 0 THEN
         Dec(P);
      SetLength(RemoteDir, P);
      If RemoteDir[Length(RemoteDir)] = ':' THEN
         RemoteDir := RemoteDir + '/';
      // Check for '//'
      P := Pos('//', RemoteDir);
      While P > 0 DO
      Begin
         Delete(RemoteDir, P, 1);
         P := Pos('//', RemoteDir);
      End;
      RemoteDir := GetString('Enter the directory name', 'Directory', RemoteDir);
    End;
  End;
  If (RemoteDir <> FTPCurDir) AND (RemoteDir <> '') THEN
  Begin
    // Check for '//'
    P := Pos('//', RemoteDir);
    While P > 0 DO
    Begin
       Delete(RemoteDir, P, 1);
       P := Pos('//', RemoteDir);
    End;
    If FTP.ChDir(RemoteDir) THEN
       GetDirList
    ELSE
       SetStatus(RemoteDir + ':  change directory failed');
  End;
  Screen.Cursor := crDefault;
end;

procedure TfrmMain.btnFTPMkDirClick(Sender: TObject);
var
  NewName: String;
begin
  { Make FTP Directory }
  NewName := GetString('Enter new directory name', 'Directory', '');
  If NewName <> '' THEN
  Begin
    Screen.Cursor := crHourglass;
    If FTP.MkDir(NewName) THEN
    Begin
      GetDirList;
      SetStatus('New directory created:  ' + NewName);
    End
    ELSE
       SetStatus(NewName + ':  create directory failed');
    Screen.Cursor := crDefault;
  End;
end;

procedure TfrmMain.btnFTPRmDirClick(Sender: TObject);
var
  RemoteDir: String;
begin
  If FTPDirListBox.ItemIndex < 0 THEN
  Begin
    SetStatus('No directory selected for removing');
    Exit;
  End;

  RemoteDir := FTPDirListBox.Items[FTPDirListBox.ItemIndex];
  If RemoteDir = '..' THEN
  Begin
    SetStatus('No directory selected for removing');
    Exit;
  End;

  { Check to see if sure }
  If MessageDlg('Are you sure you want to delete that directory?',
                mtWarning, [mbYes, mbNo], 0) = mrNo THEN
     Exit;

  If RemoteDir = '..' THEN
  Begin
    SetStatus('Cannot remove ..');
    Exit;
  End;

  Screen.Cursor := crHourglass;
  If FTP.RmDir(RemoteDir) THEN
  Begin
    GetDirList;
    SetStatus(RemoteDir + ' directory removed');
  End
  ELSE
     SetStatus(RemoteDir + ':  remove directory failed');
  Screen.Cursor := crDefault;
end;

function TfrmMain.GetString(strPrompt, strCaption, strDefault: String): String;
begin
  Result := '';
  Application.CreateForm(TfrmGetString, frmGetString);
  frmGetString.Caption := strCaption;
  With frmGetString DO
  Begin
    Edit1.Text := strDefault;
    Label1.Caption := strPrompt;
    If ShowModal = mrOK THEN
       Result := Edit1.Text;
    Hide;
    Free;
  End;
end;

procedure TfrmMain.btnExitClick(Sender: TObject);
begin
  Close;
end;

procedure TfrmMain.FormActivate(Sender: TObject);
begin
  frmLines.Memo1.Lines.Clear;
  If SetConnection THEN
     OpenConnection;
end;

function TfrmMain.SetConnection: Boolean;
begin
  Application.CreateForm(TfrmOptions, frmOptions);
  With frmOptions DO
  Begin
    With tblConnections DO
    Begin
      Active := False;
      DatabaseName := ProgramPath;
      Active := True;
    End;
    Result := (ShowModal = mrOK);
    If Result THEN
    Begin
      FTPCurDir := tblConnectionsRemoteDirectory.AsString;
      LocalDir := tblConnectionsLocalDirectory.AsString;
      DirectoryListBox1.Directory := LocalDir;
      FTP.HostName := tblConnectionsHostName.AsString;
      If tblConnectionsAnonymousLogin.AsBoolean THEN
      Begin
        FTP.Username := 'anonymous';
        FTP.Password := tblConnectionsEMailAddress.AsString;
      End
      ELSE
      Begin
        FTP.Username := tblConnectionsUserName.AsString;
        FTP.Password := tblConnectionsPassword.AsString;
      End;
      lRemoteHost.Caption := FTP.HostName;
    End;
    If FTP.HostName <> '' THEN
      SetStatus(FTP.HostName + ' selected')
    ELSE
      SetStatus('Please select a Connection!');
    Hide;
    Free;
  End;
end;

procedure TfrmMain.btnConnectionsClick(Sender: TObject);
begin
  If SetConnection THEN
     CloseConnection;
end;

procedure TfrmMain.ViewFTPFile;
var
  RemoteFile,
  LocalFile: String;
  strRead: String;
  F: TextFile;
  I: Integer;
begin
  { First, let's get the file -- store it as a temp file }
  { Transfer to Local }
  If FTPFileListBox.ItemIndex < 0 THEN
  Begin
    SetStatus('No file selected for transfer');
    Exit;
  End;

  RemoteFile := FTPFileListBox.Items[FTPFileListBox.ItemIndex];
  LocalFile := ProgramPath + 'VIEWER.TMP' ;
  If FileExists(LocalFile) THEN
     DeleteFile(LocalFile);
  Screen.Cursor := crHourglass;
  If FTP.Get(RemoteFile, LocalFile) THEN
  Begin
    { Open the file }
    AssignFile(F, LocalFile);
    Try
      Reset(F);
    Except
      DeleteFile(LocalFile);
      SetStatus('Error displaying file ' + RemoteFile);
      Screen.Cursor := crDefault;
      Exit;
    End;
    Application.CreateForm(TfrmViewer, frmViewer);
    With frmViewer DO
    Begin
      Memo1.Lines.Clear;
      Memo1.ReadOnly := True;
      While NOT EOF(F) DO
      Begin
        ReadLn(F, strRead);
        { Make sure it is text }
        For I := 1 TO Length(strRead) DO
            If Not (strRead[I] IN [#8, #10, #13, #32..#127]) THEN
            Begin
              SetStatus(RemoteFile + ' is not a text file:  ' + strRead[I]);
              Hide;
              Free;
              CloseFile(F);
              DeleteFile(LocalFile);
              Screen.Cursor := crDefault;
              Exit;
            End;
        Memo1.Lines.Add(strRead);
        Application.ProcessMessages;
      End;
      CloseFile(F);
      Screen.Cursor := crDefault;
      ShowModal;
      Hide;
      Free;
    End;
    { Now clean it up }
    DeleteFile(LocalFile);
  End;
  Screen.Cursor := crDefault;
end;

procedure TfrmMain.rgTransferClick(Sender: TObject);
begin
  Screen.Cursor := crHourglass;
  Case rgTransfer.ItemIndex OF
     0: FTP.Transfer := ftpASCII;
     1: FTP.Transfer := ftpBinary;
  ELSE
     FTP.Transfer := ftpBinary;
  End;
  Screen.Cursor := crDefault;
end;

procedure TfrmMain.bbtnFTPViewClick(Sender: TObject);
begin
  ViewFTPFile;
end;

procedure TfrmMain.GetDirList;
var
  DirList: TFTPDirList;
  I: Integer;
begin
  Screen.Cursor := crHourglass;
  FTPDirListBox.Items.Clear;
  FTPFileListBox.Items.Clear;
  DirList := FTP.DirectoryList;
  If DirList <> Nil THEN
  Begin
    If FTP.PWD(FTPCurDir) THEN
       FTPDirLabel.Caption := FTPCurDir;
    If FTPCurDir[Length(FTPCurDir)] <> '/' THEN
       FTPDirListBox.Items.Add('..');
    IF DirList.Count > 0 THEN
    Begin
       For I := 0 To DirList.Count - 1 DO
           If (DirList.FileName(I) <> '') THEN
           Begin
             If DirList.IsDirectory(I) THEN
             Begin
               If (DirList.FileName(I)[1] <> '.') THEN
                  FTPDirListBox.Items.Add(DirList.FileName(I))
             End
             ELSE
                FTPFileListBox.Items.Add(DirList.FileName(I));
             Application.ProcessMessages;
           End;
    End;
  End;
  DirList.Free;
  Screen.Cursor := crDefault;
end;

procedure TfrmMain.WMResults(var Msg: TMessage);
var
  strlList: TStringList;
  I: Integer;
begin
  Screen.Cursor := crHourglass;
  frmLines.Memo1.Lines.Add('');
  strlList := Pointer(Msg.lParam);
  If Assigned(strlList) AND (strlList Is TStringList) THEN
     If strlList.Count > 0 THEN
        For I := 0 To strlList.Count - 1 DO
        Begin
          SetStatus(strlList[I]);
          frmLines.Memo1.Lines.Add(strlList[I]);
          Application.ProcessMessages;
        End;
  Screen.Cursor := crDefault;
end;

procedure TfrmMain.btnCommandClick(Sender: TObject);
var
  strCommand: String;
begin
  strCommand := GetString('Enter the command', 'FTP Command', LastCommand);
  If strCommand <> '' THEN
  Begin
    Screen.Cursor := crHourglass;
    FTP.SendCommandResult(strCommand, 3);
    LastCommand := strCommand;
  End;
  Screen.Cursor := crDefault;
end;

procedure TfrmMain.StatusLineDblClick(Sender: TObject);
begin
  frmLines.ShowModal;
end;

procedure TfrmMain.FTPDirListBoxDblClick(Sender: TObject);
begin
  ChangeDirectory;
end;

end.
