unit Options;

interface

uses
  SysUtils, Windows, Messages, Classes, Graphics, Controls,
  StdCtrls, Forms, DBCtrls, DB, DBTables, Mask, ExtCtrls, Buttons,
  IniFiles;

type
  TfrmOptions = class(TForm)
    tblConnectionsConnectionName: TStringField;
    tblConnectionsHostName: TStringField;
    tblConnectionsUserName: TStringField;
    tblConnectionsPassword: TStringField;
    tblConnectionsEMailAddress: TStringField;
    tblConnectionsRemoteDirectory: TStringField;
    tblConnectionsLocalDirectory: TStringField;
    tblConnectionsSavePassword: TBooleanField;
    tblConnectionsAnonymousLogin: TBooleanField;
    ScrollBox: TScrollBox;
    Label1: TLabel;
    EditConnectionName: TDBEdit;
    Label2: TLabel;
    EditHostName: TDBEdit;
    Label3: TLabel;
    EditUserName: TDBEdit;
    Label4: TLabel;
    EditPassword: TDBEdit;
    Label5: TLabel;
    EditEMailAddress: TDBEdit;
    Label6: TLabel;
    EditRemoteDirectory: TDBEdit;
    Label7: TLabel;
    EditLocalDirectory: TDBEdit;
    CheckBoxSavePassword: TDBCheckBox;
    CheckBoxAnonymousLogin: TDBCheckBox;
    DBNavigator: TDBNavigator;
    Panel1: TPanel;
    srcConnections: TDataSource;
    Panel2: TPanel;
    tblConnections: TTable;
    Label8: TLabel;
    bbtnOK: TBitBtn;
    bbtnCancel: TBitBtn;
    procedure FormCreate(Sender: TObject);
    procedure tblConnectionsBeforePost(DataSet: TDataSet);
    procedure bbtnOKClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormActivate(Sender: TObject);
  private
    { private declarations }
    FTPIni: TIniFile;
  public
    { public declarations }
  end;

var
  frmOptions: TfrmOptions;

implementation

{$R *.DFM}

procedure TfrmOptions.FormCreate(Sender: TObject);
begin
  tblConnections.Open;
  FTPIni := TIniFile.Create('FTPINI.INI');
end;

procedure TfrmOptions.tblConnectionsBeforePost(DataSet: TDataSet);
begin
  If Not tblConnectionsSavePassword.AsBoolean THEN
     tblConnectionsPassword.AsString := '';
end;

procedure TfrmOptions.bbtnOKClick(Sender: TObject);
begin
  FTPIni.WriteString('Last Connection', 'Name',
                     tblConnectionsConnectionName.AsString);
  ModalResult := mrOK;
end;

procedure TfrmOptions.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  FTPIni.Free;
end;

procedure TfrmOptions.FormActivate(Sender: TObject);
var
  LastCon: ShortString;
begin
  { Find Last Connection }
  LastCon := FTPIni.ReadString('Last Connection', 'Name', '');
  If LastCon <> '' THEN
     tblConnections.FindKey([LastCon]);
end;

end.
