unit Demo_u;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls, VMMap;

type
  TForm1 = class(TForm)
    OD: TOpenDialog;
    SD: TSaveDialog;
    Panel1: TPanel;
    Label2: TLabel;
    VMMap1: TVMMap;
    Panel2: TPanel;
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Panel3: TPanel;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    RadioGroup1: TRadioGroup;
    RadioGroup2: TRadioGroup;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure VMMap1Click(Sender: TObject; Rgn: Integer; RgnID: String);
    procedure Button3Click(Sender: TObject);
    procedure VMMap1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y, Rgn: Integer; RgnID: String);
    procedure VMMap1MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y, Rgn: Integer; RgnID: String);
    procedure VMMap1MouseMove(Sender: TObject; Shift: TShiftState; X, Y,
      Rgn: Integer; RgnID: String);
    procedure CheckBox1Click(Sender: TObject);
    procedure CheckBox2Click(Sender: TObject);
    procedure RadioGroup1Click(Sender: TObject);
    procedure RadioGroup2Click(Sender: TObject);
  private
    { Private declarations }
  public
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

const
  Moving : Boolean = False;
  Movable: Boolean = False;
var
  _x, _y : Integer;

procedure TForm1.Button1Click(Sender: TObject);
begin
  if SD.Execute then
    VMMap1.SaveToFile(SD.FileName);
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  if OD.Execute then
    VMMap1.LoadFromFile(OD.FileName);
end;

procedure TForm1.VMMap1Click(Sender: TObject; Rgn: Integer; RgnID: String);
begin
  if RgnID='' then
    Label2.Caption:=''
  else
    Label2.Caption:=RgnID+' clicked';
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
  VMMap1.DeleteRgn(VMMap1.GetSelectedRgn);
end;

procedure TForm1.VMMap1MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y, Rgn: Integer; RgnID: String);
begin
  Moving:=True;
  _x:=x; _y:=y;
end;

procedure TForm1.VMMap1MouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y, Rgn: Integer; RgnID: String);
begin
  Moving:=False;
end;

procedure TForm1.VMMap1MouseMove(Sender: TObject; Shift: TShiftState; X, Y,
  Rgn: Integer; RgnID: String);
begin
  if Moving and Movable then begin
    OffsetRgn(VMMap1.GetSelectedRgn, x-_x, y-_y);
    _x:=x; _y:=y;
    VMMap1.Refresh;
  end;
end;


procedure TForm1.CheckBox1Click(Sender: TObject);
begin
  Movable:=CheckBox1.Checked;
end;

procedure TForm1.CheckBox2Click(Sender: TObject);
begin
  VMMap1.Stretch:=CheckBox2.Checked;
end;

procedure TForm1.RadioGroup1Click(Sender: TObject);
begin
  VMMap1.ShowRgns:=TShowMode(RadioGroup1.ItemIndex);
end;

procedure TForm1.RadioGroup2Click(Sender: TObject);
begin
  VMMap1.SelectedFill:=TFillMode(RadioGroup2.ItemIndex);
end;

end.
