unit HTMLMain;
               {Baby WebBrowser example for HTML object in MS Internet Control Pack;
                features simple resizeable HTML browser with Load and Save File abilities,
                document title extraction, URL history, optional image loading and
                download progress;
                public domain code; Alin Flaider 1996}
interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, OleCtrls, MSICPB, Buttons, StdCtrls, ComCtrls;

type
  THTMLForm = class(TForm)
    Panel1: TPanel;
    Panel2: TPanel;
    HTMLPanel: TPanel;
    HTML: THTML;
    URLCombo: TComboBox;
    Panel3: TPanel;
    UpdateBar: TProgressBar;
    MsgPanel: TPanel;
    StartBtn: TSpeedButton;
    MoonImage: TImage;
    SunImage: TImage;
    ImagesCB: TCheckBox;
    ImagesBtn: TSpeedButton;
    SaveBtn: TSpeedButton;
    SaveDlg: TSaveDialog;
    OpenDlg: TOpenDialog;
    OpenBtn: TSpeedButton;
    procedure HTMLPanelResize(Sender: TObject);
    procedure URLComboKeyPress(Sender: TObject; var Key: Char);
    procedure StartBtnClick(Sender: TObject);
    procedure HTMLDoRequestDoc(Sender: TObject; const URL: string;
      const Element, DocInput: Variant; var EnableDefault: Wordbool);
    procedure HTMLError(Sender: TObject; Number: Smallint;
      var Description: string; Scode: Integer; const Source,
      HelpFile: string; HelpContext: Integer; var CancelDisplay: Wordbool);
    procedure HTMLBeginRetrieval(Sender: TObject);
    procedure ImagesCBClick(Sender: TObject);
    procedure HTMLUpdateRetrieval(Sender: TObject);
    procedure HTMLEndRetrieval(Sender: TObject);
    procedure ImagesBtnClick(Sender: TObject);
    procedure SaveBtnClick(Sender: TObject);
    procedure OpenBtnClick(Sender: TObject);
    procedure HTMLDoNewElement(Sender: TObject; const ElemType: string;
      EndTag: Wordbool; const Attrs: Variant; const Text: string;
      var EnableDefault: Wordbool);
  private
    Navigating: boolean;
    DocTitle:   string;
    TitleFollows: boolean;
    procedure Navigate;
    procedure Land;
  public
    { Public declarations }
  end;

var
  HTMLForm: THTMLForm;

implementation

{$R *.DFM}

procedure THTMLForm.Navigate;
begin
   if Navigating then HTML.Cancel( 'Cancelled by user.');
   if length(URLCombo.Text) = 0 then exit;
   HTML.RequestDoc( URLCombo.Text);           {start navigating}
   StartBtn.Glyph.Assign( SunImage.Picture);
   Navigating := true;
end;

procedure THTMLForm.Land;
begin
   HTML.Cancel( 'Cancelled by user.');        {cancel navigating}
   StartBtn.Glyph.Assign( MoonImage.Picture);
   Navigating := false;
end;

procedure THTMLForm.HTMLPanelResize(Sender: TObject);
begin
   HTML.Height := HTMLPanel.ClientHeight;     {explicitly align HTML to panel client}
   HTML.Width := HTMLPanel.ClientWidth;
end;

procedure THTMLForm.URLComboKeyPress(Sender: TObject; var Key: Char);
begin
   if Key = #13 then begin
      Navigate;
      Key := #0
   end
end;

procedure THTMLForm.StartBtnClick(Sender: TObject);
begin
   if Navigating then Land else Navigate
end;

procedure THTMLForm.HTMLDoRequestDoc( Sender: TObject; const URL: string;
    const Element, DocInput: Variant; var EnableDefault: Wordbool);
begin
   MsgPanel.Caption := 'Contacting '+ URL;
   DocTitle := '';                            {initialize DocTitle}
end;

procedure THTMLForm.HTMLError( Sender: TObject; Number: Smallint;
   var Description: string; Scode: Integer; const Source, HelpFile: string;
   HelpContext: Integer; var CancelDisplay: Wordbool);
begin
   {Navigating := false;
   StartBtn.Glyph.Assign( MoonImage.Picture);}  {display error}
   MsgPanel.Caption := Format( 'Error %x: %s', [SCode, Description]);
   {CancelDisplay := false;}
end;

procedure THTMLForm.HTMLBeginRetrieval(Sender: TObject);
begin
   with URLCombo do begin                    {check if URL in history}
     if Items.IndexOf( HTML.URL) = -1 then
       Items.Add( HTML.URL);                 {add URL to history}
     Text := HTML.URL                        {display URL}
   end;
   MsgPanel.Caption := 'Retrieving data...';
   UpdateBar.Position := 0;                  {initialize progress bar}
   TitleFollows := false;                    {initialize Title flag}
end;

procedure THTMLForm.ImagesCBClick(Sender: TObject);
begin
   HTML.DeferRetrieval := ImagesCB.Checked
end;

procedure THTMLForm.HTMLUpdateRetrieval(Sender: TObject);
begin
   with UpdateBar, HTML do
     if RetrieveBytesTotal > 0 then         {advance progress bar}
       Position := RetrieveBytesDone * 100 div RetrieveBytesTotal;
end;

procedure THTMLForm.HTMLEndRetrieval(Sender: TObject);
begin
   MsgPanel.Caption := 'Done.';             {visually notify user the end of navigation}
   UpdateBar.Position := 0;
   Navigating := false;
   StartBtn.Glyph.Assign( MoonImage.Picture);
   if length(DocTitle) > 0 then Caption := DocTitle    {display document title}
                           else Caption := 'Baby WebBrowser'
end;

procedure THTMLForm.ImagesBtnClick(Sender: TObject);
begin
   HTML.RequestAllEmbedded                  {force all images download}
end;

procedure THTMLForm.SaveBtnClick(Sender: TObject);
var s: string;
    F: File;
    res: integer;
begin
   if Navigating then Land;
   if SaveDlg.Execute then
     with HTML do begin
       s := SourceText;                     {get document data as HTML source}
       AssignFile( F, SaveDlg.FileName);
       try
         rewrite(F,1);
       except
         MessageDlg( 'Error creating '+ SaveDlg.FileName + ' !', mtError, [mbOK], 0);
         exit
       end;
       try
         blockwrite(F, pointer(s)^, length(s), res);
         closefile(F);
       except
         MessageDlg( 'Error writing '+ SaveDlg.FileName + ' !', mtError, [mbOK], 0);
       end;
     end
end;

procedure THTMLForm.OpenBtnClick(Sender: TObject);
var s: string;
begin
   if Navigating then Land;
   if OpenDlg.Execute and (length(OpenDlg.Filename) > 0) then begin
      s := 'file:///'+OpenDlg.Filename;      {compose local URL}
      HTML.RequestDoc( s);                   {load HTML file}
      with URLCombo do begin
        if Items.IndexOf(s) = -1 then Items.Add(s);
        Text := s
      end
   end
end;

procedure THTMLForm.HTMLDoNewElement(Sender: TObject;
  const ElemType: string; EndTag: Wordbool; const Attrs: Variant;
  const Text: string; var EnableDefault: Wordbool);
var s: string;
    i: integer;
begin                             {check HTML elements; watch for Title section}
   if CompareText( ElemType, 'title') = 0 then
     TitleFollows := not EndTag                {state start or end of Title section}
   else if TitleFollows then DocTitle := DocTitle + Text + ' ';   {add word to title}
end;

end.
