{ ****************************************************************** }
{                                                                    }
{   Delphi component TImageAspect                                    }
{                                                                    }
{   Copyright  1995 by Indigo Software                              }
{                                                                    }
{ ****************************************************************** }

{*******************************************************************
Freeware component to display an image in the correct aspect
regardless of the size.
********************************************************************}
unit ImgAspct;

interface

{$IFDEF WIN32}
uses Messages, Windows, SysUtils, Classes, Controls, 
     Forms, Menus, Graphics;
{$ELSE}
uses WinTypes, WinProcs, Messages, SysUtils, Classes, Controls, 
     Forms, Menus, Graphics;
{$ENDIF}


type
  TImageAspect = class(TGraphicControl)
    private
        FPicture : TPicture;
        FAutoSize : Boolean;
        procedure AutoInitialize;
        procedure AutoDestroy;
        procedure SetPicture(Value : TPicture);
        procedure SetAutoSize(Value : Boolean);
        procedure WMSize(var Message: TWMSize); message WM_SIZE;

    protected
        procedure Paint; override;
        procedure PictureChanged(Sender: TObject);

    public
        constructor Create(AOwner: TComponent); override;
        destructor Destroy; override;

    published
        property OnClick;
        property OnDblClick;
        property OnDragDrop;
        property OnDragOver;
        property OnEndDrag;
        property OnMouseDown;
        property OnMouseMove;
        property OnMouseUp;
        property Picture : TPicture read FPicture write SetPicture;
        property AutoSize : Boolean read FAutoSize write SetAutoSize;
        property Align;

  end;

procedure Register;

implementation

{----------------------------------------------------------}
procedure Register;
begin
   RegisterComponents('Indigo Widgets', [TImageAspect]);
end;

{----------------------------------------------------------}
{ Method to set variable and property values and create objects }
procedure TImageAspect.AutoInitialize;
begin
   FPicture := TPicture.Create;
   FPicture.OnChange:=PictureChanged;
   FAutoSize := True;
end; { of AutoInitialize }

{----------------------------------------------------------}
{ Method to free any objects created by AutoInitialize }
procedure TImageAspect.AutoDestroy;
begin
   FPicture.Free;
end; { of AutoDestroy }

{----------------------------------------------------------}
procedure TImageAspect.PictureChanged(Sender: TObject);
begin
   {fires when a picture is assigned}
   invalidate;
end;

{----------------------------------------------------------}
{ Write method for property Picture }
procedure TImageAspect.SetPicture(Value : TPicture);
begin
   FPicture.Assign(Value);
   if autosize and not (picture.graphic = nil) then
      setbounds(left,top,picture.width,picture.height);
end;

{----------------------------------------------------------}
{ Write method for property autosize }
procedure TImageAspect.SetAutoSize(Value : Boolean);
begin
   FAutoSize:=Value;
   if value and not (picture.graphic = nil) then
      setbounds(left,top,picture.width,picture.height);
   Paint;
end;

{----------------------------------------------------------}
constructor TImageAspect.Create(AOwner: TComponent);
begin
   inherited Create(AOwner);
   AutoInitialize;
   width:=32;
   height:=32;
end;

{----------------------------------------------------------}
destructor TImageAspect.Destroy;
begin
   AutoDestroy;
   inherited Destroy;
end;

{----------------------------------------------------------}
procedure TImageAspect.WMSize(var Message: TWMSize);
begin
   inherited;
   {if you've resized then turn autosize off}
   if autosize and not (picture.graphic = nil) then
      if (width<>picture.width) or (height<>picture.height) then
         autosize:=false;
   paint;
end;

{----------------------------------------------------------}
procedure TImageAspect.Paint;
var
x,y:integer;
x1,y1,r:real;
rc:trect;
begin
   if not (picture.graphic = nil) then
   begin
      x1:=width/picture.width;
      y1:=height/picture.height;
      if x1 > y1 then
      begin
         {height is the best fit}
         r:= y1;
         rc.top:=0;
         rc.bottom:=height;
         x:=trunc(picture.width*y1);
         rc.left:=(width-x)div 2;
         rc.right:=rc.left+x;
      end else
      begin
         {width is the best fit}
         r:=x1;
         rc.left:=0;
         rc.right:=width;
         y:=trunc(picture.height*x1);
         rc.top:=(height-y)div 2;
         rc.bottom:=rc.top+y;
      end;
      canvas.stretchdraw(rc,picture.graphic);
   end;
   if csdesigning in componentstate then
      canvas.drawfocusrect(rect(0,0,width,height));
end;
end.
