unit AbtFXprp;

interface

uses
	SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
	Forms, Dialogs, StdCtrls, ExtCtrls, Buttons, DsgnIntf;

const
	CREDITNAME = 'TImageFX for Delphi';
	CREDITVERSION = 'Version 2.01';
	CREDITCOPYRIGHT = 'Copyright 1997' + #10 + 'Beond Technology Corp.' + #10 + 'All rights reserved';
	CREDITNOTES = 'Support: CIS: 76640,2664 Net: brianlow@mcs.com' + #10 + '(773) 388-3771 (voice) (773) 388-8125 (fax)';


type

	TAboutTImageFXEditor = class(TPropertyEditor)
		function GetAttributes: TPropertyAttributes; override;
		function GetValue: string; override;
		procedure Edit; override;

	end;

	TAboutTImageFX = class(TForm)
		Panel1: TPanel;
		BitBtn1: TBitBtn;
		lblName: TLabel;
		lblVersion: TLabel;
		lblCopyright: TLabel;
		lblNotes: TLabel;
    Image1: TImage;
		procedure FormCreate(Sender: TObject);
	private
		{ Private declarations }
	public
		{ Public declarations }
	end;

var
	AboutTImageFX: TAboutTImageFX;

implementation

{$R *.DFM}

function TAboutTImageFXEditor.GetAttributes;
begin
	Result := inherited GetAttributes + [paDialog] + [paReadOnly];
end;

function TAboutTImageFXEditor.GetValue: string;
begin
	Result := 'Double click or press button-';
end;

Procedure TAboutTImageFXEditor.Edit;
var
	AboutDlg: TAboutTImageFX;
begin
	try
		AboutDlg := TAboutTImageFX.Create(Application);
		AboutDlg.ShowModal;
	finally
		AboutDlg.Free;
	end;
end;

procedure TAboutTImageFX.FormCreate(Sender: TObject);
begin
	lblName.Caption := CREDITNAME;
	lblVersion.Caption := CREDITVERSION;
	lblCopyright.Caption := CREDITCOPYRIGHT;
	lblNotes.Caption := CREDITNOTES;
end;

initialization
end.
