unit AbtImgFx;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, StdCtrls,
	Buttons, ExtCtrls, ImgFX201;

type
  TAboutImageFX = class(TForm)
    Panel1: TPanel;
    Panel2: TPanel;
    Memo1: TMemo;
    Copyright: TLabel;
    Version: TLabel;
    OKButton: TButton;
		AboutFX: TImageFX;
    Label2: TLabel;
    Label1: TLabel;
    procedure OKButtonClick(Sender: TObject);
    procedure AboutFXPaint(Sender: TObject);
    procedure AboutFXClick(Sender: TObject);
    procedure CopyrightClick(Sender: TObject);
    procedure VersionClick(Sender: TObject);
    procedure ProductNameClick(Sender: TObject);
	private
    { Private declarations }
  public
    { Public declarations }
  end;

var
	AboutImageFX: TAboutImageFX;

implementation

uses Fx201Frm;

{$R *.DFM}
{$I Images.inc}

procedure TAboutImageFX.OKButtonClick(Sender: TObject);
begin
	AboutFX.Effect := fxHideImplode;
	AboutFX.ShowEffect;
	while AboutFX.Busy do								{Pause AboutBox closure until effect is complete}
		Application.ProcessMessages;
	AboutFX.Effect := fxSideCurtainRoll;		{About box opens with this effect next time}
	Close;
end;

{Don't set Effect here; then only that effect will ever paint}
procedure TAboutImageFX.AboutFXPaint(Sender: TObject);
begin
	AboutFX.ShowEffect;
end;

procedure TAboutImageFX.AboutFXClick(Sender: TObject);
begin
	with AboutFX do
	begin
		Effect := fxHideImplode;
		ShowEffect;
		while AboutFX.Busy do								{Pause AboutBox closure until effect is complete}
			Application.ProcessMessages;
		Effect := fxNone;
		ShowEffect;
	end;
end;

procedure TAboutImageFX.CopyrightClick(Sender: TObject);
begin
	with AboutFX do
	begin
		Effect := fxPushDown;
		ShowEffect;
	end;
end;

procedure TAboutImageFX.VersionClick(Sender: TObject);
begin
	with AboutFX do
	begin
		Effect := fxHideImplode;
		ShowEffect;
		while AboutFX.Busy do								{Pause AboutBox closure until effect is complete}
			Application.ProcessMessages;
		Effect := fxViewExplode;
		ShowEffect;
	end;
end;

procedure TAboutImageFX.ProductNameClick(Sender: TObject);
begin
	VersionClick(Sender);
end;

end.

