unit Fx200frm;

interface

uses
	SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
	Forms, Dialogs, ExtCtrls, StdCtrls, Buttons, ImgFX201;

const
	MaxEffects = 41;

type
  TForm1 = class(TForm)
		Panel3: TPanel;
		BitBtn2: TBitBtn;
		Panel2: TPanel;
    BitBtn1: TBitBtn;
    Label1: TLabel;
    Label2: TLabel;
		DelayScroller: TScrollBar;
    RateScroller: TScrollBar;
    Label3: TLabel;
		Label4: TLabel;
    Panel1: TPanel;
    TransparentBtn: TButton;
		StretchBtn: TButton;
		CenterBtn: TButton;
		EffectLabel: TLabel;
    StretchRatioBtn: TButton;
		ComboBox1: TComboBox;
    ComboBox2: TComboBox;
    ImageFX1: TImageFX;
		procedure FormResize(Sender: TObject);
		procedure BitBtn1Click(Sender: TObject);
		procedure DelayScrollerChange(Sender: TObject);
		procedure RateScrollerChange(Sender: TObject);
		procedure ImageFX1Complete(Sender: TObject);
		procedure TransparentBtnClick(Sender: TObject);
		procedure StretchBtnClick(Sender: TObject);
		procedure FormShow(Sender: TObject);
		procedure CenterBtnClick(Sender: TObject);
		procedure StretchRatioBtnClick(Sender: TObject);
		procedure ImageFX1MouseUp(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
		procedure BitBtn2Click(Sender: TObject);
		procedure ComboBox1Change(Sender: TObject);
		procedure ComboBox2Change(Sender: TObject);
    procedure ImageFX1Pixelation(Sender: TObject);
    procedure FormCreate(Sender: TObject);
	private
		DoingAll: Boolean;
		LoadedPicture: Integer;
		procedure DisplayEffect(EffectNumber: Integer);
		procedure SetStretch;
		procedure SetTransparent;
		procedure SetCenter;
		procedure SetRatio;
    procedure InitControls;
	public
		procedure WaitForEffect;
	end;

var
	Form1: TForm1;

implementation

uses AbtImgFX;

{$R *.DFM}				{Standard}
{$ifdef WIN32}
	{$R Images32.res}		{Holds bitmaps compiled into EXE for LoadFromResource calls}
{$else}
	{$R Images.res}		{Holds bitmaps compiled into EXE for LoadFromResource calls}
{$endif}
{$I Images.inc}		{Holds constants as used in Images.res}

procedure TForm1.FormCreate(Sender: TObject);
begin
	DoingAll := False;
end;

procedure TForm1.FormShow(Sender: TObject);
begin
	SetStretch;
	SetTransparent;
	SetCenter;
	SetRatio;
	LoadedPicture := 0;

	ComboBox1.ItemIndex := 0;

	InitControls;
end;

procedure TForm1.FormResize(Sender: TObject);
begin
	ComboBox1Change(Sender);
end;

procedure TForm1.DisplayEffect(EffectNumber: Integer);
const
	EffectType: string = ' Effect: ';
var
	AnyBitmap: TBitmap;
begin

{ NO LONGER NEEDED IN VERSION 2.}
{	if ImageFX1.Busy then		{Run-time read only property to indicate when an effect is being processed}
{		exit;									{This prevents stack overflow from doing multiple effects at once...a nasty GPF!}

	BitBtn1.Enabled := False;
	ComboBox1.Enabled := False;

	ImageFX1.EffectDelay := DelayScroller.Position;
	ImageFX1.EffectRate := RateScroller.Position;

	Label3.Caption := IntToStr(DelayScroller.Position);
	Label4.Caption := IntToStr(RateScroller.Position);

	with ImageFX1 do
	begin
		case LoadedPicture of
			0:
			begin						{Example of loading from resource in this executable}
				LoadFromResource(HInstance, SKYLINE);
				LoadedPicture := 1;
			end;
			1:
			begin
				LoadFromDLL('Images.DLL', EARTHDLL);		{Example of loading from resource in a DLL; requires distinct ResID}
				LoadedPicture := 2;
			end;
			2:
			begin
				LoadFromFile('BeondUp.bmp');		{Example for LoadFromFile method - must be a Windows BMP, not RLE compressed}
				LoadedPicture := 3;
			end;
			3:
			begin
				AnyBitmap := TBitmap.Create;		{Example of using a local TBitmap; ImageFX1.Assign DOES NOT work properly}
				AnyBitmap.LoadFromFile('shipping.bmp');
				ImageFX1.Bitmap := AnyBitmap;
				AnyBitmap.Free;
				LoadedPicture := 0;
			end;
		end;

		case EffectNumber of
{			1:		See end of this case statement}
			2:
			begin
				Effect := fxViewExplode;
				EffectLabel.Caption := EffectType + 'fxViewExplode';
				ShowEffect;
				WaitForEffect;
			end;
			3:
			begin
				Effect := fxViewZoomIn;
				EffectLabel.Caption := EffectType + 'fxViewZoomIn';
				ShowEffect;
				WaitForEffect;
			end;
			4:
			begin
				Effect := fxViewZoomOut;
				EffectLabel.Caption := EffectType + 'fxViewZoomOut';
				ShowEffect;
				WaitForEffect;
			end;
			5:
			begin
				Effect := fxHideImplode;
				EffectLabel.Caption := EffectType + 'fxHideImplode';
				ShowEffect;
				WaitForEffect;
			end;
			6:
			begin
				Effect := fxHideZoomIn;
				EffectLabel.Caption := EffectType + 'fxHideZoomIn';
				ShowEffect;
				WaitForEffect;
			end;
			7:
			begin
				Effect := fxHideZoomOut;
				EffectLabel.Caption := EffectType + 'fxHideZoomOut';
				ShowEffect;
				WaitForEffect;
			end;
			8:
			begin
				Effect := fxWipeRightRoll;
				EffectLabel.Caption := EffectType + 'fxWipeRightRoll';
				ShowEffect;
				WaitForEffect;
			end;
			9:
			begin
				Effect := fxWipeRightSlide;
				EffectLabel.Caption := EffectType + 'fxWipeRightSlide';
				ShowEffect;
				WaitForEffect;
			end;
			10:
			begin
				Effect := fxWipeRightStretch;
				EffectLabel.Caption := EffectType + 'fxWipeRightStretch';
				ShowEffect;
				WaitForEffect;
			end;
			11:
			begin
				Effect := fxWipeLeftRoll;
				EffectLabel.Caption := EffectType + 'fxWipeLeftRoll';
				ShowEffect;
				WaitForEffect;
			end;
			12:
			begin
				Effect := fxWipeLeftSlide;
				EffectLabel.Caption := EffectType + 'fxWipeLeftSlide';
				ShowEffect;
				WaitForEffect;
			end;
			13:
			begin
				Effect := fxWipeLeftStretch;
				EffectLabel.Caption := EffectType + 'fxWipeLeftStretch';
				ShowEffect;
				WaitForEffect;
			end;
			14:
			begin
				Effect := fxWipeUpRoll;
				EffectLabel.Caption := EffectType + 'fxWipeUpRoll';
				ShowEffect;
				WaitForEffect;
			end;
			15:
			begin
				Effect := fxWipeUpSlide;
				EffectLabel.Caption := EffectType + 'fxWipeUpSlide';
				ShowEffect;
				WaitForEffect;
			end;
			16:
			begin
				Effect := fxWipeUpStretch;
				EffectLabel.Caption := EffectType + 'fxWipeUpStretch';
				ShowEffect;
				WaitForEffect;
			end;
			17:
			begin
				Effect := fxWipeDownRoll;
				EffectLabel.Caption := EffectType + 'fxWipeDownRoll';
				ShowEffect;
				WaitForEffect;
			end;
			18:
			begin
				Effect := fxWipeDownSlide;
				EffectLabel.Caption := EffectType + 'fxWipeDownSlide';
				ShowEffect;
				WaitForEffect;
			end;
			19:
			begin
				Effect := fxWipeDownStretch;
				EffectLabel.Caption := EffectType + 'fxWipeDownStretch';
				ShowEffect;
				WaitForEffect;
			end;
			20:
			begin
				Effect := fxSideCurtainRoll;
				EffectLabel.Caption := EffectType + 'fxSideCurtainRoll';
				ShowEffect;
				WaitForEffect;
			end;
			21:
			begin
				Effect := fxVertCurtainRoll;
				EffectLabel.Caption := EffectType + 'fxVertCurtainRoll';
				ShowEffect;
				WaitForEffect;
			end;
			22:
			begin
				Effect := fxPushRight;
				EffectLabel.Caption := EffectType + 'fxPushRight';
				ShowEffect;
				WaitForEffect;
			end;
			23:
			begin
				Effect := fxPushLeft;
				EffectLabel.Caption := EffectType + 'fxPushLeft';
				ShowEffect;
				WaitForEffect;
			end;
			24:
			begin
				Effect := fxPushUp;
				EffectLabel.Caption := EffectType + 'fxPushUp';
				ShowEffect;
				WaitForEffect;
			end;
			25:
			begin
				Effect := fxPushDown;
				EffectLabel.Caption := EffectType + 'fxPushDown';
				ShowEffect;
				WaitForEffect;
			end;
			26:
			begin
				Effect := fxSqueeze;
				EffectLabel.Caption := EffectType + 'fxSqueeze';
				ShowEffect;
				WaitForEffect;
			end;
			27:
			begin
				Effect := fxRollRightDown;
				EffectLabel.Caption := EffectType + 'fxRollRightDown';
				ShowEffect;
				WaitForEffect;
			end;
			28:
			begin
				Effect := fxStretchRightDown;
				EffectLabel.Caption := EffectType + 'fxStretchRightDown';
				ShowEffect;
				WaitForEffect;
			end;
			29:
			begin
				Effect := fxSlideRightDown;
				EffectLabel.Caption := EffectType + 'fxSlideRightDown';
				ShowEffect;
				WaitForEffect;
			end;
			30:
			begin
				Effect := fxRollRightUp;
				EffectLabel.Caption := EffectType + 'fxRollRightUp';
				ShowEffect;
				WaitForEffect;
			end;
			31:
			begin
				Effect := fxStretchRightUp;
				EffectLabel.Caption := EffectType + 'fxStretchRightUp';
				ShowEffect;
				WaitForEffect;
			end;
			32:
			begin
				Effect := fxSlideRightUp;
				EffectLabel.Caption := EffectType + 'fxSlideRightUp';
				ShowEffect;
				WaitForEffect;
			end;
			33:
			begin
				Effect := fxRollLeftDown;
				EffectLabel.Caption := EffectType + 'fxRollLeftDown';
				ShowEffect;
				WaitForEffect;
			end;
			34:
			begin
				Effect := fxStretchLeftDown;
				EffectLabel.Caption := EffectType + 'fxStretchLeftDown';
				ShowEffect;
				WaitForEffect;
			end;
			35:
			begin
				Effect := fxSlideLeftDown;
				EffectLabel.Caption := EffectType + 'fxSlideLeftDown';
				ShowEffect;
				WaitForEffect;
			end;
			36:
			begin
				Effect := fxRollLeftUp;
				EffectLabel.Caption := EffectType + 'fxRollLeftUp';
				ShowEffect;
				WaitForEffect;
			end;
			37:
			begin
				Effect := fxStretchLeftUp;
				EffectLabel.Caption := EffectType + 'fxStretchLeftUp';
				ShowEffect;
				WaitForEffect;
			end;
			38:
			begin
				Effect := fxSlideLeftUp;
				EffectLabel.Caption := EffectType + 'fxSlideLeftUp';
				ShowEffect;
				WaitForEffect;
			end;
			39:
			begin
				Effect := fxDiagonal;
				EffectLabel.Caption := EffectType + 'fxDiagonal';
				ShowEffect;
				WaitForEffect;
			end;
			40:
			begin
				Effect := fxStrips;
				EffectLabel.Caption := EffectType + 'fxStrips';
				ShowEffect;
				WaitForEffect;
			end;
			41:
			begin
				Effect := fxPixelation;
				EffectLabel.Caption := EffectType + 'fxPixelation';
				ShowEffect;
				WaitForEffect;
			end else
{			1:
}			begin
				Effect := fxNone;
				EffectLabel.Caption := EffectType + 'fxNone';
				ShowEffect;
				WaitForEffect;
			end;
		end;
	end;
	BitBtn1.Enabled := True;
	ComboBox1.Enabled := True;
end;

{A loop to allow current wipe to finish and change effect rate and delay during draw}
procedure TForm1.WaitForEffect;
begin
	while ImageFX1.Busy do
	begin
		Application.ProcessMessages;
		if DelayScroller.Position = 0 then
			ImageFX1.StopEffect;
	end;
end;

procedure TForm1.BitBtn1Click(Sender: TObject);
begin
	ComboBox1Change(Sender);
end;

procedure TForm1.BitBtn2Click(Sender: TObject);
begin
	AboutImageFX.Show;
end;

procedure TForm1.DelayScrollerChange(Sender: TObject);
begin
	ImageFX1.EffectDelay := DelayScroller.Position;
	Label3.Caption := IntToStr(DelayScroller.Position);
end;

procedure TForm1.RateScrollerChange(Sender: TObject);
begin
	ImageFX1.EffectRate := RateScroller.Position;
	Label4.Caption := IntToStr(RateScroller.Position);
end;

procedure TForm1.ImageFX1Complete(Sender: TObject);
begin
	ShowMessage(Panel3.Caption + ' is complete');
end;

procedure TForm1.StretchBtnClick(Sender: TObject);
begin
	ImageFX1.Stretch := not ImageFX1.Stretch;
	SetStretch;
end;

procedure TForm1.TransparentBtnClick(Sender: TObject);
begin
	ImageFX1.Transparent := not ImageFX1.Transparent;
	SetTransparent;
end;

procedure TForm1.CenterBtnClick(Sender: TObject);
begin
	ImageFX1.Center := not ImageFX1.Center;
	SetCenter;
end;

procedure TForm1.StretchRatioBtnClick(Sender: TObject);
begin
	ImageFX1.StretchRatio := not ImageFX1.StretchRatio;
	SetRatio;
end;

procedure TForm1.SetStretch;
begin
	if ImageFX1.Stretch then
	begin
		CenterBtn.Enabled := False;
		StretchBtn.Caption := 'No Stretch';
		StretchRatioBtn.Enabled := True;
	end else
	begin
		StretchBtn.Caption := 'Stretch';
		CenterBtn.Enabled := True;
		StretchRatioBtn.Enabled := False;
	end;

{	ImageFX1.Invalidate;}
end;

procedure TForm1.SetTransparent;
begin
	if ImageFX1.Transparent then
		TransparentBtn.Caption := 'Opaque'		{Caption indicates what pushing button will do, not current state}
	else
		TransparentBtn.Caption := 'Transparent';

{	ImageFX1.Invalidate;}
end;

procedure TForm1.SetCenter;
begin
	if ImageFX1.Center then
		CenterBtn.Caption := 'Not centered'
	else
		CenterBtn.Caption := 'Centered';
end;

procedure TForm1.SetRatio;
begin
	if ImageFX1.StretchRatio then
		StretchRatioBtn.Caption := 'Non-ratioed'
	else
		StretchRatioBtn.Caption := 'Ratioed';
end;

procedure TForm1.ImageFX1MouseUp(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
	with ImageFX1 do
		if Transparent and not (Busy or Stretch or Center) then		{This is the only time the pixel you see is in the }
			TransparentPixel := IntToStr(X) + ',' + IntToStr(Y);			{same spot as that pixel on the loaded bitmap}
end;

procedure TForm1.ComboBox1Change(Sender: TObject);
var
	EffectCount: Integer;
begin
	if ImageFX1.Busy or DoingAll then			{Otherwise the stack [or something] gets overloaded and totally trashes the system!}
		exit;

	try
		if ComboBox1.ItemIndex = 0 then
		begin
			DoingAll := True;
			for EffectCount := 2 to MaxEffects do		{Loop through all effects; start with first one after fxNone}
			begin
				DisplayEffect(EffectCount);
				if (DelayScroller.Position = 0) or (ImageFX1.Visible = False) then
					break;
			end;
		end else if ComboBox1.ItemIndex = -1 then
			ImageFX1.Invalidate
		else
			DisplayEffect(ComboBox1.ItemIndex);
	finally
		DoingAll := False;
		ImageFX1.StopEffect;
	end;
end;

procedure TForm1.ComboBox2Change(Sender: TObject);
begin
	case ComboBox2.ItemIndex of
		0: ImageFX1.Granularity := gr50;
		1: ImageFX1.Granularity := gr100;
		2: ImageFX1.Granularity := gr250;
		3: ImageFX1.Granularity := gr500;
		else ImageFX1.Granularity := gr100;
	end;
end;

procedure TForm1.InitControls;
begin
	DelayScroller.Position := 5;		{Reinitialize everything prior to loop through all effects}
	RateScroller.Position := 5;
	ImageFX1.EffectDelay := DelayScroller.Position;	{TScroller only calls OnChange via mouse, not via Position value...}
	ImageFX1.EffectRate := RateScroller.Position;		{ change. Too bad.}
	ComboBox2.ItemIndex := 1;
	ComboBox2Change(Self);

	Label3.Caption := IntToStr(DelayScroller.Position);
	Label4.Caption := IntToStr(RateScroller.Position);
end;

procedure TForm1.ImageFX1Pixelation(Sender: TObject);
begin
	Application.ProcessMessages;		{So TImageFX does not take control of system during this effect};

	if DelayScroller.Position <> ImageFX1.EffectDelay then		{Do what user selects; esp. for EffectDelay = 0}
		ImageFX1.EffectDelay := DelayScroller.Position;

	if RateScroller.Position <> ImageFX1.EffectRate then
		ImageFX1.EffectRate := RateScroller.Position;
end;

initialization
end.
