unit httpmain;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls, Buttons, ComCtrls, agsocket,
  aghttp;

type
  THTTPForm = class(TForm)
    Panel1: TPanel;
    URLEdit: TEdit;
    Label1: TLabel;
    GetButton: TBitBtn;
    CancelButton: TBitBtn;
    StatusBar1: TStatusBar;
    SaveDialog1: TSaveDialog;
    Memo1: TMemo;
    HTTP1: TagHTTP;
    procedure GetButtonClick(Sender: TObject);
    procedure HTTP1Receiving(Sender: TObject; Total: Longint);
    procedure HTTP1Cancel(Sender: TObject);
    procedure HTTP1Closed(Sender: TObject);
    procedure HTTP1Open(Sender: TObject);
    procedure HTTP1Sending(Sender: TObject);
    procedure HTTP1Error(Sender: TObject; var Msg: string);
    procedure CancelButtonClick(Sender: TObject);
  private
    { Private declarations }
    procedure EnableControls;
    procedure DisableControls;
    procedure SaveData;
  public
    { Public declarations }
  end;

var
  HTTPForm: THTTPForm;

implementation

{$R *.DFM}

procedure THTTPForm.DisableControls;
begin
  URLEdit.Enabled:=false;
  GetButton.Enabled:=false;
  CancelButton.Enabled:=true;
end;

procedure THTTPForm.EnableControls;
begin
  URLEdit.Enabled:=true;
  GetButton.Enabled:=true;
  CancelButton.Enabled:=false;
end;

procedure THTTPForm.SaveData;
begin
  SaveDialog1.FileName:=HTTP1.FileName;
  if SaveDialog1.Execute then
    HTTP1.OutStream.SaveToFile(SaveDialog1.FileName);
end;

procedure THTTPForm.GetButtonClick(Sender: TObject);
begin
  DisableControls;
  try
    HTTP1.URL:=URLEdit.Text;
    HTTP1.Get;
    Memo1.Lines:=HTTP1.Headers;
    if MessageDlg('Do you want to save the retrieved data?',
                   mtConfirmation,[mbYes,mbNo],0)=mrYes then
      SaveData;
  finally
    EnableControls;
  end;
end;

procedure THTTPForm.HTTP1Receiving(Sender: TObject; Total: Longint);
begin
  StatusBar1.SimpleText:=IntToStr(Total)+' bytes received';
end;

procedure THTTPForm.HTTP1Cancel(Sender: TObject);
begin
  StatusBar1.SimpleText:='Operation canceled';
end;

procedure THTTPForm.HTTP1Closed(Sender: TObject);
begin
  StatusBar1.SimpleText:='Connection closed';
end;

procedure THTTPForm.HTTP1Open(Sender: TObject);
begin
  StatusBar1.SimpleText:='Opening connection';
end;

procedure THTTPForm.HTTP1Sending(Sender: TObject);
begin
  StatusBar1.SimpleText:='Sending Query';
end;

procedure THTTPForm.HTTP1Error(Sender: TObject; var Msg: string);
begin
  StatusBar1.SimpleText:=Msg;
end;

procedure THTTPForm.CancelButtonClick(Sender: TObject);
begin
  HTTP1.Cancel;
end;

end.
