unit popmain;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Buttons, ComCtrls, ExtCtrls, msmsg, msmb, mspop3, msDef, popsu,
  IniFiles, Menus, agsocket;

type
  TPopForm = class(TForm)
    Panel1: TPanel;
    Panel2: TPanel;
    StatusBar1: TStatusBar;
    ListView1: TListView;
    RetrieveButton: TSpeedButton;
    CancelButton: TSpeedButton;
    ImageList1: TImageList;
    SetupButton: TSpeedButton;
    ExitButton: TSpeedButton;
    ProgressBar1: TProgressBar;
    msPOP1: TmsPOP;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Retrieve1: TMenuItem;
    Cancel1: TMenuItem;
    Exit1: TMenuItem;
    Setup1: TMenuItem;
    Help1: TMenuItem;
    About1: TMenuItem;
    Bevel1: TBevel;
    procedure RetrieveButtonClick(Sender: TObject);
    procedure msPOP1Cancel(Sender: TObject);
    procedure msPOP1Open(Sender: TObject);
    procedure msPOP1Retrieved(Sender: TObject; Current: Integer);
    procedure msPOP1Retrieving(Sender: TObject; Current: Integer);
    procedure CancelButtonClick(Sender: TObject);
    procedure ExitButtonClick(Sender: TObject);
    procedure ListView1DblClick(Sender: TObject);
    procedure SetupButtonClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure msPOP1Closed(Sender: TObject);
    procedure msPOP1Closing(Sender: TObject);
    procedure About1Click(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure msPOP1Progress(Sender: TObject; Perc: Integer);
    procedure msPOP1Error(Sender: TObject; var Msg: string);
  private
    { Private declarations }
    Item : TListItem;
    IniName : string;
    procedure EnableControls;
    procedure DisableControls;
  public
    { Public declarations }
  end;

var
  PopForm: TPopForm;

implementation

uses popview, msabout;

{$R *.DFM}

procedure TPopForm.EnableControls;
begin
  RetrieveButton.Enabled:=true;
  CancelButton.Enabled:=false;
  SetupButton.Enabled:=true;
  ExitButton.Enabled:=true;
  Retrieve1.Enabled:=true;
  Cancel1.Enabled:=false;
  Exit1.Enabled:=true;
  Setup1.Enabled:=true;
  Help1.Enabled:=true;
end;

procedure TPopForm.DisableControls;
begin
  RetrieveButton.Enabled:=false;
  CancelButton.Enabled:=true;
  SetupButton.Enabled:=false;
  ExitButton.Enabled:=false;
  Retrieve1.Enabled:=false;
  Cancel1.Enabled:=true;
  Exit1.Enabled:=false;
  Setup1.Enabled:=false;
  Help1.Enabled:=false;
end;

procedure TPopForm.RetrieveButtonClick(Sender: TObject);
begin
  msPOP1.MessageList.Clear;
  ListView1.Items.Clear;
  ListView1.Cursor:=crHourGlass;
  DisableControls;
  try
    msPOP1.RetrieveAllMessages(true); {true - LeaveOnServer}
  finally
    EnableControls;
    ListView1.Cursor:=crDefault;
  end;
end;

procedure TPopForm.msPOP1Cancel(Sender: TObject);
begin
  StatusBar1.Panels[0].Text:='Canceled';
end;

procedure TPopForm.msPOP1Open(Sender: TObject);
begin
  StatusBar1.Panels[0].Text:='Opening connection';
end;

procedure TPopForm.msPOP1Retrieved(Sender: TObject; Current: Integer);
var
  i : Integer;
begin
  i:=msPOP1.MessageList.Count-1;
  Item:=ListView1.Items.Add;
  Item.Caption:=msPOP1.MessageList[i].Subject;
  if Item.Caption='' then Item.Caption:='No Subject';
  Item.ImageIndex:=0;
end;

procedure TPopForm.msPOP1Retrieving(Sender: TObject; Current: Integer);
begin
  StatusBar1.Panels[0].Text:='Retrieving message '+IntToStr(Current+1)+
                             ' of '+IntToStr(msPOP1.TotalMessages);
end;

procedure TPopForm.CancelButtonClick(Sender: TObject);
begin
  msPOP1.Cancel;
end;

procedure TPopForm.ExitButtonClick(Sender: TObject);
begin
  Close;
end;

procedure TPopForm.ListView1DblClick(Sender: TObject);
begin
  if ListView1.Selected<>nil then
  begin
    MsgViewDlg:=TMsgViewDlg.Create(Self);
    MsgViewDlg.MailMessage:=msPOP1.MessageList[ListView1.Selected.Index];
    MsgViewDlg.ShowModal;
    MsgViewDlg.Free;
  end;
end;

procedure TPopForm.SetupButtonClick(Sender: TObject);
begin
  with TSetupDlg.Create(Self) do
  try
    ServerEdit.Text:=msPOP1.Server;
    UserNameEdit.Text:=msPOP1.UserName;
    PasswordEdit.Text:=msPOP1.Password;
    LogFileNameEdit.Text:=msPOP1.LogFileName;
    if ShowModal=mrOk then
    begin
      msPOP1.Server:=ServerEdit.Text;
      msPOP1.UserName:=UserNameEdit.Text;
      msPOP1.Password:=PasswordEdit.Text;
      msPOP1.LogFileName:=LogFileNameEdit.Text;
    end;
  finally
    free;
  end;
end;

procedure TPopForm.FormCreate(Sender: TObject);
begin
  IniName:=ChangeFileExt(Application.ExeName,'.ini');
  with TIniFile.Create(IniName) do
  try
    msPOP1.Server:=ReadString('Setup','Server','');
    msPOP1.UserName:=ReadString('Setup','User Name','');
    msPOP1.Password:=ReadString('Setup','Password','');
    msPOP1.LogFileName:=ReadString('Setup','Log File','');
  finally
    free;
  end;
end;

procedure TPopForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  with TIniFile.Create(IniName) do
  try
    WriteString('Setup','Server',msPOP1.Server);
    WriteString('Setup','User Name',msPOP1.UserName);
    WriteString('Setup','Password',msPOP1.Password);
    WriteString('Setup','Log File',msPOP1.LogFileName);
  finally
    free;
  end;
end;

procedure TPopForm.msPOP1Closed(Sender: TObject);
begin
  StatusBar1.Panels[0].Text:='Connection closed';
end;

procedure TPopForm.msPOP1Closing(Sender: TObject);
begin
  StatusBar1.Panels[0].Text:='Closing connection';
end;

procedure TPopForm.About1Click(Sender: TObject);
begin
  with TAboutDlg.Create(Self) do
  try
    ProgramName.Caption:='msPOP Component Demo';
    ProductVersion.Caption:=msVersion;
    ShowModal;
  finally
    Free;
  end;
end;

procedure TPopForm.FormResize(Sender: TObject);
begin
  Bevel1.Width:=Width;
end;

procedure TPopForm.msPOP1Progress(Sender: TObject; Perc: Integer);
begin
  ProgressBar1.Position:=Perc;
end;

procedure TPopForm.msPOP1Error(Sender: TObject; var Msg: string);
begin
  StatusBar1.SimpleText:=Msg;
end;

end.
