unit popview;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, ComCtrls, msMsg, ShellAPI, Menus;

type
  TMsgViewDlg = class(TForm)
    ListView1: TListView;
    Memo1: TMemo;
    Panel1: TPanel;
    ImageList1: TImageList;
    PopupMenu1: TPopupMenu;
    Open1: TMenuItem;
    SaveAs1: TMenuItem;
    Label1: TLabel;
    Label2: TLabel;
    FromLabel: TLabel;
    DateLabel: TLabel;
    SaveDialog1: TSaveDialog;
    procedure ListView1DblClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure ListView1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure SaveAs1Click(Sender: TObject);
  private
    { Private declarations }
    TempPath : string;
    FMailMessage : TmsMessage;
    procedure SetMailMessage(Value : TmsMessage);
    procedure OpenAttachment(Index : Integer);
    procedure SaveTheAttachment(Index : Integer);
  public
    { Public declarations }
    property MailMessage : TmsMessage write SetMailMessage;
  end;

var
  MsgViewDlg: TMsgViewDlg;

implementation

{$R *.DFM}

procedure TMsgViewDlg.SetMailMessage(Value : TmsMessage);
var
  i : Integer;
  Item : TListItem;
  Icon : TIcon;
  s : string;
  j : word;
begin
  FMailMessage:=Value;
  Memo1.Lines:=Value.Body;
  Caption:=Value.Subject;
  FromLabel.Caption:=Value.Sender.Name;
  if FromLabel.Caption='' then
    FromLabel.Caption:=Value.Sender.Address;
  DateLabel.Caption:=Value.Headers.GetFieldBody('Date');
  if Value.Attachments.Count>0 then
  begin
    ListView1.Visible:=true;
    for i:=0 to Value.Attachments.Count-1 do
    begin
      Item:=ListView1.Items.Add;
      Item.Caption:=Value.Attachments[i].FileName;
      Value.SaveAttachment(i,TempPath);
      Icon:=TIcon.Create;
      s:=Concat(TempPath,Value.Attachments[i].FileName);
      j:=0;
      Icon.Handle:=ExtractAssociatedIcon(hInstance,PChar(s),j);
      if Icon.Handle<>0 then
        Item.ImageIndex:=ImageList1.AddIcon(Icon);
    end;
  end
  else
    ListView1.Visible:=false;
end;

procedure TMsgViewDlg.OpenAttachment(Index : Integer);
var
  s : string;
  TheHandle : THandle;
begin
  s:=Concat(TempPath,ListView1.Items[Index].Caption);
  TheHandle:=ShellExecute(Application.Handle,'Open',PChar(s),nil,nil,SW_SHOW);
  if TheHandle<=31 then
    raise Exception.Create('Unable to run ShellExec. Error code='+IntToStr(TheHandle));
end;

procedure TMsgViewDlg.SaveTheAttachment(Index : Integer);
var
  s : string;
begin
  s:=Concat(TempPath,ListView1.Items[Index].Caption);
  SaveDialog1.DefaultExt:=ExtractFileExt(s);
  SaveDialog1.FileName:=ExtractFileName(s);
  if SaveDialog1.Execute then
  begin
    if not CopyFile(PChar(s),PChar(SaveDialog1.FileName),false) then
      raise Exception.Create('Unable to save attachment');
  end;
end;

procedure TMsgViewDlg.ListView1DblClick(Sender: TObject);
begin
  if ListView1.Selected<>nil then
    OpenAttachment(ListView1.Selected.Index);
end;

procedure TMsgViewDlg.FormCreate(Sender: TObject);
var
  Buf : array[0..255] of Char;
begin
  GetTempPath(255,@Buf);
  TempPath:=StrPas(@Buf);
end;

procedure TMsgViewDlg.FormClose(Sender: TObject; var Action: TCloseAction);
var
  i : Integer;
  f : file;
  s : string;
begin
  for i:=0 to ListView1.Items.Count-1 do
  begin
    s:=Concat(TempPath,ListView1.Items[i].Caption);
    AssignFile(f,s);
    try
      Erase(f);
    except
      //Do Nothing
    end;
  end;
end;

procedure TMsgViewDlg.ListView1MouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  if (Button=mbRight) and (ListView1.Selected<>nil) then
    ListView1.PopUpMenu.PopUp(Left+ListView1.Left+X,
      Top+ListView1.Top+Y);
end;

procedure TMsgViewDlg.SaveAs1Click(Sender: TObject);
begin
  SaveTheAttachment(ListView1.Selected.Index);
end;

end.
