unit fngmain;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls, ExtCtrls, agsocket, agfinger, Buttons;

type
  TFingerForm = class(TForm)
    Panel1: TPanel;
    Memo1: TMemo;
    StatusBar1: TStatusBar;
    QueryEdit: TEdit;
    FingerButton: TSpeedButton;
    CancelButton: TSpeedButton;
    Label1: TLabel;
    agFinger1: TagFinger;
    procedure agFinger1Cancel(Sender: TObject);
    procedure agFinger1Closed(Sender: TObject);
    procedure agFinger1Error(Sender: TObject; var Msg: string);
    procedure agFinger1Open(Sender: TObject);
    procedure FingerButtonClick(Sender: TObject);
    procedure CancelButtonClick(Sender: TObject);
    procedure agFinger1SendingQuery(Sender: TObject);
    procedure agFinger1Progress(Sender: TObject; Perc: Integer;
      Transferred: Longint);
  private
    { Private declarations }
    procedure EnableControls;
    procedure DisableControls;
  public
    { Public declarations }
  end;

var
  FingerForm: TFingerForm;

implementation

{$R *.DFM}

procedure TFingerForm.agFinger1Cancel(Sender: TObject);
begin
  StatusBar1.SimpleText:='Operation has been canceled';
end;

procedure TFingerForm.agFinger1Closed(Sender: TObject);
begin
  StatusBar1.SimpleText:='Connection closed';
end;

procedure TFingerForm.agFinger1Error(Sender: TObject; var Msg: string);
begin
  StatusBar1.SimpleText:=Msg;
end;

procedure TFingerForm.agFinger1Open(Sender: TObject);
begin
  StatusBar1.SimpleText:='Opening connection';
end;

procedure TFingerForm.EnableControls;
begin
  FingerButton.Enabled:=true;
  CancelButton.Enabled:=false;
  QueryEdit.Enabled:=true;
end;

procedure TFingerForm.DisableControls;
begin
  FingerButton.Enabled:=false;
  CancelButton.Enabled:=true;
  QueryEdit.Enabled:=false;
end;

procedure TFingerForm.FingerButtonClick(Sender: TObject);
begin
  agFinger1.Query:=QueryEdit.Text;
  Memo1.Clear;
  DisableControls;
  try
    agFinger1.Execute;
    Memo1.Lines.LoadFromStream(agFinger1.InStream);
  finally
    EnableControls;
  end;
end;

procedure TFingerForm.CancelButtonClick(Sender: TObject);
begin
  agFinger1.Cancel;
end;

procedure TFingerForm.agFinger1SendingQuery(Sender: TObject);
begin
  StatusBar1.SimpleText:='Sending query';
end;

procedure TFingerForm.agFinger1Progress(Sender: TObject; Perc: Integer;
  Transferred: Longint);
begin
  StatusBar1.SimpleText:=IntToStr(Transferred)+' bytes received';
end;

end.
