unit smtpmain;

interface

uses
  SysUtils, Windows, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Buttons, ExtCtrls, StdCtrls, msMsgCls,
  SMTPSu, IniFiles, ComCtrls, msmsg, msmb, mssmtp, Menus, ShellAPI, agsocket,
  agTypes, agRasCmp;

type
  TSMTPForm = class(TForm)
    ToolBar: TPanel;
    SendButton: TSpeedButton;
    SetupButton: TSpeedButton;
    ExitButton: TSpeedButton;
    SendInfoPanel: TPanel;
    ToEdit: TEdit;
    Label1: TLabel;
    Label3: TLabel;
    SubjectEdit: TEdit;
    CancelButton: TSpeedButton;
    BodyMemo: TMemo;
    AttachButton: TSpeedButton;
    Panel1: TPanel;
    StatusBar1: TStatusBar;
    ProgressBar1: TProgressBar;
    msSMTP1: TmsSMTP;
    msMessage1: TmsMessage;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Send1: TMenuItem;
    Cancel1: TMenuItem;
    N1: TMenuItem;
    Exit1: TMenuItem;
    Attach1: TMenuItem;
    Setup1: TMenuItem;
    Help1: TMenuItem;
    About1: TMenuItem;
    Bevel1: TBevel;
    Bevel2: TBevel;
    Panel2: TPanel;
    ListView1: TListView;
    ImageList1: TImageList;
    agRas1: TagRas;
    procedure ExitButtonClick(Sender: TObject);
    procedure SendButtonClick(Sender: TObject);
    procedure CancelButtonClick(Sender: TObject);
    procedure SetupButtonClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure AttachButtonClick(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure msSMTP1Cancel(Sender: TObject);
    procedure msSMTP1Closing(Sender: TObject);
    procedure msSMTP1MailSent(Sender: TObject);
    procedure msSMTP1Open(Sender: TObject);
    procedure msSMTP1Prepare(Sender: TObject);
    procedure msSMTP1Sending(Sender: TObject);
    procedure msSMTP1Closed(Sender: TObject);
    procedure About1Click(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure msSMTP1Error(Sender: TObject; var Msg: string);
    procedure msSMTP1Progress(Sender: TObject; Perc: Integer;
      Transferred: Longint);
  private
    { Private declarations }
    IniName : string;
    procedure EnableControls;
    procedure DisableControls;
    procedure AddFileToListView(const FileName : string);
  protected
    procedure WMDropFiles(var Msg : TMessage); message WM_DROPFILES;
  public
    { Public declarations }
  end;

var
  SMTPForm: TSMTPForm;

implementation

uses msabout;

{$R *.DFM}

procedure TSMTPForm.EnableControls;
var
  i : Integer;
  SB : TSpeedButton;
begin
  for i:=0 to ToolBar.ControlCount-1 do
  if ToolBar.Controls[i] is TSpeedButton then
  begin
    SB:=ToolBar.Controls[i] as TSpeedButton;
    SB.Enabled:=SB.Tag<>1;
  end;
  ListView1.Enabled:=true;
  Send1.Enabled:=true;
  Cancel1.Enabled:=false;
  Attach1.Enabled:=true;
  Exit1.Enabled:=true;
  Setup1.Enabled:=true;
  Help1.Enabled:=true;
  SendInfoPanel.Enabled:=true;
  ProgressBar1.Visible:=false;
  BodyMemo.Enabled:=true;
  Cursor:=crDefault;
  ListView1.Cursor:=crDefault;
end;

procedure TSMTPForm.DisableControls;
var
  i : Integer;
  SB : TSpeedButton;
begin
  for i:=0 to ToolBar.ControlCount-1 do
  if ToolBar.Controls[i] is TSpeedButton then
  begin
    SB:=ToolBar.Controls[i] as TSpeedButton;
    SB.Enabled:=SB.Tag=1;
  end;
  ListView1.Enabled:=false;
  Send1.Enabled:=false;
  Cancel1.Enabled:=true;
  Attach1.Enabled:=false;
  Exit1.Enabled:=false;
  Setup1.Enabled:=false;
  Help1.Enabled:=false;
  SendInfoPanel.Enabled:=false;
  ProgressBar1.Visible:=true;
  BodyMemo.Enabled:=false;
  Cursor:=crHourGlass;
  ListView1.Cursor:=crHourGlass;
end;

procedure TSMTPForm.ExitButtonClick(Sender: TObject);
begin
  Close;
end;

procedure TSMTPForm.SendButtonClick(Sender: TObject);
var
  i : Integer;
begin
  msMessage1.Recipients.Clear;
  msMessage1.Recipients.AddAddress(ToEdit.Text,'');
  msMessage1.Subject:=SubjectEdit.Text;
  msMessage1.Body:=BodyMemo.Lines;
  msMessage1.Attachments.Clear;
  for i:=0 to ListView1.Items.Count-1 do
    msMessage1.Attachments.AddFile(ListView1.Items[i].Caption);
  DisableControls;
  try
    msSMTP1.Send;
  finally
    EnableControls;
  end;
end;

procedure TSMTPForm.CancelButtonClick(Sender: TObject);
begin
  msSMTP1.Cancel;
end;

procedure TSMTPForm.SetupButtonClick(Sender: TObject);
begin
  with TSetupDlg.Create(Self) do
  try
    ServerEdit.Text:=msSMTP1.Server;
    UserAddressEdit.Text:=msMessage1.Sender.Address;
    UserNameEdit.Text:=msMessage1.Sender.Name;
    LogFileNameEdit.Text:=msSMTP1.LogFileName;
    CharSetComboBox.ItemIndex:=Ord(msMessage1.CharSet);
    EncodingComboBox.ItemIndex:=Ord(msMessage1.Encoding);
    ShowModal;
    if ModalResult=mrOk then
    begin
      msSMTP1.Server:=ServerEdit.Text;
      msMessage1.Sender.Address:=UserAddressEdit.Text;
      msMessage1.Sender.Name:=UserNameEdit.Text;
      msSMTP1.LogFileName:=LogFileNameEdit.Text;
      msMessage1.CharSet:=TCharSet(CharSetComboBox.ItemIndex);
      msMessage1.Encoding:=TMsgEncoding(EncodingComboBox.ItemIndex);
    end;
  finally
    free;
  end;
end;

procedure TSMTPForm.FormCreate(Sender: TObject);
begin
  IniName:=ChangeFileExt(Application.ExeName,'.ini');
  with TIniFile.Create(IniName) do
  try
    msSMTP1.Server:=ReadString('Setup','Server','');
    msMessage1.Sender.Address:=ReadString('Setup','EMail Address','');
    msMessage1.Sender.Name:=ReadString('Setup','Name','');
    msSMTP1.LogFileName:=ReadString('Setup','Log File','');
    msMessage1.CharSet:=TCharSet(ReadInteger('Setup','CharSet',0));
    msMessage1.Encoding:=TMsgEncoding(ReadInteger('Setup','Encoding',0));
  finally
    free;
  end;
  DragAcceptFiles(Handle,true);
end;

procedure TSMTPForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  with TIniFile.Create(IniName) do
  try
    WriteString('Setup','Server',msSMTP1.Server);
    WriteString('Setup','EMail Address',msMessage1.Sender.Address);
    WriteString('Setup','Name',msMessage1.Sender.Name);
    WriteString('Setup','Log File',msSMTP1.LogFileName);
    WriteInteger('Setup','CharSet',Ord(msMessage1.CharSet));
    WriteInteger('Setup','Encoding',Ord(msMessage1.Encoding));
  finally
    free;
  end;
end;

procedure TSMTPForm.AttachButtonClick(Sender: TObject);
var
  i : Integer;
begin
  with TOpenDialog.Create(Self) do
  try
    Filter:='All Files (*.*)|*.*';
    Options:=[ofHideReadOnly,ofAllowMultiSelect];
    if Execute then
    begin
      for i:=0 to Files.Count-1 do
        AddFileToListView(Files[i]);
    end;
  finally
    Free;
  end;
end;

procedure TSMTPForm.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
  if not SendInfoPanel.Enabled then
  begin
    MessageDlg('Transfer in Progress.  Click Cancel button first.',
               mtError,[mbOk],0);
    CanClose:=false;
  end
  else
    CanClose:=true;
end;

procedure TSMTPForm.msSMTP1Cancel(Sender: TObject);
begin
  StatusBar1.Panels[0].Text:='Operation has been canceled';
end;

procedure TSMTPForm.msSMTP1Closing(Sender: TObject);
begin
  StatusBar1.Panels[0].Text:='Closing connection';
end;

procedure TSMTPForm.msSMTP1MailSent(Sender: TObject);
begin
  StatusBar1.Panels[0].Text:='Message has been sent';
  ProgressBar1.Position:=0;
  MessageBeep(MB_ICONASTERISK);
end;

procedure TSMTPForm.msSMTP1Open(Sender: TObject);
begin
  StatusBar1.Panels[0].Text:='Opening connection';
end;

procedure TSMTPForm.msSMTP1Prepare(Sender: TObject);
begin
  StatusBar1.Panels[0].Text:='Preparing message';
end;

procedure TSMTPForm.msSMTP1Sending(Sender: TObject);
begin
  StatusBar1.Panels[0].Text:='Sending message';
end;

procedure TSMTPForm.msSMTP1Closed(Sender: TObject);
begin
  StatusBar1.Panels[0].Text:='Connection closed';
end;

procedure TSMTPForm.About1Click(Sender: TObject);
begin
  with TAboutDlg.Create(Self) do
  try
    ProgramName.Caption:='TmsSMTP Component Demo';
    ProductVersion.Caption:=msVersion;
    ShowModal;
  finally
    Free;
  end;
end;

procedure TSMTPForm.FormResize(Sender: TObject);
begin
  Bevel1.Width:=Width;
  Bevel2.Width:=Width;
end;

procedure TSMTPForm.AddFileToListView(const FileName : string);
var
  Item : TListItem;
  Icon : TIcon;
  j : word;
begin
  Item:=ListView1.Items.Add;
  Item.Caption:=FileName;
  Icon:=TIcon.Create;
  j:=0;
  Icon.Handle:=ExtractAssociatedIcon(hInstance,PChar(FileName),j);
  if Icon.Handle<>0 then
    Item.ImageIndex:=ImageList1.AddIcon(Icon);
end;

procedure TSMTPForm.WMDropFiles(var Msg : TMessage);
var
  FileName : PChar;
  Drop : THandle;
begin
  Drop:=THandle(Msg.wParam);
  FileName:=StrAlloc(255);
  try
    DragQueryFile(Drop,0,FileName,255);
    AddFileToListView(StrPas(FileName));
  finally
    StrDispose(FileName);
    DragFinish(Drop);
  end;
end;

procedure TSMTPForm.msSMTP1Error(Sender: TObject; var Msg: string);
begin
  StatusBar1.Panels[0].Text:=Msg;
end;

procedure TSMTPForm.msSMTP1Progress(Sender: TObject; Perc: Integer;
  Transferred: Longint);
begin
  ProgressBar1.Position:=Perc;
end;

end.
