unit whmain;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  agsocket, agwhois, StdCtrls, Buttons, ComCtrls, ExtCtrls;

type
  TWhoIsForm = class(TForm)
    Panel1: TPanel;
    StatusBar1: TStatusBar;
    Label1: TLabel;
    QueryEdit: TEdit;
    SendQueryButton: TSpeedButton;
    CancelButton: TSpeedButton;
    Memo1: TMemo;
    agWhoIs1: TagWhoIs;
    procedure agWhoIs1Cancel(Sender: TObject);
    procedure agWhoIs1Closed(Sender: TObject);
    procedure agWhoIs1Error(Sender: TObject; var Msg: string);
    procedure agWhoIs1Open(Sender: TObject);
    procedure SendQueryButtonClick(Sender: TObject);
    procedure agWhoIs1SendingQuery(Sender: TObject);
    procedure agWhoIs1Progress(Sender: TObject; Perc: Integer;
      Transferred: Longint);
  private
    { Private declarations }
    procedure EnableControls;
    procedure DisableControls;
  public
    { Public declarations }
  end;

var
  WhoIsForm: TWhoIsForm;

implementation

{$R *.DFM}

procedure TWhoIsForm.agWhoIs1Cancel(Sender: TObject);
begin
  StatusBar1.SimpleText:='Operation has been canceled';
end;

procedure TWhoIsForm.agWhoIs1Closed(Sender: TObject);
begin
  StatusBar1.SimpleText:='Connection closed';
end;

procedure TWhoIsForm.agWhoIs1Error(Sender: TObject; var Msg: string);
begin
  StatusBar1.SimpleText:=Msg;
end;

procedure TWhoIsForm.agWhoIs1Open(Sender: TObject);
begin
  StatusBar1.SimpleText:='Opening connection';
end;

procedure TWhoIsForm.EnableControls;
begin
  QueryEdit.Enabled:=true;
  SendQueryButton.Enabled:=true;
  CancelButton.Enabled:=false;
end;

procedure TWhoIsForm.DisableControls;
begin
  QueryEdit.Enabled:=false;
  SendQueryButton.Enabled:=false;
  CancelButton.Enabled:=true;
end;

procedure TWhoIsForm.SendQueryButtonClick(Sender: TObject);
begin
  agWhoIs1.Query:=QueryEdit.Text;
  Memo1.Clear;
  DisableControls;
  try
    agWhoIs1.Execute;
    Memo1.Lines.LoadFromStream(agWhoIs1.InStream);
  finally
    EnableControls;
  end;
end;

procedure TWhoIsForm.agWhoIs1SendingQuery(Sender: TObject);
begin
  StatusBar1.SimpleText:='Sending query';
end;

procedure TWhoIsForm.agWhoIs1Progress(Sender: TObject; Perc: Integer;
  Transferred: Longint);
begin
  StatusBar1.SimpleText:=IntToStr(Transferred)+' bytes received';
end;

end.
