unit nntpmain;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, agsocket, msmb, msnntp, msmsg, ExtCtrls, ComCtrls, ShellAPI,
  msUtils, Menus, Buttons, agTypes, IniFiles, msMsgCls;

type
  TNNTPForm = class(TForm)
    msNNTP: TmsNNTP;
    msArticle1: TmsArticle;
    ListView1: TListView;
    StatusBar1: TStatusBar;
    Panel1: TPanel;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Setup1: TMenuItem;
    Help1: TMenuItem;
    About1: TMenuItem;
    RetrieveHeaders1: TMenuItem;
    RetrieveArticles1: TMenuItem;
    Post1: TMenuItem;
    N1: TMenuItem;
    Exit1: TMenuItem;
    Cancel1: TMenuItem;
    Bevel1: TBevel;
    HeadersButton: TSpeedButton;
    ArticleButton: TSpeedButton;
    CancelButton: TSpeedButton;
    SetupButton: TSpeedButton;
    ExitButton: TSpeedButton;
    Bevel2: TBevel;
    NGEdit: TEdit;
    PostButton: TSpeedButton;
    N2: TMenuItem;
    ArGoSoftHomepage1: TMenuItem;
    procedure msNNTPNextHeaderRetrieved(Sender: TObject; Num: Integer);
    procedure NGEditExit(Sender: TObject);
    procedure PostButtonClick(Sender: TObject);
    procedure msNNTPPosted(Sender: TObject);
    procedure msNNTPCancel(Sender: TObject);
    procedure msNNTPClosed(Sender: TObject);
    procedure msNNTPOpen(Sender: TObject);
    procedure msNNTPError(Sender: TObject; var Msg: string);
    procedure msNNTPArticleRetrieved(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure msNNTPGroupSelected(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure ExitButtonClick(Sender: TObject);
    procedure About1Click(Sender: TObject);
    procedure ArticleButtonClick(Sender: TObject);
    procedure SetupButtonClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure HeadersButtonClick(Sender: TObject);
    procedure NGEditChange(Sender: TObject);
    procedure CancelButtonClick(Sender: TObject);
    procedure msNNTPPosting(Sender: TObject);
    procedure msNNTPLastHeaderRetrieved(Sender: TObject);
    procedure ArGoSoftHomepage1Click(Sender: TObject);
    procedure msNNTPProgress(Sender: TObject; Perc, Transferred: Integer);
  private
    { Private declarations }
    IniFileName : string;
    UserName : string;
    UserAddress : string;
    HdrStep : Integer;
    Encoding : TMsgEncoding;
    CharSet : TCharSet;
    Posting : boolean;
    procedure EnableControls;
    procedure DisableControls;
  public
    { Public declarations }
  end;

var
  NNTPForm: TNNTPForm;

implementation

uses nntppst, popview, msabout, nntpsu;

{$R *.DFM}

procedure TNNTPForm.DisableControls;
begin
  HeadersButton.Enabled:=false;
  RetrieveHeaders1.Enabled:=false;
  ArticleButton.Enabled:=false;
  RetrieveArticles1.Enabled:=false;
  PostButton.Enabled:=false;
  Post1.Enabled:=false;
  CancelButton.Enabled:=true;
  Cancel1.Enabled:=true;
  SetupButton.Enabled:=false;
  Setup1.Enabled:=false;
  ExitButton.Enabled:=false;
  Exit1.Enabled:=false;
  Help1.Enabled:=false;
  ListView1.Cursor:=crHourGlass;
  NGEdit.Enabled:=false;
end;

procedure TNNTPForm.EnableControls;
begin
  HeadersButton.Enabled:=true;
  RetrieveHeaders1.Enabled:=true;
  ArticleButton.Enabled:=true;
  RetrieveArticles1.Enabled:=true;
  PostButton.Enabled:=true;
  Post1.Enabled:=true;
  CancelButton.Enabled:=false;
  Cancel1.Enabled:=true;
  SetupButton.Enabled:=true;
  Setup1.Enabled:=true;
  ExitButton.Enabled:=true;
  Exit1.Enabled:=true;
  Help1.Enabled:=true;
  NGEdit.Enabled:=true;
  ListView1.Cursor:=crDefault;
end;

procedure TNNTPForm.msNNTPNextHeaderRetrieved(Sender: TObject; Num: Integer);
var
  Item : TListItem;
  Addr, AName, s, TZ : string;
  DT : TDateTime;
begin
  Item:=ListView1.Items.Add;
  Item.Caption:=msNNTP.NewsHeadersList[Num].GetFieldBody('Subject');
  s:=msNNTP.NewsHeadersList[Num].GetFieldBody('From');
  SplitAddress(s,Addr,AName);
  if AName<>'' then s:=AName else s:=Addr;
  Item.SubItems.Add(s);
  s:=msNNTP.NewsHeadersList[Num].GetFieldBody('Date');
  MailDateToDateTime(s,DT,TZ);
  if DT<>0 then
    s:=DateTimeToStr(DT);
  Item.SubItems.Add(s);
  Item.SubItems.Add(msNNTP.NewsHeadersList[Num].GetFieldBody('Lines'));
  StatusBar1.Panels[1].Text:=IntToStr(Num+1)+' headers retrieved';
end;

procedure TNNTPForm.NGEditExit(Sender: TObject);
begin
  if NGEdit.Modified then
  begin
    ListView1.Items.Clear;
    NGEdit.Modified:=false;
    msNNTP.NewsHeadersList.Clear;
  end;
end;

procedure TNNTPForm.PostButtonClick(Sender: TObject);
var
  i : Integer;
begin
  with TArticleForm.Create(Self) do
  try
    NewsGroupsEdit.Text:=NGEdit.Text;
    if ShowModal=mrOK then
    begin
      msArticle1.Clear;
      msArticle1.Sender.Address:=UserAddress;
      msArticle1.Sender.Name:=UserName;
      msArticle1.NewsGroups:=NewsGroupsEdit.Text;
      msArticle1.Subject:=SubjectEdit.Text;
      msArticle1.Encoding:=Encoding;
      msArticle1.CharSet:=CharSet;
      for i:=0 to AttComboBox.Items.Count-1 do
        msArticle1.Attachments.AddFile(AttComboBox.Items[i]);
      msArticle1.Body:=BodyMemo.Lines;
      DisableControls;
      Posting:=true;
      try
        msNNTP.PostArticle;
      finally
        Posting:=false;
        EnableControls;
      end;
    end;
  finally
    Free;
  end;
end;

procedure TNNTPForm.msNNTPPosted(Sender: TObject);
begin
  StatusBar1.Panels[1].Text:='Article has been successfully posted';
end;

procedure TNNTPForm.msNNTPCancel(Sender: TObject);
begin
  StatusBar1.Panels[1].Text:='Oparation has been canceled';
end;

procedure TNNTPForm.msNNTPClosed(Sender: TObject);
begin
  StatusBar1.Panels[1].Text:='Connection closed';
end;

procedure TNNTPForm.msNNTPOpen(Sender: TObject);
begin
  StatusBar1.Panels[1].Text:='Opening connection';
end;

procedure TNNTPForm.msNNTPError(Sender: TObject; var Msg: string);
begin
  StatusBar1.Panels[1].Text:=Msg;
end;

procedure TNNTPForm.msNNTPArticleRetrieved(Sender: TObject);
begin
  StatusBar1.Panels[1].Text:='Article retrieved';
end;

procedure TNNTPForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  msNNTP.CloseConnection;
  with TIniFile.Create(IniFileName) do
  try
    WriteString('Setup','Server',msNNTP.Server);
    WriteString('Setup','EMail Address',UserAddress);
    WriteString('Setup','Name',UserName);
    WriteString('Setup','Log File',msNNTP.LogFileName);
    WriteInteger('Setup','CharSet',Ord(CharSet));
    WriteInteger('Setup','Encoding',Ord(Encoding));
    WriteInteger('Setup','Header Step',HdrStep);
  finally
    Free;
  end;
end;

procedure TNNTPForm.msNNTPGroupSelected(Sender: TObject);
begin
  StatusBar1.Panels[0].Text:='Total articles: '+IntToStr(msNNTP.TotalArticles);
  StatusBar1.Panels[2].Text:=msNNTP.NewsGroup;
end;

procedure TNNTPForm.FormResize(Sender: TObject);
begin
  Bevel1.Width:=Width;
end;

procedure TNNTPForm.ExitButtonClick(Sender: TObject);
begin
  Close;
end;

procedure TNNTPForm.About1Click(Sender: TObject);
begin
  with TAboutDlg.Create(Self) do
  try
    ProgramName.Caption:='msNNTP Component Demo';
    ProductVersion.Caption:=msVersion;
    ShowModal;
  finally
    Free;
  end;
end;

procedure TNNTPForm.ArticleButtonClick(Sender: TObject);
begin
  if ListView1.Selected<>nil then
  begin
    DisableControls;
    try
      msNNTP.RetrieveArticleByNumber(msNNTP.NewsHeadersList[ListView1.Selected.Index].Number);
    finally
      EnableControls;
    end;
    with TMsgViewDlg.Create(Self) do
    try
      MailMessage:=msArticle1;
      ShowModal;
    finally
      Free;
    end;
  end;
end;

procedure TNNTPForm.SetupButtonClick(Sender: TObject);
begin
  with TSetupDlg.Create(Self) do
  try
    ServerEdit.Text:=msNNTP.Server;
    UserAddressEdit.Text:=UserAddress;
    UserNameEdit.Text:=UserName;
    EncodingComboBox.ItemIndex:=Ord(Encoding);
    CharSetComboBox.ItemIndex:=Ord(CharSet);
    LogFileNameEdit.Text:=msNNTP.LogFileName;
    HdrStepEdit.Text:=IntToStr(HdrStep);
    if ShowModal=mrOk then
    begin
      msNNTP.Server:=ServerEdit.Text;
      UserAddress:=UserAddressEdit.Text;
      UserName:=UserNameEdit.Text;
      Encoding:=TMsgEncoding(EncodingComboBox.ItemIndex);
      CharSet:=TCharSet(CharSetComboBox.ItemIndex);
      msNNTP.LogFileName:=LogFileNameEdit.Text;
      try
        HdrStep:=StrToInt(Trim(HdrStepEdit.Text));
      except
        on EConvertError do
          HdrStep:=50
        else raise;
      end;
    end;
  finally
    Close;
  end;
end;

procedure TNNTPForm.FormCreate(Sender: TObject);
begin
  IniFileName:=ChangeFileExt(Application.ExeName,'.ini');
  with TIniFile.Create(IniFileName) do
  try
    msNNTP.Server:=ReadString('Setup','Server','');
    UserAddress:=ReadString('Setup','EMail Address','');
    UserName:=ReadString('Setup','Name','');
    msNNTP.LogFileName:=ReadString('Setup','Log File','');
    CharSet:=TCharSet(ReadInteger('Setup','CharSet',0));
    Encoding:=TMsgEncoding(ReadInteger('Setup','Encoding',0));
    HdrStep:=ReadInteger('Setup','Header Step',50);
  finally
    Free;
  end;
  Posting:=false;
end;

procedure TNNTPForm.HeadersButtonClick(Sender: TObject);
begin
  DisableControls;
  try
    msNNTP.NewsGroup:=NGEdit.Text;
    msNNTP.RetrieveNextNHeaders(HdrStep,true);
  finally
    EnableControls;
  end;
end;

procedure TNNTPForm.NGEditChange(Sender: TObject);
begin
  if msNNTP.NewsHeadersList.Count>0 then
  begin
    msNNTP.NewsHeadersList.Clear;
    ListView1.Items.Clear;
  end;
end;

procedure TNNTPForm.CancelButtonClick(Sender: TObject);
begin
  msNNTP.Cancel;
end;

procedure TNNTPForm.msNNTPPosting(Sender: TObject);
begin
  StatusBar1.Panels[1].Text:='Posting the article...';
end;

procedure TNNTPForm.msNNTPLastHeaderRetrieved(Sender: TObject);
begin
  StatusBar1.Panels[1].Text:='Last available header retrieved';
end;

procedure TNNTPForm.ArGoSoftHomepage1Click(Sender: TObject);
var
  TheHandle : THandle;
begin
  TheHandle:=ShellExecute(Application.Handle,'Open','http://www.argosoft.com',
             nil,nil,SW_SHOW);
  if TheHandle<=HINSTANCE_ERROR then
    raise Exception.Create('Unable to run ShellExec. Error code='+IntToStr(TheHandle));
end;

procedure TNNTPForm.msNNTPProgress(Sender: TObject; Perc,
  Transferred: Integer);
begin
  if not Posting then
    StatusBar1.Panels[1].Text:=IntToStr(Perc)+'% retrieved';
end;

end.
