unit Unit1;

interface

uses
  WinProcs, WinTypes, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  shpbtn, StdCtrls;

type
  TForm1 = class(TForm)
    isShapeButton1: TisShapeButton;
    cbxBtnShape: TComboBox;
    cbxColor: TComboBox;
    cbxBrush: TComboBox;
    Memo1: TMemo;
    procedure cbxBtnShapeChange(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure cbxColorChange(Sender: TObject);
    procedure cbxBrushChange(Sender: TObject);
  private
    procedure AddColor(const s: string);
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}
uses
  TypInfo;

procedure TForm1.cbxBtnShapeChange(Sender: TObject);
var
  tmp: TButtonShape;
begin
  tmp := Low(TButtonShape);
  Inc(tmp, cbxBtnShape.ItemIndex);
  isShapeButton1.ButtonShape := tmp;
end;

procedure TForm1.FormActivate(Sender: TObject);
var
  i: integer;
begin
  cbxBtnShape.ItemIndex := Ord(isShapeButton1.ButtonShape);
  for i := 0 to cbxColor.Items.Count do
    if cbxColor.Items[i] = ColorToString(isShapeButton1.Color) then
      begin
        cbxColor.ItemIndex := i;
        Break;
      end;
  cbxBrush.ItemIndex := Ord(isShapeButton1.BrushStyle);
end;

procedure TForm1.AddColor(const s: string);
begin
  cbxColor.Items.Add(s);
end;

procedure TForm1.FormCreate(Sender: TObject);
var
  i: integer;
  PropInf: PPropInfo;
  col: TColor;
begin
  PropInf := GetPropInfo(isShapeButton1.ClassInfo, 'ButtonShape');
  if PropInf <> nil then
    for i := Ord(Low(TButtonShape)) to Ord(High(TButtonShape)) do
      {$IFDEF VER80}
      cbxBtnShape.Items.Add(GetEnumName(PropInf^.PropType, i)^);
      {$ELSE}
      cbxBtnShape.Items.Add(GetEnumName(PropInf^.PropType, i));
      {$ENDIF}
  GetColorValues(AddColor);
  PropInf := GetPropInfo(isShapeButton1.ClassInfo, 'BrushStyle');
  if PropInf <> nil then
    for i := Ord(Low(TBrushStyle)) to Ord(High(TBrushStyle)) do
      {$IFDEF VER80}
      cbxBrush.Items.Add(GetEnumName(PropInf^.PropType, i)^);
      {$ELSE}
      cbxBrush.Items.Add(GetEnumName(PropInf^.PropType, i));
      {$ENDIF}
end;

procedure TForm1.cbxColorChange(Sender: TObject);
begin
  isShapeButton1.Color := StringToColor(cbxColor.Text);
end;

procedure TForm1.cbxBrushChange(Sender: TObject);
var
  tmp: TBrushStyle;
begin
  tmp := Low(TBrushStyle);
  Inc(tmp, cbxBrush.ItemIndex);
  isShapeButton1.BrushStyle := tmp;
end;

end.
 