{ *************** API Calls used in NWLIB.PAS ****************

  Developed with Novell Inc.'s Client SDK for C SDK Mar 1995-Aug 1996.

  Copyright 1995 by Devont Software Inc. and Jim Tyson.  All
  rights reserved.

  Please read the README.NOW file for important information.
}

  { General Connection Information Interface Structure }
  type
    TNWConnectInfo = record
      serverConnID  : TNWConnHandle ;
      loginDateTime : TDateTime     ;
      treeName,
      internet      : string        ;
      sessionID     : word          ;
      ConnectID     : TNWConnNumber ;
      userID        : string        ;
      serverName    : string        ;
  end;

  {Used by NWParseNetwarePath to obtain ID Elements}
  type
    TNWPathInfo = record
      nServer      : TNWConnHandle ;
      cServer      : string ;
      volumeID     : TNWVolNum ;
      volumeName   : string ;
      dirHandle    : TNWDirHandle ;
      pathOnly     : string ;
      relativePath : string ;
  end;

  {used by getPathInfo/NWParsePath to obtain individual elements}
  type
    TNWParsedPath = record
      nServer      : TNWConnHandle ;
      serverName   : string[40]  ;
      volName      : string[128] ;
      dirPath      : string[128] ;
  end;

  {file attribute flags (embedded in TNWFileAttrInfo)}
  type
    TNWFileFlags = record
      normal       : boolean ;
      readOnly     : boolean ;
      hidden       : boolean ;
      system       : boolean ;
      executeOnly  : boolean ;
      directory    : boolean ;
      needsArchive : boolean ;
      shareable    : boolean ;
  end;
  {extended file attribute flags (embedded in TNWFileAttrInfo)}
  type
    TNWExtendedFileAttributes = record
      transaction   : boolean ;
      indexed       : boolean ;
      readAudit     : boolean ;
      writeAudit    : boolean ;
  end;

  {file information}
  type
    TNWFileAttrInfo = record
      attributes          : TNWFileFlags              ;
      extendedAttrs       : TNWExtendedFileAttributes ;
      fileSize            : TNWFileSize               ;
      creationDate        : TDateTime                 ;
      lastAccessDate      : TDateTime                 ;
      lastUpdateDateTime  : TDateTime                 ;
      ownerName           : string                    ;
      lastArchiveDateTime : TDateTime                 ;
      fileName            : string                    ;
  end;

  type
    TNWMapInfo = record
      nServer     : TNWConnHandle ;
      serverName  : string[40]  ;
      fullPath    : string[128] ;
      driveStatus : word  ;
  end;

  type
    TNWConnectionStats = record
      bytesRead    : longint ;
      bytesWritten : longint ;
      totalPackets : longint ;
    end;

     { Netware Function Declarations }
  function NWInit : Boolean ;
  function whoAmI(nServer : TNWConnHandle) : string ;
  function fullName(nServer : TNWConnHandle ; cUserID : string ) : string ;
  function getObjName(nServer : TNWConnHandle ; nObjID : TObjID) : string ;
  function getObjType(nServer : TNWConnHandle ; cUserID : string) : TObjType ;
  function getObjID(nServer : TNWConnHandle ; cUserID : string; nObjType : TObjType) : string ;
  function getObjNumber(nServer : TNWConnHandle ; cUserID : string; nObjType : TObjType) : TObjID ;
  function getPrimaryServerID : TNWConnHandle ;
  function getConnectID(nServer:TNWConnHandle) : TNWConnHandle ;
  function maxConns : TNWNumber ;
  function sendLineMessage(nServer : TNWConnHandle ; cUserID, cMessageText : string) : boolean ;
  function getBinderyList(nServer : TNWConnHandle ; SearchType : TObjType) : TStringList ;
  function getMemberList(nServer : TNWConnHandle; cGroupName : string ; lSelf : boolean) : TStringList ;
  function isMember(nServer : TNWConnHandle ; cUserID,cGroup : string) : boolean ;
  function isLoggedIn(nServer : TNWConnHandle ; cUserID : string) : boolean ;
  function isConsoleOperator(nServer : TNWConnHandle) : boolean ;
  function isNWManager(nServer : TNWConnHandle) : boolean ;
  function secureEquiv(nServer : TNWConnHandle ; cUserID : string; cEquiv: string) : boolean ;
  function longSwap(nLong : Longint) : longInt ;
  function _nwCopy(inHandle, outHandle : word ) : boolean ;
  function nCopy(infile, outfile : string) : boolean ;
  function isInList(nServer : TNWConnHandle ; clist : string ) : boolean ;
  function getFirstNetDrive : char ;
  function getNextNetDrive  : char ;
  function map(cDrive: char; cPath: string ) : boolean ;
  function mapDelete(cDrive : string) : Boolean ;
  function mapShow : TStringList ;
  function getServerName(nServer : TNWConnHandle) : string ;
  function getServerDate(nServer : TNWConnHandle) : TDateTime ;
  function getServerTime(nServer : TNWConnHandle) : TDateTime ;
  function getConnectedServerList : TStringList ;
  function setPreferredServer(servername : string ;
                              var nServer : TNWConnHandle) : boolean ;
  function NWPassCheck(nServer : TNWConnHandle; cUserID, cPassword : string) : boolean ;
  function sList : TStringList ;
  function getMyGroups(nServer : TNWConnHandle ;
                       cUserID : string) : TStringList ;
  function getConnectInfo(nServer : TNWConnHandle ;
                          nConn   : TNWConnNumber ;
                          var connectInfo : TNWConnectInfo) : boolean ;
  function parseNetwarePath(nServer : TNWConnHandle ;
                            cPath : string;
                            var pathInfo : TNWPathInfo ) : boolean ;
  function setFileAttributes(nServer       : TNWConnHandle ;
                             fileSpec      : string        ;
                             var fileAttrs : TNWFileAttrInfo) : boolean ;
  {1.5 additions}
  function getMapInfo(drive : char ; var mapInfo : TNWMapInfo) : boolean ;
  function getPathInfo(cPath : string; var parsedPath : TNWParsedPath) : boolean ;
  function getNWLibVersion : string ;

  {1.52 additions}
  function convertLocalFileHandle(localFileHandle : TNWFileHandle) : TNWFileHandle ;

  {2.0 Additions}
  function getOpenFileUsers(nServer : TNWConnHandle ;
                            cFile   : string) : TStringList ;
  function getConnOpenFiles(nServer : TNWConnHandle ;
                            nConn   : TNWConnHandle) : TStringList ;
  function castOn(nServer : TNWConnHandle) : boolean ;
  function castOff(nServer : TNWConnHandle) : boolean ;
  function getBroadcastMessage(nServer : TNWConnHandle) : string ;
  function getBroadcastMode(nServer : TNWConnHandle) : TNWCastMode ;
  function setBroadcastMode(nServer : TNWConnHandle ; nMode : TNWCastMode) : boolean ;
  function getAllConnectRefInfo(connRef : TNWConnRef ; var connInfo : NWCCConnInfo) : boolean ;
  function getAllConnectInfo(nServer : TNWConnHandle ; var connInfo : NWCCConnInfo) : boolean ;
  function getUserList(nServer : TNWConnHandle; showNotLoggedIn : boolean) : TStringList ;
  function getConnUsageStats(nServer   : TNWConnHandle ;
                             nConn     : TNWConnHandle ;
                             var stats : TNWConnectionStats) : boolean ;
  function broadcastToConn(nServer : TNWConnHandle ;
                           nConn   : TNWConnHandle ;
                           msgText: string) : boolean ;
  function broadcastToConsole(nServer : TNWConnHandle ;
                              msgText : string) : boolean ;

  {removed 9/96: procedure setCastMode(nConn: TNWConnHandle ; lMode : boolean)}
