{ *************** NDS API Calls for NWLIB ****************

  Developed with Novell Inc.'s Client SDK for C SDK Mar 1995-Aug 1996.

  Copyright 1995 by Devont Software Inc. and Jim Tyson.  All
  rights reserved.

  Please read the README.NOW file for important information.
}

    { ***********  public interface structures ************** }
    type
      TNWDSAttrRights = record   {masks on spec p.39}
        compare    : boolean ;
        read       : boolean ;
        write      : boolean ;
        self       : boolean ;
        supervisor : boolean ;
    end;

    type
      TNWDSEntryRights = record
        browse     : boolean ;
        add        : boolean ;
        delete     : boolean ;
        rename     : boolean ;
        supervisor : boolean ;
    end;

    type
      TNWDSSMSRights = record
        scan       : boolean ;
        backup     : boolean ;
        restore    : boolean ;
        rename     : boolean ;
        delete     : boolean ;
        admin      : boolean ;
    end;

    {Interface Function Declarations}
    function NDSInit : boolean ;
    function NDSClose : boolean ;
    function NDSGetServerDN(nServer : TNWConnHandle) : string ;
    function NDSGetBinderyContextName(nServer : TNWConnHandle) : string ;
    function NDSGetContextName : string ;
    function NDSSetContextName(var context : TNWDSContextHandle ;
                               ctext   : string ) : boolean ;
    function NDSAbbreviateName(cname : string) : string ;
    function NDSExpandName(cname : string) : string ;
    function NDSWhoAmI : string ;
    function NDSLogin(contextName, cname, cPassword : string) : boolean ;
    function NDSLogout : boolean ;
    function NDSPassCheck(contextName,cname, cPassword : string) : boolean ;
    function NDSGetRootName(cobject : string) : string ;
    function NDSFreeContext(context : TNWDSContextHandle) : boolean ;
    function NDSGetContextHandle : TNWDSContextHandle ;
    function NDSCopyContext(inContext : TNWDSContextHandle) : TNWDSContextHandle ;
    function NDSGetObjID(nServer : TNWConnHandle ;
                         cname : string) : string  ;
    function NDSGetObjName(nServer : TNWConnHandle ;
                           objID : TObjID) : string ;
    function NDSGetObjNumber(nServer : TNWConnHandle ;
                             cname : string) : TObjID  ;
    function NDSGetAttrRights(cSource,cTarget : string ;
                         var attrRights : TNWDSAttrRights) : boolean ;
    function NDSGetSMSRights(cSource, cTarget : string ;
                         var smsRights : TNWDSsmsRights) : boolean ;
    function NDSGetEntryRights(cSource, cTarget : string ;
                         var entryRights : TNWDSEntryRights) : boolean ;


    {1.5 additions}
    function NDSConnectToServer(serverName : string) : TNWConnHandle ;
    function NDSisDSServer(nServer : TNWConnHandle) : boolean ;
    function NDSGetServerTreeName(nServer : TNWConnHandle) : string ;
    function NDSSetPreferredTreeName(treeName : string) : boolean ;
    function NDSGetPreferredDSServer : TNWConnHandle ;
    function NDSAttach(serverName : string) : TNWConnHandle ;
    function NDSDetach(nServer : TNWConnHandle) : boolean ;
    function NDSAuthenticateServerConn(nServer : TNWConnHandle) : boolean ;

    {2.0 additions}
    function NDSChangePassword(nServer : TNWConnHandle ;
                               cUserID,
                               newPassword,
                               oldPassword : string) : boolean ;
