{ *************** API Calls used in NWLIB.PAS ****************

  Developed with Novell Inc.'s Client SDK for C SDK Mar 1995-Aug 1996.

  Copyright 1995 by Devont Software Inc. and Jim Tyson.  All
  rights reserved.

  Please read the README.NOW file for important information.
}

    { Capture Flags }
    type
      TNWCaptureFlags = record
        copies      : longint ;
        tabSize     : longint ;
        formType    : longint ;
        timeOut     : longint ;
        description : string     ;
        formName    : string     ;
        banner      : string     ;
        qname       : string     ;
        nServer     : TNWConnHandle ;
        autoEndCap  : boolean       ;
        formFeed    : boolean       ;
        jobNotify   : boolean       ;
    end;

    type TNWQueueJobCtrlFlags = record
      auto_start      : boolean ;
      entry_restart   : boolean ;
      entry_open      : boolean ;
      user_hold       : boolean ;
      operator_hold   : boolean ;
    end;

    type
      TNWQueueJobInfo = record
        nServer         : TNWConnHandle ;
        cQueue          : string        ;
        jobID           : TNWQueueJobID ;
        ownerName       : string        ;
        serverName      : string        ;
        queueServerName : string        ;
        jobFileName     : string        ;
        jobDescription  : string        ;
        workstationID   : longint       ;
        entryDateTime   : TDateTime     ;
        execDateTime    : TDateTime     ;
        jobPosition     : word          ;
        jobFlags        : TNWQueueJobCtrlFlags ;
    end;


    { Interface Function Declarations }
    function endCap(nPort : byte) : boolean ;
    function isCaptured(nPort : byte) : boolean ;
    function setBannerUserName(cBanner : string) : boolean ;
    function getBannerUserName : string ;
    function getMaxPrinters : byte ;
    function capture(nServer: TNWConnHandle ; cQueue: string ;
                             nPort : TNWLpt ;
                             var CaptureFlags : TNWCaptureFlags) : boolean ;
    function getCaptureFlags(nPort : TNWLpt;
                             var captureFlags : TNWCaptureFlags) : boolean  ;
    function setCaptureFlags(nServer : TNWConnHandle;
                             nPort : TNWLpt ;
                             var captureFlags : TNWCaptureFlags) : boolean;
    function getQueueUsers(nServer : TNWConnHandle;
                           cQueue : string) : TStringList ;
    function getQueueOperators(nServer : TNWConnHandle ;
                               cQueue : string) : TStringList ;
    function getQueueServers(nServer : TNWConnHandle ;
                             cQueue : string) : TStringList ;
    {1.5}
    function getQueueJobList(nServer     : TNWConnHandle ;
                             cQueue      : string ;
                             var jobList : TStringList ) : boolean ;
    function getQueueJobNumbers(nServer        : TNWConnHandle ;
                                cQueue         : string ;
                                var jobNumbers : TNWQueueJobList) : boolean ;
    function getQueueJobInfo(var jobInfo : TNWQueueJobInfo) : boolean ;
    function deleteQueueJob(jobInfo : TNWQueueJobInfo) : boolean ;
    function setQueueJobPosition(var jobInfo : TNWQueueJobInfo ;
                                  newPos      : word) : boolean ;
    function setQueueJobInfo(jobInfo : TNWQueueJobInfo) : boolean ;

    {2.0}
    function getPrintServerCfgList(nServer : TNWConnHandle ;
                                   printServerName : string ;
                                   useNDS : boolean) : TStringList ;
    function isQueueOperator(nServer : TNWConnHandle ;
                             cQueue,
                             cUser  : string) : boolean ;
