{ *************** NWProp Component Functions ****************

  Developed with Novell Inc.'s Client SDK for C SDK Mar 1995-Aug 1996.

  Copyright 1995 by Devont Software Inc. and Jim Tyson.  All
  rights reserved.

  Please read the README.NOW file for important information.
}

  type
    LoginControl = record
      accountExpiresDate       : TDateTime ;
      accountExpired           : boolean   ;
      passwordExpiresDate      : TDateTime ;
      graceLogins              : byte ;
      expirationInterval       : word ;
      graceReset               : byte ;
      minPasswordLength        : byte ;
      maxConcurrentConnections : word ;
      timeBitMap               : array[1..42] of byte ;
      lastLoginDate            : TDateTime ;
      restrictionFlags         : byte      ;
      maxDiskBlocks            : longint   ;
      badLoginCount            : word      ;
      nextResetTime            : longint   ;
      badStationAddress        : string    ;
  end;

  {General Rights Structure}
  type
    TNWRights = record
      supervisor    : boolean ;
      read          : boolean ;
      open          : boolean ; { Netware 2.x only }
      write         : boolean ;
      create        : boolean ;
      erase         : boolean ;
      modify        : boolean ;
      filescan      : boolean ; { Netware 2.x = Search }
      accessControl : boolean ;
  end;


  { ************** Public Functions *************** }
  function deleteTrusteeRight(nServer    : TNWConnHandle ;
                              cUserName  : string        ;
                              cVolume    : string        ;
                              cPath      : string) : boolean ;

  function modifyTrusteeRights(nServer    : TNWConnHandle ;
                               cUserName  : string        ;
                               cVolName   : string        ;
                               cPath      : string        ;
                               rightsList : TNWRights) : boolean ;

  function changeNWPassword(nServer : TNWConnHandle ;
                            cUserID,
                            cPassword,
                            cOldPassword : string) : boolean ;

  function createObject(nServer       : TNWConnHandle ;
                       objName       : string        ;
                       objType       : TObjType      ;
                       fullName      : string        ;
                       password      : string        ;
                       permanent     : boolean       ;
                       readSecurity  : byte          ;
                       writeSecurity : byte) : boolean ;

  function createProperty(
                       nServer       : TNWConnHandle ;
                       objName       : string        ;
                       objType       : TObjType      ;
                       propName      : string        ;
                       objTypeFlag   : TNWFlags      ;
                       permanent     : boolean       ;
                       readSecurity  : TNWFlags      ;
                       writeSecurity : TNWFlags) : boolean ;

  function writeItemProperty(
                       nServer       : TNWConnHandle ;
                       objName       : string ;
                       objType       : TObjType ;
                       propName      : string ;
                       value         : string) : boolean ;

  function renameObject(
                       nServer       : TNWConnHandle ;
                       oldName       : string ;
                       newName       : string ;
                       objType       : TObjType) : boolean ;

  function deleteObject(
                       nServer       : TNWConnHandle ;
                       objName       : string) : boolean ;

  function addObjectToSet(
                       nServer       : TNWConnHandle ;
                       objName       : string ;
                       propName      : string ;
                       memName       : string) : boolean ;

  function changeObjectSecurity(
                       nServer       : TNWConnHandle ;
                       objName       : string ;
                       readSecurity  : TNWFlags ;
                       writeSecurity : TNWFlags) : boolean ;

  function deleteObjectFromSet(
                       nServer       : TNWConnHandle ;
                       objName       : string ;
                       propName      : string ;
                       memName       : string) : boolean ;

  function deleteProperty(
                        nServer    : TNWConnHandle ;
                        objName    : string ;
                        propName   : string) : boolean ;

  function changePropertySecurity(
                       nServer       : TNWConnHandle ;
                       objName       : string ;
                       propName      : string ;
                       readSecurity  : TNWFlags ;
                       writeSecurity : TNWFlags) : boolean ;

  function getObjectInfo(
                       nServer           : TNWConnHandle ;
                       inObject          : string ;
                       var hasProperties : boolean ;
                       var readSecurity  : TNWFlags ;
                       var writeSecurity : TNWFlags) : boolean ;


  procedure compareObjectAccessRights(
                       nServer           : TNWConnHandle ;
                       targetObject      : string   ;
                       var canRead       : boolean  ;
                       var canWrite      : boolean) ;

  function getPropertyList(
                       nServer           : TNWConnHandle ;
                       objectName        : string ;
                       searchValue       : string) : TStringList ;

  function getTrusteeList(nServer : TNWConnHandle ;
                          cUserID : string) : TStringList ;

  function addUserToGroup(nServer : TNWConnHandle ;
                          cGroup  : string ;
                          cUser   : string ) : boolean ;

  function deleteUserFromGroup(nServer : TNWConnHandle ;
                               cGroup  : string ;
                               cUser   : string ) : boolean ;

  function getEffectiveRights(nServer : TNWConnHandle ;
                              cPath   : string ;
                              var dirRights : TNWRights) : boolean ;

  function getObjectDirRights(nServer : TNWConnHandle ;
                              cUserID : string ;
                              cPath   : string ;
                              var rightsList : TNWRights) : boolean ;
