{ *************** API Calls used in NWLIB.PAS ****************

  Developed with Novell Inc.'s Client SDK for C SDK Mar 1995-Aug 1996.

  Copyright 1995 by Devont Software Inc. and Jim Tyson.  All
  rights reserved.

  Please read the README.NOW file for important information.
}

  type {publish these types}
    TNWFSE_FILE_SERVER_INFO = NWFSE_FILE_SERVER_INFO  ;
    TNWDIR_SPACE_INFO       = DIR_SPACE_INFO ;

  {object disk usage record}
  type
     TNWDiskUsageStats = record
       usedDirectories : longint ;
       usedFiles       : longint ;
       usedBlocks      : longint ;
    end;

  {File/Directory Inherited Rights List}
  type
    TNWInheritedRightsList = record
      read          : boolean ;
      write         : boolean ;
      open          : boolean ;
      create        : boolean ;
      delete        : boolean ;
      owner         : boolean ;
      accessControl : boolean ;
      fileScan      : boolean ;
      search        : boolean ;
      modify        : boolean ;
      all           : boolean ;
      supervisor    : boolean ;
      normal        : boolean ;
   end;

  { General File Information Interface Structure }
  type
    TNWFileInfo = record
      name              : string        ;
      updatedBy         : string        ;
      updatedDateTime   : TDateTime     ;
      ownerID           : string        ;
      lastArchivedBy    : string        ;
      creationdate      : TDateTime     ;
      lastArchiveDate   : TDateTime     ;
      lastAccessDate    : TDateTime     ;
      lastModifyDate    : TDateTime     ;
      fileSize          : longint       ;
      inheritedRights   : TNWInheritedRightsList ;
      maximumSpace      : TNWDirSpace   ;  { space left in directory }
      attributes        : TNWAttributes ;  { change to attributes record (normal, hidden, etc.)}
      flags             : TNWFlags      ;
      nameSpace         : TNWNameSpace  ;
      nameLength        : TNWNameLen    ;
  end;

  { Purged File Information }
  type
    TNWDeletedFileInfo = record
      attributes       : TNWAttributes ;
      flags            : TNWFlags      ;
      nameSpace        : TNWNameSpace  ;
      nameLength       : TNWNameLen    ;
      name             : string        ;
      creationDate     : TDateTime     ;
      ownerID          : string        ;
      lastArchiveDate  : TDateTime     ;
      lastArchivedBy   : string        ;
      updateDateTime   : TDateTime     ;
      updatedBy        : string        ;
      fileSize         : longint       ;
      inheritedRights  : TNWInheritedRightsList ;
      lastAccessDate   : TDateTime     ;
      deletedDateTime  : TDateTime     ;
      deletedBy        : string        ;
  end;

  { General Connection Statistics Structure }
  type
    TNWConnStats = record
      loginTime      : TDateTime     ;
      bytesRead      : TNWNumBytes   ;
      bytesWritten   : TNWNumBytes   ;
      totalRequests  : TNWNumPackets ;
      recordLocks    : TNWNumPackets ;
      fileLocks      : TNWNumPackets ;
      expirationTime : TDateTime   ;
  end;

  { General Server Stats Interface Structure some 4.0 only }
  type
    TNWServerInfo = record
      serverName        : string ;
      serverUpTime      : TNWSysTime  ;    {4.0}
      processor         : byte ;
      numprocs          : byte ;
      utilization       : byte ;           {4.0}
      totalmemory       : TNWNum ;
      freememory        : TNWNum ;
      PacketsIn         : TNWNumPackets ;  {4.0}
      packetsOut        : TNWNumPackets ;  {4.0}
      version           : string ;
      maxConns          : TNWNumber ;
      ConnsInUse        : TNWNumber ;
      maxConnsUsed      : TNWNumber ;
      numVolumes        : TNWNumber ;
      sftLevel          : TNWSupportLevel ;
      ttsLevel          : TNWSupportLevel ;
  end;


  { Memory Cache Interface Structure - Netware 4.0 Only }
  type TNWMemCacheInfo = record
     serverUpTime               : TNWSysTime ;
     writeBlockCount            : longint ;
     diskWriteCount             : longint ;
     writeErrorCount            : longint ;
     numCacheHits               : longint ;
     numDirtyCacheHits          : longint ;
     cacheDirtyWaitTime         : longint ;
     cacheMaxConcurrentWrites   : longint ;
     maxDirtyTime               : longint ;
     DirCacheBuffers            : longint ;
     maxByteCount               : longint ;
     minCacheBuffers            : longint ;
  end;


    { public Functions }
    function disableLogins(nServer : TNWConnHandle) : boolean ;
    function enableLogins(nServer : TNWConnHandle) : boolean ;
    function downServer(nServer : TNWConnHandle) : boolean ;
    function NWLogin(cServer,cUserID,cPassword : string ;
                     nObjType : TObjType) : boolean ;
    function NWLogout(nServer : TNWConnHandle) : boolean ;
    function getServerHandle(cServer : string) : TNWConnHandle ;
    function getServerSerial(cServer : string) : TNWSerial ;
    function getVolFileList(srchText : string) : TStringList ;
    function getDeletedFileInfo(inFile   : string;
                                var deletedFileInfo : TNWDeletedFileInfo) : boolean ;
    function getFileInfo(infile : string;
                         var fileInfo : TNWFileInfo) : boolean ;
{4} function getCacheInfo(nServer : TNWConnHandle;
                      var cacheInfo : TNWMemCacheInfo) : boolean ;
{2} function getFileSysStats(nServer : TNWConnHandle ; var FileSysInfo : FILESYS_STATS) : boolean ;
{2} function getDiskCacheStats(nServer : TNWConnHandle;
                     var cacheInfo : DSK_CACHE_STATS) : boolean ;
{2} function volInfo(nServer : TNWConnHandle ; volume : string ;
                     var volumeInfo : VOL_STATS) : boolean ;
    function getVolumes(nServer : TNWConnHandle) : TStringList ;
{4} function getServerStats(nServer : TNWConnHandle ;
                     var serverStats : TNWServerInfo) : boolean ;
    function getDeletedFileList(nServer : TNWConnHandle;
                     cpath : string) : TStringList ;
    function salvage(nServer : TNWConnHandle;
                     inFile  : string ;
                     outFile : string) : boolean ;
{4} function getUserStats(nServer : TNWConnHandle ;
                     nConn : TNWConnNumber ;
                     var connStats : TNWConnStats) : boolean ;
    function getUserConnList(nServer : TNWConnHandle ;
                     cUserID : string ;
                     var nConns : word ;
                     var connList : TConnList) : boolean  ;
    function getServerHandleFromPath(cPath : string) : TNWConnHandle ;
    function nwDateTimeToTDateTime(datein : TNWDateTime) : TDateTime ;
    function setServerDateTime(nServer : TNWConnHandle ; dt : TDateTime) : boolean ;

    {1.5 additions}
    function createSemaphore(nServer       : TNWConnHandle ;
                             semaphoreName : string   ;
                             maxInstances : word ) : TNWSemaHandle  ;
    function decSemaValue(nServer    : TNWConnhandle ;
                          semaHandle : TNWSemaHandle ;
                          amount     : word) : boolean ;
    function incSemaValue(nServer    : TNWConnHandle ;
                          semaHandle : TNWSemaHandle ;
                          amount     : word) : boolean ;

    function freeSemaphore(nServer    : TNWConnHandle ;
                           semaHandle : TNWSemaHandle) : boolean ;
    function querySemaphore(nServer      : TNWConnHandle ;
                          semaHandle   : TNWSemaHandle ;
                          var semaValue : word) : word;   {returns open station count}
    function serverLoginOK(nServer : TNWConnHandle) : boolean ;

    function attach(serverName : string) : TNWConnHandle ;

    {2.0 Additions}
    function getVolBlockInfo(nServer : TNWConnHandle ;
                             volNum  : TNWVolNum ;
                             var volBlockInfo : DIR_SPACE_INFO) : boolean ;
    function getServerInformation(nServer : TNWConnHandle; { Netware 4.x Only }
                                  var serverStats : TNWFSE_FILE_SERVER_INFO) : boolean ;
    function getDiskUtilization(nServer : TNWConnHandle ;
                                userID  : string ;
                                volNum  : byte ;
                                var diskStats : TNWDiskUsageStats) : boolean ;
    function getDirTrustees(nServer : TNWConnHandle ;
                            cPath : string) : TStringList ;
