unit Nds;

interface

uses 
     SysUtils,
     WinTypes, 
     WinProcs, 
     Classes, 
     Graphics, 
     Forms, 
     dialogs,
     Controls, 
     Buttons,
     StdCtrls, 
     ExtCtrls, 
     Nwtools, 
     Nwnds, 
     Nwlib;

type
  TwinNDS = class(TForm)
    cancelBtn: TBitBtn;
    Bevel1: TBevel;
    Label1: TLabel;
    NDScontext: TEdit;
    NWNDS1: TNWNDS;
    NWTools1: TNWTools;
    binderyContext: TEdit;
    Label2: TLabel;
    NWLib1: TNWLib;
    serverDN: TEdit;
    Label3: TLabel;
    Label4: TLabel;
    loginBtn: TButton;
    logoutBtn: TButton;
    root: TEdit;
    Label5: TLabel;
    myinfo: TMemo;
    attachBtn: TButton;
    procedure FormShow(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure loginBtnClick(Sender: TObject);
    procedure logoutBtnClick(Sender: TObject);
    procedure attachBtnClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  winNDS: TwinNDS;

implementation

{$R *.DFM}

var
  contextHandle : TNWDSContextHandle ;

procedure TwinNDS.FormShow(Sender: TObject);
  var
    nserver     : TNWConnHandle    ;
    attrRights  : TNWDSAttrRights  ;
    entryRights : TNWDSEntryRights ;
    smsRights   : TNWDSSMSRights   ;
  begin
    if ndsInit then
      begin
        contextHandle       := ndsGetContextHandle ;
        binderyContext.text := ndsGetBinderyContextName(getPrimaryServerID) ;
        serverDN.text       := ndsGetServerDN(getPrimaryServerID) ;
        root.text           := ndsGetRootName(ndsWhoAmI) ;
        ndscontext.text     := ndsGetContextName ;

        myInfo.lines.clear ;
        myInfo.lines.add(ndsWhoAmI) ;
        myInfo.lines.add(ndsAbbreviateName(whoAmI(0))) ;
        myInfo.lines.add(ndsGetObjID(0,ndsWhoAmI)) ;
      end
    else
      alertBox('Novell Directory Services Not Installed') ;
  end;

procedure TwinNDS.FormClose(Sender: TObject; var Action: TCloseAction);
  begin
    { must shut down nds communications ... else memory leaks! }
    ndsFreeContext(contextHandle) ;
    ndsClose;
  end;

procedure TwinNDS.loginBtnClick(Sender: TObject);
  var
    cpass,
    cUserID,
    contextName : string ;
  begin
    contextName := padR(ndsGetContextName,32,' ') ;
    cUserID     := padR(ndsWhoAmI,32,' ') ;
    cpass       := space(32) ;
    if inputQuery('NDS Login','Type Context String:',contextName) and
       inputQuery('NDS Login','Type Your Login ID:',cUserID) and
       inputQuery('NDS Login','Type Your Password:',cpass) then
      begin
        if ndsPassCheck(contextName,cUserID,cpass) and     { in case already logged in, } 
           ndsLogin(contextName,cUserID,cpass) then  { doesn't kill login on bad attempt}
          begin
            logoutBtn.enabled := True ;
            okBox('Login OK!') ;
          end
        else
          alertBox('Incorrect UserID/Password;;Try Again') ;
      end;
  end;

procedure TwinNDS.logoutBtnClick(Sender: TObject);
  begin
    if YesNoBox('Logging Out;;Are You Sure?') and
       ndsLogout then
      begin
        logoutBtn.enabled := False ;
        okBox('logged out!') ;
      end
    else
      alertBox('You Are Still Logged In') ;
  end;

procedure TwinNDS.attachBtnClick(Sender: TObject);
  var
    ctext : string ;
  begin
    ctext := getServerName(0) ;
    if inputQuery('Attach to DS Server','Type Server Name:',ctext) then
      if (ndsAttach(ctext) > 0) then
        okbox(ctext + ';Attached and Authenticated Successfully') 
      else
        alertBox('Error Attaching to Server!') ;

  end;

end.
