
{*******************************************************}
{                                                       }
{       Delphi Visual Component Library                 }
{                                                       }
{       Copyright (c) 1996 Laurent PINARD     					}
{                                                       }
{*******************************************************}

unit PicComboBox;

{$R-}

interface

uses Windows, Messages, SysUtils, Classes, Controls, Graphics, Forms,
  Menus, StdCtrls, Buttons;


type

	TPicComboBox = class;
  TPicComboBoxItem = class;

  TNum = class(TObject)
  	Num : integer
  end;

	{ TImageIndex }
	TPicComboBoxItem = class(TPersistent)
  private
  	FCaption: string;
    FImageIndex : integer;
  public
    property Caption: string read FCaption write FCaption;
    property ImageIndex: integer read FImageIndex write FImageIndex;
  end;

	{ TPicComboBox }
 	TPicComboBox = class(TCustomComboBox)
  private
    procedure CMFontChanged(var Message: TMessage); message CM_FONTCHANGED;
    procedure ResetItemHeight;
    function GetItem(Index: Integer): TPicComboBoxItem;
    procedure SetItem(Index: Integer; Value: TPicComboBoxItem);

  protected
    FOnChange: TNotifyEvent;
    FImages : TImageList;
    FItem : TPicComboBoxItem;
    procedure SetImages(Value: TImageList);
    procedure DrawItem(Index: Integer; Rect: TRect; State: TOwnerDrawState); override;
    procedure Change; dynamic;

  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    property Text;
    property Item[Index: Integer]: TPicComboBoxItem read GetItem write SetItem; default;

  published
    function Add(S : String; I : Integer) : integer;
    procedure Delete(Index: integer);
    property Color;
    property Ctl3D;
    property Images : TImageList read FImages write SetImages;
    property DragMode;
    property DragCursor;
    property Enabled;
    property Font;
    property ParentColor;
    property ParentCtl3D;
    property ParentFont;
    property ParentShowHint;
    property PopupMenu;
    property ShowHint;
    property TabOrder;
    property TabStop;
    property Visible;
    property ItemIndex;

    property OnClick;
    property OnDblClick;
    property OnDragDrop;
    property OnDragOver;
    property OnDropDown;
    property OnEndDrag;
    property OnEnter;
    property OnExit;
    property OnKeyDown;
    property OnKeyPress;
    property OnKeyUp;
    property OnStartDrag;
  end;

procedure Register;

implementation

uses Consts, Dialogs;

var
	bmpWidth : integer = 16;
  bmpHeight : integer = 16;


procedure Register;
begin
  RegisterComponents('Win95', [TPicComboBox]);
end;

function GetItemHeight(Font: TFont): Integer;
var
  DC: HDC;
  SaveFont: HFont;
  Metrics: TTextMetric;
begin
  DC := GetDC(0);
  SaveFont := SelectObject(DC, Font.Handle);
  GetTextMetrics(DC, Metrics);
  SelectObject(DC, SaveFont);
  ReleaseDC(0, DC);
  Result := Metrics.tmHeight;
end;


constructor TPicComboBox.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FItem := TPicComboBoxItem.Create;
  Style := csOwnerDrawFixed;
  ResetItemHeight;
end;


destructor TPicComboBox.Destroy;
begin
	FItem.Free;
  inherited Destroy;
end;


function TPicComboBox.Add(S: String; i: Integer) : Integer;
Var
	n : TNum;
begin
	n := TNum.Create;
  n.Num := i;
  result := Items.AddObject(S, n);
end;


procedure TPicComboBox.Delete(Index : integer);
begin
  Items.ObJects[Index].Free;
  Items.Delete(Index);
end;


function TPicComboBox.GetItem(Index: Integer): TPicComboBoxItem;
begin
	FItem.Caption := Items[Index];
  FItem.ImageIndex := TNum(Items.Objects[Index]).Num;

  Result := FItem;
end;

procedure TPicComboBox.SetItem(Index: Integer; Value: TPicComboBoxItem);
begin
	Items[Index] := Value.Caption;
  TNum(Items.Objects[Index]).Num := Value.ImageIndex;
end;


procedure TPicComboBox.DrawItem(Index: Integer; Rect: TRect;
  State: TOwnerDrawState);
begin
  with Canvas do
  begin
    FillRect(Rect);

    if Index > -1 then
    begin
	    if (Images <> nil) and (Item[Index] <> nil) then
		    Images.Draw(Canvas,
    				Rect.Left + 2,
      	    (Rect.Top + Rect.Bottom - bmpHeight) div 2,
        	  Item[Index].ImageIndex);


	    Rect.Left := Rect.Left + bmpWidth + 6;
  	  DrawText(Canvas.Handle,
    					 PChar(Item[Index].Caption), -1, Rect,
      	       DT_SINGLELINE or DT_VCENTER or DT_NOPREFIX);
    end;
  end;
end;

procedure TPicComboBox.CMFontChanged(var Message: TMessage);
begin
  inherited;
  ResetItemHeight;
  RecreateWnd;
end;


procedure TPicComboBox.ResetItemHeight;
var
  nuHeight: Integer;
begin
  nuHeight :=  GetItemHeight(Font);

  if nuHeight < bmpHeight then
  	nuHeight := bmpHeight;

  ItemHeight := nuHeight;
  Height := nuHeight;
end;

procedure TPicComboBox.SetImages(Value: TImageList);
begin

	FImages := Value;

  if FImages <> nil then
  begin
	  bmpWidth := FImages.Width;
	  bmpHeight := FImages.Height;
    ResetItemHeight;
    RecreateWnd;
  end;

end;

procedure TPicComboBox.Change;
begin
  if Assigned(FOnChange) then FOnChange(Self);
end;

end.

