{
 Unit Name:      StatDlg
 Unit Type:      Dialog

 Created:        18 December 1995
 Last Modified:  23 December 1995

 Authors:        CNS International B.V.
                 Feel free to use this unit as you like.

 Description: This dialog is an example of using the TDBProgress
              component. To use this dialog, perform the following
              actions:

              1. Add this file to your project
              2. Add this unit to the 'uses' clause of the
                 units which will be performing database actions
              3. Place 'dlgStatus.Show;' before and 'dlgStatus.Hide;'
                 after the database operations for which you want to
                 provide feedback.
              4. Compile and run.
 }

unit StatDlg;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, Gauges, ExtCtrls, DB,
  DBTables, DBProgrs;

type
  TdlgStatus = class(TForm)
    panBackground: TPanel;
    gauDBStatus: TGauge;
    cmdAbort: TBitBtn;
    DBProgress1: TDBProgress;
    procedure FormCreate(Sender: TObject);
    procedure cmdAbortClick(Sender: TObject);
    procedure DBProgress1StatusChange(Sender: TObject; var Abort: Boolean);
  private
    { Private declarations }
    bPerformAbort: Boolean;
  public
    { Public declarations }
  end;

var
  dlgStatus: TdlgStatus;

implementation

{$R *.DFM}

procedure TdlgStatus.FormCreate(Sender: TObject);
begin
   { Clear abort flag }
   bPerformAbort := False;
end;

procedure TdlgStatus.cmdAbortClick(Sender: TObject);
begin
   { Set the Abort flag to true }
   bPerformAbort := True;
end;

procedure TdlgStatus.DBProgress1StatusChange(Sender: TObject;
  var Abort: Boolean);
begin
   if DBProgress1.Percentage <> -1 then
   begin
      gauDBStatus.Visible := True;
      gauDBStatus.Progress := DBProgress1.Percentage;
   end
   else
   begin
      gauDBStatus.Visible := False;
      panBackground.Caption := DBProgress1.LastMessage;
   end;
   Abort := bPerformAbort;
   { Reset abort flag after aborting }
   if bPerformAbort then bPerformAbort := False;
   { Make sure abort button can be pressed }
   Application.ProcessMessages;

end;

end.
