unit PxValEd1;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics,
  Controls, Forms, Dialogs, StdCtrls, DBCtrls, DB, DBTables,
  Mask, FileCtrl, PxValTbl, ExtCtrls, DBITypes, DBLookup;

type
  TfmMain = class(TForm)
    tblEdit: TPxValcheckTable;
    db: TDatabase;
    lsFields: TListBox;
    lsFiles: TFileListBox;
    pnlProps: TPanel;
    edHasValchecks: TCheckBox;
    edRequired: TCheckBox;
    Label1: TLabel;
    edPicture: TEdit;
    Label2: TLabel;
    edMinValue: TEdit;
    Label3: TLabel;
    edMaxValue: TEdit;
    Label4: TLabel;
    edDefaultValue: TEdit;
    showFieldType: TComboBox;
    Label5: TLabel;
    lsDirs: TDirectoryListBox;
    Label6: TLabel;
    Label7: TLabel;
    pnlStatus: TPanel;
    Label8: TLabel;
    tmStatus: TTimer;
    Memo1: TMemo;
    DriveComboBox1: TDriveComboBox;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    showLookupType: TComboBox;
    rdLookupTable: TEdit;

    procedure FormCreate(Sender: TObject);
    procedure pnlPropsEnable(YesNo: Boolean);
    procedure lsFieldsClick(Sender: TObject);
    procedure lsDirsChange(Sender: TObject);
    procedure tblEditAfterOpen(DataSet: TDataset);
    procedure lsFilesChange(Sender: TObject);
    procedure tblEditBeforeClose(DataSet: TDataset);
    procedure tmStatusTimer(Sender: TObject);
    procedure edChangeProp(Sender: TObject);
    procedure ExitButtonClick(Sender: TObject);
    procedure tblEditValViolation(Sender: TObject; ValViolTbl: TCaption);

  private
    { Private-Deklarationen }
    procedure AppException(Sender: TObject; E: Exception);
    procedure ShowStatus(sMessage: String; lBeep: Boolean);

  public
    { Public-Deklarationen }
  end;

var
  fmMain: TfmMain;
  lEditing: Boolean;

implementation

{$R *.DFM}

{-------------------------------------------------------------}

procedure TfmMain.FormCreate(Sender: TObject);
var PxTbl: TPxValcheckTable;
begin
  lEditing := false;
  pnlPropsEnable(false);
  Application.OnException := AppException;
  PxTbl := TPxValcheckTable.Create(nil);
  PxTbl.Free;
end;

procedure TfmMain.AppException(Sender: TObject; E: Exception);
begin
  showStatus(E.message, true);
end;

procedure TfmMain.ShowStatus(sMessage: String; lBeep: Boolean);
begin
  pnlStatus.Caption:=sMessage;
  if lBeep then
    MessageBeep (word(-1));

  tmStatus.Enabled := false;
  tmStatus.Enabled := true;
end;

procedure TfmMain.tmStatusTimer(Sender: TObject);
begin
  tmStatus.Enabled := false;
  pnlStatus.Caption:='';
end;

{------------------------------------------------------------}

procedure TfmMain.pnlPropsEnable(YesNo: Boolean);
var
  i: Integer;
begin
  pnlProps.Enabled := YesNo;
  with pnlProps do
    for i:=0 to ControlCount-1 do
      if (not YesNo) or (Controls[i].Tag = 0) then
        Controls[i].Enabled := YesNo;
end;

procedure TfmMain.lsDirsChange(Sender: TObject);
begin
  db.close;
  db.Params.Values['PATH'] := lsDirs.Directory;
  db.open;
end;

procedure TfmMain.lsFilesChange(Sender: TObject);
begin
  if lsFiles.FileName <> '' then begin
    tblEdit.Close;
    tblEdit.TableName := lsFiles.FileName;
    tblEdit.Exclusive := True;
    try
      tblEdit.Open;
    except
      tblEdit.Exclusive := False;
      tblEdit.Open;
    end;
  end;
end;

procedure TfmMain.tblEditAfterOpen(DataSet: TDataset);
var
  i: Integer;
begin
  if not lEditing then begin
    lsFields.Items.Clear;
    with tblEdit do
      for i:=0 to FieldCount-1 do
        lsFields.Items.Add(Fields[i].FieldName);

    pnlPropsEnable(false);
    lsFields.ItemIndex := -1;
  end;
end;

procedure TfmMain.tblEditBeforeClose(DataSet: TDataset);
begin
  if not lEditing then begin
    lsFields.Items.Clear;
    pnlPropsEnable(false);
  end;
end;

procedure TfmMain.lsFieldsClick(Sender: TObject);
var
  i: Integer;
begin
  pnlPropsEnable(true);
  i:=lsFields.ItemIndex;
  with tblEdit do
    if (i >= 0) and (i < FieldCount) then begin
      showFieldType.ItemIndex := Ord(Fields[i].DataType);
      showLookupType.ItemIndex := Ord(FieldLookupType[i]);

      if (not edHasValchecks.Enabled) and FieldHasValchecks[i] then
        edHasValchecks.Enabled := True;
      edHasValchecks.Checked := FieldHasValchecks[i];
      edRequired.Checked := FieldRequired[i];

      edPicture.Text := FieldPicture[i];
      edMinValue.Text := FieldMinValue[i];
      edMaxValue.Text := FieldMaxValue[i];
      edDefaultValue.Text := FieldDefaultValue[i];
      rdLookupTable.Text := FieldLookupTable[i];
    end;
end;

procedure TfmMain.edChangeProp(Sender: TObject);
var
  i: Integer;
begin

  lEditing := true;
  Screen.Cursor := crHourGlass;

  with TblEdit do begin
    try
      i:=lsFields.ItemIndex;

      if Sender is TCheckBox then begin
        with TCheckBox(Sender) do begin
          if Name=edHasValchecks.Name then begin
            if edHasValchecks.Checked <> FieldHasValchecks[i] then begin
              if (not Checked)
                and (Application.MessageBox('Do you really wish to remove all valchecks?',
                                            'Andy asks...',
                                            MB_YESNO+MB_ICONQUESTION) = IDNO) then
                Checked := True;
              FieldHasValchecks[i] := Checked;
            end;
            Enabled := Checked;
          end;

          if (Name=edRequired.Name)
            and (edRequired.Checked <> FieldRequired[i]) then
            FieldRequired[i] := Checked;
        end;
      end;

      if (Sender is TEdit) and TEdit(Sender).Modified then begin
        with TEdit(Sender) do begin
          if Name=edMinValue.Name then
            FieldMinValue[i] := Text;

          if Name=edMaxValue.Name then
            FieldMaxValue[i] := Text;

          if Name=edDefaultValue.Name then
            FieldDefaultValue[i] := Text;

          if Name=edPicture.Name then
            FieldPicture[i] := Text;
        end;
      end;

    except
      {Oops, Show Exception}
      on E: Exception do
        showStatus(E.Message, true);
    end;

    lsFieldsClick(self);
  end;

  lEditing := false;
  Screen.Cursor := crDefault;
end;

procedure TfmMain.tblEditValViolation(Sender: TObject;
  ValViolTbl: TCaption);
begin
  {in case a viol table has been created, update the file list:}
  lsFiles.Update;
  lsFiles.FileName := tblEdit.Tablename;
end;

procedure TfmMain.ExitButtonClick(Sender: TObject);
begin
  tblEdit.Close;
  fmMain.Close;
end;

end.
